package jp.co.kpscorp.gwt.client.resize;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class ResizableWindowEx extends ResizableWindow {

	private RootWindowEx root;

	private FlexTable table = new FlexTable();

	private ResizingImageEx resizingImage = new ResizingImageEx();

	private Widget widget;

	public ResizableWindowEx(RootWindowEx root) {
		this.root = root;
		table.setHTML(0, 0, "");
		table.setHTML(0, 1, "");
		table.setHTML(0, 2, "");
		table.setHTML(1, 0, "");
		table.setHTML(1, 1, "");
		table.setHTML(1, 2, "");
		table.setHTML(2, 0, "");
		table.setHTML(2, 1, "");
		table.setHTML(2, 2, "");
		table.setCellSpacing(0);
		table.setCellPadding(0);
		table.getCellFormatter().setVerticalAlignment(1, 1,
				HasVerticalAlignment.ALIGN_TOP);
		table.getCellFormatter().setStyleName(0, 0, "resize-table-nw");
		table.getCellFormatter().setStyleName(0, 1, "resize-table-n");
		table.getCellFormatter().setStyleName(0, 2, "resize-table-ne");
		table.getCellFormatter().setStyleName(1, 0, "resize-table-w");
		table.getCellFormatter().setStyleName(1, 1, "resize-table-c");
		table.getCellFormatter().setStyleName(1, 2, "resize-table-e");
		table.getCellFormatter().setStyleName(2, 0, "resize-table-sw");
		table.getCellFormatter().setStyleName(2, 1, "resize-table-s");
		table.getCellFormatter().setStyleName(2, 2, "resize-table-se");
		resizingImage.setUrl(GWT.getModuleBaseURL() + "resize.png");
		resizingImage.setStyleName("resize-cursor");
		table.setWidget(2, 2, resizingImage);
		initWidget(table);
	}

	public void setContent(Widget w) {
		table.setWidget(1, 1, w);
		this.widget = w;
	}

	public void setPixelSize(int width, int height) {
		table.setWidth(width + "px");
		table.setHeight(height + "px");
	}

	public void resize(Event e) {
		int xDiff = DOM.eventGetClientX(e) - resizingImage.dragStartX;
		int yDiff = DOM.eventGetClientY(e) - resizingImage.dragStartY;
		int minWidth = 10;
		int minHeight = 10;
		int rootBorder = 2;
		if ((resizingImage.initialWidth + xDiff) < (minWidth
				+ resizingImage.getWidth() + rootBorder)) {
			xDiff = (minWidth + resizingImage.getWidth() + rootBorder)
					- resizingImage.initialWidth;
		}
		if ((resizingImage.initialHeight + yDiff) < (minHeight
				+ resizingImage.getHeight() + rootBorder)) {
			yDiff = (minHeight + resizingImage.getHeight() + rootBorder)
					- resizingImage.initialHeight;
		}
		table.setWidth((resizingImage.initialWidth + xDiff) + "px");
		table.setHeight((resizingImage.initialHeight + yDiff) + "px");
		widget.setWidth((resizingImage.initialWidth + xDiff)
				- (resizingImage.getWidth() + rootBorder) + "px");
		widget.setHeight((resizingImage.initialHeight + yDiff)
				- (resizingImage.getHeight() + rootBorder) + "px");
	}

	public int getResizableWindowWidth() {
		return super.getResizableWindowWidth();
	}

	public int getResizableWindowHeight() {
		return super.getResizableWindowHeight();
	}

	private class ResizingImageEx extends Image {

		private int dragStartX;

		private int dragStartY;

		private int initialWidth;

		private int initialHeight;

		public ResizingImageEx() {
			sinkEvents(Event.ONMOUSEDOWN);
		}

		public void onBrowserEvent(Event e) {
			Element target = DOM.eventGetTarget(e);
			if (target.equals(this.getElement())) {
				if (Event.ONMOUSEDOWN == DOM.eventGetType(e)) {
					dragStartX = DOM.eventGetClientX(e);
					dragStartY = DOM.eventGetClientY(e);
					initialWidth = getResizableWindowWidth();
					initialHeight = getResizableWindowHeight();
					root.setResizingWindowEx(ResizableWindowEx.this);
				}
			}
		}
	}

	public Widget getWidget() {
		return widget;
	}

}
