package jp.co.kpscorp.gwt.client.resize;

import java.util.Iterator;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;

public class RootWindowEx extends RootWindow {

	private ResizableWindowEx resizingWindow;

	public Widget getBaseWidget() {
		Iterator it = iterator();
		while (it.hasNext()) {
			Widget w = (Widget) it.next();
			if (w instanceof ResizableWindowEx) {
				ResizableWindowEx ex = (ResizableWindowEx) w;
				return ex.getWidget();
			}
		}
		return null;
	}

	public RootWindowEx() {
		super();
	}

	public void setResizingWindowEx(ResizableWindowEx resizingWindow) {
		this.resizingWindow = resizingWindow;
	}

	public void onBrowserEvent(Event e) {
		int type = DOM.eventGetType(e);
		if (type == Event.ONMOUSEUP) {
			if (resizingWindow != null) {
				resizingWindow.resize(e);
				resizingWindow = null;
			}
		} else if (type == Event.ONMOUSEMOVE) {
			if (resizingWindow != null) {
				resizingWindow.resize(e);
			}
		}
	}

}
