#! /usr/bin/env python
# -*- coding: Shift_JIS -*-

import sys
import fileinput
import re
import time
from optparse import OptionParser
from DigestParser import DigestParser
from FileOutput import FileOutput

#-----------------------------------------------

class DupCheck:
	"""dt@C̃CNX"""
	
	def __init__(self, name_check_len = 0, show_all = False, reverse = False ):
		self.__name_check_len = name_check_len
		self.__show_all = show_all
		self.__reverse = reverse
		self.__parser = DigestParser( self.__print_hash )
		self.__files = []
	
	
	def parse(self, args ):
		"""͑Ώۂ̃t@Ci[ꂽzw肵Aǂݎs܂B"""
		
		for line in fileinput.input( args ):
			self.__parser.parse( line )
	
	
	def __print_hash(self, x ):
		"""͂ꂽnbVlATCYAtAt@CȂz󂯂R[obN
		nbVlATCYA}b`Ώۃg[NAtAt@CA񐔂Ȃzɕϊēo^܂B"""

		x.append( 1 )
		split_names = unicode( x[ 3 ],"mbcs" ).split("\\")
		check_names = split_names[ len(split_names) - self.__name_check_len: ]
		z = x[:2] + [ check_names ] + x[2:]
		self.__files.append( z )
	
	def check(self):
		"""dAAo񐔂JEg܂B"""
		
		self.__files.sort()
		prev = None
		prevc = 0
		for file in self.__files:
			sig = [ file[0], file[1], file[2] ]
			if prev == sig:
				prevc = prevc + 1
				file[ 5 ] = prevc
			else:
				prev = sig
				prevc = 1
	
	def show(self, callback ):
		"""Ώۂo͂܂B"""
		for file in self.__files:
			out_flag = self.__show_all or file[ 5 ] > 1
			if self.__reverse:
				out_flag = not out_flag
			if out_flag :
				callback['normal']( file )
			else:
				callback['alternate']( file )

#-----------------------------------------------

class Format:
	def __init__(self, simple_format ):
		if simple_format:
			self.__fmt = self.__simple_format
		else:
			self.__fmt = self.__normal_format
	
	def __simple_format(self, file):
		( hash, file_size, check_name, lastModified, file_name, cnt ) = file
		return file_name
	
	def __normal_format(self, file):
		( hash, file_size, check_name, lastModified, file_name, cnt ) = file
		try:
			ctm = time.ctime( lastModified )
		except ValueError, e:
			ctm = str( e )
			print >>sys.stderr, file[3], e
		return "%s *%s *%d *%d (%s) *%d" % ( hash, file_name, file_size, lastModified, ctm, cnt )
	
	def __call__(self, file):
		return self.__fmt( file )

class FormatOutputAdaptor:
	def __init__(self, output, format ):
		self.__output = output
		self.__format = format
	
	def __call__(self, file ):
		self.__output.write( self.__format( file ) )

#-----------------------------------------------

usage = """p@: %prog [options] [ file ...]
%prog enumdir.py̏o͌ʂ̃t@Cw肵āÃnbVlAt@CTCYAtAt@C̏Ƀ\[gāA
A铯nbVlœTCỸt@CɘAԍUďo͂܂B
IvV-aw肳ȂAAQڈȍ~̃t@Co͂܂B
W͂󂯂ꍇ̓nCtw肵܂B
"""
parser = OptionParser( usage = usage )

parser.add_option(
	"-o", "--output",
	action="store",
	type="string",
	dest="output_filename",
	default=None,
	help="dΏۂo͂t@Cw肵܂B"
	)
parser.add_option(
	"-a", "--alt-output",
	action="store",
	type="string",
	dest="alt_output_filename",
	default=None,
	help="dΏۊOo͂t@Cw肵܂B"
	)

parser.add_option(
	"-p", "--match-path",
	action="store",
	type="int",
	dest="name_check_len",
	default=0,
	help="Õ`FbNs[(0ȏ)"
	)

parser.add_option(
	"-A", "--show-all",
	action="store_true",
	dest="show_all",
	default=False,
	help="d̗Lɂ炸Sďo͂܂B"
	)
parser.add_option(
	"-R", "--reverse",
	action="store_true",
	dest="reverse",
	default=False,
	help="Ώہ^Ώۂ𔽓]܂"
	)

parser.add_option(
	"-s", "--simple",
	action="store_true",
	dest="simple_format",
	default=False,
	help="dΏۂt@Co͂܂B"
	)
parser.add_option(
	"-S", "--alternate-simple",
	action="store_true",
	dest="alternate_simple_format",
	default=False,
	help="dΏۊOt@Co͂܂B"
	)

(options, args) = parser.parse_args()

normal_output = FormatOutputAdaptor(
	FileOutput( file_name = options.output_filename, default_output = sys.stdout ),
	Format( options.simple_format ) )

alternate_output = FormatOutputAdaptor(
	FileOutput( file_name = options.alt_output_filename, default_output = None ),
	Format( options.alternate_simple_format ) )

output_map = { 'normal' : normal_output, 'alternate' : alternate_output }

dupcheck = DupCheck( name_check_len = options.name_check_len, show_all = options.show_all, reverse = options.reverse )
dupcheck.parse( args )
dupcheck.check()

dupcheck.show( output_map )
