#! /usr/bin/env python
# -*- coding: Shift_JIS -*-

import sys
import os.path
import stat;
import time;
import md5
import sha
from optparse import OptionParser

#------------------------------------

class EnumerateDir:
	"""Cӂ̃tH_𑖍NXłB
	ċAIɃTutH_𑖍ꍇrecusriveTrueɎw肵܂B
	ꂽt@Ccallback̈ƂČĂяo܂B"""

	def __init__(self, callback, recursive = 0):
		"""ꂽt@CʒmR[obNƁAċAIɃTufBNg
		邩w肷recursivetOw肵č\z܂B"""
		
		self.__callback = callback
		self.__recursive = recursive
	
	
	def enum(self, dirname):
		"""w肵tH_ȉ𑖍܂B
		tH_ȊOw肳ꂽꍇ͒PɃR[obNɓn܂B"""

		dirname = os.path.normpath( dirname )
		if os.path.isdir( dirname ):
			self.__enumdir( dirname )
		else:
			self.__callback( dirname )
	
	
	def __enumdir(self, dirname ):
		"""tH_̑s܂B"""
		
		dirc = os.listdir( dirname )
		dirc.sort()
		for filename in dirc:
			filename = os.path.normpath( os.path.join( dirname, filename ) );
			try:
				fs = os.stat( filename )
				if( stat.S_ISDIR( fs[ stat.ST_MODE ] ) ):
					if self.__recursive:
						self.__enumdir( filename  )
				else:
					self.__callback( filename )
			except OSError, e:
				print >>sys.stderr, e

#------------------------------------

class FileDigestCalcurator:
	"""t@Cw肵āÃt@C̃nbVlt@CTCYAXVt
	Ȃǂ̏擾AR[obNɑM܂B"""
	
	
	def __init__(self, callback, hashfactory ):
		"""t@C̏󂯂R[obNƁAnbVW[ւ̎QƂ
		w肵\z܂B"""
		
		self.__callback = callback;
		self.__hashfactory = hashfactory
	
	
	def getFileInfo( self, filename ):
		"""t@Cʒm܂Bw肵t@C̃nbVvZA
		܂At@CTCYAXVt̏擾AR[obN
		M܂B"""
		
		fs = os.stat( filename )
		last_modified = fs[ stat.ST_MTIME ]
		file_size = fs[ stat.ST_SIZE ]
		hash = self.__hashfactory.new();
		try:
			theFile = file( filename, 'rb' )
			try:
				while True:
					chunk = theFile.read( 1024 * 1024 )
					if len( chunk ) == 0:
						break
					hash.update( chunk )
			finally:
				theFile.close()
			self.__callback( filename, hashcode = hash.hexdigest(), file_size = file_size, last_modified = last_modified )
		except IOError, e:
			self.__callback( filename, hashcode = "*error:" + str( e ) )

#------------------------------------

class FileDigestOutput:
	"""t@C̃nbVlAt@CAt@CTCYAXV̏
	o͂邽߂̃NX"""
	
	
	def __init__(self, output_filename = None, simple_format = 0):
		"""o͐t@CуVvȃtH[}bggp邩tO
		w肵\z܂Bt@CNonełꍇ͕Wo͂p܂B"""
		
		if output_filename == None:
			self.__output = sys.stdout
		else:
			self.__output = open( output_filename, "wt" )
		self.__simple_format = simple_format
	
	
	def hashprint(self, filename, hashcode, file_size = -1, last_modified = 0 ):
		"""t@CAnbVlAt@CTCYAXVtw肵āA
		tH[}bgďo͂܂B"""
		
		if self.__simple_format:
			print >>self.__output, "%s *%s" % ( hashcode, filename )
		else:
			try:
				ctm = time.ctime( last_modified )
			except ValueError, e:
				ctm = str( e )
				print >>sys.stderr, filename, e
			print >>self.__output, "%s *%s *%d *%d (%s)" % ( hashcode, filename, file_size, last_modified, ctm )
	
	
	def dispose(self):
		"""t@C邽߂ɌĂяo܂B"""
		
		self.__output.close()


#------------------------------------
usage="""g: %prog [options] [directory or file ...]
w肵fBNg܂̓t@C̃nbVlƃt@CTCYAXVAt@Co͂܂B
fBNgw肳ꂽꍇ́ÃfBNĝׂẴt@CΏۂƂ܂B
ȗꍇ̓JgfBNgw肵̂Ƃ݂Ȃ܂B
 ChJ[h͎g܂B
"""
parser = OptionParser( usage = usage )
parser.add_option(
        "-o", "--output",
	action="store", type="string",
        dest="output_filename",
	help = "w肵t@C֏o͂܂B"
	)
parser.add_option(
	"-r", "--recursive",
	action="store_true",
	dest="recursive",
	default=0,
	help="TufBNg𑖍܂B"
	)
parser.add_option(
	"-a", "--hash-algo",
	action="store", type="string",
	dest="hash_algo",
	default="sha",
	help="nbṼASY(md5/sha1)w肵܂B"
	)
parser.add_option(
	"-s", "--simple",
	action="store_true",
	dest="simple_format",
	default=0,
	help="Gnumd5sum/sha1sum̃VvȌ`ŏo͂܂B"
	)

(options, args) = parser.parse_args()

if len(args) == 0:
	args.append( "." )
args.sort()

algos = { "md5" : "md5", "sha" : "sha", "sha1" : "sha" }
if not options.hash_algo in algos :
	print >>sys.stderr, "T|[gĂȂASYłB", options.hash_algo
	sys.exit(1)

hashalgo = eval( algos[ options.hash_algo ] )


fileDigestOutput = FileDigestOutput(
	output_filename = options.output_filename,
	simple_format   = options.simple_format
	)
try:
	fileDigestCalcurator = FileDigestCalcurator( fileDigestOutput.hashprint, hashalgo )

	enm = EnumerateDir(
		callback = fileDigestCalcurator.getFileInfo,
		recursive = options.recursive
		)

	for dirname in args:
	        enm.enum( dirname )
finally:
	fileDigestOutput.dispose()

