#! /usr/bin/env python
# -*- coding: Shift_JIS -*-

import sys
import os
import os.path
from optparse import OptionParser

class CheckEmptyDir:
	
	def __init__(self, callback ):
		self.__callback = callback
	
	def search(self, dirname ):
		dirname = os.path.normpath( dirname )
		files = list( os.listdir( dirname ) )
		files.sort()
		result = 0
		for file in files:
			filenpath = os.path.normpath( dirname + "/" + file )
			if os.path.isdir( filenpath ):
				result += self.search( filenpath )
			else:
				if self.isAcceptableFile( file ):
					result += 1
		if result == 0:
			self.__callback( dirname )
		return result
	
	def isAcceptableFile(self, file ):
		return True

usage="""g: %prog [options] [fBNg ...]
w肵fBNgAсA̔z̃TufBNgłfBNgXgAbv܂B
̃fBNgfBNgƂ݂Ȃ܂B
"""
parser = OptionParser( usage = usage )
(options, args) = parser.parse_args()

if len(args) == 0:
	args.append( "." )
args.sort()

def printemptydir( dirname ):
	print dirname

searcher = CheckEmptyDir( printemptydir )

for dirname in args:
	searcher.search( dirname )
