#! /usr/bin/env python
# -*- coding: Shift_JIS -*-

import sys
import fileinput
import time
from optparse import OptionParser
from DigestParser import DigestParser
from FileOutput import FileOutput

#---------------------------------------------------

class Merger:
	def __init__( self, callback_map ):
		self.__collection = {}
		self.__parser = DigestParser( self.__print_hash )
		self.__callback_map = callback_map;

	def __print_hash( self, fileInfo ):
		( hash, file_size, lastModified, file_name ) = fileInfo
		if self.__collection.has_key( file_name ):
			if self.__collection[ file_name ] != fileInfo:
				self.__callback_map[ 'stderr' ].write( "conflict: " + str( file_name ) )
		else:
			self.__collection[ file_name ] = fileInfo
			try:
				ctm = time.ctime( lastModified )
			except ValueError, e:
				ctm = str( e )
			self.__callback_map[ 'stdout' ].write( "%s *%s *%d *%d (%s)" % ( hash, file_name, file_size, lastModified, ctm ) )
	
	def parse( self, args ):
		for line in fileinput.input( args ):
			self.__parser.parse( line )

#---------------------------------------------------

usage="""%prog [options] [nbVt@C ...]
nbVt@C}[W܂B
t@C2ڈȍ~͋Ƃĕ񍐂܂B
A܂̏łꍇ͖܂B
"""
parser = OptionParser( usage = usage )
parser.add_option(
        "-o", "--output",
	action="store", type="string",
        dest="output_filename",
	help = "w肵t@Cփ}[Wʂo͂܂B"
	)
parser.add_option(
        "-e", "--error-output",
	action="store", type="string",
        dest="error_filename",
	help = "t@CXgw肵t@C֏o͂܂B"
	)

(options, args) = parser.parse_args()

normal_output = FileOutput( options.output_filename )
error_output = FileOutput( options.error_filename, sys.stderr )
callback_map = { 'stdout' : normal_output, 'stderr' : error_output }
try:
	merger = Merger( callback_map )
	merger.parse( args )
finally:
	normal_output.dispose()
	error_output.dispose()
