/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviException;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DviColor
implements Serializable {
    private static final long serialVersionUID = 5615669030601265281L;
    public static final DviColor INVALID = new DviColor();
    private final int r;
    private final int g;
    private final int b;
    private final int intRGB;
    private final boolean valid;
    private static final Pattern rgbPat = Pattern.compile("rgb\\s+([.0-9]+)\\s+([.0-9]+)\\s+([.0-9]+)", 2);
    private static final Pattern hsbPat = Pattern.compile("hsb\\s+([.0-9]+)\\s+([.0-9]+)\\s+([.0-9]+)", 2);
    private static final Pattern cmykPat = Pattern.compile("cmyk\\s+([.0-9]+)\\s+([.0-9]+)\\s+([.0-9]+)\\s+([.0-9]+)", 2);
    private static final Pattern grayPat = Pattern.compile("gray\\s+([.0-9]+)", 2);
    private static final HashMap<String, DviColor> aliases = new HashMap();

    static {
        aliases.put("black", DviColor.IntRGB(0));
        aliases.put("blue", DviColor.IntRGB(255));
        aliases.put("green", DviColor.IntRGB(65280));
        aliases.put("cyan", DviColor.IntRGB(65535));
        aliases.put("red", DviColor.IntRGB(0xFF0000));
        aliases.put("magenta", DviColor.IntRGB(0xFF00FF));
        aliases.put("yellow", DviColor.IntRGB(0xFFFF00));
        aliases.put("white", DviColor.IntRGB(0xFFFFFF));
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public Color toColor() {
        return new Color(this.r, this.g, this.b);
    }

    public DviColor() {
        this.intRGB = 0;
        this.b = 0;
        this.g = 0;
        this.r = 0;
        this.valid = false;
    }

    public DviColor(int rgb) {
        this(rgb >>> 16 & 0xFF, rgb >>> 8 & 0xFF, rgb & 0xFF);
    }

    public DviColor(int r, int g, int b) {
        if (r < 0 || r >= 256 || g < 0 || g >= 256 || b < 0 || b >= 256) {
            throw new IllegalArgumentException("r=" + r + " g=" + g + " b=" + b);
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.intRGB = r << 16 | g << 8 | b;
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static DviColor IntRGB(int v) {
        int b = v & 0xFF;
        int g = (v >>>= 8) & 0xFF;
        int r = (v >>>= 8) & 0xFF;
        return DviColor.RGB(r, g, b);
    }

    public static DviColor RGB(int r, int g, int b) {
        return new DviColor(r, g, b);
    }

    public static DviColor RGB(double r, double g, double b) {
        return DviColor.RGB((int)(r * 255.0 + 0.5), (int)(g * 255.0 + 0.5), (int)(b * 255.0 + 0.5));
    }

    public static DviColor HSV(int h, int s, int v) {
        int b;
        int g;
        int r;
        if (s == 0) {
            return DviColor.RGB(v, v, v);
        }
        h = (h % 360 + 360) % 360;
        double f = h % 60;
        int p = (int)(((double)v * (255.0 - (double)s) + 127.5) / 255.0);
        int q = (int)(((double)v * (15300.0 - f * (double)s) + 7650.0) / 15300.0);
        int t = (int)(((double)v * (15300.0 - (60.0 - f) * (double)s) + 7650.0) / 15300.0);
        switch (h / 60) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return DviColor.RGB(r, g, b);
    }

    public static DviColor CMYK(double c, double m, double y, double k) {
        return DviColor.RGB(Math.max(0.0, 1.0 - c - k), Math.max(0.0, 1.0 - m - k), Math.max(0.0, 1.0 - y - k));
    }

    public int toIntRGB() {
        return this.intRGB;
    }

    public static DviColor parseColor(String str) throws DviException {
        str = str.trim();
        try {
            Matcher mat = rgbPat.matcher(str);
            if (mat.matches()) {
                double r = Double.parseDouble(mat.group(1));
                double g = Double.parseDouble(mat.group(2));
                double b = Double.parseDouble(mat.group(3));
                return DviColor.RGB(r, g, b);
            }
            mat = hsbPat.matcher(str);
            if (mat.matches()) {
                double h = Double.parseDouble(mat.group(1));
                double s = Double.parseDouble(mat.group(2));
                double b = Double.parseDouble(mat.group(3));
                return DviColor.HSV((int)(h * 359.0 + 0.5), (int)(s * 255.0 + 0.5), (int)(b * 255.0 + 0.5));
            }
            mat = cmykPat.matcher(str);
            if (mat.matches()) {
                double c = Double.parseDouble(mat.group(1));
                double m = Double.parseDouble(mat.group(2));
                double y = Double.parseDouble(mat.group(3));
                double k = Double.parseDouble(mat.group(3));
                return DviColor.CMYK(c, m, y, k);
            }
            mat = grayPat.matcher(str);
            if (mat.matches()) {
                double v = Double.parseDouble(mat.group(1));
                return DviColor.RGB(v, v, v);
            }
            DviColor c = aliases.get(str.toLowerCase());
            if (c != null) {
                return c;
            }
            throw new DviException("unrecognized color specification: " + str);
        }
        catch (NumberFormatException ex) {
            throw new DviException(ex);
        }
    }

    public int hashCode() {
        return this.r + 33 * (this.g + 33 * this.b);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviColor) {
            DviColor c = (DviColor)obj;
            return this.r == c.r && this.g == c.g && this.b == c.b;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hex=#" + DviColor.toHex(this.r) + DviColor.toHex(this.g) + DviColor.toHex(this.b) + "]";
    }

    private static String toHex(int a) {
        return a < 16 ? "0" + Integer.toHexString(a) : Integer.toHexString(a);
    }
}

