/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviSerialized;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class DviObject
implements DviContextSupport,
DviSerialized {
    private static final String applicationUUID = UUID.randomUUID().toString();
    private static final AtomicLong serializer = new AtomicLong();
    private final DviContextSupport dcs;
    private final String cacheKey;
    private final long serial;

    public DviObject(DviContextSupport dcs) {
        this.dcs = dcs;
        if (dcs == null) {
            throw new IllegalArgumentException("DviObject cannot be instantiated with null DviContextSupport.");
        }
        this.serial = serializer.incrementAndGet();
        this.cacheKey = String.valueOf(applicationUUID) + "-" + this.serial;
    }

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public long getSerialNumber() {
        return this.serial;
    }
}

