/*
 * Decompiled with CFR 0.152.
 */
package dvi.cmd;

import java.io.Serializable;

public class DviBop
implements Serializable {
    private static final long serialVersionUID = 1326126283946043078L;
    private final int[] count;
    private final int backPointer;

    public DviBop(int[] count, int backPointer) {
        this.count = (int[])count.clone();
        this.backPointer = backPointer;
        this.checkValues();
    }

    public void checkValues() {
        if (this.count.length != 10) {
            throw new IllegalArgumentException("count must be of type int [10].");
        }
    }

    public String countAsString() {
        String str = String.valueOf(this.count[0]);
        int i = this.count.length - 1;
        while (i > 0) {
            if (this.count[i] != 0) break;
            --i;
        }
        int j = 1;
        while (j <= i) {
            str = String.valueOf(str) + ":" + this.count[j];
            ++j;
        }
        return str;
    }

    public int[] count() {
        return (int[])this.count.clone();
    }

    public int backPointer() {
        return this.backPointer;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[count=" + this.countAsString() + ",backPointer=" + this.backPointer + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof DviBop) {
            DviBop a = (DviBop)o;
            if (a.backPointer != this.backPointer || a.count.length != this.count.length || this.count.length != 10) {
                return false;
            }
            int i = 0;
            while (i < 10) {
                if (a.count[i] != this.count[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.backPointer;
        int[] nArray = this.count;
        int n = this.count.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            hash = a + 33 * hash;
            ++n2;
        }
        return hash;
    }
}

