/*
 * Decompiled with CFR 0.152.
 */
package dvi.doc;

import dvi.DviByteRange;
import dvi.DviException;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviDocument;
import dvi.api.DviInput;
import dvi.api.DviPage;

public final class DefaultDviPage
extends DviObject
implements DviPage {
    private final DviDocument doc;
    private final long bop;
    private final long eop;
    private final int pageNum;

    DefaultDviPage(DviDocument doc, int pageNum, long bop, long eop) {
        super(doc);
        this.doc = doc;
        this.pageNum = pageNum;
        this.bop = bop;
        this.eop = eop;
    }

    public DviDocument getDocument() {
        return this.doc;
    }

    public DviUnit getDviUnit() throws DviException {
        return this.doc.getDviUnit();
    }

    public DviFontTable getFontTable() throws DviException {
        return this.doc.getFontTable();
    }

    public DviByteRange range() {
        return new DviByteRange(this.bop, this.eop);
    }

    public int getPageNumber() {
        return this.pageNum;
    }

    public DviInput getInput() throws DviException {
        return this.doc.getInput(this.bop, this.eop);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[pageNum=" + this.pageNum + ",bop=" + this.bop + ",eop=" + this.eop + "]";
    }

    public long getDataSize() throws DviException {
        return this.eop - this.bop + 1L;
    }

    public DviInput getInput(long start, long end) throws DviException {
        return this.doc.getInput(this.bop + start, this.bop + end);
    }
}

