/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.font.AWTDynamicPkFontResolver;
import dvi.font.AbstractDviFontResolver;
import dvi.font.LogicalFont;
import dvi.font.PkFontResolver;
import dvi.font.VirtualFontResolver;
import dvi.util.concurrent.CachedComputer;
import dvi.util.concurrent.ThreadedComputer;
import dvi.util.progress.ProgressItem;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviFontResolver
extends AbstractDviFontResolver {
    private static final Logger LOGGER = Logger.getLogger(DviFontResolver.class.getName());
    private static final CachedComputer<String, Collection<DviFont>> dviFontComputer = new CachedComputer(new ThreadedComputer(3));

    public DviFontResolver(DviContextSupport dcs, LogicalFont logicalFont) {
        super(dcs, logicalFont);
    }

    @Override
    public Collection<DviFont> call() throws Exception {
        ProgressItem progress = this.getDviContext().getProgressRecorder().open("resolving " + this.getLogicalFont().fontSpec().name());
        try {
            LOGGER.fine("Resolving DVI font " + this.getLogicalFont());
            LogicalFont mappedLogicalFont = this.getDviContext().mapLogicalFont(this.getLogicalFont());
            LOGGER.fine("Mapped logical font is " + mappedLogicalFont);
            ArrayList<DviFont> list = new ArrayList<DviFont>();
            Future<Collection<DviFont>> futureVF = dviFontComputer.compute(new VirtualFontResolver((DviContextSupport)this, this.getLogicalFont()));
            Future<Collection<DviFont>> futurePK = dviFontComputer.compute(new PkFontResolver((DviContextSupport)this, mappedLogicalFont));
            Future<Collection<DviFont>> futureAWT = dviFontComputer.compute(new AWTDynamicPkFontResolver((DviContextSupport)this, mappedLogicalFont));
            list.addAll(futureVF.get());
            list.addAll(futurePK.get());
            list.addAll(futureAWT.get());
            ArrayList<DviFont> arrayList = list;
            return arrayList;
        }
        finally {
            progress.close();
        }
    }

    @Override
    public String getCacheKey() {
        LogicalFont spec = this.getLogicalFont();
        return spec.fontSpec().fontName() + "-" + spec.fontSpec().checkSum() + "-" + spec.fontSpec().spaceSize() + "-" + spec.fontSpec().designSize() + "-" + spec.resolution().dpi() + "-" + spec.dviUnit();
    }

    @Override
    protected DviFont createInstanceFromStream(InputStream openStream) throws DviException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String mapToDviResourceName(LogicalFont logicalFont) {
        throw new UnsupportedOperationException();
    }
}

