/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.font.PackedSequence;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencePacker {
    private final ArrayList<Integer> data;
    private byte[] _buf;
    private int _ptr;
    private int _highNyb;
    private static final int[] cc2diffPos = new int[195];

    static {
        int d = 0;
        while (d < 13) {
            int j = 0;
            while (j < 15) {
                int cc = d * 15 + j;
                SequencePacker.cc2diffPos[cc] = 12 - d;
                ++j;
            }
            ++d;
        }
    }

    public SequencePacker(ArrayList<Integer> data) {
        this.data = data;
    }

    private void writeNyb(int a) {
        if (this._highNyb != 0) {
            int n = this._ptr;
            this._buf[n] = (byte)(this._buf[n] | (byte)((a & 0xF) << 4));
            this._highNyb = 0;
        } else {
            int n = this._ptr++;
            this._buf[n] = (byte)(this._buf[n] | (byte)(a & 0xF));
            this._highNyb = 1;
        }
    }

    public PackedSequence pack() {
        Config cfg = SequencePacker.findBestConfig(this.data);
        return this.pack(cfg);
    }

    private PackedSequence pack(Config cfg) {
        int nybLength = cfg.nybLength;
        byte[] buf = new byte[nybLength + 1 >>> 1];
        int dynF = cfg.dynF;
        int dynG = SequencePacker.computeDynG(dynF);
        int dynH = SequencePacker.computeDynH(dynF);
        this._buf = buf;
        this._ptr = 0;
        this._highNyb = 1;
        int ds = this.data.size();
        int i = 0;
        while (i < ds) {
            int c = this.data.get(i);
            if (c != 0) {
                if (c == -1) {
                    this.writeNyb(15);
                } else {
                    int cc;
                    if (c < 0) {
                        this.writeNyb(14);
                        c = -c;
                    }
                    if (c <= dynF) {
                        this.writeNyb(c);
                    } else if (c < dynG) {
                        cc = c + dynH;
                        this.writeNyb(cc >>> 4);
                        this.writeNyb(cc >>> 0);
                    } else {
                        cc = c - dynG + 16;
                        int k = cc >>> 4;
                        int nl = 0;
                        while (k > 0) {
                            this.writeNyb(0);
                            k >>>= 4;
                            nl += 4;
                        }
                        while (nl >= 0) {
                            this.writeNyb(cc >>> nl);
                            nl -= 4;
                        }
                    }
                }
            }
            ++i;
        }
        this._buf = null;
        return new PackedSequence(buf, dynF, nybLength);
    }

    private static int computeDynG(int dynF) {
        return (13 - dynF << 4) + dynF + 1;
    }

    private static int computeDynH(int dynF) {
        return (dynF + 1 << 4) - dynF - 1;
    }

    private static Config findBestConfig(ArrayList<Integer> data) {
        int len = 0;
        int[] diff = new int[13];
        int ds = data.size();
        int i = 0;
        while (i < ds) {
            int c = data.get(i);
            if (c != 0) {
                if (c == -1) {
                    ++len;
                } else {
                    int cc;
                    if (c < 0) {
                        ++len;
                        c = -c;
                    }
                    if (c < 14) {
                        int n = c - 1;
                        diff[n] = diff[n] - 1;
                        len += 2;
                    } else if (c < 209) {
                        cc = c - 14;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 1;
                        len += 2;
                    } else if (c < 254) {
                        len += 3;
                    } else if (c < 449) {
                        cc = c - 254;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 3;
                    } else if (c < 4094) {
                        len += 5;
                    } else if (c < 4289) {
                        cc = c - 4094;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 5;
                    } else if (c < 65534) {
                        len += 7;
                    } else if (c < 65729) {
                        cc = c - 65534;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 7;
                    } else if (c < 1048574) {
                        len += 9;
                    } else if (c < 0x1000C1) {
                        cc = c - 1048574;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 9;
                    } else if (c < 0xFFFFFE) {
                        len += 11;
                    } else if (c < 0x10000C1) {
                        cc = c - 0xFFFFFE;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 11;
                    } else if (c < 0xFFFFFFE) {
                        len += 13;
                    } else if (c < 0x100000C1) {
                        cc = c - 0xFFFFFFE;
                        int n = cc2diffPos[cc];
                        diff[n] = diff[n] + 2;
                        len += 13;
                    } else {
                        len += 15;
                    }
                }
            }
            ++i;
        }
        int bestDynF = -1;
        int bestSize = Integer.MAX_VALUE;
        int dynF = 0;
        while (true) {
            if (len < bestSize) {
                bestDynF = dynF;
                bestSize = len;
            }
            if (dynF >= 13) break;
            len += diff[dynF];
            ++dynF;
        }
        Config cfg = new Config(bestDynF, bestSize);
        return cfg;
    }

    private static class Config {
        private final int dynF;
        private final int nybLength;

        private Config(int dynF, int nybLength) {
            this.dynF = dynF;
            this.nybLength = nybLength;
        }
    }
}

