/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviInput;
import dvi.api.FullMetrics;
import dvi.io.DviInputStreamReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;

public class TexFontMetrics
extends DviObject
implements FullMetrics,
Serializable {
    private static final long serialVersionUID = 962603909880917980L;
    private boolean enableJFM = true;
    private boolean isJFM;
    private int checkSum;
    private int designSize;
    private final String name;
    private final HashMap<Integer, Record> ct2rec = new HashMap();
    private HashMap<Integer, Integer> code2ct;

    public TexFontMetrics(DviContextSupport dcs, File file) throws DviException {
        super(dcs);
        try {
            FileInputStream is = new FileInputStream(file);
            this.parseInputStream(is);
            is.close();
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
        this.name = String.valueOf(this.getClass().getName()) + "--" + file.getPath() + "--" + file.lastModified();
    }

    public TexFontMetrics(DviContextSupport dcs, InputStream is) throws DviException {
        super(dcs);
        try {
            this.parseInputStream(is);
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
        this.name = String.valueOf(this.getClass().getName()) + "--" + is + "--" + System.currentTimeMillis();
    }

    protected void parseInputStream(InputStream is) throws IOException, DviException {
        int lh;
        int lf;
        int nt;
        int id;
        DviInputStreamReader in = new DviInputStreamReader(new BufferedInputStream(is, 1024));
        long start = in.getOffset();
        if (this.enableJFM) {
            id = in.readU2();
            nt = in.readU2();
            boolean bl = this.isJFM = id == 9 || id == 11;
            if (this.isJFM) {
                lf = in.readU2();
                lh = in.readU2();
            } else {
                lf = id;
                lh = nt;
                id = 0;
                nt = 0;
            }
        } else {
            id = 0;
            nt = 0;
            lf = in.readU2();
            lh = in.readU2();
            this.isJFM = false;
        }
        int bc = in.readU2();
        int ec = in.readU2();
        int nw = in.readU2();
        int nh = in.readU2();
        int nd = in.readU2();
        int ni = in.readU2();
        int nl = in.readU2();
        int nk = in.readU2();
        int ne = in.readU2();
        int np = in.readU2();
        int numChars = ec - bc + 1;
        int[] header_t = TexFontMetrics.readBuffer(in, lh);
        this.checkSum = header_t[0];
        this.designSize = header_t[1];
        if (this.isJFM) {
            this.code2ct = new HashMap();
            int i = 0;
            while (i < nt) {
                int from = in.readU2();
                int to = in.readU2();
                this.code2ct.put(from, to);
                ++i;
            }
        } else {
            this.code2ct = null;
        }
        int[] char_info_t = TexFontMetrics.readBuffer(in, numChars);
        int[] width_t = TexFontMetrics.readBuffer(in, nw);
        int[] height_t = TexFontMetrics.readBuffer(in, nh);
        int[] depth_t = TexFontMetrics.readBuffer(in, nd);
        int[] italic_t = TexFontMetrics.readBuffer(in, ni);
        int[] lig_kern_t = TexFontMetrics.readBuffer(in, nl);
        int[] kern_t = TexFontMetrics.readBuffer(in, nk);
        int[] exten_t = TexFontMetrics.readBuffer(in, ne);
        int[] param_t = TexFontMetrics.readBuffer(in, np);
        long size = in.getOffset() - start;
        if ((long)(lf * 4) != size || lf != (this.isJFM ? 7 : 6) + lh + nt + numChars + nw + nh + nd + ni + nl + nk + ne + np) {
            throw new DviException("Length mismatch in TFM data");
        }
        if (this.isJFM && bc != 0) {
            throw new DviException("bc must be 0 in JFM data.");
        }
        int i = 0;
        while (i < numChars) {
            int ct = i + bc;
            int ci = char_info_t[i];
            int wi = ci >>> 24 & 0xFF;
            int hi = ci >>> 20 & 0xF;
            int di = ci >>> 16 & 0xF;
            int ii = ci >>> 10 & 0x3F;
            int tag = ci >>> 8 & 3;
            int rem = ci >>> 0 & 0xFF;
            int width = width_t[wi];
            int height = height_t[hi];
            int depth = depth_t[di];
            int italic = italic_t[ii];
            this.ct2rec.put(ct, new Record(width, height, depth, italic));
            ++i;
        }
    }

    private static int[] readBuffer(DviInput in, int length) throws IOException {
        int[] buf = new int[length];
        int i = 0;
        while (i < length) {
            buf[i] = in.readU4();
            ++i;
        }
        return buf;
    }

    public String getName() {
        return this.name;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getDesignSize() {
        return this.designSize;
    }

    public boolean isJFM() {
        return this.isJFM;
    }

    public boolean hasChar(int code) {
        return this.isJFM ? true : this.ct2rec.containsKey(code);
    }

    private int codeToCt(int code) {
        return this.code2ct == null ? code : (this.code2ct.containsKey(code) ? this.code2ct.get(code) : 0);
    }

    private Record getRecord(int code) {
        return this.ct2rec.get(this.codeToCt(code));
    }

    public int getTfmWidth(int code) {
        Record rec = this.getRecord(code);
        return rec != null ? rec.width : 0;
    }

    public int getTfmHeight(int code) {
        Record rec = this.getRecord(code);
        return rec != null ? rec.height : 0;
    }

    public int getTfmDepth(int code) {
        Record rec = this.getRecord(code);
        return rec != null ? rec.depth : 0;
    }

    public int getTfmItalic(int code) {
        Record rec = this.getRecord(code);
        return rec != null ? rec.italic : 0;
    }

    public static String getTfmFilename(DviFontSpec spec) {
        String tfm = String.valueOf(spec.name()) + ".tfm";
        return tfm;
    }

    private static class Record
    implements Serializable {
        private static final long serialVersionUID = 1638947545775532119L;
        private final int width;
        private final int height;
        private final int depth;
        private final int italic;

        private Record(int width, int height, int depth, int italic) {
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.italic = italic;
        }
    }
}

