/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviFontTable;
import dvi.DviResolution;
import dvi.api.BinaryDevice;
import dvi.api.DevicePainter;
import dvi.api.DviContextSupport;
import dvi.api.DviExecutor;
import dvi.font.AbstractDynamicPkFont;
import dvi.font.LogicalFont;
import dvi.font.PkGlyph;
import dvi.font.RunLengthEncodedGlyph;
import dvi.io.ByteArrayDviData;
import dvi.io.DviInputStreamReader;
import dvi.render.VirtualFontGeometer;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;

public class VirtualFont
extends AbstractDynamicPkFont {
    private static final long serialVersionUID = -4723597208297552498L;
    private final HashMap<Integer, GlyphInfo> glyphInfos = new HashMap();
    private final String name;
    private int idByte;
    private byte[] comment;
    private int checkSum;
    private int designSize;
    private DviFontTable fontTable;
    private int defaultFontNumber = -1;

    public VirtualFont(DviContextSupport dcs, File file) throws DviException {
        super(dcs);
        try {
            FileInputStream fis = new FileInputStream(file);
            this.parseInputStream(fis);
            fis.close();
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
        this.name = String.valueOf(this.getClass().getName()) + "--" + file + "--" + file.lastModified() + "--[" + new String(this.comment) + "]";
    }

    public VirtualFont(DviContextSupport dcs, InputStream is) throws DviException {
        super(dcs);
        try {
            this.parseInputStream(is);
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
        this.name = String.valueOf(this.getClass().getName()) + "--" + is + "--" + System.currentTimeMillis() + "--[" + new String(this.comment) + "]";
    }

    public boolean hasChar(int code) throws DviException {
        return this.glyphInfos.containsKey(code);
    }

    public String getName() {
        return this.name;
    }

    public int getIdByte() {
        return this.idByte;
    }

    public byte[] getComment() {
        return (byte[])this.comment.clone();
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getDesignSize() {
        return this.designSize;
    }

    public int getDefaultFontNumber() {
        return this.defaultFontNumber;
    }

    private void parseInputStream(InputStream is) throws IOException, DviException {
        DviInputStreamReader in = new DviInputStreamReader(new BufferedInputStream(is, 1024));
        try {
            int c;
            if (247 != in.readU1()) {
                throw new DviException("VF data doesn't start with PRE");
            }
            this.idByte = in.readU1();
            if (this.idByte != 202) {
                throw new DviException("unknown id byte: " + this.idByte);
            }
            int commentSize = in.readU1();
            this.comment = new byte[commentSize];
            in.readFully(this.comment);
            this.checkSum = in.readS4();
            this.designSize = in.readS4();
            this.fontTable = new DviFontTable();
            boolean stop = false;
            do {
                c = in.readU1();
                switch (c) {
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: {
                        int t = c - 243 + 1;
                        int fn = in.readS(t);
                        int cs = in.readS4();
                        int ss = in.readS4();
                        int ds = in.readS4();
                        int al = in.readU1();
                        int nl = in.readU1();
                        if (this.defaultFontNumber == -1) {
                            this.defaultFontNumber = fn;
                        }
                        byte[] fontName = new byte[al + nl];
                        in.readFully(fontName);
                        this.fontTable.put(fn, DviFontSpec.getInstance(cs, ss, ds, al, nl, fontName));
                        break;
                    }
                    default: {
                        stop = true;
                    }
                }
            } while (!stop);
            while (true) {
                int macroLength;
                GlyphInfo gi = new GlyphInfo();
                if (c < 242) {
                    gi.type = 0;
                    macroLength = c;
                    gi.code = in.readU1();
                    gi.tfmw = in.readS3();
                    gi.macro = new byte[macroLength];
                    in.readFully(gi.macro);
                } else {
                    if (c != 242) {
                        if (c != 248) {
                            throw new DviException("VF data doesn't terminate with POST");
                        }
                        break;
                    }
                    gi.type = 242;
                    macroLength = in.readS4();
                    gi.code = in.readS4();
                    gi.tfmw = in.readS4();
                    gi.macro = new byte[macroLength];
                    in.readFully(gi.macro);
                }
                this.glyphInfos.put(gi.code, gi);
                c = in.readU1();
            }
        }
        catch (EOFException ex) {
            throw new DviException("VF file ended while reading glyphs.", ex);
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
    }

    protected PkGlyph generatePkGlyph(LogicalFont lf, int code) throws DviException {
        GlyphInfo gi = this.glyphInfos.get(code);
        if (gi == null) {
            return null;
        }
        DviResolution res = lf.resolution();
        RunLengthEncodedGlyph rlg = new RunLengthEncodedGlyph();
        BinaryDevice dev = rlg.getBinaryDevice(res);
        dev.translate(-res.dpi(), -res.dpi());
        DviExecutor exe = this.getDviContext().newDviExecutor();
        DevicePainter dp = this.getDviContext().newDevicePainter();
        dp.setOutput(dev);
        VirtualFontGeometer geometer = new VirtualFontGeometer(this, lf.fontSpec());
        geometer.setPainter(dp);
        DviFontTable ft = this.fontTable.transformForVirtualFont(lf.fontSpec(), this.designSize);
        byte[] buf = new byte[gi.macro.length + 1 + 4];
        int fn = this.defaultFontNumber;
        buf[0] = -18;
        buf[1] = (byte)(fn >>> 24 & 0xFF);
        buf[2] = (byte)(fn >>> 16 & 0xFF);
        buf[3] = (byte)(fn >>> 8 & 0xFF);
        buf[4] = (byte)(fn >>> 0 & 0xFF);
        System.arraycopy(gi.macro, 0, buf, 5, gi.macro.length);
        exe.execute(new ByteArrayDviData(buf, lf.dviUnit(), ft), geometer);
        return rlg.toPkGlyph();
    }

    public static String getDviResourceName(LogicalFont logicalFont) {
        return String.valueOf(logicalFont.fontSpec().name()) + ".vf";
    }

    private static class GlyphInfo
    implements Serializable {
        private static final long serialVersionUID = -3968612702338551000L;
        private int type;
        private int code;
        private int tfmw;
        private byte[] macro;

        private GlyphInfo() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[type=" + this.type + " code=" + this.code + " tfwm=" + this.tfmw + " macroLength=" + this.macro.length + "]";
        }
    }
}

