/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DragToScroll
extends MouseInputAdapter {
    private final JScrollPane jsp;
    private final JScrollBar hsb;
    private final JScrollBar vsb;
    private int saveX;
    private int saveY;

    public DragToScroll(JScrollPane jsp) {
        this.jsp = jsp;
        this.hsb = jsp.getHorizontalScrollBar();
        this.vsb = jsp.getVerticalScrollBar();
    }

    public JScrollPane scrollPane() {
        return this.jsp;
    }

    public void add(Component c) {
        if (c == null) {
            return;
        }
        this.addComponent(c);
        if (c instanceof Container) {
            Component[] cs = ((Container)c).getComponents();
            int i = 0;
            while (i < cs.length) {
                this.add(cs[i]);
                ++i;
            }
        }
    }

    private void addComponent(Component c) {
        c.addMouseMotionListener(this);
        c.addMouseListener(this);
    }

    public void remove(Component c) {
        if (c == null) {
            return;
        }
        if (c instanceof Container) {
            Component[] cs = ((Container)c).getComponents();
            int i = 0;
            while (i < cs.length) {
                this.remove(cs[i]);
                ++i;
            }
        }
        this.removeComponent(c);
    }

    private void removeComponent(Component c) {
        if (c == null) {
            return;
        }
        c.removeMouseMotionListener(this);
        c.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        DragToScroll.debug("mouseClicked");
    }

    public void mouseEntered(MouseEvent e) {
        DragToScroll.debug("mouseEntered");
    }

    public void mouseExited(MouseEvent e) {
        DragToScroll.debug("mouseExited");
    }

    private void savePoint(int x, int y) {
        this.saveX = x;
        this.saveY = y;
    }

    public void mousePressed(MouseEvent e) {
        DragToScroll.debug("mousePressed");
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Component c = (Component)e.getSource();
        c.setCursor(cursor);
        if (!e.isPopupTrigger()) {
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, e.getComponent());
            this.savePoint(p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent e) {
        DragToScroll.debug("mouseReleased");
        Component c = (Component)e.getSource();
        c.setCursor(null);
    }

    public void mouseDragged(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            Component c = e.getComponent();
            DragToScroll.debug(e.getSource() + ": mouseDragged");
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, c);
            int dx = p.x - this.saveX;
            int dy = p.y - this.saveY;
            DragToScroll.debug("(dx,dy)=(" + dx + "," + dy + ")");
            this.savePoint(p.x, p.y);
            if (dy == 0) {
                this.hsb.setValue(this.hsb.getValue() - dx);
            } else if (dx == 0) {
                this.vsb.setValue(this.vsb.getValue() - dy);
            } else {
                JViewport jv = this.jsp.getViewport();
                jv.scrollRectToVisible(new Rectangle(-dx, -dy, jv.getWidth(), jv.getHeight()));
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        DragToScroll.debug("mouseMoved");
    }

    private static void debug(String str) {
    }
}

