/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import dvi.DviException;
import dvi.DviRect;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviPage;
import dvi.ctx.DviToolkit;
import dvi.gui.swing.DefaultDviLayoutManager;
import dvi.gui.swing.DviLayoutManager;
import dvi.gui.swing.ViewSpec;
import dvi.util.DaemonThreadFactory;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TDviPage
extends JPanel
implements DviContextSupport,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(TDviPage.class.getName());
    private static final long serialVersionUID = -7167678585159838308L;
    private final DviContextSupport dcs;
    private DviPage page = null;
    private ViewSpec viewSpec;
    private DviRect bbox;
    private DviRect displayRect = null;
    private static ExecutorService exe = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
    private DviLayoutManager layout = new DefaultDviLayoutManager(this, 1);

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    public TDviPage(DviContextSupport dcs, DviPage page) {
        this.dcs = dcs;
        this.viewSpec = new ViewSpec(this);
        this.viewSpec.setResolution(this.viewSpec.getResolution().approximate(200.0));
        this.setPage(page);
    }

    public TDviPage(DviContextSupport dcs) {
        this(dcs, null);
    }

    public void setPage(DviPage page) {
        this.page = page;
        this.determineSize();
    }

    public DviPage getPage() {
        return this.page;
    }

    public void setViewSpec(ViewSpec viewSpec) {
        LOGGER.fine("page=" + this.page + ",viewSpec=" + viewSpec);
        this.viewSpec = viewSpec;
        this.determineSize();
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }

    public void setBoundingBox(DviRect bbox) {
        this.bbox = bbox;
        this.determineSize();
    }

    public DviRect getBoundingBox() {
        return this.bbox;
    }

    public void determineSize() {
        DviToolkit utils = this.getDviContext().getDviToolkit();
        this.displayRect = null;
        try {
            if (this.layout != null) {
                this.displayRect = this.layout.determinePageSize(this);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.toString());
            e.printStackTrace();
        }
        if (this.displayRect == null) {
            this.displayRect = utils.computePageBoundingBox(this.viewSpec.getPaperSize(), this.viewSpec.getResolution());
        }
        this.setPreferredSize(new Dimension(this.displayRect.width(), this.displayRect.height()));
        this.setSize(new Dimension(this.displayRect.width(), this.displayRect.height()));
        this.revalidate();
    }

    protected ExecutorService getExecutorService() {
        return exe;
    }

    protected void startPagePreparation(Graphics g, Rectangle rect, final DviPage page, final ViewSpec viewSpec) {
        final DviToolkit utils = this.getDviContext().getDviToolkit();
        LOGGER.finer("Preparing page for paint: " + page);
        this.getExecutorService().submit(new Runnable(){

            public void run() {
                try {
                    utils.prepareForRendering(page, viewSpec);
                }
                catch (Exception e) {
                    LOGGER.warning(e.toString());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TDviPage.this.repaint();
                    }
                });
            }
        });
        this.paintDummyContents(g, rect, viewSpec);
    }

    private void paintDummyContents(Graphics g, Rectangle rect, ViewSpec viewSpec) {
        g.setColor(viewSpec.getBackgroundColor().toColor());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        DviToolkit utils = this.getDviContext().getDviToolkit();
        if (this.page == null) {
            return;
        }
        Rectangle rect = g.getClipBounds();
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        boolean enableDelayedRendering = true;
        try {
            enableDelayedRendering = this.getEnableDelayedRendering();
        }
        catch (DviException e1) {
            LOGGER.warning(e1.toString());
        }
        if (enableDelayedRendering && !utils.canRenderPageImmediately(this.page, this.viewSpec)) {
            LOGGER.finest("delayed rendering");
            this.startPagePreparation(g, rect, this.page, this.viewSpec);
        }
        try {
            LOGGER.finest("rendering page with viewSpec=" + this.viewSpec);
            DviRect targetArea = new DviRect(rect.x + this.displayRect.x(), rect.y + this.displayRect.y(), rect.width, rect.height);
            BufferedImage img = utils.renderToBufferedImage(this.page, targetArea, this.viewSpec);
            g.drawImage(img, rect.x, rect.y, null);
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
            e.printStackTrace();
            this.paintDummyContents(g, rect, this.viewSpec);
        }
    }

    public void stateChanged(ChangeEvent e) {
        LOGGER.fine("stateChanged called: EDT=" + SwingUtilities.isEventDispatchThread());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TDviPage.this.determineSize();
                TDviPage.this.revalidate();
                TDviPage.this.repaint();
            }
        });
    }

    public boolean getEnableDelayedRendering() throws DviException {
        if (this.layout == null) {
            return true;
        }
        return this.layout.getEnableDelayedRendering(this);
    }

    public DviLayoutManager getDviLayout() {
        return this.layout;
    }

    public void setDviLayout(DviLayoutManager layout) {
        if (layout == null) {
            throw new NullPointerException("layout");
        }
        this.layout = layout;
    }
}

