/*
 * Decompiled with CFR 0.152.
 */
package dvi.io;

import dvi.api.DviInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DviInputStreamReader
implements DviInput {
    private final InputStream in;
    private long offset = 0L;
    private long end = Long.MAX_VALUE;

    public DviInputStreamReader(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public int readU1() throws IOException {
        if (this.offset > this.end) {
            throw new EOFException();
        }
        int c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        ++this.offset;
        return c;
    }

    public void readFully(byte[] buf) throws IOException {
        if (buf == null) {
            return;
        }
        if (buf.length <= 0) {
            return;
        }
        if (this.offset + (long)buf.length - 1L > this.end) {
            throw new EOFException();
        }
        if (buf.length != this.in.read(buf)) {
            throw new EOFException("while filling the buffer.");
        }
        this.offset += (long)buf.length;
    }

    /*
     * Unable to fully structure code
     */
    public int readU(int len) throws IOException {
        v = 0;
        if (len > 0 && len <= 4) ** GOTO lbl6
        throw new IllegalArgumentException("illegal value of len: " + len);
lbl-1000:
        // 1 sources

        {
            v = v << 8 | this.readU1();
            --len;
lbl6:
            // 2 sources

            ** while (len > 0)
        }
lbl7:
        // 1 sources

        return v;
    }

    /*
     * Unable to fully structure code
     */
    public int readS(int len) throws IOException {
        bits = len * 8;
        a = 1;
        v = 0;
        if (len > 0 && len <= 4) ** GOTO lbl9
        throw new IllegalArgumentException("illegal value of len: " + len);
lbl-1000:
        // 1 sources

        {
            v = v << 8 | this.readU1();
            a <<= 8;
            --len;
lbl9:
            // 2 sources

            ** while (len > 0)
        }
lbl10:
        // 1 sources

        if ((v & 1 << bits - 1) != 0) {
            v -= a;
        }
        return v;
    }

    public int readU2() throws IOException {
        return this.readU1() << 8 | this.readU1();
    }

    public int readU3() throws IOException {
        return this.readU1() << 16 | this.readU1() << 8 | this.readU1();
    }

    public int readU4() throws IOException {
        return this.readU1() << 24 | this.readU1() << 16 | this.readU1() << 8 | this.readU1();
    }

    public int readS1() throws IOException {
        return this.readS(1);
    }

    public int readS2() throws IOException {
        return this.readS(2);
    }

    public int readS3() throws IOException {
        return this.readS(3);
    }

    public int readS4() throws IOException {
        return this.readS(4);
    }

    public void skip(int len) throws IOException {
        long skipped = this.in.skip(len);
        if (skipped > 0L) {
            this.offset += skipped;
        }
        long left = (long)len - skipped;
        while (left > 0L) {
            this.readU1();
            --left;
        }
    }
}

