/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviByteRange;
import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviData;
import dvi.api.DviExecutor;
import dvi.api.DviExecutorContext;
import dvi.api.DviExecutorHandler;
import dvi.api.DviInput;
import dvi.cmd.DviBop;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import dvi.render.EmptyHandler;
import java.io.EOFException;
import java.io.IOException;

public class BasicExecutor
extends DviObject
implements DviExecutor {
    private static final DviExecutorHandler defaultHandler = new EmptyHandler();
    private DviExecutorContextImpl ctx;

    public BasicExecutor(DviContextSupport dcs) {
        super(dcs);
    }

    public void execute(DviData data) throws DviException {
        this.execute(data, null);
    }

    protected DviExecutorContextImpl getExecutorContext() {
        return this.ctx;
    }

    public void execute(DviData data, DviExecutorHandler handler) throws DviException {
        this.ctx = new DviExecutorContextImpl(this);
        this.ctx.data = data;
        this.ctx.handler = handler != null ? handler : BasicExecutor.defaultHandler;
        this.ctx.in = data.getInput();
        this.ctx.terminate = false;
        if (this.ctx.handler == null) {
            throw new NullPointerException("handler is null");
        }
        if (this.ctx.data == null) {
            throw new NullPointerException("data is null");
        }
        if (this.ctx.in == null) {
            throw new NullPointerException("input is null");
        }
        try {
            try {
                this.begin(this.ctx);
                try {
                    try {
                        while (!this.ctx.terminate) {
                            this.executeOneCommand(this.ctx);
                        }
                    }
                    catch (EOFException eOFException) {
                        this.end();
                    }
                }
                finally {
                    this.end();
                }
            }
            catch (DviException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new DviException(ex);
            }
        }
        finally {
            try {
                this.ctx.in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void executeOneCommand(DviExecutorContextImpl ctx) throws IOException, DviException {
        DviInput in = ctx.in;
        long l = in.getOffset();
        ctx.commandEnd = l;
        ctx.commandBegin = l;
        int n = in.readU1();
        ctx.command = n;
        int t = n;
        if (t <= 127) {
            if (this.wantSet()) {
                ctx.commandDetermined();
                this.doSet(t);
            }
        } else if (171 <= t && t <= 234) {
            if (this.wantSelectFont()) {
                ctx.commandDetermined();
                this.doSelectFont(t - 171);
            }
        } else {
            switch (t) {
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    int alen = t - 128 + 1;
                    if (this.wantSet()) {
                        int code = in.readU(alen);
                        ctx.commandDetermined();
                        this.doSet(code);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: {
                    int alen = t - 133 + 1;
                    if (this.wantPut()) {
                        int code = in.readU(alen);
                        ctx.commandDetermined();
                        this.doPut(code);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 235: 
                case 236: 
                case 237: 
                case 238: {
                    int alen = t - 235 + 1;
                    if (this.wantSelectFont()) {
                        int fn = in.readU(alen);
                        ctx.commandDetermined();
                        this.doSelectFont(fn);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    int alen = t - 239 + 1;
                    int k = in.readU(alen);
                    if (this.wantSpecial()) {
                        byte[] xxx = new byte[k];
                        in.readFully(xxx);
                        ctx.commandDetermined();
                        this.doSpecial(xxx);
                        break;
                    }
                    in.skip(alen + k);
                    break;
                }
                case 132: {
                    if (this.wantSetRule()) {
                        int h = in.readS4();
                        int w = in.readS4();
                        ctx.commandDetermined();
                        this.doSetRule(w, h);
                        break;
                    }
                    in.skip(8);
                    break;
                }
                case 137: {
                    if (this.wantPutRule()) {
                        int h = in.readS4();
                        int w = in.readS4();
                        ctx.commandDetermined();
                        this.doPutRule(w, h);
                        break;
                    }
                    in.skip(8);
                    break;
                }
                case 243: 
                case 244: 
                case 245: 
                case 246: {
                    int alen = t - 243 + 1;
                    if (this.wantDefineFont()) {
                        int fn = in.readU(alen);
                        int cs = in.readS4();
                        int ss = in.readS4();
                        int ds = in.readS4();
                        int al = in.readU1();
                        int nl = in.readU1();
                        byte[] fontName = new byte[al + nl];
                        in.readFully(fontName);
                        ctx.commandDetermined();
                        this.doDefineFont(fn, DviFontSpec.getInstance(cs, ss, ds, al, nl, fontName));
                        break;
                    }
                    in.skip(alen + 4 + 4 + 4);
                    int al = in.readU1();
                    int nl = in.readU1();
                    in.skip(al + nl);
                    break;
                }
                case 143: 
                case 144: 
                case 145: 
                case 146: {
                    int alen = t - 143 + 1;
                    if (this.wantRight()) {
                        int dh = in.readS(alen);
                        ctx.commandDetermined();
                        this.doRight(dh);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: {
                    int alen = t - 148 + 1;
                    if (this.wantW()) {
                        int dh = in.readS(alen);
                        ctx.commandDetermined();
                        this.doW(dh);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 147: {
                    if (!this.wantW0()) break;
                    ctx.commandDetermined();
                    this.doW0();
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: {
                    int alen = t - 153 + 1;
                    if (this.wantX()) {
                        int dh = in.readS(alen);
                        ctx.commandDetermined();
                        this.doX(dh);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 152: {
                    if (!this.wantX0()) break;
                    ctx.commandDetermined();
                    this.doX0();
                    break;
                }
                case 157: 
                case 158: 
                case 159: 
                case 160: {
                    int alen = t - 157 + 1;
                    if (this.wantDown()) {
                        int dv = in.readS(alen);
                        ctx.commandDetermined();
                        this.doDown(dv);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 162: 
                case 163: 
                case 164: 
                case 165: {
                    int alen = t - 162 + 1;
                    if (this.wantY()) {
                        int dv = in.readS(alen);
                        ctx.commandDetermined();
                        this.doY(dv);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 161: {
                    if (!this.wantY0()) break;
                    ctx.commandDetermined();
                    this.doY0();
                    break;
                }
                case 167: 
                case 168: 
                case 169: 
                case 170: {
                    int alen = t - 167 + 1;
                    if (this.wantZ()) {
                        int dv = in.readS(alen);
                        ctx.commandDetermined();
                        this.doZ(dv);
                        break;
                    }
                    in.skip(alen);
                    break;
                }
                case 166: {
                    if (!this.wantZ0()) break;
                    ctx.commandDetermined();
                    this.doZ0();
                    break;
                }
                case 141: {
                    if (!this.wantPush()) break;
                    ctx.commandDetermined();
                    this.doPush();
                    break;
                }
                case 142: {
                    if (!this.wantPop()) break;
                    ctx.commandDetermined();
                    this.doPop();
                    break;
                }
                case 138: {
                    if (!this.wantNop()) break;
                    ctx.commandDetermined();
                    this.doNop();
                    break;
                }
                case 139: {
                    if (this.wantBop()) {
                        int[] count = new int[10];
                        int i = 0;
                        while (i < 10) {
                            count[i] = in.readS4();
                            ++i;
                        }
                        int backPointer = in.readS4();
                        ctx.commandDetermined();
                        this.doBop(new DviBop(count, backPointer));
                        break;
                    }
                    in.skip(44);
                    break;
                }
                case 140: {
                    if (!this.wantEop()) break;
                    ctx.commandDetermined();
                    this.doEop();
                    break;
                }
                case 247: {
                    if (this.wantPre()) {
                        int idByte = in.readU1();
                        int num = in.readS4();
                        int den = in.readS4();
                        int mag = in.readS4();
                        int commentSize = in.readU1();
                        byte[] comment = new byte[commentSize];
                        in.readFully(comment);
                        ctx.commandDetermined();
                        this.doPre(new DviPreamble(idByte, DviUnit.getInstance(num, den, mag), comment));
                        break;
                    }
                    in.skip(13);
                    int commentSize = in.readU1();
                    in.skip(commentSize);
                    break;
                }
                case 248: {
                    if (this.wantPost()) {
                        int firstBackPointer = in.readS4();
                        int num = in.readS4();
                        int den = in.readS4();
                        int mag = in.readS4();
                        int maxV = in.readS4();
                        int maxH = in.readS4();
                        int maxStackDepth = in.readU2();
                        int totalPages = in.readU2();
                        ctx.commandDetermined();
                        this.doPost(new DviPostamble(firstBackPointer, DviUnit.getInstance(num, den, mag), maxV, maxH, maxStackDepth, totalPages));
                        break;
                    }
                    in.skip(28);
                    break;
                }
                case 249: {
                    if (this.wantPostPost()) {
                        int postamblePointer = in.readS4();
                        int idByte = in.readU1();
                        ctx.commandDetermined();
                        this.doPostPost(new DviPostPost(postamblePointer, idByte));
                    } else {
                        in.skip(5);
                    }
                    ctx.setTerminate(true);
                    break;
                }
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    ctx.commandDetermined();
                    break;
                }
                case 255: {
                    ctx.commandDetermined();
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal executer state.");
                }
            }
        }
    }

    public boolean wantSet() {
        return true;
    }

    public boolean wantPut() {
        return true;
    }

    public boolean wantSelectFont() {
        return true;
    }

    public boolean wantSpecial() {
        return true;
    }

    public boolean wantSetRule() {
        return true;
    }

    public boolean wantPutRule() {
        return true;
    }

    public boolean wantDefineFont() {
        return true;
    }

    public boolean wantRight() {
        return true;
    }

    public boolean wantW() {
        return true;
    }

    public boolean wantW0() {
        return true;
    }

    public boolean wantX() {
        return true;
    }

    public boolean wantX0() {
        return true;
    }

    public boolean wantDown() {
        return true;
    }

    public boolean wantY() {
        return true;
    }

    public boolean wantY0() {
        return true;
    }

    public boolean wantZ() {
        return true;
    }

    public boolean wantZ0() {
        return true;
    }

    public boolean wantPush() {
        return true;
    }

    public boolean wantPop() {
        return true;
    }

    public boolean wantNop() {
        return true;
    }

    public boolean wantBop() {
        return true;
    }

    public boolean wantEop() {
        return true;
    }

    public boolean wantPre() {
        return true;
    }

    public boolean wantPost() {
        return true;
    }

    public boolean wantPostPost() {
        return true;
    }

    public void begin(DviExecutorContext ctx) throws DviException {
        this.ctx.handler.begin(ctx);
    }

    public void end() throws DviException {
        this.ctx.handler.end();
    }

    public void doSet(int code) throws DviException {
        this.ctx.handler.doSet(code);
    }

    public void doSetRule(int w, int h) throws DviException {
        this.ctx.handler.doSetRule(w, h);
    }

    public void doPut(int code) throws DviException {
        this.ctx.handler.doPut(code);
    }

    public void doPutRule(int w, int h) throws DviException {
        this.ctx.handler.doPutRule(w, h);
    }

    public void doNop() throws DviException {
        this.ctx.handler.doNop();
    }

    public void doSelectFont(int fn) throws DviException {
        this.ctx.handler.doSelectFont(fn);
    }

    public void doDefineFont(int fn, DviFontSpec fs) throws DviException {
        this.ctx.handler.doDefineFont(fn, fs);
    }

    public void doPush() throws DviException {
        this.ctx.handler.doPush();
    }

    public void doPop() throws DviException {
        this.ctx.handler.doPop();
    }

    public void doPre(DviPreamble preamble) throws DviException {
        this.ctx.handler.doPre(preamble);
    }

    public void doBop(DviBop bop) throws DviException {
        this.ctx.handler.doBop(bop);
    }

    public void doEop() throws DviException {
        this.ctx.handler.doEop();
    }

    public void doPost(DviPostamble postamble) throws DviException {
        this.ctx.handler.doPost(postamble);
    }

    public void doPostPost(DviPostPost postPost) throws DviException {
        this.ctx.handler.doPostPost(postPost);
    }

    public void doRight(int by) throws DviException {
        this.ctx.handler.doRight(by);
    }

    public void doW(int by) throws DviException {
        this.ctx.handler.doW(by);
    }

    public void doW0() throws DviException {
        this.ctx.handler.doW0();
    }

    public void doX(int by) throws DviException {
        this.ctx.handler.doX(by);
    }

    public void doX0() throws DviException {
        this.ctx.handler.doX0();
    }

    public void doDown(int by) throws DviException {
        this.ctx.handler.doDown(by);
    }

    public void doY(int by) throws DviException {
        this.ctx.handler.doY(by);
    }

    public void doY0() throws DviException {
        this.ctx.handler.doY0();
    }

    public void doZ(int by) throws DviException {
        this.ctx.handler.doZ(by);
    }

    public void doZ0() throws DviException {
        this.ctx.handler.doZ0();
    }

    public void doSpecial(byte[] xxx) throws DviException {
        this.ctx.handler.doSpecial(xxx);
    }

    protected static class DviExecutorContextImpl
    extends DviObject
    implements DviExecutorContext {
        private DviData data;
        private DviInput in;
        private DviExecutorHandler handler;
        private int command;
        private long commandBegin;
        private long commandEnd;
        private boolean terminate = false;

        public DviExecutorContextImpl(DviContextSupport dcs) {
            super(dcs);
        }

        public DviData getData() {
            return this.data;
        }

        public int getCommand() {
            return this.command;
        }

        public DviByteRange getCommandRange() {
            return new DviByteRange(this.commandBegin, this.commandEnd);
        }

        public void setTerminate(boolean f) {
            this.terminate = f;
        }

        private void commandDetermined() {
            this.commandEnd = this.in.getOffset() - 1L;
        }
    }
}

