/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.api.DviExecutorContext;
import dvi.api.DviExecutorHandler;
import dvi.cmd.DviBop;
import dvi.cmd.DviCommand;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import java.io.PrintStream;

public class DumpHandler
implements DviExecutorHandler {
    private DviExecutorContext ctx;
    private final PrintStream out;

    public DumpHandler(PrintStream out) {
        this.out = out;
        if (out == null) {
            throw new NullPointerException("output cannot be null");
        }
    }

    public void begin(DviExecutorContext ctx) throws DviException {
        this.ctx = ctx;
    }

    public void end() throws DviException {
        this.ctx = null;
    }

    public void doSet(int code) throws DviException {
        this.dump("code=" + code);
    }

    public void doSetRule(int w, int h) throws DviException {
        this.dump("set_rule: w=" + w + " h=" + h);
    }

    public void doPut(int code) throws DviException {
        this.dump("code=" + code);
    }

    public void doPutRule(int w, int h) throws DviException {
        this.dump("put_rule: w=" + w + " h=" + h);
    }

    public void doNop() throws DviException {
        this.dump("");
    }

    public void doSelectFont(int fn) throws DviException {
        this.dump(": fn=" + fn);
    }

    public void doDefineFont(int fn, DviFontSpec fs) throws DviException {
        this.dump(": fn=" + fn + " fs=" + fs);
    }

    public void doPush() throws DviException {
        this.dump("");
    }

    public void doPop() throws DviException {
        this.dump("");
    }

    public void doPre(DviPreamble preamble) throws DviException {
        this.dump(preamble.toString());
    }

    public void doBop(DviBop bop) throws DviException {
        this.dump(bop.toString());
    }

    public void doEop() throws DviException {
        this.dump("");
    }

    public void doPost(DviPostamble postamble) throws DviException {
        this.dump(postamble.toString());
    }

    public void doPostPost(DviPostPost postPost) throws DviException {
        this.dump(postPost.toString());
    }

    public void doRight(int by) throws DviException {
        this.dump("dh=" + by);
    }

    public void doW(int by) throws DviException {
        this.dump("dh=" + by);
    }

    public void doW0() throws DviException {
        this.dump("");
    }

    public void doX(int by) throws DviException {
        this.dump("dh=" + by);
    }

    public void doX0() throws DviException {
    }

    public void doDown(int by) throws DviException {
        this.dump("dv=" + by);
    }

    public void doY(int by) throws DviException {
        this.dump("dv=" + by);
    }

    public void doY0() throws DviException {
        this.dump("");
    }

    public void doZ(int by) throws DviException {
        this.dump("dv=" + by);
    }

    public void doZ0() throws DviException {
        this.dump("");
    }

    public void doSpecial(byte[] xxx) throws DviException {
        this.dump(new String(xxx));
    }

    private void dump(String msg) {
        this.out.println(String.valueOf(this.ctx.getCommandRange().toString()) + ": " + DviCommand.getName(this.ctx.getCommand()) + ": " + msg);
    }
}

