/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.GammaCorrector;
import dvi.api.ImageDevice;
import dvi.render.AbstractDevice;
import dvi.render.DefaultGammaCorrector;
import dvi.render.GammaCorrectorCache;

public class IntRGBImage {
    private final int[] buf;
    private final int width;
    private final int height;

    public IntRGBImage(int width, int height) {
        this.buf = new int[width * height];
        this.width = width;
        this.height = height;
    }

    public IntRGBImage(int[] buf, int width, int height) {
        this.buf = buf;
        this.width = width;
        this.height = height;
    }

    public int[] getBuffer() {
        return this.buf;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void fill(int c) {
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = c;
            ++i;
        }
    }

    public ImageDevice getImageDevice(DviResolution res, GammaCorrector gc) {
        return new ImageDeviceImpl(res, gc);
    }

    public ImageDevice getImageDevice(DviResolution res) {
        return this.getImageDevice(res, null);
    }

    private static int blend(int c1, int c2, int alpha10) {
        int b = c1 & 0xFF;
        b += alpha10 * ((c2 & 0xFF) - b) >>> 10;
        int g = (c1 >>>= 8) & 0xFF;
        g += alpha10 * (((c2 >>>= 8) & 0xFF) - g) >>> 10;
        int r = (c1 >>>= 8) & 0xFF;
        r += alpha10 * (((c2 >>>= 8) & 0xFF) - r) >>> 10;
        return (r &= 0xFF) << 16 | (g &= 0xFF) << 8 | (b &= 0xFF);
    }

    private class ImageDeviceImpl
    extends AbstractDevice
    implements ImageDevice {
        private final GammaCorrector originalGammaCorrector;
        private GammaCorrector gammaCorrector;
        private int maxval;
        private int ptr;

        protected ImageDeviceImpl(DviResolution res, GammaCorrector gammaCorrector) {
            super(res);
            this.ptr = 0;
            this.originalGammaCorrector = gammaCorrector == null ? new DefaultGammaCorrector() : gammaCorrector;
        }

        public DviRect getBounds() {
            return new DviRect(-this.point.x, -this.point.y, IntRGBImage.this.width, IntRGBImage.this.height);
        }

        public void begin(int maxval) {
            this.maxval = maxval;
            this.gammaCorrector = new GammaCorrectorCache(this.originalGammaCorrector);
        }

        public void end() {
        }

        public boolean beginImage(int w, int h) throws DviException {
            this.ptr = this.point.x + this.point.y * IntRGBImage.this.width;
            return true;
        }

        public void endImage() {
        }

        public void putLine(int[] l_buf, int off, int len) throws DviException {
            int color = this.getColor().toIntRGB();
            int i = 0;
            while (i < len) {
                int alpha10 = this.gammaCorrector.correctGamma(l_buf[off + i], this.maxval);
                if (alpha10 != 0) {
                    ((IntRGBImage)IntRGBImage.this).buf[this.ptr + i] = IntRGBImage.blend(IntRGBImage.this.buf[this.ptr + i], color, alpha10);
                }
                ++i;
            }
            this.ptr += IntRGBImage.this.width;
        }
    }
}

