/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviFontSpec;
import dvi.DviRegister;
import dvi.api.DviContextSupport;
import dvi.cmd.DviBop;
import dvi.render.DefaultDevicePainter;
import dvi.special.EmbeddedPostScript;
import java.io.File;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostScriptSpecialParser
extends DefaultDevicePainter {
    private static final Logger LOGGER = Logger.getLogger(PostScriptSpecialParser.class.getName());
    private static final Pattern patPS = Pattern.compile("\\s*ps:\\s*(.*)", 2);
    private static final Pattern patHeader = Pattern.compile("\\s*header\\s*=\\s*(.*)", 2);
    private static final Pattern patPSFile = Pattern.compile("\\s*PSFile\\s*=\\s*([^\\s]*)\\s+(.*)\\s*", 2);
    private File workDir;
    private final EmbeddedPostScript eps = new EmbeddedPostScript();
    private int pageNum = 0;

    public PostScriptSpecialParser(DviContextSupport dcs) {
        super(dcs);
    }

    public void setWorkDirectory(File dir) {
        this.workDir = dir;
    }

    public File getWorkDirectory() {
        return this.workDir;
    }

    public EmbeddedPostScript getEmbeddedPostScript() {
        return this.eps;
    }

    public void beginPage(DviBop bop) {
        this.eps.beginPage(this.pageNum);
    }

    public void endPage() {
        this.eps.endPage();
        ++this.pageNum;
    }

    public void beginFont(DviFontSpec fs) {
    }

    public void endFont() {
    }

    public void drawChar(int code) {
    }

    public void drawRule(int w, int h) {
    }

    protected String toAbsoluteFilename(String filename) {
        File file = new File(this.workDir, filename);
        LOGGER.finer("Resolved filename=" + filename + " to " + file.getAbsolutePath());
        return file.getAbsolutePath();
    }

    public void drawSpecial(byte[] _xxx) {
        String xxx = new String(_xxx);
        LOGGER.finer("handling special: " + xxx);
        if (xxx.startsWith("\"")) {
            DviRegister reg = this.getGeometerContext().getRegister();
            this.eps.add(new EmbeddedPostScript.QuoteSpecial(reg.getH(), reg.getV(), this.getDviUnit(), xxx.substring(1).trim()));
        } else if (xxx.startsWith("!")) {
            this.eps.add(new EmbeddedPostScript.BangSpecial(xxx.substring(1).trim()));
        } else {
            Matcher mat = patPS.matcher(xxx);
            if (mat.matches()) {
                DviRegister reg = this.getGeometerContext().getRegister();
                this.eps.add(new EmbeddedPostScript.PSSpecial(reg.getH(), reg.getV(), this.getDviUnit(), mat.group(1)));
            } else {
                mat = patHeader.matcher(xxx);
                if (mat.matches()) {
                    LOGGER.finer("PSHeader special found: " + xxx);
                    this.eps.add(new EmbeddedPostScript.HeaderSpecial(PostScriptSpecialParser.trimQuotes(mat.group(1))));
                } else {
                    mat = patPSFile.matcher(xxx);
                    if (mat.matches()) {
                        LOGGER.finer("page=" + this.pageNum + " PSFile special found: " + xxx);
                        String fileName = this.toAbsoluteFilename(PostScriptSpecialParser.trimQuotes(mat.group(1)));
                        String options = mat.group(2);
                        int llx = 0;
                        int lly = 0;
                        int urx = 0;
                        int ury = 0;
                        int rwi = 0;
                        int rhi = 0;
                        int angle = 0;
                        String[] os = Pattern.compile("\\s+").split(options);
                        int i = 0;
                        while (i < os.length) {
                            Matcher mat2 = Pattern.compile("([a-z]+)=(-?[.0-9]+)").matcher(os[i]);
                            if (mat2.matches()) {
                                try {
                                    String var = mat2.group(1);
                                    int val = Integer.parseInt(mat2.group(2));
                                    if ("llx".equals(var)) {
                                        llx = val;
                                    }
                                    if ("lly".equals(var)) {
                                        lly = val;
                                    }
                                    if ("urx".equals(var)) {
                                        urx = val;
                                    }
                                    if ("ury".equals(var)) {
                                        ury = val;
                                    }
                                    if ("rwi".equals(var)) {
                                        rwi = val;
                                    }
                                    if ("rhi".equals(var)) {
                                        rhi = val;
                                    }
                                    if ("angle".equals(var)) {
                                        angle = val;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                        DviRegister reg = this.getGeometerContext().getRegister();
                        this.eps.add(new EmbeddedPostScript.PSFileSpecial(reg.getH(), reg.getV(), this.getDviUnit(), fileName, llx, lly, urx, ury, rwi, rhi, angle));
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String trimQuotes(String str) {
        if (str != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            str = str.substring(1);
lbl4:
            // 2 sources

            ** while (str.startsWith((String)"\""))
        }
lbl5:
        // 2 sources

        while (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

