/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.concurrent;

import dvi.util.concurrent.Computation;
import dvi.util.concurrent.Computer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheEntry<K, V> {
    private final Computer<K, V> cachedComputer;
    private final Computation<K, V> computable;
    private final Future<V> future;
    private final long serialNumber;
    private static final AtomicLong serializer = new AtomicLong();

    public CacheEntry(Computer<K, V> cachedComputer, Computation<K, V> computable, Future<V> future) {
        this.cachedComputer = cachedComputer;
        this.computable = computable;
        this.future = future;
        this.serialNumber = serializer.incrementAndGet();
    }

    public Computer<K, V> getCachedComputer() {
        return this.cachedComputer;
    }

    public Computation<K, V> getComputable() {
        return this.computable;
    }

    public Future<V> getFuture() {
        return this.future;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "serialNumber=" + this.serialNumber + ",key=" + this.computable.getCacheKey() + ",future=" + this.future + "]";
    }
}

