/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.concurrent;

import dvi.util.concurrent.CacheEntry;
import dvi.util.concurrent.Computation;
import dvi.util.concurrent.Computer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedComputer<K, V>
implements Computer<K, V> {
    private static final Logger LOGGER = Logger.getLogger(CachedComputer.class.getName());
    private final Map<K, CacheEntry<K, V>> map;
    private final Computer<K, V> computer;

    public CachedComputer(Computer<K, V> computer) {
        this.computer = computer;
        this.map = Collections.synchronizedMap(this.createCache());
    }

    protected Map<K, CacheEntry<K, V>> createCache() {
        return new LinkedHashMap<K, CacheEntry<K, V>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<K, V>> eldest) {
                boolean doRemove = CachedComputer.this.removeEldestEntry(eldest);
                LOGGER.finer("doRemove = " + doRemove);
                return doRemove;
            }
        };
    }

    protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<K, V>> entry) {
        return false;
    }

    protected synchronized Future<V> startComputation(Computation<K, V> computable) {
        Future<V> future = this.computer.compute(computable);
        return future;
    }

    @Override
    public synchronized Future<V> compute(Computation<K, V> computable) {
        Object key = computable.getCacheKey();
        if (key == null) {
            LOGGER.finer("Key is null: " + computable);
            Future<V> future = this.startComputation(computable);
            return future;
        }
        CacheEntry<K, V> cacheEntry = this.map.get(key);
        if (cacheEntry == null) {
            LOGGER.finer("Cache miss: " + key);
            Future<V> future = this.startComputation(computable);
            cacheEntry = new CacheEntry<K, V>(this, computable, future);
            this.getCache().put(key, cacheEntry);
            LOGGER.finer("Wrote cache: key=" + key + " value=" + future);
        } else {
            LOGGER.finest("Cache hit: " + key);
        }
        return cacheEntry.getFuture();
    }

    public synchronized Future<V> getCachedResult(Computation<K, V> computable) {
        Object key = computable.getCacheKey();
        if (key == null) {
            return null;
        }
        CacheEntry<K, V> cacheEntry = this.map.get(key);
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getFuture();
    }

    public Map<K, CacheEntry<K, V>> getCache() {
        return this.map;
    }
}

