/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.progress;

import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.util.progress.ManagedProgressItem;
import dvi.util.progress.ProgressEvent;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractProgressModel
extends DviObject {
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractProgressModel(DviContextSupport dcs) {
        super(dcs);
    }

    public void addProgressListener(ProgressListener l) {
        this.listenerList.add(ProgressListener.class, l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(ProgressListener.class, l);
    }

    protected void fireProgressOpenEvent(ManagedProgressItem item) {
        ProgressEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ProgressListener.class) {
                if (event == null) {
                    event = new ProgressEvent(this, item);
                }
                ((ProgressListener)listeners[i + 1]).progressOpen(event);
            }
            i -= 2;
        }
    }

    protected void fireProgressCloseEvent(ManagedProgressItem item) {
        ProgressEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ProgressListener.class) {
                if (event == null) {
                    event = new ProgressEvent(this, item);
                }
                ((ProgressListener)listeners[i + 1]).progressClose(event);
            }
            i -= 2;
        }
    }

    protected void fireProgressUpdateEvent(ManagedProgressItem item) {
        ProgressEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ProgressListener.class) {
                if (event == null) {
                    event = new ProgressEvent(this, item);
                }
                ((ProgressListener)listeners[i + 1]).progressUpdate(event);
            }
            i -= 2;
        }
    }

    public abstract ProgressItem getMostRecentItem();
}

