/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.progress;

import dvi.DviException;
import dvi.api.DviContextSupport;
import dvi.util.progress.AbstractProgressModel;
import dvi.util.progress.ManagedProgressItem;
import dvi.util.progress.ProgressBlock;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressRecorder
extends AbstractProgressModel {
    private final ArrayList<ManagedProgressItem> list = new ArrayList();

    public ProgressRecorder(DviContextSupport dcs) {
        super(dcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInternal(ManagedProgressItem newWrappedItem) {
        if (newWrappedItem == null) {
            return;
        }
        ArrayList<ManagedProgressItem> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(newWrappedItem);
            while (this.list.size() > 0) {
                ManagedProgressItem wrappedItem = this.list.get(0);
                boolean remove = this.removeEldestElement(wrappedItem);
                if (!remove) break;
                this.list.remove(0);
            }
        }
    }

    protected List<ManagedProgressItem> getProgressItems() {
        return Collections.unmodifiableList(this.list);
    }

    protected boolean removeEldestElement(ManagedProgressItem item) {
        return false;
    }

    public void append(ProgressItem item) throws DviException {
        if (item == null) {
            return;
        }
        ManagedProgressItem wrappedItem = (ManagedProgressItem)this.open(item, 0, 0);
        wrappedItem.close();
    }

    public void append(String msg) throws DviException {
        this.append(new ProgressMessage(this, msg));
    }

    public ProgressItem open(String msg, int start, int end) throws DviException {
        ProgressBlock item = new ProgressBlock(this, msg);
        return this.open(item, start, end);
    }

    public ProgressItem open(String msg) throws DviException {
        return this.open(msg, 0, 1);
    }

    protected ProgressItem open(ProgressItem item, int start, int end) throws DviException {
        if (start > end) {
            throw new IllegalArgumentException("Invalid value range: start=" + start + " end=" + end);
        }
        ManagedProgressItem wrappedItem = new ManagedProgressItem(this, item);
        wrappedItem.open(start, end);
        this.addInternal(wrappedItem);
        return wrappedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressItem getMostRecentItem() {
        ManagedProgressItem managedItem = null;
        ArrayList<ManagedProgressItem> arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            if (size != 0) {
                managedItem = this.list.get(size - 1);
            }
        }
        if (managedItem != null) {
            return managedItem.getOriginalItem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressItem[] getOpenItems() {
        ArrayList<ProgressItem> items = new ArrayList<ProgressItem>();
        ArrayList<ManagedProgressItem> arrayList = this.list;
        synchronized (arrayList) {
            for (ManagedProgressItem wrappedItem : this.list) {
                if (!wrappedItem.isOpen()) continue;
                items.add(wrappedItem.getOriginalItem());
            }
        }
        return items.toArray(new ProgressItem[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressItem[] getItems() {
        ArrayList<ProgressItem> items = new ArrayList<ProgressItem>();
        ArrayList<ManagedProgressItem> arrayList = this.list;
        synchronized (arrayList) {
            for (ManagedProgressItem wrappedItem : this.list) {
                items.add(wrappedItem.getOriginalItem());
            }
        }
        return items.toArray(new ProgressItem[0]);
    }
}

