﻿#pragma once

namespace SDX
{

enum class EnemyID
{
	雑魚A,
	戦車,
	ビッグヘリ,
	MAX,	
};

struct EnemyData
{
public:
	static EnemyData data[EnemyID::MAX];
	int 最大耐久;
	int スコア;
	int 物理;
	int 射撃;
	double 速さ;
	Shape* 当り判定;
	int ずれX;
	int ずれY;
	Sprite* 見た目;
	int 爆発アニメ;

	static void Load()
	{
		File csvFile("File/csv/enemy.csv" , FileMode::Read );

		for (int i = 0; i < (int)EnemyID::MAX+1 ; ++i)
		{
			std::vector<std::string> strings;
			strings.clear();
			csvFile.GetLineCSV( strings );
			if( i == 0 ) continue;
			data[i-1].最大耐久 = atoi(strings[1].c_str());
			data[i-1].スコア   = atoi(strings[2].c_str());
			data[i-1].物理     = atoi(strings[3].c_str());
			data[i-1].射撃     = atoi(strings[4].c_str());

			int 種類 = atoi(strings[5].c_str());
			int 幅   = atoi(strings[6].c_str());
			int 高さ = atoi(strings[7].c_str());

			data[i-1].ずれX = atoi(strings[8].c_str());
			data[i-1].ずれY = atoi(strings[9].c_str());
			//図形生成
			switch (種類)
			{
				case 0:
					data[i-1].当り判定 = new Circle( 0 , 0 , 幅 );
				break;
				case 1:
					data[i-1].当り判定 = new Rect( 0 , 0 , 幅 , 高さ );
				break;
			}
			data[i - 1].爆発アニメ = 5;
		}
	}
};
}