﻿#pragma once
#include "Unit.h"
#include "Material.h"
#include "StgSystem.h"

namespace SDX
{
class Item :public Object
{
private:
	ItemID 種類;
	double 落下速度 = 0;
	Speed::AccelLimit 拡散速度 = { 6,-0.3, 0};
	bool 追跡フラグ = false;
public:
	Item(double X座標, double Y座標, ItemID アイテム種) :
		Object(new Circle( X座標, Y座標,10), new SpImage(&MIcon::ありす), 0 , Belong::Item),
		種類(アイテム種)
	{
		SetAngle( Rand::Get(0.0 , PAI * 2));
	}

	/**毎フレームの行動.*/
	void Act()
	{
		//追跡開始判定
		if ( !Scene::GetPlayer()->GetRemoveFlag() && GetDistance(Scene::GetPlayer()) < StgSystem::吸い寄せLV * 100 )
		{
			追跡フラグ = true;
		}

		//移動処理
		MovePolar(拡散速度.Ease(), this->GetAngle());

		if (追跡フラグ)
		{
			const double 向き = GetDirect(Scene::GetPlayer());
			MovePolar(10, 向き);
		}
		else
		{
			落下速度 += 0.02;
			Move(0, 落下速度);
		}
	}

	/**自機と衝突.*/
	void Damaged(double 被ダメージ)
	{
		++StgSystem::素材数[(int)種類];

		this->isRemove = true;
	}

};
}