#pragma once
#include <SDXFrameWork.h>
#include <Framework/IScene.h>
#include <Utility/Module.h>
#include <STG/Layer.h>
#include "Unit.h"
#include "Shot.h"
#include "MenuObject.h"

namespace SDX
{
class Menu : public IScene
{
private:

	Layer<MenuObject> selects;
	Layer<Object> backEffects;
	Layer<Object> midEffects;
	Layer<Object> frontEffects;

	std::vector<std::shared_ptr<IModule>> events;

	Camera camera;

	static Menu* menuNow;

	bool isActive = false;//͒~tO

	int IID = 0;
	int j[ = 1;
	int j[c = 1;

	std::string bZ[W;

protected:
	bool isCancel = true;//LZɈԍŌ̃IuWFNgN
public:

	int timer = 0;

	Menu() :
		camera(400, 300, 1)
	{}

	virtual ~Menu(){}

	void SetNow()
	{
		camera.SetActive();
		menuNow = this;
	}

	void SetItemCount(int  ,int c)
	{
		j[ = ;
		j[c = c;	
	}

	static Menu* Now()
	{
		return menuNow;
	}

	virtual void Update()
	{
		SetNow();
		++timer;

		if( isCancel && Input::pad.Button2.on )
		{
			selects[selects.GetCount()-1]->Push();
		}

		//I̕ύX
		ChangeSelect();

		//Cxg
		for (auto it : events)
		{
			it->Update();
		}

		//IuWFNg̍XV
		selects.Update();
		backEffects.Update();
		midEffects.Update();
		frontEffects.Update();

		selects.ExeRemove(nullptr);
		backEffects.ExeRemove( nullptr );
		midEffects.ExeRemove(nullptr);
		frontEffects.ExeRemove(nullptr);
	}

	void ChangeSelect()
	{
		if (selects.GetCount() == 0) return;

		if (	 Input::pad.Up.on	 && j[c > 1) IID -= j[;
		else if (Input::pad.Down.on	 && j[c > 1) IID += j[;
		else if (Input::pad.Left.on  && j[ > 1) IID --;
		else if (Input::pad.Right.on && j[ > 1) IID ++;
		else return;

		const int j[v = j[c * j[;

		int ID;

		if (IID < 0)
		{
			IID += j[v;
		}
		else if (IID >= j[v )
		{
			IID -= j[v;
		}

		ID = IID;

		if (IID >= selects.GetCount() )
		{
			ID = selects.GetCount() - 1;
		}

		Select(ID);
		if( selects[ID]->.length() > 0) this->bZ[W = selects[ID]->;
	}

	virtual void Draw()
	{
		SetNow();
		backEffects.Draw();
		selects.Draw();
		midEffects.Draw();
		frontEffects.Draw();
	}

	void Select(int CfbNX)
	{
		for (int i = 0; i < selects.GetCount(); ++i)
		{
			selects[i]->isSelect = (i == CfbNX);
		}
	}

	void ToEnd()
	{
		isEnd = true;
	}

	static void Add( MenuObject *IuWFNg )
	{
		Now()->selects.Add( IuWFNg );

		if (Now()->selects.GetCount() == 1)
		{
			IuWFNg->isSelect = true;
		}
	}

	static void Add(Object *IuWFNg, int ҋ@ = 0)
	{
		Now()->midEffects.Add(IuWFNg, ҋ@);
	}

	static void AddFront(Object *IuWFNg, int ҋ@ = 0)
	{
		Now()->frontEffects.Add(IuWFNg, ҋ@);
	}

	static void AddBack(Object *IuWFNg, int ҋ@ = 0)
	{
		Now()->backEffects.Add(IuWFNg, ҋ@);
	}

	static void AddEvent(IModule *W[)
	{
		Now()->events.emplace_back(W[);
	}

	static bool IsActive()
	{
		return Now()->isActive;
	}

	static void SetActive(bool ͉\tO )
	{
		Now()->isActive = ͉\tO;
	}

	static std::string& Message()
	{
		return Now()->bZ[W;
	}

	virtual void Init(){};
	virtual void Final(){};
};
}