﻿#pragma once
#include <Object.h>
#include "Material.h"
#include "StgSystem.h"

namespace SDX
{
class エフェクト : public Object
{
public:
	エフェクト( Image* 画像 , double X座標 , double Y座標 , double 大きさ = 1.0):
			Object( new Point( X座標 , Y座標 ) , new SpImage( 画像 ) )
	{
		sprites[0]->SetZoom(大きさ,大きさ);
	}

	エフェクト( Anime* アニメ画像 , double X座標 , double Y座標 , bool 消滅フラグ = true):
			Object( new Point( X座標 , Y座標 ) , new SpAnime( アニメ画像 ) )
	{
		if (消滅フラグ)
		{
			lifeTime = アニメ画像->GetAnimeTime();
		}
	}

	エフェクト( const IFont *フォント , double X座標 , double Y座標 ,  Color 色 , double 表示倍率 , const char *描画文字  ):
			Object( new Point( X座標 , Y座標 ) , new SpFont( フォント , 色 , 表示倍率 , 表示倍率 , 描画文字) )
	{}

	エフェクト(const BmpFrame *BMPフレーム, double X座標, double Y座標, double 幅, double 高さ ) :
			Object( new Point( X座標 , Y座標 ) , new SpFrame( BMPフレーム , 幅 , 高さ) )
	{}
};

class 背景 : public Object
{
public:
	背景( double 頂点座標X , double 頂点座標Y , ImagePack &マップチップ , const char* ファイル名, int 幅, int 高さ):
		Object( new Point( 頂点座標X , 頂点座標Y ) , new SpMap( マップチップ , ファイル名, 幅, 高さ, 0) )
	{
		this->isOutCheck = false;
	}

	void Act()
	{
		Move(0,0.5);
	}
};

class システム表示 : public Object
{
private:
	int score = 0;
public:
	システム表示() :
		Object(new Point(0, 0), nullptr )
	{
		this->isOutCheck = false;
	}

	void Act()
	{
		if (StgSystem::現在スコア > score)
		{
			score += 56;
			if (StgSystem::現在スコア < score) score = StgSystem::現在スコア;
		}
	}


	void Draw() const
	{
		MSystem::背景[1]->DrawPart(  0, 0, 0, 0,150,600);
		MSystem::背景[1]->DrawPart(650, 0, 0, 0,150,600);

		//スコア表示
		MFont::赤絵.Draw(155, 5, Color::White, "SCORE");
		MFont::白絵.DrawExtend(160, 25, 2, 2,Color::White, {score});

		MFont::赤絵.Draw(355, 5, Color::White, "HISCORE");
		MFont::白絵.DrawExtend(360, 25, 2, 2, Color::White , {score});
		
		//ライフ表示
		MFrame::BMPフレーム[1].Draw(155, 57, StgSystem::最大HP + 16, 30);
		MFont::白絵.Draw(160, 55, Color::Aqua , "SHIELD");
		Drawing::Rect(164, 66, StgSystem::現在HP , 9, Color::Red, true);

		//必殺ゲージ表示
		MFrame::BMPフレーム[2].Draw(155, 87, 100 + 16, 30);
		MFont::白絵.DrawExtend(160, 85,1,1 ,Color::Red, "HYPER");
		Drawing::Rect(164, 96, StgSystem::現在チャージ , 9, Color::Red, true);

		//ボスライフゲージ
	}
};

}