﻿#pragma once
#include "Material.h"
#include "WeponData.h"
#include "Player.h"
#include "Shots.h"

namespace SDX
{
class Wepon : public Object
{
protected:
	Player *親;
	int 待機中 = 0;
	Point 相対座標;
	int 左右;
	bool 固定砲;
	int レベル;
public:
	const WeponData* const 性能;

	Wepon(Player* 親 , Image* アイコン画像 , WeponID 武器ID ) :
		Object( new Point( 親->GetX() , 親->GetY() ) , new SpImage( アイコン画像 )),
		性能( &WeponData::data[(int)武器ID] ),
		親(親)
	{
		レベル = 5 - StgSystem::難易度;

		this->isOutCheck = false;

		switch ( 親->GetWeponCount() )
		{
			case 0://前方
				相対座標.SetPos( -15 , -30 );
				固定砲 = true;
				左右 = -1;
			break;
			case 1://前方
				相対座標.SetPos( 15  , -30 );
				固定砲 = true;
				左右 = 1;
			break;
			case 2://側方
				相対座標.SetPos( -50  , 20 );
				固定砲 = false;
				左右 = -1;
			break;
			case 3://側方
				相対座標.SetPos( 50  , 20 );
				固定砲 = false;
				左右 = 1;
			break;
		}
	}

	void Update( )
	{
		if ( 親->GetRemoveFlag() )
		{
			this->isRemove = true;
			return;
		}
		Object::Update( );

		if( (Input::pad.Button1.hold || 親->hyperTime > 0) && 待機中 <= 0)
		{
			待機中 = 性能->連射;

			switch (レベル)
			{
				case 1:発射LV1(); break;
				case 2:発射LV2(); break;
				case 3:発射LV3(); break;
				case 4:発射LV4(); break;
			}
		}

		待機();
		追従();

		--待機中;
	}

	void Remove()
	{
		Scene::Add(new エフェクト(&MEffect::爆発[16], GetX(), GetY()));
	}

	virtual void 待機(){}

	virtual void 発射LV1() = 0;
	virtual void 発射LV2() = 0;
	virtual void 発射LV3() = 0;
	virtual void 発射LV4() = 0;

	void 射撃(double 威力 , int Xずれ , int Yずれ , double 速度 , double 角度 , Image* 画像 )
	{
		double 攻撃力 = this->性能->攻撃力[レベル-1] * 威力;
		if (親->hyperTime > 0)
		{
			Xずれ *= 2;
			Yずれ *= 2;
			角度 *= 2;
			攻撃力 *= 3;

			if (画像 == &MShot::火)
			{
				画像 = &MShot::火炎;
			}
			else
			{
				画像 = &MShot::ビーム超;
			}
		}

		角度 -= PAI / 2;

		Scene::Add(new 弾::通常((int)GetX() + Xずれ, (int)GetY() + Yずれ, 攻撃力, new Speed::Liner(速度), 画像, 画像->GetWidth(), 画像->GetHeight(), 角度));
	}

	void 射撃( double 威力,int Xずれ, int Yずれ, double 初速, double 加速度, double 角度, Image* 画像)
	{
		double 攻撃力 = this->性能->攻撃力[レベル-1] * 威力;
		if (親->hyperTime > 0)
		{
			Xずれ *= 2;
			Yずれ *= 2;
			角度 *= 2;
			攻撃力 *= 3;

			画像 = &MShot::緑丸;
		}

		角度 -= PAI / 2;

		Scene::Add(new 弾::通常((int)GetX() + Xずれ, (int)GetY() + Yずれ, 攻撃力, new Speed::Accel(初速, 加速度), 画像, 画像->GetWidth(), 画像->GetHeight(), 角度));
	}

	void 追従()
	{
		if( 固定砲 )
		{
			this->SetPos( 親->GetX() + 相対座標.x , 親->GetY() + 相対座標.y );
			return;
		}

		const double xDis = 親->GetX() - ( GetX() - 相対座標.x );
		const double yDis = 親->GetY() - ( GetY() - 相対座標.y );
				
		double angle = atan2( yDis , xDis );
		double speed = sqrt(xDis * xDis + yDis * yDis) / 3;

		if( speed > 10 ) speed = 10;

		this->MovePolar( speed , angle  );	
	}
};
}