﻿#pragma once
namespace SDX
{
enum class WeponID
{
	いくさん,
	てんこ,

	ありす,
	ぱちぇ,

	ふらん,
	さくや,	
	MAX,
	//各武器が最大レベル４まで

	//各武器毎に設定
	//攻撃
	//耐久
	//速度

	//特殊スキル、装備しなくても開発すればOK
	//レアドロップ・てい開発 ABCD

	//当たり判定縮小・ちるの開発 ABCD

	//必殺時間強化・さくや開発 ABCD

	//吸い寄せ強化・ゆーびぃ開発 ABCD

	//自然回復強化・テルヨフ ABCD

	//底力強化
};

struct WeponData
{
public:
	static WeponData data[(int)WeponID::MAX];
	int 攻撃力[4];
	int 連射;

	ItemID 素材ID[4];
	int 素材数[4];
	
	static void Load()
	{
		File csvFile("File/csv/wepon.csv" , FileMode::Read );

		for(int i=0; i < (int)WeponID::MAX+1 ; ++i )
		{
			std::vector<std::string> strings;
			strings.clear();
			csvFile.GetLineCSV( strings );
			if (i == 0) continue;

			data[i - 1].連射 = atoi(strings[1].c_str());
			data[i - 1].攻撃力[0] = atoi(strings[2].c_str()) * data[i-1].連射;
			data[i - 1].攻撃力[1] = atoi(strings[3].c_str()) * data[i - 1].連射;
			data[i - 1].攻撃力[2] = atoi(strings[4].c_str()) * data[i - 1].連射;
			data[i - 1].攻撃力[3] = atoi(strings[5].c_str()) * data[i - 1].連射;
		}
	}
};
}