# ̑IuWFNgǗ
module OtherManager

  # 
  def OtherManager.initAll
    # Ŝ̂z
    @objects = []
  end

  # Ŝ̂ړ
  def OtherManager.moveAll
    # ړ
    @objects.each do |t|
      t.move
    end
  end

  # Ŝ̂`
  def OtherManager.drawAll
    # `
    @objects.each do |t|
      t.draw
    end
  end

  def OtherManager.objects
    @objects
  end

  # tOĂIuWFNg폜
  def OtherManager.clear
    @objects.delete_if do |t|
      t.delflag
    end
  end

end


# ꂽ΂
class OtherObakeKO

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, scale)
    @x = x
    @y = y
    @scale = scale
    @rot = 0
    temp = rand(60) + 270
    @dx = Math.cos(TO_RADIAN * temp) * 8
    @dy = Math.sin(TO_RADIAN * temp) * 8
    @delflag = false
    @alpha = 256
  end

  def move
    # ړ
    @x = @x + @dx
    @y = @y + @dy
    @dy = @dy + 0.2

    # ʊO
    if @y >  480  or @x >  640  then
      @delflag = true
      return
    end

    # 
    @alpha = @alpha - 3
    if @alpha < 0 then
      @delflag = true
      return
    end

    # ]
    @rot = @rot + 20
    if @rot > 359 then
      @rot = @rot - 360
    end
  end

  def draw
    Window.drawEx(@x, @y, IMAGE_obakehit, :angle => @rot, :scalex => @scale, :alpha => @alpha, :z => 5)
  end

  attr_accessor :delflag
end


# ꂱ
class OtherBatKO

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @bx = x
    @angle = 90
    @delflag = false
    @alpha = 255
    @count = 60
  end

  def move
    # ړ
    @bx = @bx - 0.5
    @y = @y + 2

    @x = @bx + Math.cos(TO_RADIAN * @angle) * 15
    
    @count -= 1
    if @count < 0 then
      @alpha -= 5
    end

    # ʊO
    if @y >  480 or @alpha < 0 then
      @delflag = true
      return
    end

    # ]
    @angle = @angle + 8
    if @angle > 359 then
      @angle = @angle - 360
    end
  end

  def draw
    Window.drawEx(@x, @y, IMAGE_batdead, :scaley => -1, :alpha => @alpha, :z => 5)
  end

  attr_accessor :delflag
end


# WbN
class OtherJackKO

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @rot = 0
    temp = rand(60) + 270
    @dx = Math.cos(TO_RADIAN * temp) * 8
    @dy = Math.sin(TO_RADIAN * temp) * 8
    @delflag = false
  end

  def move
    # ړ
    @x = @x + @dx
    @y = @y + @dy
    @dy = @dy + 0.2

    # ʊO
    if @y >  480  or @x >  640  then
      @delflag = true
      return
    end

    # ]
    @rot = @rot + 20
    if @rot > 359 then
      @rot = @rot - 360
    end
  end

  def draw
    Window.drawRot(@x, @y, IMAGE_jack2, @rot, nil, nil, 5)
  end

  attr_accessor :delflag
end


# ꖂ
class OtherMajoKO

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @dy = -4
    @delflag = false
  end

  def move
    # ړ
    @y = @y + @dy
    @dy = @dy + 0.2

    # ʊO
    if @y >  480  or @x >  640  then
      @delflag = true
      return
    end

  end

  def draw
    Window.draw(@x, @y, IMAGE_majo3, 5)
  end

  attr_accessor :delflag
end


# ꂤ
class OtherUsagiKO

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @dy = -4
    @delflag = false
  end

  def move
    # ړ
    @y = @y + @dy
    @dy = @dy + 0.2

    # ʊO
    if @y >  480  or @x >  640  then
      @delflag = true
      return
    end

  end

  def draw
    Window.draw(@x, @y, IMAGE_usagihit, 5)
  end

  attr_accessor :delflag
end


# 
class OtherUki

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x + 32
    @y = y - 32
    @count = 20
    @delflag = false
  end

  def move
    @count = @count - 1
    if @count == 0 then
      @delflag = true
    end
  end

  def draw
    Window.draw(@x, @y, IMAGE_uki, 3)
  end

  attr_accessor :delflag
end


# 邳邽
class OtherSarutama

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, scale)
    @x = x
    @y = y
    @count = scale
    @angle = 0
    @delflag = false
  end

  def move
    @x = @x + 0.5
    @count = @count - 1
    if @count == 0 then
      @delflag = true
      return
    end

    # 摜]
    @angle = @angle + 10
    if @angle > 359 then
      @angle = @angle - 360
    end
  end

  def draw
    Window.drawEx(@x, @y, IMAGE_sarutamadel, :angle => @angle, :scalex => @count / 40.0, :scaley => @count / 40.0, :z => 3)
  end

attr_accessor :delflag

end


# ɂ
class OtherSaruDead

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @count = 180
    @angle = 0
    @delflag = false
  end

  def move
    @y = @y - 0.5
    @count = @count - 1
    if @count == 0 then
      $zanki = $zanki - 1
      if $zanki > 0 then
        SaruManager.create
      else
        BgGameOver.create(210, 150)
      end
      @delflag = true
      return
    end

    # 摜]
    @angle = @angle + 20
    if @angle > 359 then
      @angle = @angle - 360
    end
  end

  def draw
    Window.drawRot(@x, @y, IMAGE_saru01, @angle, nil, nil, 3)
  end

attr_accessor :delflag

end


# 炫
class OtherKirakira

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, image, z)
    @x = x
    @y = y
    @z = z
    @angle = 0
    @delflag = false
    @alpha = 256
    if image == 0 then
      @image = IMAGE_tekitama3p
    else
      @image = IMAGE_tekitama3m
    end
  end

  def move
    @alpha = @alpha - 16
    if @alpha <= 0 then
      @delflag = true
    end
  end

  def draw
    Window.drawAlpha(@x, @y, @image, @alpha, @z)
  end

attr_accessor :delflag

end


# 񕜗pGtFNgi炫琶IuWFNgBꎩ͔̂\j
class OtherLifeUpEffect

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize
    @y = 24
    @angle = 0
  end

  def move
    if $saru == nil then
      @delflag = true
      return
    end

    @angle = @angle + 15
    if @angle > 359 then
      @angle = @angle - 360
    end

    @y = @y - 0.8

    if @y < -10 then
      @delflag = true
    end

  end

  def draw
    temp = @angle > 180 ? 5.9 : 6.1
    OtherLifeUpKirakira.create(Math.cos(TO_RADIAN * @angle) * 16 + 16, @y, rand(2), temp)
    OtherLifeUpKirakira.create(Math.cos(TO_RADIAN * @angle) * 16 + 16, @y + 2, rand(2), temp)
  end

attr_accessor :delflag

end

# 񕜗p炫
class OtherLifeUpKirakira

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, image, z)
    @x = x
    @y = y
    @z = z
    @angle = 0
    @delflag = false
    @alpha = 256
    if image == 0 then
      @image = IMAGE_tekitama3p
    else
      @image = IMAGE_tekitama3m
    end
  end

  def move
    if $saru == nil then
      @delflag = true
      return
    end

    @alpha = @alpha - 16
    if @alpha <= 0 then
      @delflag = true
    end
  end

  def draw
    if $saru != nil then
      Window.drawAlpha($saru.x + @x, $saru.y + @y, @image, @alpha, @z)
    end
  end

attr_accessor :delflag

end


# 񕜕
class OtherLifeUp

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize
    @y = -30
    @alpha = 255
  end

  def move
    if $saru == nil then
      @delflag = true
      return
    end

    @alpha = @alpha - 3
    if @alpha < 0 then
      @delflag = true
    end

    @y = @y - 0.3

  end

  def draw
    if $saru != nil then
      Window.drawAlpha($saru.x, $saru.y + @y, IMAGE_LIFEUP, @alpha, 6)
    end
  end

attr_accessor :delflag

end


# 񕜕
class OtherAddOption

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize
    @y = -30
    @alpha = 255
  end

  def move
    if $saru == nil then
      @delflag = true
      return
    end

    @alpha = @alpha - 3
    if @alpha < 0 then
      @delflag = true
    end

    @y = @y - 0.3

  end

  def draw
    if $saru != nil then
      Window.drawAlpha($saru.x - 15, $saru.y + @y, IMAGE_ADDOPTION, @alpha, 6)
    end
  end

attr_accessor :delflag

end


# 
class OtherOption

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize
    temp = []
    @prev = $saru.lastoption
    for i in 1..10
      temp.push([@prev.x, @prev.y])
    end
    $saru.option.push(self)
    @data = temp
    @x = @prev.x
    @y = @prev.y
  end

  def move
    if $saru == nil then
      @delflag = true
      return
    end

    # L[Ԃɂ邘Ƃ̑擾
    dx, dy = Input.x, Input.y
    if dx == 0 and dy == 0 then
      return
    end

    @data.push([@prev.x, @prev.y])
    temp = @data.shift
    @x = temp[0]
    @y = temp[1]

  end

  def draw
    Window.drawScale(@x, @y-4, IMAGE_saru01, 0.5, 0.5, 5)
  end

attr_accessor :delflag, :x, :y

end


# 
class OtherBomber

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @delflag = false
    @anime = 0
    @animewait = 10
    @animecount = @animewait
    @count = 20
  end

  def move
    @animecount = @animecount - 1
    if @animecount == 0 then
      @animecount = @animewait
      @anime = 1 - @anime
    end

    @count = @count - 1
    if @count == 0 then
      @delflag = true
    end

  end

  def draw
    Window.draw(@x, @y, IMAGE_bomber[@anime], 9)
  end

attr_accessor :delflag

end


# ĂNXi΂Hj
class OtherHaka

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y)
    @x = x
    @y = y
    @delflag = false
  end

  def move
    # ړ
    @x = @x  - 0.5

    # ʊO
    if @x <= -IMAGE_hakaDestroy.width then
      @delflag = true
    end

  end

  def draw
    Window.draw(@x, @y, IMAGE_hakaDestroy, 5.9)
  end

# NXOɌJϐ
attr_accessor :delflag

end


# GtFNg
class OtherUsaStar

  def self.create(*arr)
    OtherManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, angle, speed)
    @x = x
    @y = y
    @count = 40
    @alpha = 255
    @dx = Math.cos(TO_RADIAN * angle) * speed
    @dy = Math.sin(TO_RADIAN * angle) * speed
  end

  def move
    @x += @dx
    @y += @dy

    @count -= 1

    if @count < 0 then
      @alpha = @alpha - 16
      if @alpha <= 0 then
        @delflag = true
      end
    end
  end

  def draw
    Window.drawAlpha(@x, @y, IMAGE_usatama2, @alpha, 6)
  end

attr_accessor :delflag

end


