#include "stdafx.h"
#include <float.h>				// For DBL_MAX.
#include "UtilMisc.h"				// For M_PI,POW2.
#include "UtilLine.h"			// For FCPolyHash.
#include "UtilBezier.h"			// For DrawBezierFast2.
//#include "Cardano.h"			// For FCCardano.
#include "Ferrari.h"			// For FCFerrari.
#include "ApproximateBezier.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::FCApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCApproximateBezier::FCApproximateBezier ()
{
	m_mmSlimDistance1 = 2.0;	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
	m_mmSlimDistance2 = 3.16;	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
	m_dSlimRoundA = 0.0;		// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
	m_dJointAngle1 = 0.5;		// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiCpAjClEiCkGiCoJiCmGjGlDiPpAiMiPiCmJjFhDjIeBjBlBiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
	m_dJointAngle2 = 0.22;		// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiImIiJlKiClOiCmGjGlDiPpAiMiPiCmJjIeBjBlBiClFiClNiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
	m_mmJointDistance = 11.0;	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiBeC_xHqqkZx_m_dJointAngle2_xZkqqHx_iCmG_xHqqkZx_m_dJointDistance_xZkqqHx_iCmM_xHqqkZx_
								// _xZkqqHx_jHlMjFpLiCpAjClEiCkGiClNiCmGiCkLiBeBjFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGiClFiCmEjElLjCgGiClDiCoKiCoJiBeC_xHqqkZx_
	m_dSplitAngle0 = 1.6;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_
	m_dSplitAngle1 = 0.8;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_
	m_dAngleDiffLimit = 0.8;	// _xZkqqHx_jAkHiMoEjDfPiCgBiBgJiCgCiBgKiCmMiMhGiOfKiOjOiCmJiBeBiOgOjDfPiBgJiPeJjDfPiBgKiKhAjDhIiCmGjClMjApMiCgAiCgBiBgJiCgCiCgDiBgKiCmMiKhAjDhIiCmM_xHqqkZx_
								// _xZkqqHx_iNlHjFkKiCmMiLjGjHgFjCgMiCpAiOhHjCoIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCoJiCmGjAkHiMoEjDfPiCgBiBgJiCgCiBgKiCmNiNmEiMhGiOfKiBeC_xHqqkZx_
	m_dLengthScore = 0.1;		// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiClLiCmMiLjHjHkDiCmMiNlHiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
								// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_
	m_dMilestoneScore = 0.1;	// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiDhNiDeDiDiLiDfIiDgHiDjDiCmMiLjHjHkDiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
								// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_
	m_dPlayOfAngle = 0.2;		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjDhCjCiGiCmMjDfPiCgPiCpAiOgHiCmBiCmEiDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmJiBeBjDfPiCgPiCmJiCkIiCkPiCoJiDhMiDiKiDiJiDeDiDjDiKhAjDhI_xHqqkZx_R1_xZkqqHx_iCmG_xHqqkZx_
								// _xZkqqHx_iLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJjDfPiCgPiCmJiCkIiCkPiCoJiKhAjDhI_xHqqkZx_R2_xZkqqHx_iCmMiNlHjFkKiCmMiLjGjHgFjEmNiImNiBeC_xHqqkZx_
} // FCApproximateBezier::FCApproximateBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::PolylineToBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClFiClNiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmptPoint _xZkqqHx_iCmNjAlGiDgGiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::PolylineToBezier (FCBezierControlsVector& vControls,
											const DBLPoint* mmptPoint,
											long lPointSize) const
{
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHjAjEiCkKiCfBjGkCjGjOiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (lPointSize < 2) return;
	// _xZkqqHx_iDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPointVector vPointSlim(mmptPoint, mmptPoint + lPointSize);
	SlimLine(vPointSlim);
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	doubleVector vLineAngle;
	FFGetLineAngle(vLineAngle, vPointSlim.size(), vPointSlim.begin());
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiCkEiClPiBeBjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<long> stJoint;
	GetJoint(stJoint, vPointSlim.begin(), vPointSlim.size(), vLineAngle.begin());
	// _xZkqqHx_jIeBjBlBiClFiClNiDhMiDiKiDiJiDeDiDjDiCkKiBeBjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmFjIeBiMiLiClFiClNiDhMiDiKiDiJiDeDiDjDiCpA_xHqqkZx_
	// _xZkqqHx_jFkBjAjEiCmMiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
	JointsToBezier(vControls, stJoint, vPointSlim.begin(), vLineAngle.begin());
} // FCApproximateBezier::PolylineToBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::SlimLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiPoHjClHiCmIjDfPiCpAiPmIjHkKiClFiDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSlimLine	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeCiDfIiDiKiDiAiJlLiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPnKiNnHiCmN_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::SlimLine (DBLPointVector& vSlimLine) const
{
	// _xZkqqHx_iDfIiDiKiDiAiJlLiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	FFSlimLine(vSlimLine, m_mmSlimDistance1, m_mmSlimDistance2, m_dSlimRoundA);
	if (m_mmSlimDistance2 != 0.0)
		FFOmitClosePoint(vSlimLine, BYTEVector(vSlimLine.size(), FALSE), m_mmSlimDistance2);
} // FCApproximateBezier::SlimLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMiCkEiClPiBeBjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stJoint	:_xZkqqHx_jFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::GetJoint (set<long>& stJoint,
									const DBLPoint* mmptPoint,
									long lPointSize,
									const double* pLineAngle) const
{
	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiCpAjClEiCkGiCoJiCmGjGlDiPpAiMiPiCmJjFhDjIeBjBlBiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
	const double dJointAngle1 = m_dJointAngle1 * M_PI;
	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiImIiJlKiClOiCmGjIeBjBlBiClFiClNiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
	const double dJointAngle2 = m_dJointAngle2 * M_PI;
	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiBeC_xHqqkZx_m_dJointAngle2_xZkqqHx_iCmG_xHqqkZx_m_dJointDistance_xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_jHlMjFpLiCpAjClEiCkGiClNiCmGiCkLiBeBjFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGiClFiCmEjElLjCgGiClDiCoKiCoJiBeC_xHqqkZx_
	const double dJointPowDistance = POW2(m_mmJointDistance);
	// _xZkqqHx_jFhDjIeBjBlBjIeBiMiLjDfPiPfHiNiHiCmJiBeBiOgOjDfPiCmGiPeJjDfPiCpAjCmHiJmBiBeC_xHqqkZx_
	stJoint.insert(0);
	stJoint.insert(lPointSize - 1);
	long lIndex;
	for (lIndex = 0; lIndex != lPointSize - 2; lIndex++)
	{
		// _xZkqqHx_jIeBjBlBiClHiCoJjApMjFkKiCmMiLmIiCkKiCoJiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		const double dAngleDiff = fabs(FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]));
//		TRACE(_T("ANGLE %d,%f\n"), lIndex, dAngleDiff);
		if (dJointAngle1 < dAngleDiff)
		//----- _xZkqqHx_iKoOiPiAiKhAiCpAjClEiCkGiCmEiLmIiCkKiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiCpAjClEiCkGiCoJiCmGjGlDiPpAiMiPiCmJjFhDjIeBjBlBiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
			stJoint.insert(lIndex + 1);
		} else
		if (dJointAngle2 < dAngleDiff)
		//----- _xZkqqHx_iKoOiPiAiKhAiCpAjClEiCkGiCmEiLmIiCkKiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iKoOiPiAiCmMiKhAjDhIiCoGiCoIiPkMiClDiCkCiPoKiNiHiCmNiBeBjCiGiKnEjDfPiCkKjHkDiCoKiCmEiCkCiCmEiCoAjFhDjIeBjBlBiCmGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jBoFiCkLiCkNiCnMiCoNiCoJiPoKiNiHiCmJiBeBjCiGiKnEjDfPiCkKjHkDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
			// _xZkqqHx_jClMjApMiBgJ_xHqqkZx_Point[lIndex-1] - Point[lIndex+1]_xZkqqHx_iBgK_xHqqkZx_ _xZkqqHx_iCmG_xHqqkZx_ Point[lIndex]_xZkqqHx_iCmMiLjHjHkDiCkK_xHqqkZx_
			// _xZkqqHx_iCkAiCoJiIoKjCoIiImIiPoDiCmMjClHiClDiCmFiCkAiCoKiCmOiBeBiDfHiDiHiDeDiDjDiDgHiCmFiCkAiCoJiBeBiCmGjElLjCgGiBeC_xHqqkZx_
			DBLPoint mmptNear = DBLLine(mmptPoint[lIndex], mmptPoint[lIndex + 2]).GetNearest(mmptPoint[lIndex + 1]);
			if (dJointPowDistance < (mmptNear - mmptPoint[lIndex + 1]).PowLen())
				stJoint.insert(lIndex + 1);
		}
	}
} // FCApproximateBezier::GetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::JointsToBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBjBlBiClFiClNiDhMiDiKiDiJiDeDiDjDiCkKiBeBjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmFjIeBiMiLiClFiClNiDhMiDiKiDiJiDeDiDjDiCpA_xHqqkZx_
 *			_xZkqqHx_jFkBjAjEiCmMiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *			stJoint		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	stJoint_xZkqqHx_iCmJiCmNiBeBiOgOjDfPiCmGiPeJjDfPiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiDhMiDiKiDiJiDeDiDjDiCmFiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_5_xZkqqHx_iCmG_xHqqkZx_10_xZkqqHx_iCmJjFhDjIeBjBlBiCmIiDhMiDeDiDjDiDgHiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhMiDiKiDiJiDeDiDjDiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeB_xHqqkZx_stJoint_xZkqqHx_iCmJiCmN_xHqqkZx_(0,5,10,15)_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *         
 *                                     _xZkqqHx_iBkF_xHqqkZx_                  _xZkqqHx_iBkF_xHqqkZx_
 *          Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_  _xZkqqHx_iCfH_xHqqkZx_  _xZkqqHx_iCfI_xHqqkZx_  10  11  12  13  14  15
 *                 _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
 *         
 *                  _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_    _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfOiBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_  
 *                    _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_    _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::JointsToBezier (	FCBezierControlsVector& vControls,
											const set<long>& stJoint,
											const DBLPoint* mmptPoint,
											const double* pLineAngle) const
{
	set<long>::const_iterator iIdx;
	iIdx = stJoint.begin();
	long lIndexFrom;
	long lIndexUntil = *iIdx;
	for (iIdx++; iIdx != stJoint.end(); iIdx++)
	{
		FCBezierControlsVector vControlsTmp;
		lIndexFrom = lIndexUntil;
		lIndexUntil = *iIdx;
		OneJointToBezier(	vControlsTmp,
							mmptPoint + lIndexFrom,
							lIndexUntil - lIndexFrom + 1,
							pLineAngle + lIndexFrom);
		vControls.insert(vControls.end(), vControlsTmp.begin(), vControlsTmp.end());
	}
} // FCApproximateBezier::JointsToBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::OneJointToBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBjBlBiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCkJiCoHiBeBjFkBjAjEiCmMiDhIiDfHiDeGiLmIjApMiCpAiLnPiOjHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::OneJointToBezier (FCBezierControlsVector& vControls,
											const DBLPoint* mmptPoint,
											long lPointSize,
											const double* pLineAngle) const
{
	if (lPointSize < 2)
	//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCkKiCePiBgAiCfAiDhMiDeDiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return;
	}
	if (lPointSize == 2)
	//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCkKiCfBiDhMiDeDiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCpAiMiLiCnEjClMjApMiCmMiDhIiDfHiDeGiLmIjApMiCpAjAnNjCoIiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(	mmptPoint[0],
												mmptPoint[0],
												mmptPoint[1],
												mmptPoint[1]));
		return;
	}

	//----- _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCkKiCfCiDhMiDeDiDjDiDgHiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmGjApMjFkKiKhAjDhIjCgMjEhKjHpBiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
	DBLPointVector vPoint;
	vPoint.insert(vPoint.end(), mmptPoint, mmptPoint + lPointSize);
	doubleVector vLineAngle;
	vLineAngle.insert(vLineAngle.end(), pLineAngle, pLineAngle + lPointSize - 1);

	//----- _xZkqqHx_iKgFiDhMiDeDiDjDiDgHiCmMiKhAjDhIiCpAiMhGiOfKiClHiCoJ_xHqqkZx_ -----
	doubleVector vPointAngle;
	// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCmNiMoDiCmFjAnNjCoIiBeC_xHqqkZx_
	vPointAngle.push_back(0.0);
	long lIndex;
	for (lIndex = 1; lIndex != lPointSize - 1; lIndex++)
	{
		// _xZkqqHx_jBmOiPnLiDhMiDeDiDjDiDgHiCmMiIoKiCmCjBePiCmGiIoKiCmCiMoDiCmMiDhMiDeDiDjDiDgHiCpAiMiLiCnEjClMjApMiCmMiKhAjDhIiCpAiBeBjBmOiPnLiDhMiDeDiDjDiDgHiCmMiKhAjDhIiCmGiClHiCoJiBeC_xHqqkZx_
		const DBLPoint mmptL = mmptPoint[lIndex + 1] - mmptPoint[lIndex - 1];
		vPointAngle.push_back(atan2(mmptL.y, mmptL.x));
	}
	// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCpAjAnNjCoIiBeCiOgOjDfPiCmJiCmCiCmIiCkKiCoJjApMjFkKiCmMiKhAjDhIiCmGiOjPiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIiCkJiCoHiLiBiCnPiCoJiBeC_xHqqkZx_
	vPointAngle[0] = FFAngleMinusPitoPi(pLineAngle[0] - (vPointAngle[1] - pLineAngle[0]));
	// _xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCpAjAnNjCoIiBeCiPeJjDfPiCmJiCmCiCmIiCkKiCoJjApMjFkKiCmMiKhAjDhIiCmGjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIiCkJiCoHiLiBiCnPiCoJiBeC_xHqqkZx_
	vPointAngle.push_back(FFAngleMinusPitoPi(pLineAngle[lPointSize - 2] - (vPointAngle[lPointSize - 2] - pLineAngle[lPointSize - 2])));

	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiOgOjDfPiCkJiCoHjDeLjDjGiCmIiDhMiDeDiDjDiDgH_xHqqkZx_(F)_xZkqqHx_iCnMiCmFjAnIiCoIiOoGiCmBiCmEiBeBiClLiCoKiCmJjBmOiClFiCmE_xHqqkZx_
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCpAiOiOiCnNiCoJiBeCiClBiCoKiCkKiOlIjEhDiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_F_xZkqqHx_iCpAiJkPiCkGiCmEiCkIiCkCiCmEiBeB_xHqqkZx_
	// F_xZkqqHx_iCoGiCoIiCoAiOoIjBePiCmMiImKjChFiCnMiCmFiCpAjAnIiCoIiOoGiCoIiBeBiNmEiCnBiDhIiDfHiDeGiLnPiOjHiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAiLnPiOjHiCkKjAkMiMpHiClHiCoJiCnMiCmFiMeKiCoIjFnEiClHiBeC_xHqqkZx_
	// _xZkqqHx_iLnPiOjHiCkKjAkMiMpHiClFiClNiCoHiBeBjAnIiCoIiOoGiCmBiClNiNmFiMoDiCmMiImKjChFiCpAjAfGiClFiCkCiOgOjDfPiCmGiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_jDkPiClGiDfIiDgFiDgCiDhGiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_

	// _xZkqqHx_jBePiJpBiCmMiLnPiOjHiCmFiOlIjEhDiClFiClNiDhMiDeDiDjDiDgHiCnMiCmFiCmMjApMjFkKjAjEiBeC_xHqqkZx_
	long lFailedLineSize = -1;

	while (!vPoint.empty())
	{
		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiBeBiKhAjDhIjCgMjEhKjHpBiCpAiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		// _xZkqqHx_iLnPiOjHiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiMlDiCmJjGnPiClHiClNiCnPiBeC_xHqqkZx_
		DBLPointVector vPointBackup = vPoint;
		doubleVector vLineAngleBackup = vLineAngle;
		doubleVector vPointAngleBackup = vPointAngle;

		// _xZkqqHx_iLnPiOjHiClHiCoJiCmMiCmJjDeLjDjGiCmIiImKjChFiCnMiCmFiBeBiDhMiDiKiDiJiDeDiDjDiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
		DBLPointVector vPointFirst;
		doubleVector vLineAngleFirst;
		doubleVector vPointAngleFirst;
		int iLevel = GetFirstPolyForBezier(	vPointFirst,
											vLineAngleFirst,
											vPointAngleFirst,
											vPoint,
											vLineAngle,
											vPointAngle,
											lFailedLineSize);
		// _xZkqqHx_iOgOjDfPiCmNjIeBiMiLjDfPiCkJiBeI_xHqqkZx_
		const BOOL bIsJoint0 = vControls.empty();
		// _xZkqqHx_iPeJjDfPiCmNjIeBiMiLjDfPiCkJiBeI_xHqqkZx_
		const BOOL bIsJointN = vPoint.empty();
		double dAngleDiffLimit0 = bIsJoint0 ? m_dAngleDiffLimit * 2.0 : m_dAngleDiffLimit;
		double dAngleDiffLimitN = bIsJointN ? m_dAngleDiffLimit * 2.0 : m_dAngleDiffLimit;

		BOOL bSucceed;
		if (6 <= vPointFirst.size())
		//----- _xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfFiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iKhAjBkMjDhIjElNjDfNiCmMiJpBjAjEiCmJiCoGiCmBiCmEiLnPiOjHjFpLjGeAiCpAjFmPiCkGiCoJiBeC_xHqqkZx_iLevel=1_xZkqqHx_iCmNiCfAiJpBiCmMjElNjDfNiBeB_xHqqkZx_iLevel=0_xZkqqHx_iCmNiCePiJpBiCmMjElNjDfNiBeC_xHqqkZx_
			if (iLevel == 0)
				bSucceed = Calc1WayPointBezier(	vControls,
												vPointFirst.begin(),
												vLineAngleFirst.begin(),
												vPointAngleFirst.begin(),
												vPointFirst.size(),
												dAngleDiffLimit0,
												dAngleDiffLimitN);
			else
				bSucceed = Calc2WayPointBezier(	vControls,
												vPointFirst.begin(),
												vLineAngleFirst.begin(),
												vPointAngleFirst.begin(),
												vPointFirst.size(),
												dAngleDiffLimit0,
												dAngleDiffLimitN);
		} else
		if (vPointFirst.size() == 5 || vPointFirst.size() == 4)
		//----- _xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfDiCkJiCfEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			bSucceed = Calc5PointBezier(vControls,
										vPointFirst.begin(),
										vLineAngleFirst.begin(),
										vPointAngleFirst.begin(),
										vPointFirst.size(),
										dAngleDiffLimit0,
										dAngleDiffLimitN);
		} else
		if (vPointFirst.size() == 3)
		//----- _xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			bSucceed = Calc3PointBezier(vControls,
										vPointFirst.begin(),
										vLineAngleFirst.begin(),
										vPointAngleFirst.begin(),
										vPointFirst.size(),
										dAngleDiffLimit0,
										dAngleDiffLimitN);
		} else
		//----- _xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfBiCmMiPoKiNiH_xHqqkZx_ -----
		{
			Calc2PointBezier(	vControls,
								vPointFirst.begin(),
								vLineAngleFirst.begin(),
								vPointAngleFirst.begin(),
								vPointFirst.size());
			bSucceed = TRUE;
		}
		
		if (bSucceed)
		//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			lFailedLineSize = -1;
		} else
		//----- _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOlIjEhDiClFiClNiDhMiDeDiDjDiDgHiCnMiCmFiCmMjApMjFkKjAjEiCpAiLeMjIfOiBeC_xHqqkZx_
			lFailedLineSize = vLineAngleFirst.size();
			// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiBeBiKhAjDhIjCgMjEhKjHpBiCpAiOlIjEhDjBePiCmJjGnPiClHiBeC_xHqqkZx_
			vPoint = vPointBackup;
			vLineAngle = vLineAngleBackup;
			vPointAngle = vPointAngleBackup;
		}
	}
} // FCApproximateBezier::OneJointToBezier.

//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetPolyForBezierL0
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCkKiCfAiJpBiCoAjElNjDfNiClFiCmIiCkCiDhMiDiKiDiJiDeDiDjDiCkJiCoHiBeBiDhIiDfHiDeGiLnPiOjHiCpA_xHqqkZx_
// *			_xZkqqHx_iClHiCoJiCmMiCmJjDeLjDjGiCmIiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPointFirst		:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vLineAngleFirst	:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPointAngleFirst:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPoint			:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vLineAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPointAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			lIndex1			:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiNmFiMoDiCmMjApMjFkKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *							 _xZkqqHx_iJlKjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
// *			dAngleMove1		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_[0,lIndex1]_xZkqqHx_iCmM_xHqqkZx_
// *							 _xZkqqHx_iKnEiCmFiBeBjFmPiJlLiClFiClNjApMjFkKiCmMiKhAjDhIiCmMjBiNjIgBiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lFailedLineSize	:_xZkqqHx_jBePiJpBiCmMiDhIiDfHiDeGiLnPiOjHiCmFiOlIjEhDiClFiClNiDhMiDiKiDiJiDeDiDjDjApMjFkKiCmM_xHqqkZx_
// *							 _xZkqqHx_jAjEiCpAiOhHjCoIiBeCjAkMiMpHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDiCmMiKhAjBkMjDhIiCmMjElNjDfNjAjEiBgJjBkGiClP_xHqqkZx_0_xZkqqHx_iBgK_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCmNiBeB_xHqqkZx_lIndex1=6_xZkqqHx_iCmMiPoKiNiHiBeBiJlKjAhNiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
// *
// *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
// *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
// *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
// *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
// *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
// *            _xZkqqHx_iEkA_xHqqkZx_               
// *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
// *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
// *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
// *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
// *
// *			_xZkqqHx_iClBiCmMiPoKiNiHiBeB_xHqqkZx_PointIndex=7_xZkqqHx_iCmFiDhMiDiKiDiJiDeDiDjDiCkKiPeJjHlJiClHiCoJiPoKiNiHiCmGiBeBiClLiCmMjAoGiCmJ_xHqqkZx_
// *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkCiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
// *
// *			_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_lFailedLineSize=6_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBePiJpBiCmMiOmAiNhDiCmF_xHqqkZx_
// *			_xZkqqHx_iImIiJlKiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClFiCmEiBeBiClLiCoKiCkKiDhIiDfHiDeGiLnPiOjHiCmJiOlIjEhDiClFiClNiClBiCmGiCpA_xHqqkZx_
// *			_xZkqqHx_iInDjGkBiClFiCmEiCkCiCoJiBeC_xHqqkZx_
// *
// *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
// *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
// *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
// *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
// *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
// *            _xZkqqHx_iEkA_xHqqkZx_               
// *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_              
// *             _xZkqqHx_iCfDiBfPiBfBiBfB_xHqqkZx_        
// *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
// *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long FCApproximateBezier::GetPolyForBezierL0 (	DBLPointVector& vPointFirst,
//												doubleVector& vLineAngleFirst,
//												doubleVector& vPointAngleFirst,
//												DBLPointVector& vPoint,
//												doubleVector& vLineAngle,
//												doubleVector& vPointAngle,
//												long lIndex1,
//												double dAngleMove1,
//												long lFailedLineSize) const
//{
//	// _xZkqqHx_jBePiJpBiCmMiDhIiDfHiDeGiLnPiOjHiCkKiOlIjEhDiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOlIjEhDiClFiClN_xHqqkZx_
//	// _xZkqqHx_iDhMiDeDiDjDiDgHiCoGiCoIiOoIjBePiCmMiDhMiDeDiDjDiDgHiCnMiCmFiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	if (lFailedLineSize != -1 && lFailedLineSize - 2 < lIndex1)
//		lIndex1 = lFailedLineSize - 2;
//
//	// _xZkqqHx_jAnIiCoIiPgPiClHiImKjChFiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	long lIndexM = lIndex1;
//	if (M_PI * 1.6 < fabs(dAngleMove1))
//	//----- _xZkqqHx_jApMjFkKiCkKiJpBiCoIiClHiCkMiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- _xZkqqHx_iCkAiCnMiCoIiJpBiCmBiCmEiCkCiCmIiCkCiImKjChFiCmFiDhMiDiKiDiJiDeDiDjDiCpAjAnIjCgGiClHiCoJ_xHqqkZx_ -----
//		double dMinAngle = DBL_MAX;
//		lIndexM = lIndex1 / 2;
//		double dAngleMove = 0.0;
//		long lIndex;
//		for (lIndex = 0; lIndex != lIndex1; lIndex++)
//		{
//			double dAngle = FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex]);
//			dAngleMove += dAngle;
//			if (M_PI * 0.8 < fabs(dAngleMove) && fabs(dAngleMove) < M_PI * 1.6)
//			{
//				// _xZkqqHx_iPgPjHiIiCoJiClOiCkPiKhAjBkMjDhIiCmMjChIiCkCiImKjChFiCmFjAnIjCgGiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
//				// _xZkqqHx_iKhAjBkMjDhIiCmMjBkMiCkCiImKjChFiCmNiBeBiDhMiDeDiDjDiDgHiKhAjDhIiOfKiPgPiCmMiMoLiNlHiCkKjBoFiCkLiCkCiCmG_xHqqkZx_
//				// _xZkqqHx_iNgMiCkGiCoHiCoKiCoJiClNiCnPiBeC_xHqqkZx_
//				if (fabs(dAngle) < dMinAngle)
//				{
//					dMinAngle = fabs(dAngle);
//					lIndexM = lIndex;
//				}
//			}
//		}
//	}
//	if (lIndexM == vLineAngle.size() - 1)
//	//----- lIndexM_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkJiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCpAjBfDiCmEjAnIiCoIiPgPiClHiDhMiDiKiDiJiDeDiDjDiCmJiOhHjCoIiBeC_xHqqkZx_
//		// _xZkqqHx_jAnIiCoIiPgPiClFiClNiMoDiCmMiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDiCmNiLpDiCmJiClHiCoJiBeC_xHqqkZx_
//		vPointFirst = vPoint;
//		vPoint.clear();
//		vLineAngleFirst = vLineAngle;
//		vLineAngle.clear();
//		vPointAngleFirst = vPointAngle;
//		vPointAngle.clear();
//	} else
//	//----- lIndexM_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkNiPoKiNiH_xHqqkZx_ -----
//	{
//		// LineIndex=4(lIndexM=4)_xZkqqHx_iCmJiCkIiCkCiCmEiDfKiDePiDiBiDjDiDgHiCpAjFkKiKiEiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//		//
//		//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
//		//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
//		//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
//		//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
//		//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
//		//         _xZkqqHx_iEkA_xHqqkZx_               
//		//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
//		//          _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
//		//             _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
//		//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
//		//
//		// PointIndex=5_xZkqqHx_iCpAjDpBiCmCiCmJjFkKiKiEiBeC_xHqqkZx_
//		//
//		//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
//		//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
//		//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
//		//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
//		//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
//		//         _xZkqqHx_iEkA_xHqqkZx_               
//		//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_            _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_
//		//          _xZkqqHx_iCfDiBfP_xHqqkZx_    _xZkqqHx_iBfBiBfBiBfOiCfA_xHqqkZx_    
//		//             _xZkqqHx_iBkD_xHqqkZx_  _xZkqqHx_iBkDiCePiBkD_xHqqkZx_       
//		//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
//		//
//		// PointIndex_xZkqqHx_iCkK_xHqqkZx_[0,5]_xZkqqHx_iCmMjEmNiImNiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClFiCmEiBeB_xHqqkZx_
//		// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_PointIndex[5,_xZkqqHx_iBgA_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoKiNiHiBeBjAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmGiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMjHlMjFpLiCmJ_xHqqkZx_
//		// _xZkqqHx_iDhMiDeDiDjDiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_=5_xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//		vPointFirst.clear();
//		vLineAngleFirst.clear();
//		vPointAngleFirst.clear();
//		vPointFirst.insert(vPointFirst.end(), vPoint.begin(), vPoint.begin() + lIndexM + 2);
//		vPoint.erase(vPoint.begin(), vPoint.begin() + lIndexM + 1);
//		vLineAngleFirst.insert(vLineAngleFirst.end(), vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
//		vLineAngle.erase(vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
//		vPointAngleFirst.insert(vPointAngleFirst.end(), vPointAngle.begin(), vPointAngle.begin() + lIndexM + 2);
//		vPointAngle.erase(vPointAngle.begin(), vPointAngle.begin() + lIndexM + 1);
//	}
//	return 0;
//} // FCApproximateBezier::GetPolyForBezierL0.
//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetPolyForBezierL0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCkKiCfAiJpBiCoAjElNjDfNiClFiCmIiCkCiDhMiDiKiDiJiDeDiDjDiCkJiCoHiBeBiDhIiDfHiDeGiLnPiOjHiCpA_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCmMiCmJjDeLjDjGiCmIiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jBePiJpBiCmMiDhIiDfHiDeGiLnPiOjHiCmFjAkMiMpHiClFiClNiDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPointFirst		:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngleFirst	:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngleFirst:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPoint			:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIndex1			:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiNmFiMoDiCmMjApMjFkKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
 *			dAngleMove1		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_[0,lIndex1]_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmFiBeBjFmPiJlLiClFiClNjApMjFkKiCmMiKhAjDhIiCmMjBiNjIgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDiCmMiKhAjBkMjDhIiCmMjElNjDfNjAjEiBgJjBkGiClP_xHqqkZx_0_xZkqqHx_iBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCmNiBeB_xHqqkZx_lIndex1=6_xZkqqHx_iCmMiPoKiNiHiBeBiJlKjAhNiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *            _xZkqqHx_iEkA_xHqqkZx_               
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeB_xHqqkZx_PointIndex=7_xZkqqHx_iCmFiDhMiDiKiDiJiDeDiDjDiCkKiPeJjHlJiClHiCoJiPoKiNiHiCmGiBeBiClLiCmMjAoGiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkCiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCApproximateBezier::GetPolyForBezierL0 (	DBLPointVector& vPointFirst,
												doubleVector& vLineAngleFirst,
												doubleVector& vPointAngleFirst,
												DBLPointVector& vPoint,
												doubleVector& vLineAngle,
												doubleVector& vPointAngle,
												long lIndex1,
												double dAngleMove1) const
{
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeC_xHqqkZx_
	const double dSplitAngle0 = m_dSplitAngle0 * M_PI;
	// _xZkqqHx_jAnIiCoIiPgPiClHiImKjChFiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lIndexM = lIndex1;
	if (dSplitAngle0 < fabs(dAngleMove1))
	//----- _xZkqqHx_jApMjFkKiCkKiJpBiCoIiClHiCkMiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		double dAngleMoveTmp = fabs(dAngleMove1);
		while (dSplitAngle0 < dAngleMoveTmp)
			dAngleMoveTmp /= 2.0;
		const double dAngleM1 = dAngleMoveTmp * 0.45;
		const double dAngleM2 = dAngleMoveTmp * 0.55;
		//----- _xZkqqHx_iCkAiCnMiCoIiJpBiCmBiCmEiCkCiCmIiCkCiImKjChFiCmFiDhMiDiKiDiJiDeDiDjDiCpAjAnIjCgGiClHiCoJ_xHqqkZx_ -----
		double dMinAngle = DBL_MAX;
		lIndexM = lIndex1 / 2;
		double dAngleMove = 0.0;
		long lIndex;
		for (lIndex = 0; lIndex != lIndex1; lIndex++)
		{
			// _xZkqqHx_iDhMiDeDiDjDiDgH_xHqqkZx_P[lIndex]_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjBkMjDhIiBeC_xHqqkZx_
			double dAngle = FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex]);
			// _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiBeC_xHqqkZx_
			dAngleMove += dAngle;
			if (dAngleM1 < fabs(dAngleMove) && fabs(dAngleMove) < dAngleM2)
			//----- _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiCkKjCiGiKnEjEmNiImNiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iPgPjHiIiCoJiClOiCkPiKhAjBkMjDhIiCmMjChIiCkCiImKjChFiCmFjAnIjCgGiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
				// _xZkqqHx_iKhAjBkMjDhIiCmMjBkMiCkCiImKjChFiCmNiBeBiDhMiDeDiDjDiDgHiKhAjDhIiOfKiPgPiCmMiMoLiNlHiCkKjBoFiCkLiCkCiCmG_xHqqkZx_
				// _xZkqqHx_iNgMiCkGiCoHiCoKiCoJiClNiCnPiBeC_xHqqkZx_
				if (fabs(dAngle) < dMinAngle)
				{
					dMinAngle = fabs(dAngle);
					lIndexM = lIndex;
				}
			}
		}
	}
	if (lIndexM == vLineAngle.size() - 1)
	//----- lIndexM_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkJiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCpAjBfDiCmEjAnIiCoIiPgPiClHiDhMiDiKiDiJiDeDiDjDiCmJiOhHjCoIiBeC_xHqqkZx_
		// _xZkqqHx_jAnIiCoIiPgPiClFiClNiMoDiCmMiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDiCmNiLpDiCmJiClHiCoJiBeC_xHqqkZx_
		vPointFirst = vPoint;
		vPoint.clear();
		vLineAngleFirst = vLineAngle;
		vLineAngle.clear();
		vPointAngleFirst = vPointAngle;
		vPointAngle.clear();
	} else
	//----- lIndexM_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkNiPoKiNiH_xHqqkZx_ -----
	{
		// LineIndex=4(lIndexM=4)_xZkqqHx_iCmJiCkIiCkCiCmEiDfKiDePiDiBiDjDiDgHiCpAjFkKiKiEiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		//
		//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
		//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
		//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
		//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
		//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
		//         _xZkqqHx_iEkA_xHqqkZx_               
		//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
		//          _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
		//             _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
		//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
		//
		// PointIndex=5_xZkqqHx_iCpAjDpBiCmCiCmJjFkKiKiEiBeC_xHqqkZx_
		//
		//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
		//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
		//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
		//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
		//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
		//         _xZkqqHx_iEkA_xHqqkZx_               
		//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_            _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_
		//          _xZkqqHx_iCfDiBfP_xHqqkZx_    _xZkqqHx_iBfBiBfBiBfOiCfA_xHqqkZx_    
		//             _xZkqqHx_iBkD_xHqqkZx_  _xZkqqHx_iBkDiCePiBkD_xHqqkZx_       
		//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
		//
		// PointIndex_xZkqqHx_iCkK_xHqqkZx_[0,5]_xZkqqHx_iCmMjEmNiImNiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClFiCmEiBeB_xHqqkZx_
		// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_PointIndex[5,_xZkqqHx_iBgA_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiBeBjAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmGiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMjHlMjFpLiCmJ_xHqqkZx_
		// _xZkqqHx_iDhMiDeDiDjDiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_=5_xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		vPointFirst.clear();
		vLineAngleFirst.clear();
		vPointAngleFirst.clear();
		vPointFirst.insert(vPointFirst.end(), vPoint.begin(), vPoint.begin() + lIndexM + 2);
		vPoint.erase(vPoint.begin(), vPoint.begin() + lIndexM + 1);
		vLineAngleFirst.insert(vLineAngleFirst.end(), vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
		vLineAngle.erase(vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
		vPointAngleFirst.insert(vPointAngleFirst.end(), vPointAngle.begin(), vPointAngle.begin() + lIndexM + 2);
		vPointAngle.erase(vPointAngle.begin(), vPointAngle.begin() + lIndexM + 1);
	}
	return 0;
} // FCApproximateBezier::GetPolyForBezierL0.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetPolyForBezierL0Fail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCkKiCfAiJpBiCoAjElNjDfNiClFiCmIiCkCiDhMiDiKiDiJiDeDiDjDiCkJiCoHiBeBiDhIiDfHiDeGiLnPiOjHiCpA_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCmMiCmJjDeLjDjGiCmIiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jBePiJpBiCmMiDhIiDfHiDeGiLnPiOjHiCmFiOlIjEhDiClFiClNiDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPointFirst		:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngleFirst	:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngleFirst:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPoint			:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIndex1			:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiNmFiMoDiCmMjApMjFkKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
 *			dAngleMove1		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_[0,lIndex1]_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmFiBeBjFmPiJlLiClFiClNjApMjFkKiCmMiKhAjDhIiCmMjBiNjIgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDiCmMiKhAjBkMjDhIiCmMjElNjDfNjAjEiBgJjBkGiClP_xHqqkZx_0_xZkqqHx_iBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCmNiBeB_xHqqkZx_lIndex1=6_xZkqqHx_iCmMiPoKiNiHiBeBiJlKjAhNiCmMiCoGiCkEiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 *                _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
 *                _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
 *             _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *         _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
 *          _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *            _xZkqqHx_iEkA_xHqqkZx_               
 *         _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
 *             _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
 *                _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
 *
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeB_xHqqkZx_PointIndex=7_xZkqqHx_iCmFiDhMiDiKiDiJiDeDiDjDiCkKiPeJjHlJiClHiCoJiPoKiNiHiCmGiBeBiClLiCmMjAoGiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkCiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
 *			lIndex1=6_xZkqqHx_iCmNiBeBjBePiJpBiOlIjEhDiClFiClNiDfAiBfLiDfIiCmIiCmMiCmFiBeBjAnIiCoIiPgPiClHiDhMiDiKiDiJiDeDiDjDiCmN_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoGiCoIiOoIjBePiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCApproximateBezier::GetPolyForBezierL0Fail (	DBLPointVector& vPointFirst,
													doubleVector& vLineAngleFirst,
													doubleVector& vPointAngleFirst,
													DBLPointVector& vPoint,
													doubleVector& vLineAngle,
													doubleVector& vPointAngle,
													long lIndex1,
													double dAngleMove1) const
{
	ASSERT(0 < lIndex1);
	const double dAngleM1 = fabs(dAngleMove1 * 0.45);
	const double dAngleM2 = fabs(dAngleMove1 * 0.55);
	// _xZkqqHx_jAnIiCoIiPgPiClHiImKjChFiCmMjApMjFkKiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lIndexM = lIndex1;
	//----- _xZkqqHx_jCiGiKnEiCkNiCoHiCkCiCmMiImKjChFiCmFiDhMiDiKiDiJiDeDiDjDiCpAjAnIjCgGiClHiCoJ_xHqqkZx_ -----
	double dMinAngle = DBL_MAX;
	double dAngleMove = 0.0;
	long lIndex;
	for (lIndex = 0; lIndex != lIndex1; lIndex++)
	{
		// _xZkqqHx_iDhMiDeDiDjDiDgH_xHqqkZx_P[lIndex]_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjBkMjDhIiBeC_xHqqkZx_
		double dAngle = FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex]);
		// _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiBeC_xHqqkZx_
		dAngleMove += dAngle;
		if (dAngleM1 < fabs(dAngleMove) && fabs(dAngleMove) < dAngleM2)
		//----- _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiCkKjCiGiKnEjEmNiImNiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iPgPjHiIiCoJiClOiCkPiKhAjBkMjDhIiCmMjChIiCkCiImKjChFiCmFjAnIjCgGiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
			// _xZkqqHx_iKhAjBkMjDhIiCmMjBkMiCkCiImKjChFiCmNiBeBiDhMiDeDiDjDiDgHiKhAjDhIiOfKiPgPiCmMiMoLiNlHiCkKjBoFiCkLiCkCiCmG_xHqqkZx_
			// _xZkqqHx_iNgMiCkGiCoHiCoKiCoJiClNiCnPiBeC_xHqqkZx_
			if (fabs(dAngle) < dMinAngle)
			{
				dMinAngle = fabs(dAngle);
				lIndexM = lIndex;
			}
		}
	}
	if (lIndexM == lIndex1)
		lIndexM = lIndex1 / 2;

	// LineIndex=4(lIndexM=4)_xZkqqHx_iCmJiCkIiCkCiCmEiDfKiDePiDiBiDjDiDgHiCpAjFkKiKiEiClHiCoJiPoKiNiHiBeC_xHqqkZx_
	//
	//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
	//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
	//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
	//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
	//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
	//         _xZkqqHx_iEkA_xHqqkZx_               
	//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfG_xHqqkZx_
	//          _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
	//             _xZkqqHx_iBkDiCfEiBkD_xHqqkZx_       
	//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_       
	//
	// PointIndex=5_xZkqqHx_iCpAjDpBiCmCiCmJjFkKiKiEiBeC_xHqqkZx_
	//
	//             _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
	//             _xZkqqHx_iBkFiCfAiBkF_xHqqkZx_       
	//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
	//      _xZkqqHx_iCfCiBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiCeP_xHqqkZx_
	//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
	//         _xZkqqHx_iEkA_xHqqkZx_               
	//      _xZkqqHx_iCfDiBkFiBfP_xHqqkZx_            _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_
	//          _xZkqqHx_iCfDiBfP_xHqqkZx_    _xZkqqHx_iBfBiBfBiBfOiCfA_xHqqkZx_    
	//             _xZkqqHx_iBkD_xHqqkZx_  _xZkqqHx_iBkDiCePiBkD_xHqqkZx_       
	//             _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
	//
	// PointIndex_xZkqqHx_iCkK_xHqqkZx_[0,5]_xZkqqHx_iCmMjEmNiImNiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_PointIndex[5,_xZkqqHx_iBgA_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiBeBjAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmGiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMjHlMjFpLiCmJ_xHqqkZx_
	// _xZkqqHx_iDhMiDeDiDjDiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_=5_xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	vPointFirst.clear();
	vLineAngleFirst.clear();
	vPointAngleFirst.clear();
	vPointFirst.insert(vPointFirst.end(), vPoint.begin(), vPoint.begin() + lIndexM + 2);
	vPoint.erase(vPoint.begin(), vPoint.begin() + lIndexM + 1);
	vLineAngleFirst.insert(vLineAngleFirst.end(), vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
	vLineAngle.erase(vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
	vPointAngleFirst.insert(vPointAngleFirst.end(), vPointAngle.begin(), vPointAngle.begin() + lIndexM + 2);
	vPointAngle.erase(vPointAngle.begin(), vPointAngle.begin() + lIndexM + 1);
	return 0;
} // FCApproximateBezier::GetPolyForBezierL0Fail.
//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetPolyForBezierL1
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCkKiCfAiJpBiClOiCkPjElNjDfNiClHiCoJiDhMiDiKiDiJiDeDiDjDiCkJiCoHiBeBiDhIiDfHiDeGiLnPiOjHiCpA_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCmMiCmJjDeLjDjGiCmIiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPointFirst		:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngleFirst	:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngleFirst:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPoint			:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIndex1			:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiKgFjBkMjDhIjElNjDfNiImKjChFiCmMjApMjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
 *			lIndex2			:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMiNmFiMoDiCmMjApMjFkKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlKjAhNiCpAiOfBiPmGiBeC_xHqqkZx_
 *			dAngleMove1		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_[0,lIndex1]_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmFiBeBjFmPiJlLiClFiClNjApMjFkKiCmMiKhAjDhIiCmMjBiNjIgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dAngleMove2		:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_[lIndex1,lIndex2]_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iKnEiCmFiBeBjFmPiJlLiClFiClNjApMjFkKiCmMiKhAjDhIiCmMjBiNjIgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDiCmMiKhAjBkMjDhIiCmMjElNjDfNjAjEiBgJ_xHqqkZx_0_xZkqqHx_iCmG_xHqqkZx_1_xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoJiBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeB_xHqqkZx_lIndex1=2_xZkqqHx_iBeB_xHqqkZx_lIndex2=4_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_lIndex2_xZkqqHx_iCmMiMoDiCmJiCoAiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkNiBeC_xHqqkZx_
 *         
 *                            _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_    
 *           Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  
 *                        _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
 *           Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_
 *         
 *                         _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_
 *                           _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_
 *         
 *         
 *          _xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeB_xHqqkZx_lIndex1=2_xZkqqHx_iBeB_xHqqkZx_lIndex2=4_xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_lIndex2_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCmNjBlBiCkJiCmIiCkCiBeC_xHqqkZx_
 *         
 *                            _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_    
 *           Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  
 *                        _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
 *           Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_
 *         
 *                         _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_  
 *                           _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCApproximateBezier::GetPolyForBezierL1 (	DBLPointVector& vPointFirst,
												doubleVector& vLineAngleFirst,
												doubleVector& vPointAngleFirst,
												DBLPointVector& vPoint,
												doubleVector& vLineAngle,
												doubleVector& vPointAngle,
												long lIndex1,
												long lIndex2,
												double dAngleMove1,
												double dAngleMove2) const
{
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeC_xHqqkZx_
	const double dSplitAngle1 = m_dSplitAngle1 * M_PI;
	if (dSplitAngle1 < fabs(dAngleMove1))
	//----- _xZkqqHx_iKhAjBkMjDhIjElNjDfNiImKjChFiCnMiCmFiCmMjApMjFkKiCmMiJpBjDfNiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKhAjBkMjDhIjElNjDfNiBiBiCePiJpBiCmGiClFiCmEiPiIjHjNiClHiCoJiBeC_xHqqkZx_
		return GetPolyForBezierL0(	vPointFirst,
									vLineAngleFirst,
									vPointAngleFirst,
									vPoint,
									vLineAngle,
									vPointAngle,
									lIndex1,
									dAngleMove1);
	}
	if (dSplitAngle1 < fabs(dAngleMove2))
	//----- _xZkqqHx_iKhAjBkMjDhIjElNjDfNiMoDiCmMjApMjFkKiCmMiJpBjDfNiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		double dAngleMoveTmp = fabs(dAngleMove2);
		while (dSplitAngle1 < dAngleMoveTmp)
			dAngleMoveTmp /= 2.0;
		const double dAngleM1 = dAngleMoveTmp * 0.45;
		const double dAngleM2 = dAngleMoveTmp * 0.55;
		//----- _xZkqqHx_jBoFiCkLiClHiCkMiCmIiCkCiImKjChFiCnMiCmFiCmFiDhMiDiKiDiJiDeDiDjDiCpAjAnIjCgGiClHiCoJ_xHqqkZx_ -----
		double dMinAngle = DBL_MAX;
		long lIndexM = (lIndex2 + lIndex1) / 2;
		double dAngleMove = 0.0;
		long lIndex;
		for (lIndex = lIndex1; lIndex != lIndex2; lIndex++)
		{
			// _xZkqqHx_iDhMiDeDiDjDiDgH_xHqqkZx_P[lIndex]_xZkqqHx_iCmJiCkIiCkPiCoJiKhAjBkMjDhIiBeC_xHqqkZx_
			double dAngle = FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex]);
			// _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiBeC_xHqqkZx_
			dAngleMove += dAngle;
			if (dAngleM1 < fabs(dAngleMove) && fabs(dAngleMove) < dAngleM2)
			//----- _xZkqqHx_iNiHiMhGiCmMiKhAjDhIiCkKjCiGiKnEjEmNiImNiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iPgPjHiIiCoJiClOiCkPiKhAjBkMjDhIiCmMjChIiCkCiImKjChFiCmFjAnIjCgGiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
				// _xZkqqHx_iKhAjBkMjDhIiCmMjBkMiCkCiImKjChFiCmNiBeBiDhMiDeDiDjDiDgHiKhAjDhIiOfKiPgPiCmMiMoLiNlHiCkKjBoFiCkLiCkCiCmG_xHqqkZx_
				// _xZkqqHx_iNgMiCkGiCoHiCoKiCoJiClNiCnPiBeC_xHqqkZx_
				if (fabs(dAngle) < dMinAngle)
				{
					dMinAngle = fabs(dAngle);
					lIndexM = lIndex;
				}
			}
		}
		// LineIndex=4(lIndexM=6)_xZkqqHx_iCmJiCkIiCkCiCmEiDfKiDePiDiBiDjDiDgHiCpAjFkKiKiEiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		//
		//                  _xZkqqHx_iBkDiCeP_xHqqkZx_      
		//                  _xZkqqHx_iBfP_xHqqkZx_        
		//                  _xZkqqHx_iCePiBfPiBkDiCfA_xHqqkZx_  
		//                     _xZkqqHx_iEkAiCfA_xHqqkZx_   
		//                     _xZkqqHx_iEkA_xHqqkZx_     
		//             _xZkqqHx_iCfD_xHqqkZx_     _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_  
		//             _xZkqqHx_iBkFiCfC_xHqqkZx_ _xZkqqHx_iBfOiCfB_xHqqkZx_      
		//          _xZkqqHx_iCfDiBfOiBfAiBfAiBkFiCfC_xHqqkZx_      
		//      _xZkqqHx_iCfEiBkDiBfO_xHqqkZx_                
		//       _xZkqqHx_iCfEiEkA_xHqqkZx_                 
		//         _xZkqqHx_iEkA_xHqqkZx_                 
		//      _xZkqqHx_iCfFiBkFiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiCfI_xHqqkZx_  
		//          _xZkqqHx_iCfFiBfPiBfBiBfBiBfOiCfH_xHqqkZx_      
		//             _xZkqqHx_iBkDiCfGiBkD_xHqqkZx_         
		//             _xZkqqHx_iCfG_xHqqkZx_  _xZkqqHx_iCfH_xHqqkZx_         
		//
		// PointIndex=7_xZkqqHx_iCpAjDpBiCmCiCmJjFkKiKiEiBeC_xHqqkZx_
		//
		//                  _xZkqqHx_iBkDiCeP_xHqqkZx_      
		//                  _xZkqqHx_iBfP_xHqqkZx_        
		//                  _xZkqqHx_iCePiBfPiBkDiCfA_xHqqkZx_  
		//                     _xZkqqHx_iEkAiCfA_xHqqkZx_   
		//                     _xZkqqHx_iEkA_xHqqkZx_     
		//             _xZkqqHx_iCfD_xHqqkZx_     _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_  
		//             _xZkqqHx_iBkFiCfC_xHqqkZx_ _xZkqqHx_iBfOiCfB_xHqqkZx_      
		//          _xZkqqHx_iCfDiBfOiBfAiBfAiBkFiCfC_xHqqkZx_      
		//      _xZkqqHx_iCfEiBkDiBfO_xHqqkZx_                
		//       _xZkqqHx_iCfEiEkA_xHqqkZx_                 
		//         _xZkqqHx_iEkA_xHqqkZx_                 
		//      _xZkqqHx_iCfFiBkFiBfP_xHqqkZx_            _xZkqqHx_iBfOiBkFiCfB_xHqqkZx_
		//          _xZkqqHx_iCfFiBfP_xHqqkZx_    _xZkqqHx_iBfBiBfBiBfOiCfA_xHqqkZx_    
		//             _xZkqqHx_iBkD_xHqqkZx_  _xZkqqHx_iBkDiCePiBkD_xHqqkZx_       
		//             _xZkqqHx_iCfG_xHqqkZx_  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_       
		//
		// PointIndex_xZkqqHx_iCkK_xHqqkZx_[0,7]_xZkqqHx_iCmMjEmNiImNiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClFiCmEiBeB_xHqqkZx_
		// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_PointIndex_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiBeBjAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmGiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCmMjHlMjFpLiCmJ_xHqqkZx_
		// _xZkqqHx_iDhMiDeDiDjDiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_=7_xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		vPointFirst.clear();
		vLineAngleFirst.clear();
		vPointAngleFirst.clear();
		vPointFirst.insert(vPointFirst.end(), vPoint.begin(), vPoint.begin() + lIndexM + 2);
		vPoint.erase(vPoint.begin(), vPoint.begin() + lIndexM + 1);
		vLineAngleFirst.insert(vLineAngleFirst.end(), vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
		vLineAngle.erase(vLineAngle.begin(), vLineAngle.begin() + lIndexM + 1);
		vPointAngleFirst.insert(vPointAngleFirst.end(), vPointAngle.begin(), vPointAngle.begin() + lIndexM + 2);
		vPointAngle.erase(vPointAngle.begin(), vPointAngle.begin() + lIndexM + 1);
// 05.04.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return 1;
		return (lIndexM == lIndex1) ? 0 : 1;
	}

	//----- _xZkqqHx_iKhAjBkMjDhIjElNjDfNiCmMjBePiCmGiMoDiCmMjApMjFkKiCmMiJpBjDfNiCkKjBoFiCkLiJnPiCkMiCmIiCkCiPoKiNiH_xHqqkZx_ -----

	if (lIndex2 == vLineAngle.size() - 1)
	//----- lIndex2_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkJiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDiCpAjBfDiCmEjAnIiCoIiPgPiClHiDhMiDiKiDiJiDeDiDjDiCmJiOhHjCoIiBeC_xHqqkZx_
		// _xZkqqHx_jAnIiCoIiPgPiClFiClNiMoDiCmMiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDiCmNiLpDiCmJiClHiCoJiBeC_xHqqkZx_
		vPointFirst = vPoint;
		vPoint.clear();
		vLineAngleFirst = vLineAngle;
		vLineAngle.clear();
		vPointAngleFirst = vPointAngle;
		vPointAngle.clear();
	} else
	//----- lIndex2_xZkqqHx_iCmMiMoDiCmJiDhMiDiKiDiJiDeDiDjDiCkKjBlBiCkNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKhAjBkMjDhIiCkKjElNjDfNiClFiCmEiCkCiCoJiImKjChFiCmMjApMjFkKiCmNiBeBiClLiCmMjApMjFkKiCmMjDhCjCiGiCmFjElNjDfNiClFiCmE_xHqqkZx_
		// _xZkqqHx_iCkCiCoJiCmNiClIiCmIiCmMiCmFiBeBjApMjFkKiCpAjDpBiCmCiCmJjFkKiKiEiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		//
		// LineIndex=4(lIndex2=4)_xZkqqHx_iCmJiCkIiCkCiCmEiDfKiDePiDiBiDjDiDgHiCpAjFkKiKiEiClHiCoJiPoKiNiHiBeC_xHqqkZx_
		//
		//                   _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_    
		//  Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  
		//               _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
		//  Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_
		//
		//                _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_
		//                  _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_
		//                               _xZkqqHx_iEkA_xHqqkZx_    
		//                               _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
		//                                 _xZkqqHx_iCgB_xHqqkZx_
		//
		// _xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCpA_xHqqkZx_PointIndex=5 _xZkqqHx_iCmGiClFiCmEjBhNjDpMiBeC_xHqqkZx_
		// _xZkqqHx_jDkPjHgMiCmJ_xHqqkZx_LineAngle_xZkqqHx_jEhKjHpBiCmJiCoAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
		//
		//                   _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhLiCePiBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_    
		//  Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_ _xZkqqHx_iCfDiCfE_xHqqkZx_ _xZkqqHx_iCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_  
		//               _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiElOiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
		//  Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfDiCfEiCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_  _xZkqqHx_iCfH_xHqqkZx_
		//
		//                _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_
		//                  _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_
		//                           _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_  
		//                       _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkFiEkJiEkH_xHqqkZx_
		//                         _xZkqqHx_iCgA_xHqqkZx_      _xZkqqHx_iCgB_xHqqkZx_
		//
		//                   _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_     _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_    
		//  Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_ _xZkqqHx_iCfD_xHqqkZx_   _xZkqqHx_iCeP_xHqqkZx_ _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  
		//               _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEkH_xHqqkZx_ _xZkqqHx_iElFiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
		//  Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfDiCfE_xHqqkZx_ _xZkqqHx_iCePiCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_
		//
		//                _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_          _xZkqqHx_iBfO_xHqqkZx_
		//                  _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_          _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_
		//
		//
		// PointIndex_xZkqqHx_iCkK_xHqqkZx_[0,5]_xZkqqHx_iCmMjEmNiImNiCpAiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiClFiCmEiBeB_xHqqkZx_
		// _xZkqqHx_iOgDiCoIiCmM_xHqqkZx_PointIndex[5,_xZkqqHx_iBgA_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_

		// _xZkqqHx_iDhMiDeDiDjDiDgH_xHqqkZx_P_xZkqqHx_iCmMiImKjChFiCmGiKhAjDhIiCmMiOfKiPgPiClOiCkKiBeBiCkCiCoLiCkCiCoLjFpLjGeAiCkKiNgMiCkGiCoHiCoKiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jBePiMoDiCmMjApMjFkKiCoCiDhMiDeDiDjDiDgHiCmMiKhAjBkMjDhIiCkJiCoHiCfCiOjPiOkOiCpAiNoMiCmBiCmEiOfKiPgPiClFiClNiCoIiBeB_xHqqkZx_
		// _xZkqqHx_jBePiMoDiCmMiDhMiDeDiDjDiDgHiCkJiCoHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClFiCmEiBeBiClLiCmMiKhAiJmBjBkMjDhIiBiBiCePiCmMjDfPiCpAiLiBiCnPiClNiCoIiBeB_xHqqkZx_
		// _xZkqqHx_iCkCiCoLiCkCiCoLiOiOiClFiCmEiCnNiClNiBeC_xHqqkZx_
		// _xZkqqHx_iCkCiClIiCoKiCoAjAlDiKgNiCmIjCgMiCpAiLiBiCnPiCoJiClBiCmGiCmNiPgPjHiIiClIiBeBiCnMiClNiDhMiDeDiDjDiDgH_xHqqkZx_P_xZkqqHx_iCmMiImKjChFiCoC_xHqqkZx_P_xZkqqHx_iCmMiKhAjDhIiCkK_xHqqkZx_
		// _xZkqqHx_iCkAiCnMiCoIjAlDiKgNiCmFiCkAiCoJjFeLjHhGiCkKiCmIiCkCiDeBiDiLiDfDiDiKiDfJiDiAiCmJjFmPiNfIiClFiClNiClNiCnPiBeB_xHqqkZx_P_xZkqqHx_iCmMiPoOjFpBiOfKiPgPiCmN_xHqqkZx_
		// _xZkqqHx_jBkMjDhIiCkKjBkMiCkNiKmIjCfAiCmIjFpLjGeAiCmJjFmPiNfIiClFiClNiBeC_xHqqkZx_

		// _xZkqqHx_jApMjFkKiCmMjCiGiKnEiImKjChFiCpAjFkKiKiEjDfP_xHqqkZx_P_xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
		DBLPoint mmptP = (vPoint[lIndex2] + vPoint[lIndex2 + 1]) / 2.0;
		// _xZkqqHx_iDhMiDeDiDjDiDgH_xHqqkZx_P_xZkqqHx_iCmMiKhAjDhIiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_P_xZkqqHx_iCmMjBePiMoDiCmMiDhMiDeDiDjDiDgHiCmGjApMjFkKiCmMiKhAjDhIiCpAiOgHiCkEiBeC_xHqqkZx_
		double dPointAngleP1 = FFAngleMinusPitoPi(vLineAngle[lIndex2] + (vLineAngle[lIndex2] - vPointAngle[lIndex2]) / 2.0);
		double dPointAngleP2 = FFAngleMinusPitoPi(vLineAngle[lIndex2] + (vLineAngle[lIndex2] - vPointAngle[lIndex2+1]) / 2.0);
		double dPointAngleP = (dPointAngleP1 + dPointAngleP2) / 2.0;

		vPointFirst.clear();
		vLineAngleFirst.clear();
		vPointAngleFirst.clear();

		vPointFirst.insert(vPointFirst.end(), vPoint.begin(), vPoint.begin() + lIndex2 + 1);
		vPointFirst.push_back(mmptP);
		vPoint.erase(vPoint.begin(), vPoint.begin() + lIndex2 + 1);
		vPoint.insert(vPoint.begin(), mmptP);

		vLineAngleFirst.insert(vLineAngleFirst.end(), vLineAngle.begin(), vLineAngle.begin() + lIndex2 + 1);
		vLineAngle.erase(vLineAngle.begin(), vLineAngle.begin() + lIndex2);

		vPointAngleFirst.insert(vPointAngleFirst.end(), vPointAngle.begin(), vPointAngle.begin() + lIndex2 + 1);
		vPointAngleFirst.push_back(dPointAngleP);
		vPointAngle.erase(vPointAngle.begin(), vPointAngle.begin() + lIndex2 + 1);
		vPointAngle.insert(vPointAngle.begin(), dPointAngleP);
	}
	return 1;
} // FCApproximateBezier::GetPolyForBezierL1.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::GetFirstPolyForBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCkJiCoHiBeBiDhIiDfHiDeGiLnPiOjHiCpAiClHiCoJiCmMiCmJjDeLjDjGiCmIiDhMiDeDiDjDiDgH_xHqqkZx_
 *			_xZkqqHx_iCnMiCmFiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjAnIiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPointFirst		:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngleFirst	:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngleFirst:_xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPoint			:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vLineAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vPointAngle		:_xZkqqHx_jAnIiCoIiPgPiClHjBePiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jAnIiCoIiPgPiClDiCoKiClNiOgDiCoIiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lFailedLineSize	:_xZkqqHx_jBePiJpBiCmMiDhIiDfHiDeGiLnPiOjHiCmFiOlIjEhDiClFiClNiDhMiDiKiDiJiDeDiDjDjApMjFkKiCmM_xHqqkZx_
 *							 _xZkqqHx_jAjEiCpAiOhHjCoIiBeCjAkMiMpHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnIiCoIiPgPiClFiClNiDhMiDiKiDiJiDeDiDjDiCmMiKhAjBkMjDhIiCmMjElNjDfNjAjEiBgJ_xHqqkZx_0_xZkqqHx_iCmG_xHqqkZx_1_xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoJiBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiCmMiKhAjDhIiCpAjClCiCnHiBeBiClLiCmMiKhAjBkMjDhIiCkK_xHqqkZx_
 *			_xZkqqHx_jElNjDfNiClFiCmEiCkCiCoJiImKjChFiCoCiBeBiCmHiCoKiClOiCkPiKhAjDhIiCkKjFmPiJlLiClFiCmEiCkCiCoJiCkJiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAiLnPiOjHiClHiCoJiCmMiCmJjDeLjDjGiCmIiImKjChFiCpAiKiEiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCApproximateBezier::GetFirstPolyForBezier (DBLPointVector& vPointFirst,
												doubleVector& vLineAngleFirst,
												doubleVector& vPointAngleFirst,
												DBLPointVector& vPoint,
												doubleVector& vLineAngle,
												doubleVector& vPointAngle,
												long lFailedLineSize) const
{
	// _xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeB_xHqqkZx_LineIndex=2(lIndex=2)_xZkqqHx_iCmJiCkIiCkCiCmEiCfAiJpBjGnKiBeB_xHqqkZx_
	// LineIndex=4(lIndex=4)_xZkqqHx_iCmJiCkIiCkCiCmEiCfBiJpBjGnKiCmMjAlDjFiJiLhEjDfNiCkK_xHqqkZx_
	// _xZkqqHx_iLeOiCkLiCmEiCkCiCoJiBeC_xHqqkZx_
	//
	//                   _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_    
	//  Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  
	//               _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
	//  Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_  _xZkqqHx_iCfF_xHqqkZx_  _xZkqqHx_iCfG_xHqqkZx_
	//
	//                _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_
	//                  _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_        _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_
	//                           _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   
	//                       _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
	//                         _xZkqqHx_iCgA_xHqqkZx_      _xZkqqHx_iCgB_xHqqkZx_
	//
	// _xZkqqHx_iCgAiCmMjApMjFkKjCiGiCmJiKhAjBkMjDhIiBiBiCePiCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	// LineIndex_xZkqqHx_iCePiBgAiCfBiCmMiKnEiCmMiKhAiLjHjHkDiCkKjAkHiMmAjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iCgAiCmFiDfKiDePiDiBiDjDiDgHiCpAjFkKjCgGiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iKhAiLjHjHkDiCkKjAkHiMmAjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiBeBiOjPiCmMjFkKjCgGiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
	// LineIndex_xZkqqHx_iCfBiBgAiCfDiCmMiKnEiCmMiKhAiLjHjHkDiCkKjAkHiMmAjCgMiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iCfBiBgAiCfDiCmMiKnEiCmFiDfKiDePiDiBiDjDiDgHiCpAjFkKjCgGiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iKhAiLjHjHkDiCkKjAkHiMmAjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiBeBiCgBiCmFiDfKiDePiDiBiDjDiDgHiCpAjFkKjCgGiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeBiCgPiCmFjAlDjFiJiLhEjDfNiCkKiLeOiCkLiCmEiCkCiCoJiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iOgOjDfPiCgAiCkJiCoHiCgPiCmJiOiKiCoJiCnMiCmFiCmMiKhAiLjHjHkDiCkKjBoFiCkLiClHiCkMiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iCgAiBgAiCgPiCmMjDhCjCiGiCmFjFkKjCgGiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	//                               
	//            _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_           
	//          _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_         
	//         _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iBkKiCgA_xHqqkZx_      
	//         _xZkqqHx_iEkA_xHqqkZx_                    
	//          _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBfAiBfAiBfP_xHqqkZx_   
	//            _xZkqqHx_iBfPiBfBiBfBiBfOiBkK_xHqqkZx_      _xZkqqHx_iBfP_xHqqkZx_ 
	//                    _xZkqqHx_iCgP_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_
	//                             _xZkqqHx_iEkA_xHqqkZx_
	//                  _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_ 
	//                    _xZkqqHx_iBfPiBfBiBfBiBfO_xHqqkZx_   
	//                               

	double dAngleMove[2] = { 0.0, 0.0 };
	long lIndexM[2] = { -1, -1 };
	int iSign = 0;
	int iChangeCount = 0;
	long lIndex;
// 05.04.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	for (lIndex = 0; lIndex != vLineAngle.size() - 1; lIndex++)
	for (lIndex = 0; lIndex != lFailedLineSize - 1 && lIndex != vLineAngle.size() - 1; lIndex++)
	{
		double dAngle = FFAngleMinusPitoPi(vLineAngle[lIndex + 1] - vLineAngle[lIndex]);
		ASSERT(!almost0(dAngle));
		if (almostless(dAngle, 0.0))
		//----- _xZkqqHx_iKhAjBkMjDhIiCkKjFiJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (0 < iSign)
			{
				lIndexM[iChangeCount] = lIndex;
				iChangeCount++;
			}
			iSign = -1;
		} else
		//----- _xZkqqHx_iKhAjBkMjDhIiCkKjAlDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (iSign < 0)
			{
				lIndexM[iChangeCount] = lIndex;
				iChangeCount++;
			}
			iSign = 1;
		}
		if (iChangeCount == 2) break;
		dAngleMove[iChangeCount] += dAngle;
	}

	if (iChangeCount == 1 || iChangeCount == 2)
	//----- _xZkqqHx_iKhAjBkMjDhIiCmMjAlDjFiJiLhEjDfNiCkKiCfAiJpBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (lFailedLineSize != -1)
		//----- _xZkqqHx_jBePiJpBiCmMiOlIjEhDiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// GetPolyForBezierL0Fail_xZkqqHx_iCmFiCmNiCmIiCkNiBeB_xHqqkZx_GetPolyForBezierL0_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
			// _xZkqqHx_iKhAjBkMjDhIiCmJjAlDjFiJiLhEjDfNiCkKiCkAiCoJiCoAiCmMiCpAiBeBiLhEjDfNiImKjChFiCmFjFkKjCgGiClHiCoJiClNiCnPiBeB_xHqqkZx_
			// GetPolyForBezierL0Fail_xZkqqHx_iCpAiMmEiCnEjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
			return GetPolyForBezierL0(	vPointFirst,
										vLineAngleFirst,
										vPointAngleFirst,
										vPoint,
										vLineAngle,
										vPointAngle,
										lIndexM[0],
										dAngleMove[0]);
		} else
		//----- _xZkqqHx_jBePiJpBiCmMiOlIjEhDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			return GetPolyForBezierL1(	vPointFirst,
										vLineAngleFirst,
										vPointAngleFirst,
										vPoint,
										vLineAngle,
										vPointAngle,
										lIndexM[0],
										lIndex,
										dAngleMove[0],
										dAngleMove[1]);
		}
	} else
	//----- _xZkqqHx_iKhAjBkMjDhIiCmMjAlDjFiJiLhEjDfNiCkKiCePiJpBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (lFailedLineSize != -1)
		//----- _xZkqqHx_jBePiJpBiCmMiOlIjEhDiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			return GetPolyForBezierL0Fail(	vPointFirst,
											vLineAngleFirst,
											vPointAngleFirst,
											vPoint,
											vLineAngle,
											vPointAngle,
											lIndex,
											dAngleMove[0]);
		} else
		//----- _xZkqqHx_jBePiJpBiCmMiOlIjEhDiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			return GetPolyForBezierL0(	vPointFirst,
										vLineAngleFirst,
										vPointAngleFirst,
										vPoint,
										vLineAngle,
										vPointAngle,
										lIndex,
										dAngleMove[0]);
		}
	}
} // FCApproximateBezier::GetFirstPolyForBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::Calc1WayPointBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfFiImIiPoDiCmMiBeBiKhAjBkMjDhIiCkKiIoKjDhIiCoAjElNjDfNiClFiCmEiCkCiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClHiCoJiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::Calc1WayPointBezier (	FCBezierControlsVector& vControls,
												const DBLPoint* mmptPoint,
												const double* pLineAngle,
												const double* pPointAngle,
												long lPointSize,
												double dAngleDiffLimit0,
												double dAngleDiffLimitN) const
{
	ASSERT(6 <= lPointSize);
	const long lLineSize = lPointSize - 1;
	int iSign = 0;
	long lIndex;

	// _xZkqqHx_iOgOjDfPiCkJiCoHiPeJjDfPiCnMiCmFiCmMjApMjFkKiJpBjDfNiKhA_xHqqkZx_(dAngleMove)_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	double dAngleMove = 0.0;
	for (lIndex = 0; lIndex != lLineSize - 1; lIndex++)
		dAngleMove += FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);

	//
	//             _xZkqqHx_iCgB_xHqqkZx_
	//             _xZkqqHx_iBkF_xHqqkZx_
	//          _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
	//          _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfPiBkDiOgOjDfP_xHqqkZx_
	//       _xZkqqHx_iCfCiEkA_xHqqkZx_               
	//         _xZkqqHx_iEkA_xHqqkZx_               
	//          _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBkFiPeJjDfP_xHqqkZx_
	//          _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
	//             _xZkqqHx_iBkD_xHqqkZx_
	//             _xZkqqHx_iCgC_xHqqkZx_
	//
	// _xZkqqHx_iKhAjBkMjDhIiCkKiIoKjDhIiCoAjElNjDfNiClFiCmEiCkCiCmIiDhMiDiKiDiJiDeDiDjDiCmJiCkIiCkCiCmEiBeB_xHqqkZx_
	// _xZkqqHx_jAkHiMoEjDfPiCgBiCpAiMhGiOfKiClHiCoJiClNiCnPiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmG_xHqqkZx_
	// _xZkqqHx_jAkHiMoEjDfPiCgCiCpAiMhGiOfKiClHiCoJiClNiCnPiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCpA_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiClHiCoJiBeC_xHqqkZx_
	//

	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmNiBeBiNmFiPiJiCkJiCoHiKhAjDhIiCkKiCfAiBfOiCfDiCmMjCgOjDfPiBeB_xHqqkZx_
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmNiBeBiNmFiPiJiCkJiCoHiKhAjDhIiCkKiCfCiBfOiCfDiCmMjCgOjDfPiCpAjBeJjBpAiBeC_xHqqkZx_
	const double dRMeanB = (1.0 / 4.0) * dAngleMove;
	const double dRMeanC = (3.0 / 4.0) * dAngleMove;
	double dAngleDiffMinB = DBL_MAX;
	double dAngleDiffMinC = DBL_MAX;
	long lIndexB = -1;
	long lIndexC = -1;
	dAngleMove = 0.0;
	for (lIndex = 0; lIndex != lLineSize - 1; lIndex++)
	{
		// _xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dAngle = FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);
		// _xZkqqHx_iDhMiDeDiDjDiDgHiCmMiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dPointAngle = dAngleMove + dAngle / 2.0;
		dAngleMove += dAngle;
		if (fabs(dRMeanB - dPointAngle) < dAngleDiffMinB)
		//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmMiOhHjCoIiKhAjDhIiCmGiCmMiNlHjFkKiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dAngleDiffMinB = fabs(dRMeanB - dPointAngle);
			lIndexB = lIndex + 1;
		}
		//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmMiOhHjCoIiKhAjDhIiCmGiCmMiNlHjFkKiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		if (fabs(dRMeanC - dPointAngle) < dAngleDiffMinC)
		{
			dAngleDiffMinC = fabs(dRMeanC - dPointAngle);
			lIndexC = lIndex + 1;
		}
	}
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmNiBeB_xHqqkZx_DoCalcControlsB_xZkqqHx_iCmMiPoKiNiHiDeDiDjDiDgGiDgCiDeOiDfIiCkKiCfBiImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (lIndexB == 1) lIndexB = 2;
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmNiBeB_xHqqkZx_DoCalcControlsB_xZkqqHx_iCmMiPoKiNiHiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_LAST-_xZkqqHx_iCfBiImIiJlKiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (lIndexC == lPointSize - 2) lIndexC = lPointSize - 3;
	if (lIndexB == lIndexC)
	//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiBeBiCgCiCkKjDkPiClGiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iIoKiCmCiKnEiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
		if (lIndexB == 2)
			lIndexC = lIndexB + 1;
		if (lIndexC == lPointSize - 3)
			lIndexB = lIndexC - 1;
	}
	const DBLPoint mmptA = mmptPoint[0];
	const DBLPoint mmptD = mmptPoint[lPointSize - 1];
	DBLPoint mmptB = mmptA;
	DBLPoint mmptC = mmptD;
//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	DBLRect mmrtFrame;
//	FFCalcFrame(mmrtFrame, lPointSize, mmptPoint);
//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jAkHiMoEjDfPiCmMiKfEiOfKiCpAiMhGiOfKiBeCiOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
	if (!DoCalcControlsA(mmptA, mmptB, mmptC, mmptD,
						mmptPoint, pLineAngle, pPointAngle, lPointSize,
						lIndexB, lIndexC,
						dAngleDiffLimit0,
						dAngleDiffLimitN)) return FALSE;
	if (!almost0(m_dAngleDiffLimit))
	//------ _xZkqqHx_iKhAjDhIiKoOiPiAiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiPnKiClFiCkNiMhGiOfKiBeCiOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
		if (!DoCalcControlsB(mmptA, mmptB, mmptC, mmptD,
							mmptPoint, pLineAngle, lPointSize,
							lIndexB, lIndexC,
							dAngleDiffLimit0,
							dAngleDiffLimitN)) return FALSE;
	}
	if (ComparePolyBezier(mmptPoint, lPointSize, mmptA, mmptB, mmptC, mmptD))
	//----- _xZkqqHx_iOfKiPgPiClFiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCkKiCnJiCnKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(mmptA, mmptB, mmptC, mmptD));
		return TRUE;
	}
	return FALSE;
} // FCApproximateBezier::Calc1WayPointBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::Calc2WayPointBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfFiImIiPoDiCmMiBeBiKhAjBkMjDhIiCkKiIoKiJpBjElNjDfNiClFiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClHiCoJiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::Calc2WayPointBezier (	FCBezierControlsVector& vControls,
												const DBLPoint* mmptPoint,
												const double* pLineAngle,
												const double* pPointAngle,
												long lPointSize,
												double dAngleDiffLimit0,
												double dAngleDiffLimitN) const
{
	const long lLineSize = lPointSize - 1;

	// _xZkqqHx_iKhAjBkMjDhIjElNjDfNiCmMiImKjChFiCgMiCmGiBeBiCgMiCpAiLkLiCmJiClFiClNjBePjElMiCmMjApMjFkKiJpBjDfNiKhA_xHqqkZx_(dAngleMove1)_xZkqqHx_iCmG_xHqqkZx_
	// _xZkqqHx_iMoDjElMiCmMjApMjFkKiJpBjDfNiKhA_xHqqkZx_(dAngleMove2)_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	int iSign = 0;
	long lIndex;
	double dAngleMove1 = 0.0;
	double dAngleMove2 = 0.0;
	for (lIndex = 0; lIndex != lLineSize - 1; lIndex++)
	{
		double dAngle = FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);
		if (almostlesseq(dAngle, 0.0))
		//----- _xZkqqHx_iKhAjBkMjDhIiCkKiCePiCnMiClNiCmNjFiJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (0 < iSign) break;
			iSign = -1;
		} else
		//----- _xZkqqHx_iKhAjBkMjDhIiCkKjAlDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (iSign < 0) break;
			iSign = 1;
		}
		dAngleMove1 += dAngle;
	}
	const long lIndexM = lIndex;
	ASSERT(lIndex != lLineSize - 1);
	for (; lIndex != lLineSize - 1; lIndex++)
	{
		double dAngle = FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);
		dAngleMove2 += dAngle;
	}

	// _xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeB_xHqqkZx_lIndexM _xZkqqHx_iBiBiCfBiCmJiCkIiCkCiCmEjAlDjFiJiLhEjDfNiCkK_xHqqkZx_
	// _xZkqqHx_iLeOiCkLiCmEiCkCiCoJiBeC_xHqqkZx_
	//
	//                   _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhM_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_  _xZkqqHx_iBhL_xHqqkZx_
	//  Line Index     _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_
	//               _xZkqqHx_iEkFiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkJiEjPiEkH_xHqqkZx_
	//  Point Index  _xZkqqHx_iCeP_xHqqkZx_  _xZkqqHx_iCfA_xHqqkZx_  _xZkqqHx_iCfB_xHqqkZx_  _xZkqqHx_iCfC_xHqqkZx_  _xZkqqHx_iCfD_xHqqkZx_  _xZkqqHx_iCfE_xHqqkZx_
	//                            _xZkqqHx_iBfBiBfB_xHqqkZx_ 
	//                _xZkqqHx_iBfP_xHqqkZx_  _xZkqqHx_iCgB_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_  _xZkqqHx_iBkKiBfP_xHqqkZx_  
	//                  _xZkqqHx_iBfPiBkL_xHqqkZx_  _xZkqqHx_iBfOiBkK_xHqqkZx_  _xZkqqHx_iCgC_xHqqkZx_  _xZkqqHx_iBfP_xHqqkZx_
	//                    _xZkqqHx_iBfAiBfA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
	//                          _xZkqqHx_iCgM_xHqqkZx_
	//
	// _xZkqqHx_jApMjFkKiCgMiCmMjCiGiCmJiKhAjBkMjDhIiBiBiCePiCmMiDhMiDeDiDjDiDgHiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jAkHiMoEjDfPiCgBiCpAiMhGiOfKiClHiCoJiClNiCnPiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmG_xHqqkZx_
	// _xZkqqHx_jAkHiMoEjDfPiCgCiCpAiMhGiOfKiClHiCoJiClNiCnPiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCpA_xHqqkZx_
	// _xZkqqHx_jBeJjBpAiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmNiBeBiNmFiPiJiCkJiCoHiKhAjDhIiCkKiCfAiBfOiCfCiCmMjCgOjDfPiBeB_xHqqkZx_
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmNiBeBiNmFiPiJiCkJiCoHiKhAjDhIiCkKiCfBiBfOiCfCiCmMjCgOjDfPiCpAjBeJjBpAiBeC_xHqqkZx_
	const double dRMeanB = (1.0 / 3.0) * dAngleMove1;
	const double dRMeanC = (2.0 / 3.0) * dAngleMove2;

	double dAngleDiffMin = DBL_MAX;
	long lIndexB = -1;
	dAngleMove1 = 0.0;
	for (lIndex = 0; lIndex != lIndexM; lIndex++)
	{
		// _xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dAngle = FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);
		// _xZkqqHx_iDhMiDeDiDjDiDgHiCmMiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dPointAngle = dAngleMove1 + dAngle / 2.0;
		dAngleMove1 += dAngle;
		if (fabs(dRMeanB - dPointAngle) < dAngleDiffMin)
		//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmMiOhHjCoIiKhAjDhIiCmGiCmMiNlHjFkKiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dAngleDiffMin = fabs(dRMeanB - dPointAngle);
			lIndexB = lIndex + 1;
		}
	}
	dAngleDiffMin = DBL_MAX;
	long lIndexC = -1;
	dAngleMove2 = 0.0;
	for (; lIndex != lLineSize - 1; lIndex++)
	{
		// _xZkqqHx_jApMjFkKiCmMiKhAjBkMjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dAngle = FFAngleMinusPitoPi(pLineAngle[lIndex + 1] - pLineAngle[lIndex]);
		// _xZkqqHx_iDhMiDeDiDjDiDgHiCmMiKhAjDhIiCpAiOfKiPgPiBeC_xHqqkZx_
		double dPointAngle = dAngleMove2 + dAngle / 2.0;
		dAngleMove2 += dAngle;
		if (fabs(dRMeanC - dPointAngle) < dAngleDiffMin)
		//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmMiOhHjCoIiKhAjDhIiCmGiCmMiNlHjFkKiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			dAngleDiffMin = fabs(dRMeanC - dPointAngle);
			lIndexC = lIndex + 1;
		}
	}
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmNiBeB_xHqqkZx_DoCalcControlsB_xZkqqHx_iCmMiPoKiNiHiDeDiDjDiDgGiDgCiDeOiDfIiCkKiCfBiImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (lIndexB == 1) lIndexB = 2;
	// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmNiBeB_xHqqkZx_DoCalcControlsB_xZkqqHx_iCmMiPoKiNiHiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_LAST-_xZkqqHx_iCfBiImIiJlKiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (lIndexC == lPointSize - 2) lIndexC = lPointSize - 3;
	if (lIndexB == lIndexC)
	//----- _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiBeBiCgCiCkKjDkPiClGiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iIoKiCmCiKnEiCpAiLpDiCkPiCoJiBeC_xHqqkZx_
		if (lIndexB == 2)
			lIndexC = lIndexB + 1;
		if (lIndexC == lPointSize - 3)
			lIndexB = lIndexC - 1;
	}

	const DBLPoint mmptA = mmptPoint[0];
	const DBLPoint mmptD = mmptPoint[lPointSize - 1];
	DBLPoint mmptB = mmptA;
	DBLPoint mmptC = mmptD;

//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	DBLRect mmrtFrame;
//	FFCalcFrame(mmrtFrame, lPointSize, mmptPoint);
//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jAkHiMoEjDfPiCmMiKfEiOfKiCpAiMhGiOfKiBeCiOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
	if (!DoCalcControlsA(mmptA, mmptB, mmptC, mmptD,
						mmptPoint, pLineAngle, pPointAngle, lPointSize,
						lIndexB, lIndexC,
						dAngleDiffLimit0,
						dAngleDiffLimitN)) return FALSE;
	if (!almost0(m_dAngleDiffLimit))
	//------ _xZkqqHx_iKhAjDhIiKoOiPiAiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiPnKiClFiCkNiMhGiOfKiBeCiOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
		if (!DoCalcControlsB(mmptA, mmptB, mmptC, mmptD,
							mmptPoint, pLineAngle, lPointSize,
							lIndexB, lIndexC,
							dAngleDiffLimit0,
							dAngleDiffLimitN)) return FALSE;
	}
	if (ComparePolyBezier(mmptPoint, lPointSize, mmptA, mmptB, mmptC, mmptD))
	//----- _xZkqqHx_iOfKiPgPiClFiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCkKiCnJiCnKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(mmptA, mmptB, mmptC, mmptD));
		return TRUE;
	}
	return FALSE;
} // FCApproximateBezier::Calc2WayPointBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::Calc5PointBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfDiCkJiCfEiCmMiPoKiNiHiCmMiPiIjHjNjFpLjGeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::Calc5PointBezier (FCBezierControlsVector& vControls,
											const DBLPoint* mmptPoint,
											const double* pLineAngle,
											const double* pPointAngle,
											long lPointSize,
											double dAngleDiffLimit0,
											double dAngleDiffLimitN) const
{
	const long lLineSize = lPointSize - 1;
	ASSERT(lPointSize == 4 || lPointSize == 5);
	const DBLPoint mmptA = mmptPoint[0];
	const DBLPoint mmptD = mmptPoint[lPointSize - 1];
	DBLPoint mmptB = mmptA;
	DBLPoint mmptC = mmptD;

//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
//	DBLRect mmrtFrame;
//	FFCalcFrame(mmrtFrame, lPointSize, mmptPoint);
//----- 05.04.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jAkHiMoEjDfPiCmMiKfEiOfKiCpAiMhGiOfKiBeCiOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
	if (!DoCalcControlsA(mmptA, mmptB, mmptC, mmptD,
						mmptPoint, pLineAngle, pPointAngle, lPointSize,
						1, lPointSize - 2,
						dAngleDiffLimit0,
						dAngleDiffLimitN)) return FALSE;
	// DoCalcControlsA _xZkqqHx_iCmNiDhMiDeDiDjDiDgHjAjEiCkKiPkNiCmIiClHiCkMiCmEiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
	if (ComparePolyBezier(mmptPoint, lPointSize, mmptA, mmptB, mmptC, mmptD))
	//----- _xZkqqHx_iOfKiPgPiClFiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCkKiCnJiCnKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(mmptA, mmptB, mmptC, mmptD));
		return TRUE;
	}
	return FALSE;
} // FCApproximateBezier::Calc5PointBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::Calc3PointBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfCiCmMiPoKiNiHiCmMiPiIjHjNjFpLjGeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiCfCjDfPiClFiCkJiCmIiCkCiDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *                   P1
 *                  _xZkqqHx_iBfOiBfP_xHqqkZx_
 *                _xZkqqHx_iBfO_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_
 *              _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *             P0           _xZkqqHx_iBfP_xHqqkZx_
 *                            P2
 *
 *			P0_xZkqqHx_iCmG_xHqqkZx_P2_xZkqqHx_iCmMiKhAjDhIiBeBjBkGiClPiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCgAiCgBiCmGiCgDiCgCiCmMjClHiClDiCpAjDjJiClFiCkNiClFiCmEiBeB_xHqqkZx_P1_xZkqqHx_iCpAjCmKiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmGiClHiCoJiCmG_xHqqkZx_
 *			P = A * k^3 + 3 * B * k^2 * t + 3 * C * k * t^2 + D * t^3
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*u(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*u
 *			P = A*k^3 + 3*k^2*t*(A + L*u) + 3*k*t^2*(D + M*u) + D*t^3
 *			u_xZkqqHx_iCpAiJpAiCkCiCmE_xHqqkZx_
 *			u = -(P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3)/(-3*L*k^2*t - 3*M*k*t^2) _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *			x,y_xZkqqHx_iCkJiCoHiJgFiLlPiCpAiOpDiCkPiCmIiCkCjFmPjAjEiCpAiNlGjFnDiCmJiPfHiCnPiCoJiBeC_xHqqkZx_
 *			3*k*t*u = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3)/(L*k + M*t)
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ x,y_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiBeC_xHqqkZx_
 *			3*k*t*u = (Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3)/(Lx*k + Mx*t) _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			3*k*t*u = (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3)/(Ly*k + My*t) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			_xZkqqHx_iHeAiBeBiHeBiCkJiCoH_xHqqkZx_
 *			(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3)/(Lx*k + Mx*t) -  (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3)/(Ly*k + My*t) = 0
 *			(Ly*k + My*t)(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3) -  (Lx*k + Mx*t)(Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3) = 0
 *			t_xZkqqHx_iCmJiKnGiClFiCmEiCnMiCmGiCnPiCmEiBeC_xHqqkZx_
 *			(Ay*Lx - Ax*Ly + Ly*Px - Lx*Py) +
 *			  (-Ay*Lx + Ax*Ly + Ay*Mx - Ax*My - Ly*Px + My*Px + Lx*Py - Mx*Py)*t +
 *			    (-3*Ay*Lx + 3*Dy*Lx + 3*Ax*Ly - 3*Dx*Ly)*t^2 +
 *			      (5*Ay*Lx - 5*Dy*Lx - 5*Ax*Ly + 5*Dx*Ly - 3*Ay*Mx + 3*Dy*Mx + 3*Ax*My - 3*Dx*My)*t^3 +
 *			        (-2*Ay*Lx + 2*Dy*Lx + 2*Ax*Ly - 2*Dx*Ly + 2*Ay*Mx - 2*Dy*Mx - 2*Ax*My + 2*Dx*My)*t^4 = 0
 *			_xZkqqHx_iClBiCmMiCfDiOjPiOkOiCpAiJpAiCkCiCmE_xHqqkZx_t_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeCiCmG_xHqqkZx_t_xZkqqHx_iCmMjCgMiCkJiCoH_xHqqkZx_u_xZkqqHx_iCpAiLiBiCnPiBeB_xHqqkZx_B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::Calc3PointBezier (FCBezierControlsVector& vControls,
											const DBLPoint* mmptPoint,
											const double* pLineAngle,
											const double* pPointAngle,
											long lPointSize,
											double dAngleDiffLimit0,
											double dAngleDiffLimitN) const
{
	// _xZkqqHx_iCfCjDfPiClFiCkJiCmIiCkCiPoKiNiHiCmMiPiIjHjNiBeC_xHqqkZx_
	// _xZkqqHx_iCgAiCmGiCgDiCmMiKhAjDhIiCmNiMiIiCnMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_

	ASSERT(lPointSize == 3);
	const DBLPoint mmptA = mmptPoint[0];
	const DBLPoint mmptD = mmptPoint[lPointSize - 1];
	DBLPoint mmptB = mmptA;
	DBLPoint mmptC = mmptD;
	// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
	const double dPointAngle0 = pPointAngle[0];
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!vControls.empty())
//	{
//		DBLPoint mmptL = vControls.back().m_mmptControl[3] - vControls.back().m_mmptControl[2];
//		dPointAngle0 = atan2(mmptL.y, mmptL.x);
//	}
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
	const double dPointAngleN = pPointAngle[lPointSize - 1];
	// _xZkqqHx_iOgOjDfPiCmGiBeBiOjPiCmMjApMjFkKiCmMiKhAjDhIiNlHiBeC_xHqqkZx_
	const double dAngleDiff0 = dPointAngle0 - pLineAngle[0];
	// _xZkqqHx_iPeJjDfPiCmGiBeBjBePiCmMjApMjFkKiCmMiKhAjDhIiNlHiBeC_xHqqkZx_
	const double dAngleDiffN = dPointAngleN - pLineAngle[lPointSize - 2];
	long lC;
	for (lC = 0; lC != 20; lC++)
	{
		// _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCmMiKhAjDhIiCpAiPkNiClFiClIiCmCiClIiCoHiClFiCmEiBeBjAkMiMpHiClHiCoJiCnMiCmFiJlNjDhIiCoAiOiOiClFiCmEiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iOgOjDfPiBeBiPeJjDfPiCmMiKhAjDhIiCmMiDfJiDiMiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
		if (dAngleDiffLimit0 < fabs(FFAngleMinusPitoPi(double(lC) * dAngleDiff0 / 2.0))) return FALSE;
		if (dAngleDiffLimitN < fabs(FFAngleMinusPitoPi(double(lC) * dAngleDiffN / 2.0))) return FALSE;
		// _xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiOfKiPgPiClHiCoJiBeCjAkMiMpHiClFiClNiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (CalcBCFromADLMP1(mmptB, mmptC, mmptA, mmptD,
							dPointAngle0 + double(lC) * dAngleDiff0 / 2.0,
							dPointAngleN + double(lC) * dAngleDiffN / 2.0,
							mmptPoint[1])) break;
	}
	// _xZkqqHx_iOfKiPgPiCmJiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
	if (lC == 20) return FALSE;
	if (ComparePolyBezier(mmptPoint, lPointSize, mmptA, mmptB, mmptC, mmptD))
	//----- _xZkqqHx_iOfKiPgPiClFiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCkKiCnJiCnKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAkHiMoEjDfPiCpAiLeMjIfOiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(mmptA, mmptB, mmptC, mmptD));
		return TRUE;
	}
	return FALSE;
} // FCApproximateBezier::Calc3PointBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::Calc2PointBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjAjEiCkKiCfBiCmMiPoKiNiHiCmMiPiIjHjNjFpLjGeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vControls	:_xZkqqHx_iLnPiOjHiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiCfBjDfPiClFiCkJiCmIiCkCiDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *             P0             P1
 *              _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_
 *
 *			_xZkqqHx_iClBiCmMiPoKiNiHiBeB_xHqqkZx_P0_xZkqqHx_iCmG_xHqqkZx_P1_xZkqqHx_iCmMiKhAjDhIiBeBjBkGiClPiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iLnPiOjHiCmGiCkCiCkEiCnJiCmHiCmMiCoAiCmMiCmNiCmIiCkNiBeB_xHqqkZx_|_xZkqqHx_iCgAiCgB_xHqqkZx_|_xZkqqHx_iCmG_xHqqkZx_|_xZkqqHx_iCgDiCgC_xHqqkZx_|_xZkqqHx_iCpAiBeB_xHqqkZx_
 *			|P0 P1|_xZkqqHx_iCmMiCfAiBfOiCfBiCmGiClFiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCApproximateBezier::Calc2PointBezier (FCBezierControlsVector& vControls,
											const DBLPoint* mmptPoint,
											const double* pLineAngle,
											const double* pPointAngle,
											long lPointSize) const
{
	ASSERT(lPointSize == 2);

	const DBLPoint mmptA = mmptPoint[0];
	const DBLPoint mmptD = mmptPoint[lPointSize - 1];
	double dPointAngle0 = pPointAngle[0];
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!vControls.empty())
//	{
//		DBLPoint mmptL = vControls.back().m_mmptControl[3] - vControls.back().m_mmptControl[2];
//		dPointAngle0 = atan2(mmptL.y, mmptL.x);
//	}
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	double dPointAngleN = pPointAngle[lPointSize - 1];
	// _xZkqqHx_iNmFiMoDiCmMjDfPiCmMiKhAjDhIiCmNiLhEiMpMiCkLiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	dPointAngleN = FFAngleMinusPitoPi(dPointAngleN + M_PI);
	// AB_xZkqqHx_iBeB_xHqqkZx_DC_xZkqqHx_iCmMiMfIiOmOiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPoint mmptL(cos(dPointAngle0), sin(dPointAngle0));
	DBLPoint mmptM(cos(dPointAngleN), sin(dPointAngleN));
	// A_xZkqqHx_iCmG_xHqqkZx_D_xZkqqHx_iKnEiCmMiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
	mmetol mmLen = (mmptA -  mmptD).Len();
	// AD_xZkqqHx_iKnEiLjHjHkDiCmM_xHqqkZx_1/2_xZkqqHx_iCmMjClHiClDiCmF_xHqqkZx_B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	DBLPoint mmptB = mmptA + mmptL * mmLen / 2.0;
	DBLPoint mmptC = mmptD + mmptM * mmLen / 2.0;
	vControls.push_back(FCBezierControls(mmptA, mmptB, mmptC, mmptD));
} // FCApproximateBezier::Calc2PointBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::DoCalcControlsA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmMiPoKiNiHiCmJiBeBjDpBiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pPointAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhMiDeDiDjDiDgHiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtFrame	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexB		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexC		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  Pb
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *               _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *               _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                  _xZkqqHx_iBkD_xHqqkZx_
 *                  Pc
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmGiClFiCmEjAkHjGpBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEiDhMiDiKiDiJiDeDiDjDiPoDiCmMjDpBiCmCiCmMjDfP_xHqqkZx_(Pb_xZkqqHx_iBeB_xHqqkZx_Pc)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmI_xHqqkZx_
 *				_xZkqqHx_iCgAiCgBiCmMjClHiClDiCmGiCgDiCgCiCmMjClHiClDiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiOgOjDfP_xHqqkZx_P0_xZkqqHx_iCmGiPeJjDfP_xHqqkZx_Pn_xZkqqHx_iCmMiKhAjDhIiBeBjBkGiClPiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCmNiKpJjCgNiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*v(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*v
 *			_xZkqqHx_iClBiCoKiCpAiHeAiCmJjBoDjDpMiClFiCmEjDfHiKeKiBeBiNfIiCmJ_xHqqkZx_xy_xZkqqHx_jFpLiMpMiCmJjFkKiJpAiClFiCmEiJpAiCkCiCmEiCkCiCkNiCmG_xHqqkZx_
 *			t^3*(-2*Ax/Lx + 2*Dx/Lx + 2*Ay/Ly - 2*Dy/Ly + 3/Lx*Mx*v - 3/Ly*My*v) +
 *			  t^2*(3*Ax/Lx - 3*Dx/Lx - 3*Ay/Ly + 3*Dy/Ly - 3/Lx*Mx*v + 3/Ly*My*v) +
 *			    (-Ax/Lx + Ay/Ly + 1/Lx*Px - 1/Ly*Py) = 0 _xZkqqHx_iBeFiBeFiBeFiHeE_xHqqkZx_
 *			v_xZkqqHx_iCmMjCgMiCpAjDeLjDjGiCmJiMiIiCnPiCmEiBeBiHeEiCpA_xHqqkZx_t_xZkqqHx_iCmJiKnGiClFiCmEiJpAiCkNiBeCiClLiCmM_xHqqkZx_t_xZkqqHx_iCmMjCgMiCpAiHeBiCmJjBoDjDpMiClFiCmE_xHqqkZx_ u _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			v_xZkqqHx_iCmMjCgMiCpAiInKjDkOiClDiClJiCmEiBeBiClLiCmMjDhDjDhI_xHqqkZx_ u _xZkqqHx_iCpAiMhGiOfKiClHiCoJiClBiCmGiCmFiBeBjAiFjFlN_xHqqkZx_u_xZkqqHx_iOlCiBeBjAiCjClM_xHqqkZx_v_xZkqqHx_iOlCiCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiJiDhEiCpAiNoMjAkMiPgPjHiIiCoJiBeC_xHqqkZx_
 *			Pb_xZkqqHx_iBeB_xHqqkZx_Pc_xZkqqHx_iCmJiKnGiClFiCmEiBeB_xHqqkZx_u_xZkqqHx_iOlCiCmG_xHqqkZx_v_xZkqqHx_iOlCiCmMiDePiDiJiDhEiCpAiNoMjAkMiClFiBeBiMpAiNlHiClHiCoJjDfP_xHqqkZx_T_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_T_xZkqqHx_iCmM_xHqqkZx_u_xZkqqHx_iBeF_xHqqkZx_v_xZkqqHx_iCkKiBeB_xHqqkZx_Pb_xZkqqHx_iBeF_xHqqkZx_Pc_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiDhIiDfHiDeGiLmIjApMiCpAjGjOiClNiClH_xHqqkZx_B_xZkqqHx_iBeF_xHqqkZx_C_xZkqqHx_iCmMiMfHjAjEiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPnKiNnHiCmN_xHqqkZx_FFCalcBCFromADLMP2_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::DoCalcControlsA (	const DBLPoint& mmptA,
											DBLPoint& mmptB,
											DBLPoint& mmptC,
											const DBLPoint& mmptD,
											const DBLPoint* mmptPoint,
											const double* pLineAngle,
											const double* pPointAngle,
											long lPointSize,
											long lIndexB,
											long lIndexC,
											double dAngleDiffLimit0,
											double dAngleDiffLimitN) const
{
	// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
	const double dPointAngle0 = pPointAngle[0];
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!vControls.empty())
//	{
//		DBLPoint mmptL = vControls.back().m_mmptControl[3] - vControls.back().m_mmptControl[2];
//		dPointAngle0 = atan2(mmptL.y, mmptL.x);
//	}
//----- 05.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
	const double dPointAngleN = pPointAngle[lPointSize - 1];
	// _xZkqqHx_iOgOjDfPiCmGiBeBiOjPiCmMjApMjFkKiCmMiKhAjDhIiNlHiBeC_xHqqkZx_
	const double dAngleDiff0 = dPointAngle0 - pLineAngle[0];
	// _xZkqqHx_iPeJjDfPiCmGiBeBjBePiCmMjApMjFkKiCmMiKhAjDhIiNlHiBeC_xHqqkZx_
	const double dAngleDiffN = dPointAngleN - pLineAngle[lPointSize - 2];
	long lC;
// 05.04.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	for (lC = 0; lC != 20; lC++)
	for (lC = 0; lC != 5; lC++)
	{
		// _xZkqqHx_iOgOjDfPiCmGiPeJjDfPiCmMiKhAjDhIiCpAiPkNiClFiClIiCmCiClIiCoHiClFiCmEiBeBjAkMiMpHiClHiCoJiCnMiCmFiJlNjDhIiCoAiOiOiClFiCmEiCnNiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iOgOjDfPiBeBiPeJjDfPiCmMiKhAjDhIiCmMiDfJiDiMiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmNiDeHiDiJiBfLiCmGiClFiCmEjFjMiLeBiBeC_xHqqkZx_
		if (dAngleDiffLimit0 < fabs(FFAngleMinusPitoPi(double(lC) * dAngleDiff0 / 2.0))) break;
		if (dAngleDiffLimitN < fabs(FFAngleMinusPitoPi(double(lC) * dAngleDiffN / 2.0))) break;
		// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
		const double dR0 = dPointAngle0 + double(lC) * dAngleDiff0 / 2.0;
		// _xZkqqHx_iPeJjDfPiCmMiKhAjDhIiBeC_xHqqkZx_
		const double dRN = dPointAngleN + double(lC) * dAngleDiffN / 2.0;
		// _xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiOfKiPgPiClHiCoJiBeCjAkMiMpHiClFiClNiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
		if (FFCalcBCFromADLMP2(	mmptB, mmptC, mmptA, mmptD,
								DBLPoint(cos(dR0), sin(dR0)),
								-DBLPoint(cos(dRN), sin(dRN)),
								mmptPoint[lIndexB],
								mmptPoint[lIndexC],
								pPointAngle[lIndexB],
								pPointAngle[lIndexC],
								m_dPlayOfAngle * M_PI)) return TRUE;
		TRACE(_T("DoCalcControlsA FAIL %d\n"), lC);
	}
	return FALSE;
//----- 05.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiOfKiPgPiClHiCoJiBeCjAkMiMpHiClFiClNiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (FFCalcBCFromADLMP2(	mmptB, mmptC, mmptA, mmptD,
//							DBLPoint(cos(dPointAngle0), sin(dPointAngle0)),
//							-DBLPoint(cos(dPointAngleN), sin(dPointAngleN)),
//							mmptPoint[lIndexB],
//							mmptPoint[lIndexC],
//							pPointAngle[lIndexB],
//							pPointAngle[lIndexC],
//							m_dPlayOfAngle * M_PI)) return TRUE;
//	return FALSE;
//----- 05.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCApproximateBezier::DoCalcControlsA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::DoCalcControlsB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfDiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgBiBeBiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAiOhHjCoIiBeCjDeLjAnIiCmIjCgMiCmJjFoCjAlDiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAiOhHjCoIiBeCjDeLjAnIiCmIjCgMiCmJjFoCjAlDiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pLineAngle	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiNfMjAkMjApMjFkKiCmMiKhAjDhIjCgMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexB		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexC		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLnPiOjHiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  Pb1
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *          Pb2_xZkqqHx_iBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *          Pc2_xZkqqHx_iBkDiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                  _xZkqqHx_iBkD_xHqqkZx_
 *                  Pc1
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiLnPiOjHjCgMiCmJiLnPiCkCjAkHiMoEjDfPiCgBiBeBiCgCiCpAiPiJiKpKjCgMiCmGiClFiCmEjHfOiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjHfOiCkGiCoHiCoKiClNjAkHiMoEjDfPiCgAiBeBiCgCiBeBiCgDiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiPoDiCmMjHnHiCoIiNiHiCkE_xHqqkZx_
 *				_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(Pb1_xZkqqHx_iBeB_xHqqkZx_Pb2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgBiCmMiImKjChFiCpA_xHqqkZx_
 *				_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEjHfOiCkGiCoHiCoKiClNjAkHiMoEjDfPiCgAiBeBiCgBiBeBiCgDiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiPoDiCmMjHnHiCoIiNiHiCkE_xHqqkZx_
 *				_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(Pc1_xZkqqHx_iBeB_xHqqkZx_Pc2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgCiCmMiImKjChFiCpA_xHqqkZx_
 *				_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfDiBeEiCfBiBgAiCfCiCpAiMeKiCoIjFnEiClFiCmEiCfDiCmCiCmMjDfP_xHqqkZx_(Pb1,Pb2,Pc1,Pc2)_xZkqqHx_iCpAjCmKiCoJiCoGiCkEiCmI_xHqqkZx_
 *				_xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::DoCalcControlsB (	const DBLPoint& mmptA,
											DBLPoint& mmptB,
											DBLPoint& mmptC,
											const DBLPoint& mmptD,
											const DBLPoint* mmptPoint,
											const double* pLineAngle,
											long lPointSize,
											long lIndexB,
											long lIndexC,
											double dAngleDiffLimit0,
											double dAngleDiffLimitN) const
{
	TRACE(_T("DoCalcControlsB\n"));
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLRect rect;
	FFCalcFrame(rect, lPointSize, mmptPoint);
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMjBmOiKhAjApMiCmMjClHiClDiCkJiCoHiBeBiMhGiOfKiPeJjHlJiCmMiKoOiPiAjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const double dStdLen = POW2(0.05 * sqrt(rect.Width() * rect.Width() + rect.Height() * rect.Height()));

	long lCount;
	for (lCount = 10; lCount != 0; lCount--)
	//----- 10_xZkqqHx_iJpBiDiLiBfLiDhG_xHqqkZx_ -----
	{
//----- 05.03.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		if (0)
//		{
//			CFrameWnd* pWnd = (CFrameWnd*)AfxGetMainWnd();
//			CView* pView = pWnd->GetActiveView();
//			CClientDC dc(pView);
//			CRect rtClient;
//			pView->GetClientRect(rtClient);
//			dc.BeginPath();
//			dc.FillRect(rtClient, &CBrush(FD_COLREF_WHITE));
//			dc.EndPath();
//
//			dc.BeginPath();
//			CPen penXXX(PS_SOLID, 1, FD_COLREF_BLACK);
//			CPen* penOld = dc.SelectObject(&penXXX);
//			long lC;
//			for (lC = 0; lC != lPointSize; lC++)
//			{
//				if (lC == 0)
//					dc.MoveTo(D2L(mmptPoint[lC].x), D2L(mmptPoint[lC].y));
//				else
//					dc.LineTo(D2L(mmptPoint[lC].x), D2L(mmptPoint[lC].y));
//			}
//			dc.EndPath();
//			dc.StrokePath();
//			dc.SelectObject(penOld);
//		}
//----- 05.03.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jAfGiClFiCkNiOfKiPgPiClDiCoKiCoJiCgBiCmGiCgCiCmMjCgMiBeC_xHqqkZx_
		DBLPoint mmptNewB;
		DBLPoint mmptNewC;
		// _xZkqqHx_jBePiJpBiCmMiCgBiCmGiCgCiCmMjCgMiBeC_xHqqkZx_
		DBLPoint mmptPrevB = mmptB;
		DBLPoint mmptPrevC = mmptC;
		for (;;)
		{
			// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgBiCkJiCoHiMhGiOfKiCpAiOgOiCnPiCmEiBeBiJpAiCkKiLiBiCnMiCoHiCmIiCkC_xHqqkZx_
			// _xZkqqHx_iPoKiNiHiCmNiBeBiOgOjDfPiCmJiMpMiCkJiCmBiCmEiIoKiCmCiClIiCmCiInKjDkOiClHiCoJiBeC_xHqqkZx_
			double dScoreB = DBL_MAX;
			for (long lC = lIndexB; lC != 1; lC--)
			{
				// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkK_xHqqkZx_mmptPoint[lC - 1]_xZkqqHx_iBeB_xHqqkZx_mmptPoint[lC]_xZkqqHx_iCmM_xHqqkZx_
				// _xZkqqHx_jHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgBiCpAiOfKiPgPiBeC_xHqqkZx_
				DBLPoint mmptTmpB;
				dScoreB = CalcBFromACDP2(mmptTmpB, mmptA, mmptC, mmptD, mmptPoint[lC - 1], mmptPoint[lC], pLineAngle[0]);
				if (dScoreB < dAngleDiffLimit0)
				//----- _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClHiPoKiNiH_xHqqkZx_(_xZkqqHx_jCoBiCkCjFpLiCkKjHmHiCkC_xHqqkZx_) -----
				{
					// _xZkqqHx_jAfGiClFiCkCiCgBiCmGiClFiCmEiLeMjIfOiBeCiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
					mmptNewB = mmptTmpB;
					break;
				}
			}
			// _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClHiPoKiNiH_xHqqkZx_(_xZkqqHx_jCoBiCkCjFpLiCkKjHmHiCkC_xHqqkZx_)_xZkqqHx_iCmNiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
			if (dScoreB < dAngleDiffLimit0) break;

			//----- _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			// _xZkqqHx_jAkHiMoEjDfPiCgCiCkKiCgDiCnMiCmFiInKjDkOiClFiClNiCoHiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
			if (rougheq(mmptC, mmptD)) return FALSE;
			// _xZkqqHx_jAkHiMoEjDfPiCgCiCpAiCgDiCmMjFpLiCmJiKpBiClJiCoJiBeC_xHqqkZx_
			mmptC = (mmptC + mmptD) / 2.0;
		}
		for (;;)
		{
			// _xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCgCiCkJiCoHiMhGiOfKiCpAiOgOiCnPiCmEiBeBiJpAiCkKiLiBiCnMiCoHiCmIiCkC_xHqqkZx_
			// _xZkqqHx_iPoKiNiHiCmNiBeBiPeJjDfPiCmJiMpMiCkJiCmBiCmEiIoKiCmCiClIiCmCiInKjDkOiClHiCoJiBeC_xHqqkZx_
			double dScoreC = DBL_MAX;
			for (long lC = lIndexC; lC != lPointSize - 2; lC++)
			{
				// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCkK_xHqqkZx_mmptPoint[lC]_xZkqqHx_iBeB_xHqqkZx_mmptPoint[lC + 1]_xZkqqHx_iCmM_xHqqkZx_
				// _xZkqqHx_jHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgCiCpAiOfKiPgPiBeC_xHqqkZx_
				DBLPoint mmptTmpC;
				dScoreC = CalcCFromABDP2(mmptTmpC, mmptA, mmptB, mmptD, mmptPoint[lC], mmptPoint[lC + 1], pLineAngle[lPointSize - 2]);
				if (dScoreC < dAngleDiffLimitN)
				//----- _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClHiPoKiNiH_xHqqkZx_(_xZkqqHx_jCoBiCkCjFpLiCkKjHmHiCkC_xHqqkZx_) -----
				{
					// _xZkqqHx_jAfGiClFiCkCiCgCiCmGiClFiCmEiLeMjIfOiBeCiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
					mmptNewC = mmptTmpC;
					break;
				}
			}
			// _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClHiPoKiNiH_xHqqkZx_(_xZkqqHx_jCoBiCkCjFpLiCkKjHmHiCkC_xHqqkZx_)_xZkqqHx_iCmNiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
			if (dScoreC < dAngleDiffLimitN) break;

			//----- _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAjGjOiClNiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			// _xZkqqHx_jAkHiMoEjDfPiCgBiCkKiCgAiCnMiCmFiInKjDkOiClFiClNiCoHiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
			if (rougheq(mmptB, mmptA)) return FALSE;
			// _xZkqqHx_jAkHiMoEjDfPiCgBiCpAiCgAiCmMjFpLiCmJiKpBiClJiCoJiBeC_xHqqkZx_
			mmptB = (mmptB + mmptA) / 2.0;
		}
		//----- _xZkqqHx_jAfGiClFiCkCiCgBiCmGiCgCiCkKiKoOiPiAjCgMiCpAjGjOiClNiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----

		// _xZkqqHx_iCgBiCmGiCgCiCmNiBeBjAfGiClFiCkCjCgMiCpAiClLiCmMiCnMiCnMjAnNjCoIiClHiCoJiCmMiCmFiCmNiCmIiCkNiBeB_xHqqkZx_
		// _xZkqqHx_iInKjDkOiClHiCoJjHmKiCpAiClOiCpBiClOiCpBiMlIiCoHiClFiCmEiCkCiCkNiBeC_xHqqkZx_
		mmptB += (mmptNewB - mmptB) * double(lCount) / 10.0;
		mmptC += (mmptNewC - mmptC) * double(lCount) / 10.0;

		TRACE(_T("DoCalcControlsB %f %f\n"), (mmptPrevB - mmptNewB).Len(), (mmptPrevC - mmptNewC).Len());

		// _xZkqqHx_jAfGiClFiCkCiImKjChFiCnMiCmFiCmMiLjHjHkDiCkKiKoOiPiAjCgMiCpAiJlKiJpBiCoJiPoKiNiHiCmNiBeBiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
		if ((mmptPrevB - mmptNewB).PowLen() < dStdLen &&
			(mmptPrevC - mmptNewC).PowLen() < dStdLen)
			break;
	}
	TRACE(_T("DoCalcControlsB Success\n"));

	return TRUE;
} // FCApproximateBezier::DoCalcControlsB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::ComparePolyBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmGiDhIiDfHiDeGiLmIjApMiCkKiIoKjChGiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptPoint	:_xZkqqHx_iDhMiDiKiDiJiDeDiDjDjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lPointSize	:mmptPoint_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKoOiPiAjDoAiCmFiIoKjChGiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClIiDhMiDiKiDiJiDeDiDjDiCmGiDhIiDfHiDeGiLmIjApMiCmMjBiNiLjHjHkDiCpAjEoEiKhCiClFiBeBiKoOiPiAjCgMiCpAiPoDiJpBiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNjFhDiIoKjChGiCmGiClFiCmEjElLjCgGiBeC_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiDhMiDiKiDiJiDeDiDjDiCmGiDhIiDfHiDeGiLmIjApMjHlMjFpLiCmFiDhNiDeDiDiLiDfIiDgHiDjDiCmMiNmAjFfHiCpAiMhGiOfKiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iKgFiDhNiDeDiDiLiDfIiDgHiDjDiCmMiImKjChFiCkKiCnJiCnKiIoKjChGiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiIoKjChGjDhIiCkKiKoOiPiAjCgMiCpAiPoDiJpBiCoJiPoKiNiHiCmNjFhDiIoKjChGiCmGiClFiCmEjElLjCgGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::ComparePolyBezier (const DBLPoint* mmptPoint,
											long lPointSize,
											const DBLPoint& mmptA,
											const DBLPoint& mmptB,
											const DBLPoint& mmptC,
											const DBLPoint& mmptD) const
{
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMjApMjFkKiCmMjClHiClDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	doubleVector vLineLength0;
	double dPolylineLength0 = FFGetLineLength(vLineLength0, lPointSize, mmptPoint);
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	DBLPoint mmptControl[4] = { mmptA, mmptB, mmptC, mmptD };
	DBLPointVector vPoly;
	DrawBezierFast2(vPoly, mmptControl, 40);
	vPoly.insert(vPoly.begin(), mmptA);
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjApMjFkKiCmMjClHiClDjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	doubleVector vLineLength1;
	double dPolylineLength1 = FFGetLineLength(vLineLength1, vPoly.size(), vPoly.begin());
	// _xZkqqHx_jBiNiLjHjHkDiCmMiIoKjChGjDhIiDfIiDfCiDeBiCpAiOfKiPgPiBeC_xHqqkZx_
	double dScoreL = fabs(dPolylineLength0 - dPolylineLength1) / dPolylineLength1;
	// _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAiPoDiJpBiCoJiPoKiNiHiCmNjFhDiIoKjChGiBeC_xHqqkZx_
	if (m_dLengthScore < dScoreL)
	{
		TRACE(_T("SCORE_L = %f\n"), dScoreL);
		return FALSE;
	}

	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmMiDhNiDeDiDiLiDfIiDgHiDjDiNmAjFfHjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPointVector vMilestone0;
	FFGetMilestonePoint(vMilestone0,
						lPointSize,
						mmptPoint,
						vLineLength0.begin(),
						40);
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiDhNiDeDiDiLiDfIiDgHiDjDiNmAjFfHjEhKjHpBiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPointVector vMilestone1;
	FFGetMilestonePoint(vMilestone1,
						vPoly.size(),
						vPoly.begin(),
						vLineLength1.begin(),
						40);
//----- 05.04.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iIoKjChGjDhIiCmMiDfIiDfCiDeBiCpAiMhGiOfKiBeCiKgFiDhNiDeDiDiLiDfIiDgHiDjDiCmMiLjHjHkDiCmMjDpBiPoGiCmMjBiNjIgBiCpAjBfDiLjHjHkDiCmFiKiEiCoJiBeC_xHqqkZx_
//	double dScoreP = 0.0;
//	long lC;
//	for (lC = 0; lC != vMilestone0.size(); lC++)
//		dScoreP += (vMilestone0[lC] - vMilestone1[lC]).PowLen();
//	dScoreP /= dPolylineLength1;
//	// _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAiPoDiJpBiCoJiPoKiNiHiCmNjFhDiIoKjChGiBeC_xHqqkZx_
//	if (dScoreP < m_dMilestoneScore)
//	{
//		return TRUE;
//	} else
//	{
//		TRACE(_T("SCORE_P = %f\n"), dScoreP);
//		return FALSE;
//	}
//----- 05.04.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const double dMilestoneScore = POW2(m_dMilestoneScore / 20.0);
	long lC;
	for (lC = 0; lC != vMilestone0.size(); lC++)
	{
		// _xZkqqHx_iOgOjDfPiBgJiPeJjDfPiBgKiCkJiCoHiCmMiLjHjHkDiBeCiLnPiCkCjFpLiCpAiOoGiCoJiBeC_xHqqkZx_
		long lDistance = (lC < vMilestone0.size() - lC) ? lC : vMilestone0.size() - lC;
		lDistance += 20;
		// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCmMiDhNiDeDiDiLiDfIiDgHiDjDiLjHjHkDiBeCiOgOjDfPiBgJiPeJjDfPiBgKiCmJiLnPiCkCiCnJiCmHiMlFiClFiCkNiClHiCoJiBeC_xHqqkZx_
		double dScoreP = (vMilestone0[lC] - vMilestone1[lC]).PowLen() / POW2(double(lDistance));
		// _xZkqqHx_iDfIiDfCiDeBiCkKiKoOiPiAjCgMiCpAiPoDiJpBiCoJiPoKiNiHiCmNjFhDiIoKjChGiBeC_xHqqkZx_
		if (dMilestoneScore < dScoreP)
			return FALSE;
	}
	return TRUE;
//----- 05.04.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCApproximateBezier::ComparePolyBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::CalcBFromACDP2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgAiBeBiCgCiBeBiCgDiCmGiCfBiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgBiCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP1		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP2		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dLineAngle0	:_xZkqqHx_iNmFiPiJiCmMjApMjFkKiCmMiKhAjDhIiCpAiOhHjCoIiBeCiDfIiDfCiDeBiMhGiOfKiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCmGjClMjApMiCgAiCgBiCmMiKhAjDhIiCmMiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgBiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                  P1
 *                  _xZkqqHx_iBkF_xHqqkZx_
 *               _xZkqqHx_iCfBiBfOiBfAiBfAiBfPiCeP_xHqqkZx_    
 *           P2_xZkqqHx_iBkDiBfO_xHqqkZx_        _xZkqqHx_iBfPiBkD_xHqqkZx_P0
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiLnPiOjHjCgMiCmJiLnPiCkCjAkHiMoEjDfPiCgCiCpAiPiJiKpKjCgMiCmGiClFiCmEjHfOiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjHfOiCkGiCoHiCoKiClNjAkHiMoEjDfPiCgAiBeBiCgCiBeBiCgDiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiPoDiCmMjHnHiCoIiNiHiCkE_xHqqkZx_
 *				_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(P1_xZkqqHx_iBeB_xHqqkZx_P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgBiCmMiImKjChFiCpA_xHqqkZx_
 *				_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEjClMjApMiCgAiCgBiCmMiKhAjDhIiCmGiOgOjDfP_xHqqkZx_P0_xZkqqHx_iCmMiKhAjDhIiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(P1_xZkqqHx_iBeB_xHqqkZx_P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgBiCmNiOjPiCmMjFpLjGeAiCmFiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmFjChFiCkLiKlHiCkGiCmE_xHqqkZx_
 *			P = A * k^3 + 3 * B * k^2 * t + 3 * C * k * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			_xZkqqHx_iHeAiCpAiCgBiCmJiCmCiCkCiCmEiJpAiCkCiCmEiBeB_xHqqkZx_
 *			B = -(-P + A*k^3 + 3*C*k*t^2 + D*t^3)/(3*t*k^2) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			t_xZkqqHx_iCmMjCgMiCpAjFmPiJlLiClDiClJiBeBiClLiCoKiClMiCoKiCmFiCgBiCpAiLiBiCnPiCoJiCmGiBeB_xHqqkZx_B(t)_xZkqqHx_iCmMiDePiDiJiDhEiCkKiDhGiDiNiDgCiDgHiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeBjDfP_xHqqkZx_P_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t(0_xZkqqHx_iBgA_xHqqkZx_1)_xZkqqHx_iCmFjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgBiCmMjFmPiJlLiCmIiCmMiCmFiBeB_xHqqkZx_
 *			P1_xZkqqHx_iBeB_xHqqkZx_P2_xZkqqHx_iCmJiKnGiClFiCmEiClLiCoKiClMiCoKiCgBiCmMiDePiDiJiDhEiCpAjFgAiCkCiCmEiBeBiDePiDiJiDhEiCkKiMpAiNlHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCkKiBeB_xHqqkZx_(P1,P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiJnPiClHiCoJiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgBiCmM_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCApproximateBezier::CalcBFromACDP2 (DBLPoint& mmptB,
											const DBLPoint& mmptA,
											const DBLPoint& mmptC,
											const DBLPoint& mmptD,
											const DBLPoint& mmptP1,
											const DBLPoint& mmptP2,
											double dLineAngle0) const
{
	// 0.0001 _xZkqqHx_iBgA_xHqqkZx_ 0.8 _xZkqqHx_iCnMiCmFjClCiCnHiCoJiBeC_xHqqkZx_
	DBLPointVector vmmptB1;
	DBLPointVector vmmptB2;
	long lC;
	for (lC = 0; lC != 40; lC++)
	{
		double t = 0.8 * double(lC) / 40.0;
		if (lC == 0) t = 0.0001;
		double k = 1.0 - t;
		// _xZkqqHx_jDfP_xHqqkZx_P1_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgBiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptTmpB = -(mmptA * POW3(k) + 3.0 * mmptC * k * POW2(t) - mmptP1 + mmptD * POW3(t)) / (3.0 * t * POW2(k));
		// _xZkqqHx_iCgBiCmMiNmAjFfHiCpAjEhKjHpBiCmJiLeMjIfOiBeC_xHqqkZx_
		vmmptB1.push_back(mmptTmpB);
	}
	for (lC = 0; lC != 40; lC++)
	{
		double t = 0.8 * double(lC) / 40.0;
		if (lC == 0) t = 0.0001;
		double k = 1.0 - t;
		// _xZkqqHx_jDfP_xHqqkZx_P2_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgBiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptTmpB = -(mmptA * POW3(k) + 3.0 * mmptC * k * POW2(t) - mmptP2 + mmptD * POW3(t)) / (3.0 * t * POW2(k));
		// _xZkqqHx_iCgBiCmMiNmAjFfHiCpAjEhKjHpBiCmJiLeMjIfOiBeC_xHqqkZx_
		vmmptB2.push_back(mmptTmpB);
	}

	// _xZkqqHx_iCfBiCmCiCmMiCgBiLmIjApMiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
	FCPolyHash hash1(vmmptB1.size(), vmmptB1.begin(), DBLRect(-10000, -10000, 10000, 10000));
	FCPolyHash hash2(vmmptB2.size(), vmmptB2.begin(), DBLRect(-10000, -10000, 10000, 10000));
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkJiCoHiCgBiLmIjApMiCmMiMpAjDfPiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPointVector vIntersectPoint;
	FCPolyHash::GetIntersectPoint(vIntersectPoint, hash1, hash2);
	if (!vIntersectPoint.empty())
	//----- _xZkqqHx_iMpAjDfPiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmptB = vIntersectPoint[0];
		// _xZkqqHx_jClMjApMiCgAiCgBiCmMiKhAjDhIiCmGiOgOjDfP_xHqqkZx_P0_xZkqqHx_iCmMiKhAjDhIiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
		DBLPoint mmptL = mmptB - mmptA;
		double dR = atan2(mmptL.y, mmptL.x);
		return fabs(FFAngleMinusPitoPi(dR - dLineAngle0));
	}
	return DBL_MAX;
} // FCApproximateBezier::CalcBFromACDP2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::CalcCFromABDP2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgAiBeBiCgBiBeBiCgDiCmGiCfBiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgCiCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP1		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP2		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dLineAngle0	:_xZkqqHx_iNmFiMoDiCmMjApMjFkKiCmMiKhAjDhIiCpAiOhHjCoIiBeCiDfIiDfCiDeBiMhGiOfKiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCmGjClMjApMiCgCiCgDiCmMiKhAjDhIiCmMiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgCiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *            _xZkqqHx_iCfCiEkA_xHqqkZx_               
 *              _xZkqqHx_iEkA_xHqqkZx_               
 *          Pc2_xZkqqHx_iBkDiBfP_xHqqkZx_        _xZkqqHx_iBfOiBkF_xHqqkZx_Pn
 *               _xZkqqHx_iCfDiBfPiBfBiBfBiBfOiCfF_xHqqkZx_    
 *                  _xZkqqHx_iBkD_xHqqkZx_
 *                  Pc1
 *
 *			_xZkqqHx_iClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmNiBeBjBoFiOeHjEgDiCmJiMlOiCkEiCmGiImIiJlKiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiLnPiOjHjCgMiCmJiLnPiCkCjAkHiMoEjDfPiCgBiCpAiPiJiKpKjCgMiCmGiClFiCmEjHfOiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjHfOiCkGiCoHiCoKiClNjAkHiMoEjDfPiCgAiBeBiCgBiBeBiCgDiCkJiCoHiBeBiDhMiDiKiDiJiDeDiDjDiPoDiCmMjHnHiCoIiNiHiCkE_xHqqkZx_
 *				_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(P1_xZkqqHx_iBeB_xHqqkZx_P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgCiCmMiImKjChFiCpA_xHqqkZx_
 *				_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeEjClMjApMiCgCiCgDiCmMiKhAjDhIiCmGiPeJjDfP_xHqqkZx_Pn_xZkqqHx_iCmMiKhAjDhIiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_(P1_xZkqqHx_iBeB_xHqqkZx_P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiCoJiCoGiCkEiCmIjAkHiMoEjDfPiCgCiCmNiOjPiCmMjFpLjGeAiCmFiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiOkOiCmNiImIiJlKiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmFjChFiCkLiKlHiCkGiCmE_xHqqkZx_
 *			P = A * k^3 + 3 * B * k^2 * t + 3 * C * k * t^2 + D * t^3 _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			_xZkqqHx_iHeAiCpAiCgCiCmJiCmCiCkCiCmEiJpAiCkCiCmEiBeB_xHqqkZx_
 *			C = (P - A*k^3 - 3*B*k^2*t - D*t^3)/(3*k*t^2) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			t_xZkqqHx_iCmMjCgMiCpAjFmPiJlLiClDiClJiBeBiClLiCoKiClMiCoKiCmFiCgCiCpAiLiBiCnPiCoJiCmGiBeB_xHqqkZx_C(t)_xZkqqHx_iCmMiDePiDiJiDhEiCkKiDhGiDiNiDgCiDgHiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeBjDfP_xHqqkZx_P_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t(0_xZkqqHx_iBgA_xHqqkZx_1)_xZkqqHx_iCmFjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgCiCmMjFmPiJlLiCmIiCmMiCmFiBeB_xHqqkZx_
 *			P1_xZkqqHx_iBeB_xHqqkZx_P2_xZkqqHx_iCmJiKnGiClFiCmEiClLiCoKiClMiCoKiCgCiCmMiDePiDiJiDhEiCpAjFgAiCkCiCmEiBeBiDePiDiJiDhEiCkKiMpAiNlHiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCkKiBeB_xHqqkZx_(P1,P2)_xZkqqHx_iCmMjHlMjFpLiCpAjCmKiJnPiClHiCoJiDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCgCiCmM_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCApproximateBezier::CalcCFromABDP2 (DBLPoint& mmptC,
											const DBLPoint& mmptA,
											const DBLPoint& mmptB,
											const DBLPoint& mmptD,
											const DBLPoint& mmptP1,
											const DBLPoint& mmptP2,
											double dLineAngleN) const
{
	// 0.0001 _xZkqqHx_iBgA_xHqqkZx_ 0.8 _xZkqqHx_iCnMiCmFjClCiCnHiCoJiBeC_xHqqkZx_
	DBLPointVector vmmptC1;
	DBLPointVector vmmptC2;
	long lC;
	for (lC = 0; lC != 40; lC++)
	{
		double k = 0.8 * double(lC) / 40.0;
		if (lC == 0) k = 0.0001;
		double t = 1.0 - k;
		// _xZkqqHx_jDfP_xHqqkZx_P1_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgCiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptTmpC = (mmptP1 - mmptA * POW3(k) - 3.0 * mmptB * POW2(k) * t - mmptD * POW3(t)) / (3.0 * k * POW2(t));
		// _xZkqqHx_iCgCiCmMiNmAjFfHiCpAjEhKjHpBiCmJiLeMjIfOiBeC_xHqqkZx_
		vmmptC1.push_back(mmptTmpC);
	}
	for (lC = 0; lC != 40; lC++)
	{
		double k = 0.8 * double(lC) / 40.0;
		if (lC == 0) k = 0.0001;
		double t = 1.0 - k;
		// _xZkqqHx_jDfP_xHqqkZx_P2_xZkqqHx_iCpAiOjOiNiP_xHqqkZx_t_xZkqqHx_iCmJjCmKiJnPiClHiCoJiPoKiNiHiCmMiCgCiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		DBLPoint mmptTmpC = (mmptP2 - mmptA * POW3(k) - 3.0 * mmptB * POW2(k) * t - mmptD * POW3(t)) / (3.0 * k * POW2(t));
		// _xZkqqHx_iCgCiCmMiNmAjFfHiCpAjEhKjHpBiCmJiLeMjIfOiBeC_xHqqkZx_
		vmmptC2.push_back(mmptTmpC);
	}

	// _xZkqqHx_iCfBiCmCiCmMiCgCiLmIjApMiCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
	FCPolyHash hash1(vmmptC1.size(), vmmptC1.begin(), DBLRect(-10000, -10000, 10000, 10000));
	FCPolyHash hash2(vmmptC2.size(), vmmptC2.begin(), DBLRect(-10000, -10000, 10000, 10000));
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCkJiCoHiCgCiLmIjApMiCmMiMpAjDfPiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPointVector vIntersectPoint;
	FCPolyHash::GetIntersectPoint(vIntersectPoint, hash1, hash2);
	if (!vIntersectPoint.empty())
	//----- _xZkqqHx_iMpAjDfPiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmptC = vIntersectPoint[0];
		// _xZkqqHx_jClMjApMiCgCiCgDiCmMiKhAjDhIiCmGiPeJjDfP_xHqqkZx_Pn_xZkqqHx_iCmMiKhAjDhIiNlHiCpAiDfIiDfCiDeBiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
		DBLPoint mmptL = mmptD - mmptC;
		double dR = atan2(mmptL.y, mmptL.x);
		return fabs(FFAngleMinusPitoPi(dR - dLineAngleN));
	}
	return DBL_MAX;
} // FCApproximateBezier::CalcCFromABDP2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCApproximateBezier::CalcBCFromADLMP1
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCkKiKpJjCgNiCmFiCkAiCoIiBeBiKiOiCmC_xHqqkZx_|_xZkqqHx_iCgAiCgB_xHqqkZx_|=|_xZkqqHx_iCgDiCgC_xHqqkZx_|_xZkqqHx_iCmMiPoKiNiHiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iCfAiCmCiCmMiDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCkJiCoHjAkHiMoEjDfPiCgBiBeBiCgCiCmMjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptB		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptC		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptD		:_xZkqqHx_iDhIiDfHiDeGiCmMjAkHiMoEjDfPiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dPointAngle0:_xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dPointAngleN:_xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptP		:_xZkqqHx_iDfEiDjDiDhGiDiLiDhMiDeDiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiLnPiOjHjAkHiMoEjDfPiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAkHiMoEjDfPiCgBiBeBiCgCiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 *                   P1
 *                  _xZkqqHx_iBfOiBfP_xHqqkZx_
 *                _xZkqqHx_iBfO_xHqqkZx_    _xZkqqHx_iBfP_xHqqkZx_
 *              _xZkqqHx_iBfO_xHqqkZx_        _xZkqqHx_iBfP_xHqqkZx_
 *             P0           _xZkqqHx_iBfP_xHqqkZx_
 *                            P2
 *
 *			P0_xZkqqHx_iCmG_xHqqkZx_P2_xZkqqHx_iCmMiKhAjDhIiBeBjBkGiClPiCgAiCgBiCmGiCgDiCgCiCmMiKhAjDhIiCmNiKpJjCgNiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCgAiCgBiCmGiCgDiCgCiCmMjClHiClDiCpAjDjJiClFiCkNiClFiCmEiBeB_xHqqkZx_P1_xZkqqHx_iCpAjCmKiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *			P = A * (1-t)^3 + 3 * B * (1-t)^2 * t + 3 * C * (1-t) * t^2 + D * t^3
 *			1-t=k_xZkqqHx_iCmGiClHiCoJiCmG_xHqqkZx_
 *			P = A * k^3 + 3 * B * k^2 * t + 3 * C * k * t^2 + D * t^3
 *			B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiBeBjApMjFkK_xHqqkZx_AB=L*u_xZkqqHx_iCmGjApMjFkK_xHqqkZx_DC=M*u(L,M_xZkqqHx_iCmNjClHiClD_xHqqkZx_1)_xZkqqHx_iCmFjFfMiClHiCmG_xHqqkZx_
 *			B=A+L*u
 *			C=D+M*u
 *			P = A*k^3 + 3*k^2*t*(A + L*u) + 3*k*t^2*(D + M*u) + D*t^3
 *			u_xZkqqHx_iCpAiJpAiCkCiCmE_xHqqkZx_
 *			u = -(P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3)/(-3*L*k^2*t - 3*M*k*t^2) _xZkqqHx_iBeFiBeFiBeFiHeC_xHqqkZx_
 *			x,y_xZkqqHx_iCkJiCoHiJgFiLlPiCpAiOpDiCkPiCmIiCkCjFmPjAjEiCpAiNlGjFnDiCmJiPfHiCnPiCoJiBeC_xHqqkZx_
 *			3*k*t*u = (P - A*k^3 - 3*A*k^2*t - 3*D*k*t^2 - D*t^3)/(L*k + M*t)
 *			_xZkqqHx_iClBiCoKiCpA_xHqqkZx_ x,y_xZkqqHx_iCmJiKnGiClFiCmEjDfHiKeKiBeC_xHqqkZx_
 *			3*k*t*u = (Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3)/(Lx*k + Mx*t) _xZkqqHx_iBeFiBeFiBeFiHeA_xHqqkZx_
 *			3*k*t*u = (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3)/(Ly*k + My*t) _xZkqqHx_iBeFiBeFiBeFiHeB_xHqqkZx_
 *			_xZkqqHx_iHeAiBeBiHeBiCkJiCoH_xHqqkZx_
 *			(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3)/(Lx*k + Mx*t) -  (Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3)/(Ly*k + My*t) = 0
 *			(Ly*k + My*t)(Px - Ax*k^3 - 3*Ax*k^2*t - 3*Dx*k*t^2 - Dx*t^3) -  (Lx*k + Mx*t)(Py - Ay*k^3 - 3*Ay*k^2*t - 3*Dy*k*t^2 - Dy*t^3) = 0
 *			t_xZkqqHx_iCmJiKnGiClFiCmEiCnMiCmGiCnPiCmEiBeC_xHqqkZx_
 *			(Ay*Lx - Ax*Ly + Ly*Px - Lx*Py) +
 *			  (-Ay*Lx + Ax*Ly + Ay*Mx - Ax*My - Ly*Px + My*Px + Lx*Py - Mx*Py)*t +
 *			    (-3*Ay*Lx + 3*Dy*Lx + 3*Ax*Ly - 3*Dx*Ly)*t^2 +
 *			      (5*Ay*Lx - 5*Dy*Lx - 5*Ax*Ly + 5*Dx*Ly - 3*Ay*Mx + 3*Dy*Mx + 3*Ax*My - 3*Dx*My)*t^3 +
 *			        (-2*Ay*Lx + 2*Dy*Lx + 2*Ax*Ly - 2*Dx*Ly + 2*Ay*Mx - 2*Dy*Mx - 2*Ax*My + 2*Dx*My)*t^4 = 0 _xZkqqHx_iBeFiBeFiBeFiHeD_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiCfDiOjPiOkOiCpAiJpAiCkCiCmE_xHqqkZx_t_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iHeCiCmG_xHqqkZx_t_xZkqqHx_iCmMjCgMiCkJiCoH_xHqqkZx_u_xZkqqHx_iCpAiLiBiCnPiBeB_xHqqkZx_B_xZkqqHx_iCmG_xHqqkZx_C_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iBkG_xHqqkZx_ _xZkqqHx_iHeAiBeBiHeBiCmF_xHqqkZx_Lx*k + Mx*t = 0_xZkqqHx_iBeB_xHqqkZx_Ly*k + My*t = 0 _xZkqqHx_iCmJiCmIiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiCkKiBeB_xHqqkZx_
 *			   _xZkqqHx_iNmFiPeJjDeJiCmJiHeDiCmFiCmNjFkKjFoKiCkKiPmBiCkGiCoJiCmMiCmFjGoCjBoIiCmIiCkCiBeCiClNiCnEiCpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCApproximateBezier::CalcBCFromADLMP1 (DBLPoint& mmptB,
											DBLPoint& mmptC,
											const DBLPoint& mmptA,
											const DBLPoint& mmptD,
											double dPointAngle0,
											double dPointAngleN,
											const DBLPoint& mmptP) const
{
	// _xZkqqHx_iNmFiMoDiCmMjDfPiCmMiKhAjDhIiCmNiLhEiMpMiCkLiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	dPointAngleN = FFAngleMinusPitoPi(dPointAngleN + M_PI);
	// _xZkqqHx_iOgOjDfPiCmMiKhAjDhIiCkJiCoHiCgLiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptL(cos(dPointAngle0), sin(dPointAngle0));
	// _xZkqqHx_iPeJjDfPiCmMiKhAjDhIiCkJiCoHiCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptM(cos(dPointAngleN), sin(dPointAngleN));
	// _xZkqqHx_iDhEiDeGiDiJiDiKjGeAiCmFiHeDiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCFerrari fr;
	fr.Set(	-2.0*mmptA.y*mmptL.x + 2.0*mmptD.y*mmptL.x + 2.0*mmptA.x*mmptL.y - 2.0*mmptD.x*mmptL.y + 2.0*mmptA.y*mmptM.x - 2.0*mmptD.y*mmptM.x - 2.0*mmptA.x*mmptM.y + 2.0*mmptD.x*mmptM.y,
			5.0*mmptA.y*mmptL.x - 5.0*mmptD.y*mmptL.x - 5.0*mmptA.x*mmptL.y + 5.0*mmptD.x*mmptL.y - 3.0*mmptA.y*mmptM.x + 3.0*mmptD.y*mmptM.x + 3.0*mmptA.x*mmptM.y - 3.0*mmptD.x*mmptM.y,
			-3.0*mmptA.y*mmptL.x + 3.0*mmptD.y*mmptL.x + 3.0*mmptA.x*mmptL.y - 3.0*mmptD.x*mmptL.y,
			-mmptA.y*mmptL.x + mmptA.x*mmptL.y + mmptA.y*mmptM.x - mmptA.x*mmptM.y - mmptL.y*mmptP.x + mmptM.y*mmptP.x + mmptL.x*mmptP.y - mmptM.x*mmptP.y,
			mmptA.y*mmptL.x - mmptA.x*mmptL.y + mmptL.y*mmptP.x - mmptL.x*mmptP.y);
	fr.Solve();
	mmetol mmUMin = DBL_MAX;
	long lC;
	for (lC = 0; lC != 4; lC++)
	//----- _xZkqqHx_iCfDiCmCiCmMiJpAiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_jHeMiMpIiCmIiCjEiCmMjCgMiCmFiCkAiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		if (figeq(fr.m_cSol[lC].imag(), 0, 5) &&
			0.0 < fr.m_cSol[lC].real() && fr.m_cSol[lC].real() < 1.0)
		//----- _xZkqqHx_iLjFjAjEjFjEiCkKiCePiCmFiCkAiCoIiBeBiOmAjAjEjFjEiBgJjBkGiClP_xHqqkZx_t_xZkqqHx_iBgKiCkK_xHqqkZx_(0,1)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// t_xZkqqHx_iCmG_xHqqkZx_k_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			double dT = fr.m_cSol[lC].real();
			double dK = 1.0 - dT;
			// t_xZkqqHx_iCkJiCoH_xHqqkZx_u_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_x,y_xZkqqHx_jHlMjFpLiMpMiCkJiCoHiOfKiPgPiBeC_xHqqkZx_
			mmetol mmUx = -(mmptP.x - mmptA.x*POW3(dK) - 3.0*mmptA.x*POW2(dK)*dT - 3.0*mmptD.x*dK*POW2(dT) - mmptD.x*POW3(dT))/(-3.0*mmptL.x*POW2(dK)*dT - 3.0*mmptM.x*dK*POW2(dT));
			mmetol mmUy = -(mmptP.y - mmptA.y*POW3(dK) - 3.0*mmptA.y*POW2(dK)*dT - 3.0*mmptD.y*dK*POW2(dT) - mmptD.y*POW3(dT))/(-3.0*mmptL.y*POW2(dK)*dT - 3.0*mmptM.y*dK*POW2(dT));
			ASSERT(fabs((mmUx - mmUy) / mmUx) < 0.1);
			// x,y_xZkqqHx_jHlMjFpLiCkJiCoHiLiBiCnPiClN_xHqqkZx_u_xZkqqHx_iCmNiIoKjChGiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiCkKiBeB_xHqqkZx_
			// _xZkqqHx_iOmAiNnLiCmNiIoKjChGiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_
			if (fabs((mmUx - mmUy) / mmUx) < 0.1)
			//----- Ux_xZkqqHx_iCmG_xHqqkZx_Uy_xZkqqHx_iCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// u_xZkqqHx_iCmN_xHqqkZx_0_xZkqqHx_iCoGiCoIjBoFiCkLiCkNiCmIiCkNiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jCgMiCkKiPkMiClDiCkCiCnJiCmHjHmHiCkCiBeC_xHqqkZx_
				if (0.0 < mmUx && mmUx < mmUMin) mmUMin = mmUx;
			}
		}
	}
	if (mmUMin != DBL_MAX)
	//---- u_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// u_xZkqqHx_iCmMjCgMiCkJiCoHiBeBjAkHiMoEjDfPiCgBiBeBiCgCiCmMiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
		mmptB = mmptA + mmptL * mmUMin;
		mmptC = mmptD + mmptM * mmUMin;
		return TRUE;
	}
	return FALSE;
} // FCApproximateBezier::CalcBCFromADLMP1.

