#ifndef __ApproximateBezier_h
#define __ApproximateBezier_h

struct FCBezierControls;
typedef vector<FCBezierControls> FCBezierControlsVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCApproximateBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAiLnPiOjHiClHiCoJiDhIiDfHiDeGiLmIjApMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCApproximateBezier
{
public:
	FCApproximateBezier ();

	virtual void PolylineToBezier (	FCBezierControlsVector& vControls,
									const DBLPoint* mmptPoint,
									long lPointSize) const;
	virtual void SlimLine (DBLPointVector& vSlimLine) const;
	virtual void GetJoint (	set<long>& stJoint,
							const DBLPoint* mmptPoint,
							long lPointSize,
							const double* pLineAngle) const;
	virtual void JointsToBezier (	FCBezierControlsVector& vControls,
									const set<long>& stJoint,
									const DBLPoint* mmptPoint,
									const double* pLineAngle) const;
	virtual void OneJointToBezier (	FCBezierControlsVector& vControls,
									const DBLPoint* mmptPoint,
									long lPointSize,
									const double* pLineAngle) const;

protected:
//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual long GetPolyForBezierL0 (DBLPointVector& vPointFirst,
//									doubleVector& vLineAngleFirst,
//									doubleVector& vPointAngleFirst,
//									DBLPointVector& vPoint,
//									doubleVector& vLineAngle,
//									doubleVector& vPointAngle,
//									long lIndex1,
//									double dAngleMove1,
//									long lFailedLineSize) const;
//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual long GetPolyForBezierL0 (DBLPointVector& vPointFirst,
									doubleVector& vLineAngleFirst,
									doubleVector& vPointAngleFirst,
									DBLPointVector& vPoint,
									doubleVector& vLineAngle,
									doubleVector& vPointAngle,
									long lIndex1,
									double dAngleMove1) const;

	virtual long GetPolyForBezierL0Fail (DBLPointVector& vPointFirst,
										doubleVector& vLineAngleFirst,
										doubleVector& vPointAngleFirst,
										DBLPointVector& vPoint,
										doubleVector& vLineAngle,
										doubleVector& vPointAngle,
										long lIndex1,
										double dAngleMove1) const;
//----- 05.04.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	virtual long GetPolyForBezierL1 (DBLPointVector& vPointFirst,
									doubleVector& vLineAngleFirst,
									doubleVector& vPointAngleFirst,
									DBLPointVector& vPoint,
									doubleVector& vLineAngle,
									doubleVector& vPointAngle,
									long lIndex1,
									long lIndex2,
									double dAngleMove1,
									double dAngleMove2) const;

	virtual long GetFirstPolyForBezier (DBLPointVector& vPointFirst,
										doubleVector& vLineAngleFirst,
										doubleVector& vPointAngleFirst,
										DBLPointVector& vPoint,
										doubleVector& vLineAngle,
										doubleVector& vPointAngle,
										long lFailedLineSize) const;

	virtual BOOL Calc1WayPointBezier (	FCBezierControlsVector& vControls,
										const DBLPoint* mmptPoint,
										const double* pLineAngle,
										const double* pPointAngle,
										long lPointSize,
										double dAngleDiffLimit0,
										double dAngleDiffLimitN) const;
	virtual BOOL Calc2WayPointBezier (	FCBezierControlsVector& vControls,
										const DBLPoint* mmptPoint,
										const double* pLineAngle,
										const double* pPointAngle,
										long lPointSize,
										double dAngleDiffLimit0,
										double dAngleDiffLimitN) const;

	virtual BOOL Calc5PointBezier (	FCBezierControlsVector& vControls,
									const DBLPoint* mmptPoint,
									const double* pLineAngle,
									const double* pPointAngle,
									long lPointSize,
									double dAngleDiffLimit0,
									double dAngleDiffLimitN) const;

	virtual BOOL Calc3PointBezier (	FCBezierControlsVector& vControls,
									const DBLPoint* mmptPoint,
									const double* pLineAngle,
									const double* pPointAngle,
									long lPointSize,
									double dAngleDiffLimit0,
									double dAngleDiffLimitN) const;

	virtual void Calc2PointBezier (	FCBezierControlsVector& vControls,
									const DBLPoint* mmptPoint,
									const double* pLineAngle,
									const double* pPointAngle,
									long lPointSize) const;

	virtual BOOL DoCalcControlsA (	const DBLPoint& mmptA,
									DBLPoint& mmptB,
									DBLPoint& mmptC,
									const DBLPoint& mmptD,
									const DBLPoint* mmptPoint,
									const double* pLineAngle,
									const double* pPointAngle,
									long lPointSize,
// 05.04.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//									const DBLRect& mmrtFrame,
									long lIndexB,
									long lIndexC,
									double dAngleDiffLimit0,
									double dAngleDiffLimitN) const;

	virtual BOOL DoCalcControlsB (	const DBLPoint& mmptA,
									DBLPoint& mmptB,
									DBLPoint& mmptC,
									const DBLPoint& mmptD,
									const DBLPoint* mmptPoint,
									const double* pLineAngle,
									long lPointSize,
									long lIndexB,
									long lIndexC,
									double dAngleDiffLimit0,
									double dAngleDiffLimitN) const;

	virtual BOOL ComparePolyBezier (const DBLPoint* mmptPoint,
									long lPointSize,
									const DBLPoint& mmptA,
									const DBLPoint& mmptB,
									const DBLPoint& mmptC,
									const DBLPoint& mmptD) const;

	virtual double CalcBFromACDP2 (	DBLPoint& mmptB,
									const DBLPoint& mmptA,
									const DBLPoint& mmptC,
									const DBLPoint& mmptD,
									const DBLPoint& mmptP1,
									const DBLPoint& mmptP2,
									double dLineAngle0) const;
	virtual double CalcCFromABDP2 (	DBLPoint& mmptC,
									const DBLPoint& mmptA,
									const DBLPoint& mmptB,
									const DBLPoint& mmptD,
									const DBLPoint& mmptP1,
									const DBLPoint& mmptP2,
									double dLineAngleN) const;

	virtual BOOL CalcBCFromADLMP1 (	DBLPoint& mmptB,
									DBLPoint& mmptC,
									const DBLPoint& mmptA,
									const DBLPoint& mmptD,
									double dPointAngle0,
									double dPointAngleN,
									const DBLPoint& mmptP) const;

public:
	mmetol	m_mmSlimDistance1;	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_

	mmetol	m_mmSlimDistance2;	// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_

	double	m_dSlimRoundA;		// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiPmIjHkKiClHiCoJiCkJiCmHiCkEiCkJiCmMiKoOiPiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_FFSlimLine_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_

	angle	m_dJointAngle1;		// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiCpAjClEiCkGiCoJiCmGjGlDiPpAiMiPiCmJjFhDjIeBjBlBiDhMiDeDiDjDiDgHiBeC_xHqqkZx_

	angle	m_dJointAngle2;		// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiKhAjDhIiBeCiClBiCoKiImIiJlKiClOiCmGjGlDiPpAiMiPiCmJjIeBjBlBiClFiClNiDhMiDeDiDjDiDgHiBeC_xHqqkZx_

	mmetol	m_mmJointDistance;	// _xZkqqHx_jFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGjElLjCgGiClDiCoKiCoJiKoOiPiAiLjHjHkDiBeC_xHqqkZx_m_dJointAngle2_xZkqqHx_iCmG_xHqqkZx_m_dJointDistance_xZkqqHx_iCmM_xHqqkZx_
								// _xZkqqHx_jHlMjFpLiCpAjClEiCkGiClNiCmGiCkLiBeBjFhDjIeBjBlBiCmIjIeBiMiLjDfPiCmGiClFiCmEjElLjCgGiClDiCoKiCoJiBeC_xHqqkZx_

	angle	m_dSplitAngle0;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_

	angle	m_dSplitAngle1;		// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmMiBeBiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiKoOiPiAiKhAjDhIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCmE_xHqqkZx_
								// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjApMjFkKiCkKiJpBiCoIiNjOiCnOiPoKiNiHiCmNiDhIiDfHiDeGiLmIjApMiCpAjFkKiKiEiClHiCoJiBeC_xHqqkZx_

	double	m_dAngleDiffLimit;	// _xZkqqHx_jAkHiMoEjDfPiCgBiBgJiCgCiBgKiCmMiMhGiOfKiOjOiCmJiBeBiOgOjDfPiBgJiPeJjDfPiBgKiKhAjDhIiCmGjClMjApMiCgAiCgBiBgJiCgCiCgDiBgKiCmMiKhAjDhIiCmM_xHqqkZx_
								// _xZkqqHx_iNlHjFkKiCmMiLjGjHgFjCgMiCpAiOhHjCoIiBeCiClBiCmMiKhAjDhIiCpAjClEiCkGiCoJiCmGjAkHiMoEjDfPiCgBiBgJiCgCiBgKiCmNiNmEiMhGiOfKiBeC_xHqqkZx_

	double	m_dLengthScore;		// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiClLiCmMiLjHjHkDiCmMiNlHiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
								// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_

	double	m_dMilestoneScore;	// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDhIiDfHiDeGiLmIjApMiCmGiDhMiDiKiDiJiDeDiDjDiCpAjEoEiKhCiClFiClNiOjOiCmMiBeBiDhNiDeDiDiLiDfIiDgHiDjDiCmMiLjHjHkDiCmMiDfIiDfCiDeBiKoOiPiAjCgMiBeC_xHqqkZx_
								// _xZkqqHx_iClBiCmMjCgMiCpAjClEiCkGiCoJiCmGiDhIiDfHiDeGiLmIjApMiCmNjGlDiMpIiBeC_xHqqkZx_

	angle	m_dPlayOfAngle;		// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDjDhCjCiGiCmMjDfPiCgPiCpAiOgHiCmBiCmEiDhIiDfHiDeGiLnPiOjHiClHiCoJiNnLiCmJiBeBjDfPiCgPiCmJiCkIiCkPiCoJiDhMiDiKiDiJiDeDiDjDiKhAjDhI_xHqqkZx_R1_xZkqqHx_iCmG_xHqqkZx_
								// _xZkqqHx_iLnPiOjHiOkOiCmFjDlOiCoHiCoKiCoJjDfPiCgPiCmJiCkIiCkPiCoJiKhAjDhI_xHqqkZx_R2_xZkqqHx_iCmMiNlHjFkKiCmMiLjGjHgFjEmNiImNiBeC_xHqqkZx_
}; // class FCApproximateBezier.

#endif//__ApproximateBezier_h
