#ifndef __Arrow_h
#define __Arrow_h

//;----- <EXPORT TO SDK> -----;

class FCObjPictArrow;
class FCEditDraw;
template<class T> class FCPolyBezier;
typedef FCPolyBezier<DBLPoint> FCMmPolyBezier;

// _xZkqqHx_jGoOiIpDiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
enum
{
	FDUG_ARW_TYPE_FLAT = 0,			// _xZkqqHx_iDhEiDiJiDgCiDgHiBeC_xHqqkZx_
	FDUG_ARW_TYPE_TYPICAL,			// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	FDUG_ARW_TYPE_ARROW_A,			// _xZkqqHx_iOkJjHfCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
	FDUG_ARW_TYPE_ARROW_B,			// _xZkqqHx_iOkJjHfCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
	FDUG_ARW_TYPE_ARROW_C,			// _xZkqqHx_iOkJjHfCjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
	FDUG_ARW_TYPE_PICT = 0x0e,		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiBeC_xHqqkZx_
//	FDUG_ARW_TYPE_RECT,
//	FDUG_ARW_TYPE_BALL,
//	FDUG_ARW_TYPE_NONE	= 0x0f,		// _xZkqqHx_jGoOiIpDjGlDiClFiBeC_xHqqkZx_
};

// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiCmMiOjOiCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
enum
{
	FDUG_ARW_STYL_ARROW_A0 = 0,		// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_A1,			// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_A2,			// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_B0,			// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_B1,			// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_B2,			// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_C0,			// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_C1,			// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_ARROW_C2,			// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
	FDUG_ARW_STYL_END,				// _xZkqqHx_jGoOiIpDiDfOiDeDiDhGiCmMiPeJiCoNiCoIiBeC_xHqqkZx_
};

/*************************************************************************
 * <_xZkqqHx_jHpBiLjD_xHqqkZx_>	FTArrowClassType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCArrow_xZkqqHx_iDeOiDiJiDfIiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
enum FTArrowClassType
{
	FDAW_NONE = 0,
	FDAW_BASE,			// FCArrowBase_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
	FDAW_STANDARD,		// FCStdArrow_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
	FDAW_PICTURE,		// FCPictArrow_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
}; // enum FTArrowClassType.

// _xZkqqHx_iDfIiDfOiDeDiDiLiCmMjBoFiCkLiClDiCmMiNmFjBoFjCgMiBeC_xHqqkZx_
#define FDUG_ARW_SIZE_MAX		8

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCUGArrowParams
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAjGoOiIpDiCmMiCfDiCmCiCmMiDhAiDiJiDiBiBfLiDfOiCpAiLeMjIfOiClHiCoJiClNiCnPiCmMiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCfDiCmCiCmMiDhAiDiJiDiBiBfLiDfOiCmNiBeBiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCUGArrowParams
{
	FCUGArrowParams () {}
	FCUGArrowParams (BYTE byT, BYTE byP0, BYTE byP1, BYTE byP2)
		: byType(byT), byParam0(byP0), byParam1(byP1), byParam2(byP2) {}
	BYTE byType;
	BYTE byParam0;
	BYTE byParam1;
	BYTE byParam2;
}; // struct FCUGArrowParams.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCUGPqr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAjGoOiIpDiCmMiMgAiCpAiMiIjCoIiClHiCoJjCgM_xHqqkZx_P,Q,R_xZkqqHx_iCpAiLeMjIfOiClHiCoJiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCUGPqr
{
	FCUGPqr () {}
	FCUGPqr (double p, double q, double r) : dP(p), dQ(q), dR(r) {}
	double dP;
	double dQ;
	double dR;
}; // struct FCUGPqr.

//;------ </EXPORT TO SDK> -----;

// 03.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "../MolipSDK/FCArrowExp.h"	// Superclass.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCBaseArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHiCpAiLeMjIfOiClHiCoJiDeOiDiJiDfIiBeCiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCBaseArrow
{
public:
	FCBaseArrow (BOOL bWidePoly);
	virtual ~FCBaseArrow ();
	virtual void	MakeFitBezier (	FCMmPolyBezier& polyBezier,
									mmetol& mmP,
									mmetol& mmQ,
									DBLPoint& mmptA,
									DBLPoint& mmptB,
									mmetol mmH,
									mmetol mmMinH) const;
	virtual void	InitByPoly (DBLPointVector& vmmptPoly, mmetol mmH, mmetol mmElemLen,
								PenStyleID psidPenStyle, fmmetol mmfPenWeight,
								SColorID scidPenBackSColor, PatternID ptidBrushPattern,
								SColorID scidBrushForeSColor, SColorID scidBrushBackSColor,
								SColorID scidShadowSColor);
	virtual void	FillArrow (CDC* pDC, mmetol mmElemLen, SColorID scid, const CRect& lgrtRgn) const;
//----------<NOT EXPORT TO VIEWER>-----------
	virtual void	FillArrow (FCEditDraw& eDraw, mmetol mmElemLen) const;
//----------</NOT EXPORT TO VIEWER>-----------
	virtual void	CalcOuterFrame (DBLRect& mmrtFrame, const DBLPoint& mmptEdge,
									mmetol mmH, fmmetol mmfPenWeight) const;
	virtual void	CalcAffectFrame (DBLRect& mmrtFrame, const DBLPoint& mmptEdge,
									mmetol mmH, fmmetol mmfPenWeight) const;
	virtual void	Release ();

public:
	virtual FTArrowClassType	Type () const = 0;
	virtual mmetol	GetP (mmetol mmH) const = 0;
	virtual DBLRect	GetFrame (mmetol mmH, fmmetol mmWeight) const = 0;
	virtual void	InitArrow (	mmetol mmH, const DBLPoint& mmptA, const DBLPoint& mmptB,
								PenStyleID psidPenStyle, fmmetol mmfPenWeight,
								SColorID scidPenBackSColor, PatternID ptidBrushPattern,
								SColorID scidBrushForeSColor,
								SColorID scidBrushBackSColor, SColorID scidShadowSColor) = 0;
	virtual void	GetPolygon (DBLPointVector& vmmptPoly, mmetol mmElemLen) const = 0;
	virtual void	GetBezier (FCMmPolyBezier& polyBezier) const = 0;

	virtual DBLRect	CalcExactOuterFrame (fmmetol mmfPenWeight) const = 0;
	virtual void	PreDraw (CDC* pDC, BOOL bIsMono) const = 0;
	virtual void	PostDraw (CDC* pDC, BOOL bIsMono) const = 0;
	virtual void	DrawShadow (CDC* pDC) = 0;

protected:
	virtual void	GetPostPolyline (DBLPointVector& vmmptPoly) const;
	virtual mmetol	GetP (mmetol mmH, const FCUGPqr& pqr) const;
	virtual FCObjPictArrow*			GetLocalObject () const;
	virtual const FCObjPictArrow*	GetStdObject () const;

protected:
	BOOL			m_bWidePoly;
}; // class FCBaseArrow.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCStdArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAjGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHiCpAiLeMjIfOiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCStdArrow : public FCBaseArrow
{
protected:
typedef FCBaseArrow BASE_CLASS;

public:
	FCStdArrow (const FCUGArrowParams& params, BOOL bWidePoly);
	virtual FTArrowClassType	Type () const;
	virtual mmetol	GetP (mmetol mmH) const;
	virtual DBLRect	GetFrame (mmetol mmH, fmmetol mmWeight) const;
	virtual void	InitArrow (	mmetol mmH, const DBLPoint& mmptA, const DBLPoint& mmptB,
								PenStyleID psidPenStyle, fmmetol mmfPenWeight,
								SColorID scidPenBackSColor, PatternID ptidBrushPattern,
								SColorID scidBrushForeSColor,
								SColorID scidBrushBackSColor, SColorID scidShadowSColor);
	virtual void	GetPolygon (DBLPointVector& vmmptPoly, mmetol mmElemLen) const;
	virtual void	GetBezier (FCMmPolyBezier& polyBezier) const;
	virtual DBLRect	CalcExactOuterFrame (fmmetol mmfPenWeight) const;
	virtual void	PreDraw (CDC* pDC, BOOL bIsMono) const;
	virtual void	PostDraw (CDC* pDC, BOOL bIsMono) const;
	virtual void	DrawShadow (CDC* pDC);

protected:
	virtual void	GetPostPolyline (DBLPointVector& vmmptPoly) const;
	virtual mmetol	GetP (mmetol mmH, const FCUGPqr& pqr) const;

protected:
	FCUGArrowParams	m_params;
	DBLPoint		m_mmptaC[5];
	PenStyleID		m_psidPenStyle;
	mmetol			m_mmH;
	fmmetol			m_mmfPenWeight;
	SColorID		m_scidPenBackSColor;
	SColorID		m_scidShadowSColor;
}; // class FCStdArrow.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCPictArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDeJiDhFiDfHiDeGiDeOiDgHiCpAiLeMjIfOiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCPictArrow : public FCBaseArrow
{
protected:
typedef FCBaseArrow BASE_CLASS;

public:
	FCPictArrow (PictArrowID paid, BOOL bWidePoly);
	virtual ~FCPictArrow ();
	virtual FTArrowClassType	Type () const;
	virtual mmetol	GetP (mmetol mmH) const;
	virtual DBLRect	GetFrame (mmetol mmH, fmmetol mmWeight) const;
	virtual void	InitArrow (mmetol mmH, const DBLPoint& mmptA, const DBLPoint& mmptB,
								PenStyleID psidPenStyle, fmmetol mmfPenWeight,
								SColorID scidPenBackSColor, PatternID ptidBrushPattern,
								SColorID scidBrushForeSColor,
								SColorID scidBrushBackSColor, SColorID scidShadowSColor);
	virtual void	GetPolygon (DBLPointVector& vmmptPoly, mmetol mmElemLen) const;
	virtual void	GetBezier (FCMmPolyBezier& polyBezier) const;
	virtual DBLRect	CalcExactOuterFrame (fmmetol mmfPenWeight) const;
	virtual void	PreDraw (CDC* pDC, BOOL bIsMono) const;
	virtual void	PostDraw (CDC* pDC, BOOL bIsMono) const;
	virtual void	DrawShadow (CDC* pDC);

protected:
	virtual FCObjPictArrow*			GetLocalObject () const;
	virtual const FCObjPictArrow*	GetStdObject () const;

//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	static void	PenBrushConvert (	FCObjDynabase* pObj,			// _xZkqqHx_jBmOiPnLjFjEjFgJiBeC_xHqqkZx_
//									BYTE byDuty,					// _xZkqqHx_jFjEjFgJiCmMjGpAiKiEiBeC_xHqqkZx_
//									PenStyleID psidPenStyle,		// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
//									fmmetol mmfPenWeight,			// _xZkqqHx_iDhJiDjDjFjNiBeC_xHqqkZx_
//									mmetol mmPenWidth,				// _xZkqqHx_iDhJiDjDjFjNiBgJjFjNiNeMjFjEjFgJiCmMiPoKiNiHiCmNjFjNiBgK_xHqqkZx_
//									double dRatio,					// _xZkqqHx_iDhJiDjDiKgHjBoFjHkGiBeC_xHqqkZx_
//									SColorID scidPenBackSColor,		// _xZkqqHx_iDhJiDjDjEhHiMgJjAeGiBeC_xHqqkZx_
//									PatternID ptidBrushPattern,		// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
//									SColorID scidBrushForeSColor, 	// _xZkqqHx_iDhFiDiJiDfGjBePiMgJjAeGiBeC_xHqqkZx_
//									SColorID scidBrushBackSColor,	// _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiBeC_xHqqkZx_
//									SColorID scidShadowSColor);		// _xZkqqHx_iJgFjAeGiBeC_xHqqkZx_
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
protected:
	PictArrowID		m_paid;
	FCObjPictArrow*	m_pArrow;
}; // class FCPictArrow.

//----------<NOT EXPORT TO VIEWER>-----------
extern const wchar_t* GetArrowStyleName (int index);
extern const wchar_t* GetArrowSizeName (int index);
//----------</NOT EXPORT TO VIEWER>-----------
extern void CalcPQR (FCUGPqr& pqr, double mmWeight, const FCUGArrowParams& params);

#endif//__Arrow_h

