// ArrowEditorDoc.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "RegData.h"		// For GetOptiRegColor.
#include "UtilStr.h"		// For GetResString.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilMath.h"		// For mmroundoff.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilObj.h"		// For FFObjTypeToStr.
#include "Arrow.h"			// For FDUG_ARW_TYPE_PICT.etc.
#include "CommonEditorFrame.h"// For CFCCommonEditorFrame.
#include "ObjPictArrow.h"	// For FCObjPictArrow.
#include "ObjPoly.h"		// For FCObjPoly.
#include "ZOrder.h"			// For FCZOrder.
#include "LayerManager.h"	// For CurrentSheet().
#include "SheetManager.h"	// For FCSheetManager.
#include "DynamicDrawView.h"	// For g_pView.
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#include "PrsObjProperty.h"			// For CFCPrsObjProperty.
#include "ProObjDynabaseUserId.h"	// For CFCProObjDynabaseUserId.
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
#include "ArrowEditorDoc.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAiOkGiClHiDhEiDeIiDjDiDgHiCmMiNiCiClDiBeCiDhDiDeOiDfKiDiLiBeC_xHqqkZx_
#define FDAE_ARFRAME_FONT_HEIGHT	30

//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDgIiDeMiDiFiDiBiDjDiDgHjFmPjAjEiBeC_xHqqkZx_
//CFCArrowEditorDoc* g_pArrowEditorDoc = NULL;
//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


/////////////////////////////////////////////////////////////////////////////
// CFCArrowEditorDoc

IMPLEMENT_DYNCREATE(CFCArrowEditorDoc, CFCCommonEditorDoc)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::CFCArrowEditorDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCArrowEditorDoc::CFCArrowEditorDoc ()
{
	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	m_mmrtPictArrowFrame[0] = mmroundoff(DBLRect(150, 200, 350, 250));
	m_mmrtPictArrowFrame[1] = mmroundoff(DBLRect(150, 200, 350, 250));
	// _xZkqqHx_iDhJiDjDjBlOiClDiCmMiNmFjCoBjCgMiBeC_xHqqkZx_
	m_mmaMinArrowPenWeight[0] = 0.0;
	m_mmaMinArrowPenWeight[1] = 0.0;

//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
	m_pObjArrow = NULL;
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCArrowEditorDoc::CFCArrowEditorDoc.

//----- 02.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnNewDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDgIiDeMiDiFiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCArrowEditorDoc::OnNewDocument ()
//{
//	if (!BASE_CLASS::OnNewDocument())
//		return FALSE;
//	return TRUE;
//} // CFCArrowEditorDoc::OnNewDocument.
//----- 02.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::~CFCArrowEditorDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCArrowEditorDoc::~CFCArrowEditorDoc ()
{
} // CFCArrowEditorDoc::~CFCArrowEditorDoc.

BEGIN_MESSAGE_MAP(CFCArrowEditorDoc, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCArrowEditorDoc)
	ON_COMMAND(ID_FILE_COMEDT_SAVE_EXIT, OnFileComedtSaveExit)
	ON_UPDATE_COMMAND_UI(ID_FILE_COMEDT_SAVE_EXIT, OnUpdateFileChpedSaveExit)
	ON_COMMAND(ID_ARROWEDIT_PROPERTY, OnArroweditProperty)
	ON_UPDATE_COMMAND_UI(ID_ARROWEDIT_PROPERTY, OnUpdateArroweditProperty)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCArrowEditorDoc_xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::UnregisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_jDgPjIfOiCkJiCoHiCmNiClIiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.24 Fukushiro M. _xZkqqHx_iIoKjFjEiLeAjEfMiCpA_xHqqkZx_CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::UnregisterObject (FCObjDynabase* pObj)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnregisterObject(pObj);
} // CFCArrowEditorDoc::UnregisterObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::ReceiveStreamAndInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCkJiCoHjBjHjAeNiClDiCoKiCoJiDgGiBfLiDfOiCpAiOpDjAeNiClFiBeBiDfIiDgHiDiKiBfLiDiAiCmJ_xHqqkZx_
 *			_xZkqqHx_jDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndDraw	:Molip Draw_xZkqqHx_iCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCMainFrame_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			99.11.02 Fukushiro M. _xZkqqHx_jFjEjFgJiCkKjFkBiNiHiDgAiDgCiDhGiCmMiPoKiNiHiJpAjBmMiClHiCoJiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::ReceiveStreamAndInit (HWND hwndDraw)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeCiOmAiNnLiCmJiDgGiBfLiDfOiCpAiOpDjAeNiClFiBeBiDfGiBfLiDgHiCmJjFjEjFgJiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
	BASE_CLASS::ReceiveStreamAndInit(hwndDraw);

//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iJlKiCmM_xHqqkZx_FCObjDynabase::RegisterObjID()_xZkqqHx_iCmJiCoGiCmBiCmEjFjEjFgJiCpAjDgPjIfOiClHiCoJiNnLiBeB_xHqqkZx_
	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkK_xHqqkZx_Open_xZkqqHx_iClFiCmEiCkCiCoJiClBiCmGiCkKjFeLjHhGiCmFiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiClNiCnPiCmJiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEjFmCiClGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
	SessionBegin();
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	SessionEnd();

	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pObjArrow = new FCObjPictArrow();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_0,_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1_xZkqqHx_iCmMiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAiJpAjBmMiClHiCoJiBeC_xHqqkZx_
	for (int id = 0; id != 2; id++)
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCZOrder zOrder;
		SheetManager()->GetSheet(id)->GetZOrder(zOrder, FDOZ_ON_ANY);
		if (zOrder.Size() == 1)
		{
			FCObjPictArrow* pArrow = (FCObjPictArrow*)zOrder.Front();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			if (id == 0)
			//----- _xZkqqHx_iDfGiBfLiDgHiCePiCmMiDhDiDeOiDgAiDiDjGoOiIpDiCkJiCoHiPoOjFpBiCpAiOoGjDlO_xHqqkZx_ -----
			{
				// _xZkqqHx_iClBiCmM_xHqqkZx_FCDynabase_xZkqqHx_iDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAjFnLjBlGjHhAiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCmJiDfCiDhDiBfLiBeC_xHqqkZx_
				pArrow->FCObjDynabase::CopySelf(m_pObjArrow);
			}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
			SetPictArrowFrame(id, pArrow->GetArrowFrame());
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhJiDjDjBlOiClDiNmFjCoBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
			SetMinArrowPenWeight(id, pArrow->GetMinArrowPenWeight());
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//			SetObjUserUlong(pArrow->GetObjUserUlong());
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jGoOiIpDiCmMjGpAiKiEiCpAjAnNjCoIiBeC_xHqqkZx_
			for (short nIndex = 0; nIndex != pArrow->GetMemberSize(); nIndex++)
				SetPictArrowDuty(id, pArrow->GetMember(nIndex),
									pArrow->GetDuty(nIndex));
			// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJiDePiDiLiBfLiDhGiDiBiDjDiDgPjFjEjFgJiCpAjBhNjDpMiBeC_xHqqkZx_
			SheetManager()->GetSheet(id)->AppendToLZOrder(pArrow->GetMemberArray(),
															pArrow->GetMemberSize());
			// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjCiGiCmMiDiBiDjDiDgPjFjEjFgJiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeCiDePiDiLiBfLiDhGjFjEjFgJiNoNiPjMiOjOiCmJ_xHqqkZx_
			// _xZkqqHx_iIoKiPiPiCmJiNoNiPjMiClDiCoKiCoJiClBiCmGiCkKiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
			pArrow->ClearGroup();
			// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			SheetManager()->GetSheet(id)->RemoveFromLZOrder(pArrow);
			// _xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			pArrow->UnregisterObjID();
//----- 02.05.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
//			// _xZkqqHx_jFjEjFgJiCmMiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
//			pArrow->Terminate();
//----- 02.05.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)-----
			// _xZkqqHx_jFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
			delete pArrow;
		}
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFnLjBlGjHhAiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAjDgPjIfOiBeCjDmHiCnNiNjOiCpBiClOiDgGiBfLiDfOiCmM_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCmMjDgPjIfOiCkKiPeJiCoNiCmBiCmEiCkJiCoHjDgPjIfOiClHiCoJiClNiCnPiBeBiClBiClBiCmJiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOiClFiCmEiCoAiBeBiDfGiBfLiDgHiCmJjDpMiCoKiCmIiCkPiCoKiCmOjFnLjBlGiClDiCoKiCmIiCkCiCkJiCoHjBoFiPoEjFhGiBeC_xHqqkZx_
	m_pObjArrow->RegisterObjID();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCpBiClOiMoDiPiIjHjNiBeC_xHqqkZx_
	AfterLoadDocument(TRUE);
	// _xZkqqHx_iJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->Invalidate();
//----- 05.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCmMjCiGjAfDjDfPiCpAiDhCiDiFiBfLiCmMjCiGjAfDiCmJiBeC_xHqqkZx_
	g_pView->SetScrollCenter(GetPictArrowFrame(0).CenterPoint());
} // CFCArrowEditorDoc::ReceiveStreamAndInit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::SendStreamAndEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiBfLiLeOjDkOiMlDiDeBiDhGiDiKiCmJiDgGiBfLiDfOjBjHjAeNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::SendStreamAndEnd ()
{
//----- 05.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jGoOiIpDiDeHiDgGiDeCiDfOiCpAiLeOjDkOiClFiCmEiCkJiCoHiIoKjDhIiCoAiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkCiCmIiCkCiCmGiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjFmCiClGiClNiCnMiCnMiClBiClBiCmJjHiIiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	// _xZkqqHx_iJlKiCmM_xHqqkZx_FCObjDynabase::RegisterObjID()_xZkqqHx_iCmJiCoGiCmBiCmEjFjEjFgJiCpAjDgPjIfOiClHiCoJiNnLiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkK_xHqqkZx_Open_xZkqqHx_iClFiCmEiCkCiCoJiClBiCmGiCkKjFeLjHhGiCmFiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiClNiCnPiCmJiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEjFmCiClGiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
//	SessionBegin();
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	SessionEnd();
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMiDePiDiLiBfLiDhGiJlLiCpAiNhDiCkEiClNiCnPiBeBjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
//----- 05.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_0,_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1_xZkqqHx_iCmMiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAiJpAjBmMiClHiCoJiBeC_xHqqkZx_
	for (int id = 0; id != 2; id++)
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCZOrder zOrder;
		SheetManager()->GetSheet(id)->GetZOrder(zOrder, FDOZ_ON_ANY);
		if (zOrder.Size() != 0)
		{
			//-------------------------------------------------------------
			// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCpA_xHqqkZx_FCObjPictArrow_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCmJjEfLiCnPiCmEiBeB_xHqqkZx_
			// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjCiGiCmJiCmN_xHqqkZx_FCObjPictArrow_xZkqqHx_iCmMiCnNiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
			//-------------------------------------------------------------
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAjAlGjAkMiBeC_xHqqkZx_
			FCObjPictArrow* pObjArrow = new FCObjPictArrow();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_iClBiCmM_xHqqkZx_FCDynabase_xZkqqHx_iDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAjFnLjBlGjHhAiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
			m_pObjArrow->FCObjDynabase::CopySelf(pObjArrow);
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
			pObjArrow->RegisterObjID();
			// _xZkqqHx_jBfDiChJiDeJiBfLiDfPiBfLiCpAjCmKiClFiCmFiOoGjDlOiBeC_xHqqkZx_
			ObjDynabaseVector vObj;
			zOrder.GetAllOrder(vObj);
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCmJiMlLiNnNiCmMjFjEjFgJjBfDiCmEiCpAiDePiDiLiBfLiDhGjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
			pObjArrow->SetGroup(vObj);
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
			pObjArrow->SetArrowFrame(GetPictArrowFrame(id));
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhJiDjDjBlOiClDiNmFjCoBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
			pObjArrow->SetMinArrowPenWeight(GetMinArrowPenWeight(id));
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//			pObjArrow->SetObjUserUlong(GetObjUserUlong());
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			//----- _xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmMjGpAiKiEiPoOjFpBiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
			BYTEVector byvArrowDuty;
			ObjDynabaseVector::const_iterator iObj;
			for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
				byvArrowDuty.push_back(GetPictArrowDuty(id, *iObj));
			pObjArrow->SetDuty(byvArrowDuty);
			// _xZkqqHx_jGhLjBmMjAnKjBlBjFjEjFgJiBeC_xHqqkZx_
			FCObjPoly* pPoly = (FCObjPoly*)pObjArrow->GetArrowDutyObject();
			if (pPoly != NULL)
			{
				// _xZkqqHx_iCoAiClFjIeBiMiLjDfPjEhKjHpBiCkKiLhEiBgJiPoDiCkJiCoHiJlKiBgKiCmIiCoHiCmOiBeBjDpMjBnGiCkGiCoJiBeC_xHqqkZx_
				if (pPoly->m_pJoint[0].m_mmptPivot.y <
					pPoly->m_pJoint[pPoly->m_lJoint - 1].m_mmptPivot.y)
					ReversePolyJoint(pPoly->m_pJoint, pPoly->m_lJoint);
			}
			// _xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCmMjFjEjFgJjDgPjIfOiCpAiJpAiPjMiBeC_xHqqkZx_
			SheetManager()->GetSheet(id)->RemoveFromLZOrder(vObj);
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCmMiCnNiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
			SheetManager()->GetSheet(id)->AppendToLZOrder(pObjArrow);
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::SendStreamAndEnd();
} // CFCArrowEditorDoc::SendStreamAndEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnDrawBackView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView::OnDraw_xZkqqHx_iCmMjEhHiMgJjFgAiJoGiBeCiDeHiDgGiDeCiDfOjDjJiCmMiDgIiDeMiDiFiDiBiDjDiDgHjFmKiCmMjDmBjFmKiCmI_xHqqkZx_
 *			_xZkqqHx_jEhHiMgJjFgAiJoGiCpAjCfDjDjGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::OnDrawBackView (CDC* pDC)
{
	//----- Head/Tail/Upper/Lower_xZkqqHx_jApMiCpAjFgAiJoG_xHqqkZx_ -----
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC);
	atDC.SetPen(PS_SOLID, 2, g_pReg->GetOptiRegColor(FDCL_GRID));
	DBLRect mmrtArrow = GetPictArrowFrame(GetCurrentSheetId());
	DBLRect mmrtArrowEx = mmrtArrow.ExtendRect(20);
	CRect lgrtArrow = mm2lg(mmrtArrow);
	CRect lgrtArrowEx = mm2lg(mmrtArrowEx);
	// Upper line _xZkqqHx_jFgAiJoGiBeC_xHqqkZx_
	atDC.MoveTo(lgrtArrowEx.left, lgrtArrow.top);
	atDC.LineTo(lgrtArrowEx.right, lgrtArrow.top);
	// Lower line _xZkqqHx_jFgAiJoGiBeC_xHqqkZx_
	atDC.MoveTo(lgrtArrowEx.left, lgrtArrow.bottom);
	atDC.LineTo(lgrtArrowEx.right, lgrtArrow.bottom);
	// Head line _xZkqqHx_jFgAiJoGiBeC_xHqqkZx_
	atDC.MoveTo(lgrtArrow.left, lgrtArrowEx.top);
	atDC.LineTo(lgrtArrow.left, lgrtArrowEx.bottom);
	// Tail line _xZkqqHx_jFgAiJoGiBeC_xHqqkZx_
	atDC.MoveTo(lgrtArrow.right, lgrtArrowEx.top);
	atDC.LineTo(lgrtArrow.right, lgrtArrowEx.bottom);

	// VCenter line _xZkqqHx_jFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 1, g_pReg->GetOptiRegColor(FDCL_GRID));
	atDC.MoveTo(mm2lg(mmrtArrow.right - 100.0), mm2lg((mmrtArrow.top + mmrtArrow.bottom) / 2.0));
	atDC.LineTo(mm2lg(mmrtArrow.right + 100.0), mm2lg((mmrtArrow.top + mmrtArrow.bottom) / 2.0));

	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLjHhAiCmMiDhEiDeIiDjDiDgHiCmMiPiAjEpF_xHqqkZx_ -----
	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	LOGFONT logFont;
	g_pReg->InitRegFont(logFont, FDFT_TOOLBAR);
	logFont.lfHeight = -FDAE_ARFRAME_FONT_HEIGHT;
	// _xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	atDC.SetFont(&logFont);
	atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_GRID));
	atDC.SetBkMode(TRANSPARENT);
	CRect lgrtText;

	lgrtText.SetRect(lgrtArrow.left - FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.top - FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrow.left + FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.top);
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	atDC.DrawText(L"H", 1, lgrtText, DT_CENTER);
	atDC.DrawText(L"H", 1, CP_ACP, lgrtText, DT_CENTER);
	lgrtText.SetRect(lgrtArrow.right - FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.top - FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrow.right + FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.top);
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	atDC.DrawText(L"T", 1, lgrtText, DT_CENTER);
	atDC.DrawText(L"T", 1, CP_ACP, lgrtText, DT_CENTER);
	lgrtText.SetRect(lgrtArrowEx.right,
					 lgrtArrow.top - 0.5 * FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.right + FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrow.top + 0.5 * FDAE_ARFRAME_FONT_HEIGHT);
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	atDC.DrawText(L"U", 1, lgrtText, DT_CENTER);
	atDC.DrawText(L"U", 1, CP_ACP, lgrtText, DT_CENTER);
	lgrtText.SetRect(lgrtArrowEx.right,
					 lgrtArrow.bottom - 0.5 * FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrowEx.right + FDAE_ARFRAME_FONT_HEIGHT,
					 lgrtArrow.bottom + 0.5 * FDAE_ARFRAME_FONT_HEIGHT);
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	atDC.DrawText(L"L", 1, lgrtText, DT_CENTER);
	atDC.DrawText(L"L", 1, CP_ACP, lgrtText, DT_CENTER);

} // CFCArrowEditorDoc::OnDrawBackView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::GetPictArrowFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect CFCArrowEditorDoc::GetPictArrowFrame (int iSheetId) const
{
	return m_mmrtPictArrowFrame[iSheetId];
} // CFCArrowEditorDoc::GetPictArrowFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::SetPictArrowFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::SetPictArrowFrame (int iSheetId, const DBLRect& mmrtFrame)
{
	m_mmrtPictArrowFrame[iSheetId] = mmrtFrame;
} // CFCArrowEditorDoc::SetPictArrowFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::GetMinArrowPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol CFCArrowEditorDoc::GetMinArrowPenWeight (int iSheetId) const
{
	return m_mmaMinArrowPenWeight[iSheetId];
} // CFCArrowEditorDoc::GetMinArrowPenWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::SetMinArrowPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::SetMinArrowPenWeight (int iSheetId, mmetol mmPenWeight)
{
	m_mmaMinArrowPenWeight[iSheetId] = mmPenWeight;
} // CFCArrowEditorDoc::SetMinArrowPenWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::GetPictArrowDuty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCmMjGoOiIpDjGpAiKiEiCkIiCoGiCnBiDePiDiJiDhEiDeCiDeOiDfIjBkOjAkLiMhAiPlDiCmMiDhEiDiJiDePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iSheetId	:_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDePiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTE CFCArrowEditorDoc::GetPictArrowDuty (int iSheetId, const FCObjDynabase* pObj) const
{
	FDObjToArrowDuty::const_iterator iOd;
	iOd = m_mpObjToDuty[iSheetId].find(pObj);
	if (iOd == m_mpObjToDuty[iSheetId].end()) return 0;
	return (*iOd).second;
} // CFCArrowEditorDoc::GetPictArrowDuty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::SetPictArrowDuty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCmMjGoOiIpDjGpAiKiEiCkIiCoGiCnBiDePiDiJiDhEiDeCiDeOiDfIjBkOjAkLiMhAiPlDiCmMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iSheetId	:_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			byDuty		:_xZkqqHx_iDhEiDiJiDePiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::SetPictArrowDuty (int iSheetId, const FCObjDynabase* pObj, BYTE byDuty)
{
	m_mpObjToDuty[iSheetId][pObj] = byDuty;
} // CFCArrowEditorDoc::SetPictArrowDuty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::GetPictArrowDutyMap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjGpAiKiEiPoOjFpBiCmMiDiKiDfIiDgHiCpAiKnLiClCiCmGjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FDObjToArrowDuty& CFCArrowEditorDoc::GetPictArrowDutyMap (int iSheetId) const
{
	return m_mpObjToDuty[iSheetId];
} // CFCArrowEditorDoc::GetPictArrowDutyMap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::IsPictArrowForbidden
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCkKiLnGiOhOiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCkAiCnMiCoIjEpMiClFiCkCiCoCiCoIjFpLiCmFiCmNiCmIiCkCiCkKiBeB_xHqqkZx_PrpObjFigure4_xZkqqHx_iCmFiBeBiDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_
 *			_xZkqqHx_iCpAiLnGiOhOiClHiCoJiClNiCnPiCmJiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCArrowEditorDoc::IsPictArrowForbidden () const
{
	return TRUE;
} // CFCArrowEditorDoc::IsPictArrowForbidden.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::CmdCreate1Obj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFjEjFgJiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::CmdCreate1Obj (FCObjDynabase* objp, SheetID stid, const FCLayerZOrder& lzorder)
{
	ASSERT(objp->IsKindOf(FDOJ_FIGURE));
	FCObjFigure* pFig = (FCObjFigure*)objp;
	//----- _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiPoKiNiHiCmNiBeBiDhEiDiJiDgCiDgHiCmJjFmPiNfIiClHiCoJ_xHqqkZx_ -----
	if (pFig->GetArrowFType() == FDUG_ARW_TYPE_PICT)
		pFig->SetArrowFType(FDUG_ARW_TYPE_FLAT);
	if (pFig->GetArrowBType() == FDUG_ARW_TYPE_PICT)
		pFig->SetArrowBType(FDUG_ARW_TYPE_FLAT);
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CmdCreate1Obj(objp, stid, lzorder);
} // CFCArrowEditorDoc::CmdCreate1Obj.

//----- 05.04.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::CmdDelete1Obj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFjEjFgJiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_ChipEditor_xZkqqHx_iCmFiCmNiBeBjFjEjFgJiNoNiPjMiOjOiCmJjGpAiKiEiDgFiBfLiDhFiDiL_xHqqkZx_
// *			_xZkqqHx_iCkJiCoHjDgPjIfOjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeBiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiClNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_iNoNiPjMiClHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCArrowEditorDoc::CmdDelete1Obj (FCObjDynabase* objp)
//{
//	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CmdDelete1Obj(objp);
//} // CFCArrowEditorDoc::CmdDelete1Obj.
//----- 05.04.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::GetForbiddenObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmFiIlFiCkCiCkKiLnGiOhOiClDiCoKiClNjFjEjFgJiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiOoNiBeCiOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiNmFiMoDiCmIiCoHiCmO_xHqqkZx_ FDOJ_NONE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiOoNiCmMiDfEiDhFiDeOiDiJiDfIjBfDiCmEiCkKiLnGiOhOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTObjectType CFCArrowEditorDoc::GetForbiddenObject (long lIndex) const
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmGiDhMiDeDiDjDiDgHjFjEjFgJiCpAiLnGiOhOiClHiCoJiBeC_xHqqkZx_
	// OLE_xZkqqHx_jFjEjFgJiCoAiIlFiCkGiCmIiCkCiCkKiBeB_xHqqkZx_Baseclass_xZkqqHx_iCmFiLnGiOhOiClDiCoKiCoJiCmMiCmFiClBiClBiCmFiCmNiNnKiClJiCmIiCkCiBeC_xHqqkZx_
	static FTObjectType s_ObjKind[] = { FDOJ_GROUP, FDOJ_POINT };
	static int s_iObjKindCount = sizeof(s_ObjKind) / sizeof(s_ObjKind[0]);
	if (s_iObjKindCount <= lIndex)
		return BASE_CLASS::GetForbiddenObject(lIndex - s_iObjKindCount);
	return s_ObjKind[lIndex];
} // CFCArrowEditorDoc::GetForbiddenObject.

/////////////////////////////////////////////////////////////////////////////
// CFCArrowEditorDoc _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void CFCArrowEditorDoc::AssertValid() const
{
	BASE_CLASS::AssertValid();
} // CFCArrowEditorDoc::AssertValid.

void CFCArrowEditorDoc::Dump(CDumpContext& dc) const
{
	BASE_CLASS::Dump(dc);
} // CFCArrowEditorDoc::Dump.
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFCArrowEditorDoc _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCArrowEditorDoc _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::DeleteContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiDgGiBfLiDfOiCpAiNoNiPjMiClFiBeBiNmEiCnBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiOkJjAgHiCmNjEgKiKpMiClJiClIiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiClHiCoJiClNiCnPiCmJiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkKiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnNewDocument
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnOpenDocument
 *			_xZkqqHx_iBeF_xHqqkZx_CFrameWnd::OnClose
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjEgKiKpMiOjOiCmJiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCoJiOjOiCmNiBeBiKpJiCmJ_xHqqkZx_View_xZkqqHx_iCmNjEgKiKpM_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiCkCiCoJiClBiCmGiCmJjCiNiInD_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiIoKjFjEiLeAjEfMiCpAiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::DeleteContents ()
{
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pObjArrow != NULL)
	//----- _xZkqqHx_jFnLjBlGjHhAiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDgPjIfOiCpAiJpAiPjMiBeC_xHqqkZx_
		m_pObjArrow->UnregisterObjID();
		// _xZkqqHx_iNoNiPjMiBeC_xHqqkZx_
		delete m_pObjArrow;
		m_pObjArrow = NULL;
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::DeleteContents();
} // CFCArrowEditorDoc::DeleteContents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnFileComedtSaveExit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjGoOiIpDiCpAjDgPjIfOiClFiPeJjHlJiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGoOiIpDiDeHiDgGiDeCiDfOiCmMiDfIiDgHiDiKiBfLiDiAiCpA_xHqqkZx_Molip Draw_xZkqqHx_iCnGjDfNjBjHiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.15 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			99.01.10 Fukushiro M. OLEAutomation_xZkqqHx_iCkJiCoH_xHqqkZx_Message_xZkqqHx_iDhIiBfLiDfIjFmPiNfIiCmJ_xHqqkZx_
 *									_xZkqqHx_jElKiCmBiCmEjAfGiLeLiCmJiNoMjAkM_xHqqkZx_
 *			99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::OnFileComedtSaveExit ()
{
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCZOrder zOrder;
//	GetZOrder(zOrder, FDOZ_ON_ANY);
//	// _xZkqqHx_jFjEjFgJjAjEiCkKiCePiBeDiIlNiCkCiCmNiDhMiDeDiDjDiDgHjFjEjFgJiCmMiCnNiCmMiPoKiNiHiCmNiDfKiBfLiDhFiClJiClIiPeJjHlJiBeC_xHqqkZx_
//	if (zOrder.IsEmpty() ||
//		(zOrder.Size() == 1 && zOrder.Front()->Type() == FDOJ_POINT))
//	{
//		// IDS_MSG_INVALID_ARROW_END = "_xZkqqHx_jDgPjIfOjGlDiMpI_xHqqkZx_(_xZkqqHx_jFjEjFgJiCkKjGlDiCkC_xHqqkZx_/_xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiCmMiCnN_xHqqkZx_)_xZkqqHx_iCmFiClHiBeC_xHqqkZx_"
//		// IDS_MSG_IS_QUIT_NO_REGISTER = "_xZkqqHx_jDgPjIfOiClJiClIiPeJjHlJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//		if (FFMessageBox(FFLoadWString(IDS_MSG_INVALID_ARROW_END) + L"\r\n" +
//						FFLoadWString(IDS_MSG_IS_QUIT_NO_REGISTER), 0, MB_OKCANCEL) == IDOK)
//		{
//			// _xZkqqHx_iClBiCmMiCnMiCnMiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//			ExitApplication();
//		}
//		return;
//	}
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiMmEiCnBiPgPiClFiMlDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCmJiClHiCoJiBeC_xHqqkZx_
//	::SetForegroundWindow(CFCCommonEditorFrame::GetMasterAppFrame());
//	// _xZkqqHx_iKmCiLkLiPoOjFpBiCmGjFjEjFgJiPoOjFpBiCpAiPjBiCkLiPgPiClFiBeBiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//	SendStreamAndEnd();
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCZOrder zOrder;
//	GetZOrder(zOrder, FDOZ_ON_ANY);
//	// _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiDgAiDeGiDgCiDeOiClFiBeBjAhNiMgAiMgOiCmFiCmIiCkPiCoKiCmOiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
//	FCZOrderIterator iObj;
//	for (zOrder.Begin(iObj); !iObj.IsEnd(); iObj++)
//	{
//		if (!(*iObj)->IsKindOf(FDOJ_FIGURE))
//			break;
//	}
//	if (!iObj.IsEnd())
//	//----- _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCjFjEjFgJiCpAjBeJjBpAiBeC_xHqqkZx_
//		g_pView->ClearSelectObj(TRUE);
//		g_pView->AppendSelectObj(*iObj, TRUE);
//		// _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiKnMiCnMiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_
//		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmJjDgPjIfOiCmFiCkLiCoJiCmMiCmNjAhNiMgAiMgOjFjEjFgJiCmMiCnNiCmFiClHiBeC_xHqqkZx_
//		// IDS_MSG_IS_QUIT_NO_REGISTER = "_xZkqqHx_jDgPjIfOiClJiClIiPeJjHlJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
//		WString wstrMessage;
//		wstrMessage.Format(	IDS_ERR_MSG_INVALID_OBJECT_FOR_ARROW, 
//							FFObjTypeToStr((*iObj)->Type()));
//		if (FFMessageBox(wstrMessage + L"\r\n" +
//						FFLoadWString(IDS_MSG_IS_QUIT_NO_REGISTER), 0, MB_OKCANCEL) == IDOK)
//		{
//			// _xZkqqHx_iClBiCmMiCnMiCnMiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//			ExitApplication();
//		}
//		return;
//	}
//	// _xZkqqHx_iDeHiDgGiDeCiDfOiMmEiCnBiPgPiClFiMlDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCmJiClHiCoJiBeC_xHqqkZx_
//	::SetForegroundWindow(CFCCommonEditorFrame::GetMasterAppFrame());
//	// _xZkqqHx_iKmCiLkLiPoOjFpBiCmGjFjEjFgJiPoOjFpBiCpAiPjBiCkLiPgPiClFiBeBiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//	SendStreamAndEnd();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (int id = 0; id != 2; id++)
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
		FCZOrder zOrder;
		SheetManager()->GetSheet(id)->GetZOrder(zOrder, FDOZ_ON_ANY);

		if (id == 0 && zOrder.IsEmpty())
		//----- _xZkqqHx_iDfGiBfLiDgHiCfAiCmMjFjEjFgJiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfGiBfLiDgHiCfAiCmMjFjEjFgJiCmNjFeLjAhLiBeC_xHqqkZx_
			// IDS_MSG_ARROWEDIT_NO_OBJECT = "_xZkqqHx_iLkEjHhAjGoOiIpDiDfGiBfLiDgHiCmJjFjEjFgJiCkKjDgPjIfOiClDiCoKiCmEiCkCiCnMiClJiCpBiBeCjDgPjIfOiClJiClIiPeJjHlJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
			if (FFMessageBox(IDS_MSG_ARROWEDIT_NO_OBJECT, 0, MB_OKCANCEL) == IDOK)
			{
				// _xZkqqHx_iClBiCmMiCnMiCnMiPeJjHlJiClHiCoJiBeC_xHqqkZx_
				ExitApplication();
			}
			return;
		}
		// _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiDgAiDeGiDgCiDeOiClFiBeBjAhNiMgAiMgOiCmFiCmIiCkPiCoKiCmOiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
		FCZOrderIterator iObj;
		for (zOrder.Begin(iObj); !iObj.IsEnd(); iObj++)
		{
			if (!(*iObj)->IsKindOf(FDOJ_FIGURE))
				break;
		}
		if (!iObj.IsEnd())
		//----- _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCpAjFmPiNfIiBeC_xHqqkZx_
			g_pView->ClearSelectObj(TRUE);
			SetCurrentSheetId(id);
			// _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCjFjEjFgJiCpAjBeJjBpAiBeC_xHqqkZx_
			g_pView->AppendSelectObj(*iObj, TRUE);
			// _xZkqqHx_jDgPjIfOiCmFiCkLiCmIiCkCiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiKnMiCnMiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_
			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmJjDgPjIfOiCmFiCkLiCoJiCmMiCmNjAhNiMgAiMgOjFjEjFgJiCmMiCnNiCmFiClHiBeC_xHqqkZx_
			// IDS_MSG_IS_QUIT_NO_REGISTER = "_xZkqqHx_jDgPjIfOiClJiClIiPeJjHlJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
			WString wstrMessage;
			wstrMessage.Format(	IDS_ERR_MSG_INVALID_OBJECT_FOR_ARROW, 
								FFObjTypeToStr((*iObj)->Type()));
			if (FFMessageBox(wstrMessage + L"\r\n" +
							FFLoadWString(IDS_MSG_IS_QUIT_NO_REGISTER), 0, MB_OKCANCEL) == IDOK)
			{
				// _xZkqqHx_iClBiCmMiCnMiCnMiPeJjHlJiClHiCoJiBeC_xHqqkZx_
				ExitApplication();
			}
			return;
		}
	}
	// _xZkqqHx_iDeHiDgGiDeCiDfOiMmEiCnBiPgPiClFiMlDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCmJiClHiCoJiBeC_xHqqkZx_
	::SetForegroundWindow(CFCCommonEditorFrame::GetMasterAppFrame());
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCmGjFjEjFgJiPoOjFpBiCpAiPjBiCkLiPgPiClFiBeBiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	SendStreamAndEnd();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCArrowEditorDoc::OnFileComedtSaveExit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnUpdateFileChpedSaveExit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhDiDeOiDgAiDiDjGoOiIpDiCpAjDgPjIfOiClFiPeJjHlJiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFfMiOkGiPpDjBnEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::OnUpdateFileChpedSaveExit (CCmdUI* pCmdUI)
{
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
//	FCZOrder zOrder;
//	GetZOrder(zOrder, FDOZ_ON_ANY);
//	pCmdUI->Enable(FFCanBasicOperate() && !zOrder.IsEmpty() &&
//					!(zOrder.Size() == 1 &&
//					  zOrder.Front()->Type() == FDOJ_POINT));
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFiBeBjFjEjFgJiCkKiIlFiCkGiCoJiDfOiDeDiDhGiCkJiCmNiDgAiDeGiDgCiDeOiClFiCmIiCkCiBeC_xHqqkZx_
	// OnFileComedtSaveExit _xZkqqHx_iCnGiNhDiCkJiClJiCmEiBeBiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_
	// _xZkqqHx_iDiGiBfLiDfFiBfLiCmJiOkGiClHiClNiCnPiBeC_xHqqkZx_
	FCZOrder zOrder;
// 06.04.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	GetZOrder(zOrder, FDOZ_ON_ANY);
	SheetManager()->GetSheet(0)->GetZOrder(zOrder, FDOZ_ON_ANY);
	pCmdUI->Enable(FFCanBasicOperate() && !zOrder.IsEmpty());
//----- 06.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCArrowEditorDoc::OnUpdateFileChpedSaveExit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnArroweditProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhDiDeOiDgAiDiDjGoOiIpDiCmMiDhGiDiNiDhAiDgFiDeCiBhGiDfCiDhNiDjDiDgIiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::OnArroweditProperty ()
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPfHiNiHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	vObj.push_back(m_pObjArrow);
	CFCPrsObjProperty sheet(ID_ARROWEDIT_PROPERTY);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjFnLjBlGjHhAiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAiBeBjDoAjFjEjFjEjFgJiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_jDoAjFjEjFjEjFgJiCmGiClFiCmEjAnNjCoIiClHiCoJiClBiCmGiCmJiCoGiCoIiBeBjFjEjFgJjGkCjBeJjBpAiCmMiPpDjBnEiCmFiCoAjFmPiNfIiJmCjEfMiCmJiBeC_xHqqkZx_
	sheet.SetTargetObject(&vObj, TRUE);
	// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	CFCProObjDynabaseUserId proUserId;
	sheet.AddPage(&proUserId);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
} // CFCArrowEditorDoc::OnArroweditProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCArrowEditorDoc::OnUpdateArroweditProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhDiDeOiDgAiDiDjGoOiIpDiCmMiDhGiDiNiDhAiDgFiDeCiBhGiDfCiDhNiDjDiDgIiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCArrowEditorDoc::OnUpdateArroweditProperty (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
} // CFCArrowEditorDoc::OnUpdateArroweditProperty.
