#include "stdafx.h"
#include "DBLMath.h"	// For almost0.
#include "UtilMisc.h"		// For POW2.
#include "Bhaskara.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBhaskara::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFpLjCpGiOkOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_iCfBiOjPiNiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			b	:_xZkqqHx_iCfAiOjPiNiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			c	:_xZkqqHx_iCePiOjPiNiAiCmMiMfHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmPjAjE_xHqqkZx_x_xZkqqHx_iCmJjBmOiClHiCoJiCfBiOjPjFpLjCpGiOkO_xHqqkZx_ ax^2+bx+c=0 _xZkqqHx_iCmMiKgFiMfHjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBhaskara::Set (double a, double b, double c)
{
	m_dA = a;
	m_dB = b;
	m_dC = c;
} // FCBhaskara::Set.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBhaskara::Solve
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFpLjCpGiOkOiCmMiJpAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJpAiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Set_xZkqqHx_iKnGjAjEiCmFjAnNjCoIiClDiCoKiClNjFpLjCpGiOkOiCpAiJpAiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCBhaskara::Solve ()
{
	if (almost0(m_dA))
	//----- a=0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// b*x + c = 0 _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
		if (almost0(m_dB))
		//----- b=0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// c=0_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_x_xZkqqHx_iCmMjCgMiCkKiJlNiCmFiCkAiCmBiCmEiCoAjHmHiCkCiCmMiClOiCkKiBeB_xHqqkZx_
			// _xZkqqHx_iClLiCoKiCpAiKnMiCnPiCmEiJpAjGlDiClFiCmGiClFiClNiBeC_xHqqkZx_
			return 0;
		} else
		//----- b!=0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// x = -c / b
			m_cSol[0] = dblcompex(-m_dC / m_dB);
			return 1;
		}
	} else
	//----- a!=0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// x = (-b + sqrt(b^2 - 4*a*c))/(2*a)
		// x = (-b - sqrt(b^2 - 4*a*c))/(2*a)
		// pow(x, 1.0/3.0)_xZkqqHx_iCmNiBeB_xHqqkZx_x.imag = 0, x.real < 0 _xZkqqHx_iClOiCmGjAlDiClFiCkCiJpAiCpAiPgPiClDiCmIiCkCiCkKiBeB_xHqqkZx_
		// sqrt(x)_xZkqqHx_iCmNiBeB_xHqqkZx_x.imag = 0, x.real < 0 _xZkqqHx_iCmFiCkAiCmBiCmEiCoAjAlDiClFiCkCiJpAiCpAiPgPiClHiBeC_xHqqkZx_
		dblcompex cR = sqrt(dblcompex(POW2(m_dB) - 4.0 * m_dA * m_dC, 0.0));
		m_cSol[0] = (-m_dB + cR) / (2.0 * m_dA);
		m_cSol[1] = (-m_dB - cR) / (2.0 * m_dA);
		return 2;
	}
} // FCBhaskara::Solve.

