// ChipEditorDoc.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include <algorithm>		// For find template.
#include "UtilStr.h"		// For GetResString.
#include "UtilErr.h"		// For FFMessageBox.
#include "ChipEditorFrame.h"// For FFChipEditorFrame().
#include "ObjChipMaster.h"	// For FCObjChipMaster.
#include "ZOrder.h"			// For FCZOrder.
#include "LayerManager.h"	// For CurrentSheet().
#include "SheetManager.h"	// For FCSheetManager.
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#include "PrsObjProperty.h"			// For CFCPrsObjProperty.
#include "ProObjDynabaseUserId.h"	// For CFCProObjDynabaseUserId.
#include "ProObjDynabaseMark.h"		// For CFCProObjDynabaseMark.
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
#include "DynamicDrawView.h"
#include "ChipEditorDoc.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDgIiDeMiDiFiDiBiDjDiDgHjFmPjAjEiBeC_xHqqkZx_
//CFCChipEditorDoc* g_pChipDoc = NULL;
//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCChipEditorDoc

IMPLEMENT_DYNCREATE(CFCChipEditorDoc, CFCCommonEditorDoc)

CFCChipEditorDoc::CFCChipEditorDoc ()
{
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiBeC_xHqqkZx_
	m_pObjChip = NULL;
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCChipEditorDoc::CFCChipEditorDoc.

//----- 02.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//BOOL CFCChipEditorDoc::OnNewDocument()
//{
//	if (!BASE_CLASS::OnNewDocument())
//		return FALSE;
//	return TRUE;
//}
//----- 02.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

CFCChipEditorDoc::~CFCChipEditorDoc ()
{
// 02.12.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	g_pChipDoc = NULL;	// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDgIiDeMiDiFiDiBiDjDiDgHjFmPjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
} // CFCChipEditorDoc::~CFCChipEditorDoc.

BEGIN_MESSAGE_MAP(CFCChipEditorDoc, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCChipEditorDoc)
	ON_COMMAND(ID_FILE_COMEDT_SAVE_EXIT, OnFileComedtSaveExit)
	ON_UPDATE_COMMAND_UI(ID_FILE_COMEDT_SAVE_EXIT, OnUpdateFileChpedSaveExit)
	ON_COMMAND(ID_CHIPEDIT_MODE_OBJECT_CHIP, OnChipeditModeObjectChip)
	ON_UPDATE_COMMAND_UI(ID_CHIPEDIT_MODE_OBJECT_CHIP, OnUpdateChipeditModeObjectChip)
	ON_COMMAND(ID_CHIPEDIT_MODE_COMPOSITE_CHIP, OnChipeditModeCompositeChip)
	ON_UPDATE_COMMAND_UI(ID_CHIPEDIT_MODE_COMPOSITE_CHIP, OnUpdateChipeditModeCompositeChip)
	ON_COMMAND(ID_CHIPEDIT_PROPERTY, OnChipeditProperty)
	ON_UPDATE_COMMAND_UI(ID_CHIPEDIT_PROPERTY, OnUpdateChipeditProperty)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCChipEditorDoc_xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::UnregisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_jDgPjIfOiCkJiCoHiCmNiClIiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.24 Fukushiro M. _xZkqqHx_iIoKjFjEiLeAjEfMiCpA_xHqqkZx_CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::UnregisterObject (FCObjDynabase* pObj)
{
	// _xZkqqHx_iClHiCmFiCmJ_xHqqkZx_ CmdDelete1Obj_xZkqqHx_jDjJiCmF_xHqqkZx_ _xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiCmNiNoNiPjMiClDiCoKiCmEiCkCiCoJiCmNiClIiBeC_xHqqkZx_
	ASSERT(find(m_vChipDutyLink.begin(), m_vChipDutyLink.end(), pObj->GetObjID()) == m_vChipDutyLink.end());
	ASSERT(find(m_vChipDutyText.begin(), m_vChipDutyText.end(), pObj->GetObjID()) == m_vChipDutyText.end());
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnregisterObject(pObj);
} // CFCChipEditorDoc::UnregisterObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::ReceiveStreamAndInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Molip Draw_xZkqqHx_iCkJiCoHjBjHjAeNiClDiCoKiCoJiDgGiBfLiDfOiCpAiOpDjAeNiClFiBeBiDfIiDgHiDiKiBfLiDiAiCmJ_xHqqkZx_
 *			_xZkqqHx_jDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIiOjOiCmJiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndDraw	:Molip Draw_xZkqqHx_iCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCMainFrame_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			99.11.02 Fukushiro M. _xZkqqHx_jFjEjFgJiCkKjFkBiNiHiDgAiDgCiDhGiCmMiPoKiNiHiJpAjBmMiClHiCoJiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::ReceiveStreamAndInit (HWND hwndDraw)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeCiOmAiNnLiCmJiDgGiBfLiDfOiCpAiOpDjAeNiClFiBeBiDfGiBfLiDgHiCmJjFjEjFgJiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
	BASE_CLASS::ReceiveStreamAndInit(hwndDraw);
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iJlKiCmM_xHqqkZx_FCObjDynabase::RegisterObjID()_xZkqqHx_iCmJiCoGiCmBiCmEjFjEjFgJiCpAjDgPjIfOiClHiCoJiNnLiBeB_xHqqkZx_
	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkK_xHqqkZx_Open_xZkqqHx_iClFiCmEiCkCiCoJiClBiCmGiCkKjFeLjHhGiCmFiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiClNiCnPiCmJiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEjFmCiClGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
	SessionBegin();
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	SessionEnd();

	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pObjChip = new FCObjChipMaster();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCZOrder zOrder;
	GetZOrder(zOrder, FDOZ_ON_ANY);
	if (zOrder.Size() != 0)
	//----- _xZkqqHx_iKpJjBlGiDgAiDgCiDhGjFjEjFgJiCmMjFnCiPfHiOjO_xHqqkZx_ -----
	{
		ASSERT(zOrder.Size() == 1 && zOrder.Front()->Type() == FDOJ_CHIP_MASTER);
		FCObjChipMaster* pChip = (FCObjChipMaster*)zOrder.Front();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iClBiCmM_xHqqkZx_FCDynabase_xZkqqHx_iDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAjFnLjBlGjHhAiDgAiDgCiDhGjFjEjFgJiCmJiDfCiDhDiBfLiBeC_xHqqkZx_
		pChip->FCObjDynabase::CopySelf(m_pObjChip);
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCpAjAnNjCoIiBeC_xHqqkZx_
		m_nChipKind = pChip->GetChipKind();
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//		SetObjUserUlong(pChip->GetObjUserUlong());
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		short nIdx;
		// _xZkqqHx_iDgAiDgCiDhGiDhNiDfIiDfOjCiGiCmMiDiBiDjDiDgPjFjEjFgJiCmMjGpAiKiEiCpAiDgIiDeMiDiFiDiBiDjDiDgHiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		for (nIdx = 0; nIdx != pChip->GetDutyLinkSize(); nIdx++)
			InsertChipDutyObject(FDCA_LINK, nIdx, pChip->GetDutyLink(nIdx));
		for (nIdx = 0; nIdx != pChip->GetDutyTextSize(); nIdx++)
			InsertChipDutyObject(FDCA_TEXT, nIdx, pChip->GetDutyText(nIdx));
		// _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiBeCiLeMjIfOiClFiCmIiCkCiClNiCnPiCmJiBeB_xHqqkZx_NULL_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmFiDfCiDhNiDjDiDgIiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
		NullSessionBegin();
		ObjDynabaseVector vObj;
		// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMjDgPjIfOiBeBiDiKiDjDiDeOiCmMjDgPjIfOjDjJiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
		CmdUngroup(vObj, pChip);
		NullSessionEnd();
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFnLjBlGjHhAiDgAiDgCiDhGjFjEjFgJiCpAjDgPjIfOiBeCjDmHiCnNiNjOiCpBiClOiDgGiBfLiDfOiCmM_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCmMjDgPjIfOiCkKiPeJiCoNiCmBiCmEiCkJiCoHjDgPjIfOiClHiCoJiClNiCnPiBeBiClBiClBiCmJiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOiClFiCmEiCoAiBeBiDfGiBfLiDgHiCmJjDpMiCoKiCmIiCkPiCoKiCmOjFnLjBlGiClDiCoKiCmIiCkCiCkJiCoHjBoFiPoEjFhGiBeC_xHqqkZx_
	m_pObjChip->RegisterObjID();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCpBiClOiMoDiPiIjHjNiBeC_xHqqkZx_
	AfterLoadDocument(TRUE);
	// _xZkqqHx_iJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->Invalidate();
//----- 05.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCChipEditorDoc::ReceiveStreamAndInit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::SendStreamAndEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiBfLiLeOjDkOiMlDiDeBiDhGiDiKiCmJiDgGiBfLiDfOjBjHjAeNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::SendStreamAndEnd ()
{
//----- 05.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCpAiLeOjDkOiClFiCmEiCkJiCoHiIoKjDhIiCoAiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkCiCmIiCkCiCmGiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjFmCiClGiClNiCnMiCnMiClBiClBiCmJjHiIiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	// _xZkqqHx_iJlKiCmM_xHqqkZx_FCObjDynabase::RegisterObjID()_xZkqqHx_iCmJiCoGiCmBiCmEjFjEjFgJiCpAjDgPjIfOiClHiCoJiNnLiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkK_xHqqkZx_Open_xZkqqHx_iClFiCmEiCkCiCoJiClBiCmGiCkKjFeLjHhGiCmFiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
//	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiClNiCnPiCmJiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEjFmCiClGiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
//	SessionBegin();
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	SessionEnd();
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMiDePiDiLiBfLiDhGiJlLiCpAiNhDiCkEiClNiCnPiBeBjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	g_pView->ClearSelectObj(TRUE);
//----- 05.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCZOrder zOrder;
	GetZOrder(zOrder, FDOZ_ON_ANY);
	// _xZkqqHx_jBfDiChJiDeJiBfLiDfPiBfLiCpAjCmKiClFiCmFiOoGjDlOiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	zOrder.GetAllOrder(vObj);
	// _xZkqqHx_jFkBiNiHjFjEjFgJiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
	//-------------------------------------------------------------
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCpA_xHqqkZx_FCObjChipMaster_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCmJjEfLiCnPiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjCiGiCmJiCmN_xHqqkZx_FCObjChipMaster_xZkqqHx_iCmMiCnNiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
	//-------------------------------------------------------------
	// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCpAjAlGjAkMiBeC_xHqqkZx_
	FCObjChipMaster* pObjChip = new FCObjChipMaster();
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmM_xHqqkZx_FCDynabase_xZkqqHx_iDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAjFnLjBlGjHhAiDgAiDgCiDhGjFjEjFgJiCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
	m_pObjChip->FCObjDynabase::CopySelf(pObjChip);
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
	pObjChip->RegisterObjID();
	// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCmJiMlLiNnNiCmMjFjEjFgJjBfDiCmEiCpAiDePiDiLiBfLiDhGjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
	pObjChip->SetGroup(vObj);
	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCmMjAnNjCoIiBeC_xHqqkZx_
	pObjChip->SetChipKind(m_nChipKind);
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	pObjChip->SetObjUserUlong(GetObjUserUlong());
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	DWORDVector vLinkId;
	LinkManager()->GetLinkIdList(vLinkId);
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmJiDiKiDjDiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	pObjChip->SetLink(vLinkId);
	// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCmJiDePiDiLiBfLiDhGjFjEjFgJiCmMiKgFjGpAiKiEiCpAjDgPjIfOiBeC_xHqqkZx_
	DWORDVector::iterator i;
	for (i = m_vChipDutyLink.begin(); i != m_vChipDutyLink.end(); i++)
		pObjChip->AppendDutyLink(ObjID2Object(*i));
	for (i = m_vChipDutyText.begin(); i != m_vChipDutyText.end(); i++)
		pObjChip->AppendDutyText(ObjID2Object(*i));
	// _xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCpAiDeOiDiKiDeBiClFiBeBiDhNiDfIiDfOjFjEjFgJiCmMiCnNiCpAiNmEjDgPjIfOiBeC_xHqqkZx_
	m_pSheetManager->Clear();
	m_pSheetManager->Initialize();
	CurrentSheet()->AppendToLZOrder(pObjChip);
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::SendStreamAndEnd();
} // CFCChipEditorDoc::SendStreamAndEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::GetChipDutyObjects
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjGpAiKiEiCmMjFjEjFgJiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iDuty	:_xZkqqHx_jGpAiKiEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_FDCA_NONE_xZkqqHx_iCmNjGlDiMpIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DWORDVector& CFCChipEditorDoc::GetChipDutyObjects (FTChipDuty iDuty) const
{
	switch (iDuty)
	{
	case FDCA_LINK:
		return m_vChipDutyLink;
	default:	// case FDCA_TEXT:
		return m_vChipDutyText;
	}
} // CFCChipEditorDoc::GetChipDutyObjects.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::FindChipDutyID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCmMiOhHjCoIiClDiCoKiClNjGpAiKiEiCpAiMjPiNpFiClFiBeBjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iDutyID	:_xZkqqHx_jGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCjGpAiKiEiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			iDuty	:_xZkqqHx_jGpAiKiEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_iMjPiNpFiClHiCoJjFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::FindChipDutyID (	int& iDutyID, FTChipDuty iDuty,
										const FCObjDynabase* pObj) const
{
	// _xZkqqHx_iCkAiCoHiCkJiClGiCnPiBhMiCfAiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	iDutyID = -1;
	DWORDVector::const_iterator iObj;
	switch (iDuty)
	{
	case FDCA_LINK:	// _xZkqqHx_iDiKiDjDiDeOjGpAiKiEiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
		//----- _xZkqqHx_iDiKiDjDiDeOjGpAiCmMjFjEjFgJiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
		iObj = find(m_vChipDutyLink.begin(), m_vChipDutyLink.end(), pObj->GetObjID());
		// _xZkqqHx_iDiKiDjDiDeOjGpAiDiKiDfIiDgHjCiGiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		if (iObj != m_vChipDutyLink.end())
			iDutyID = int(iObj - m_vChipDutyLink.begin());
		break;
	case FDCA_TEXT:	// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiKiEiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiCmMjFjEjFgJiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
		iObj = find(m_vChipDutyText.begin(), m_vChipDutyText.end(), pObj->GetObjID());
		// _xZkqqHx_iDgFiDeMiDfIiDgHjGpAiDiKiDfIiDgHjCiGiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		if (iObj != m_vChipDutyText.end())
			iDutyID = int(iObj - m_vChipDutyText.begin());
		break;
	}
} // CFCChipEditorDoc::FindChipDutyID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::CmdDelete1Obj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFjEjFgJiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_ChipEditor_xZkqqHx_iCmFiCmNiBeBjFjEjFgJiNoNiPjMiOjOiCmJjGpAiKiEiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iCkJiCoHjDgPjIfOjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeBiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_iNoNiPjMiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::CmdDelete1Obj (FCObjDynabase* objp, SheetID stid)
{
	int iDutyID;
	// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
	FindChipDutyID(iDutyID, FDCA_LINK, objp);
	// _xZkqqHx_iCfAjFjEjFgJiDiKiDjDiDeOjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	if (0 <= iDutyID) CmdDelete1ObjLinkDutyTbl(iDutyID, objp);
	// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
	FindChipDutyID(iDutyID, FDCA_TEXT, objp);
	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	if (0 <= iDutyID) CmdDelete1ObjTextDutyTbl(iDutyID, objp);
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CmdDelete1Obj(objp, stid);
} // CFCChipEditorDoc::CmdDelete1Obj.

//----- 05.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::CmdDeleteObjs
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEjFjEjFgJiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_ChipEditor_xZkqqHx_iCmFiCmNiBeBjFjEjFgJiNoNiPjMiOjOiCmJjGpAiKiEiDgFiBfLiDhFiDiL_xHqqkZx_
// *			_xZkqqHx_iCkJiCoHjDgPjIfOjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeBiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiClNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_jFjEjFgJiCkKjBkOiClHiCoJiDfGiBfLiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			vObj	:_xZkqqHx_iNoNiPjMiClDiCoKiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCChipEditorDoc::CmdDeleteObjs (SheetID stid, const ObjDynabaseVector& vObj)
//{
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
//	{
//		int iDutyID;
//		// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
//		FindChipDutyID(iDutyID, FDCA_LINK, *iObj);
//		// _xZkqqHx_iCfAjFjEjFgJiDiKiDjDiDeOjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//		if (0 <= iDutyID) CmdDelete1ObjLinkDutyTbl(iDutyID, *iObj);
//		// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
//		FindChipDutyID(iDutyID, FDCA_TEXT, *iObj);
//		// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//		if (0 <= iDutyID) CmdDelete1ObjTextDutyTbl(iDutyID, *iObj);
//	}
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CmdDeleteObjs(stid, vObj);
//} // CFCChipEditorDoc::CmdDeleteObjs.
//----- 05.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::CmdGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_ChipEditor_xZkqqHx_iCmFiCmNiBeBiDePiDiLiBfLiDhGiJlLiOjOiCmJiDiBiDjDiDgPjFjEjFgJiCpA_xHqqkZx_
 *			_xZkqqHx_jGpAiKiEiDgFiBfLiDhFiDiLiCkJiCoHjDgPjIfOjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeBiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDePiDiLiBfLiDhGiJlLiClHiCoJiDiBiDjDiDgPjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlGjAkMiClDiCoKiClNiDePiDiLiBfLiDhGjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjGroup*	CFCChipEditorDoc::CmdGroup (const ObjDynabaseVector& vObj, const DWORDVector& vLinkId)
{
	int iDutyID;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
		FindChipDutyID(iDutyID, FDCA_LINK, *iObj);
		// _xZkqqHx_iCfAjFjEjFgJiDiKiDjDiDeOjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		if (0 <= iDutyID) CmdDelete1ObjLinkDutyTbl(iDutyID, *iObj);
		// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
		FindChipDutyID(iDutyID, FDCA_TEXT, *iObj);
		// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		if (0 <= iDutyID) CmdDelete1ObjTextDutyTbl(iDutyID, *iObj);
	}
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CmdGroup(vObj, vLinkId);
} // CFCChipEditorDoc::CmdGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::CmdUngroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_ChipEditor_xZkqqHx_iCmFiCmNiBeBiDeBiDjDiDePiDiLiBfLiDhGiJlLiOjOiCmJ_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCpAjGpAiKiEiDgFiBfLiDhFiDiLiCkJiCoHjDgPjIfOjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiJlLiCmFjAlGiClGiClNiDiBiDjDiDgPjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			pGrp	:_xZkqqHx_iDeBiDjDiDePiDiLiBfLiDhGiJlLiClHiCoJiDePiDiLiBfLiDhGjFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::CmdUngroup (ObjDynabaseVector& vObj, FCObjGroup* pGrp)
{
	int iDutyID;
	// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
	FindChipDutyID(iDutyID, FDCA_LINK, pGrp);
	// _xZkqqHx_iCfAjFjEjFgJiDiKiDjDiDeOjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	if (0 <= iDutyID) CmdDelete1ObjLinkDutyTbl(iDutyID, pGrp);
	// _xZkqqHx_jFjEjFgJiCkJiCoHjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
	FindChipDutyID(iDutyID, FDCA_TEXT, pGrp);
	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjGpAiKiEiDgFiBfLiDhFiDiLiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	if (0 <= iDutyID) CmdDelete1ObjTextDutyTbl(iDutyID, pGrp);
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CmdUngroup(vObj, pGrp);
} // CFCChipEditorDoc::CmdUngroup.

//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::GetObjUserUlong
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DWORD CFCChipEditorDoc::GetObjUserUlong () const
//{
//	return m_dwObjUserUlong;
//} // CFCChipEditorDoc::GetObjUserUlong.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::SetObjUserUlong
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCChipEditorDoc::SetObjUserUlong (DWORD dwId)
//{
//	m_dwObjUserUlong = dwId;
//} // CFCChipEditorDoc::SetObjUserUlong.
//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::InsertChipDutyObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjGpAiKiEiCmMjFjEjFgJiDiKiDfIiDgHiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiCmJiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iDuty	:_xZkqqHx_jGpAiKiEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			iDutyID	:_xZkqqHx_jGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeCjBhNjDpMiMoDiBeBjFjEjFgJiCmMjGpAiKiE_xHqqkZx_ID_xZkqqHx_iCkKiClBiCmMjCgMiCmJiCmIiCoJiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::InsertChipDutyObject (FTChipDuty iDuty, int iDutyID, FCObjDynabase* pObj)
{
	switch (iDuty)
	{
	case FDCA_LINK:
		m_vChipDutyLink.insert(m_vChipDutyLink.begin() + iDutyID, pObj->GetObjID());
		break;
	case FDCA_TEXT:
		m_vChipDutyText.insert(m_vChipDutyText.begin() + iDutyID, pObj->GetObjID());
		break;
	}
//----- 05.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jGpAiKiEiDgFiBfLiDhFiDiLiCmMiNfIjAfGiCpAiDhEiDiMiBfLiDiAiCmJjCmKjCgNiBeC_xHqqkZx_
//	FFChipEditorFrame()->DutyTblUpdateNotify();
//----- 05.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCChipEditorDoc::InsertChipDutyObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::RemoveChipDutyObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjGpAiKiEiCmMjFjEjFgJiDiKiDfIiDgHiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiCmMjFjEjFgJiCpAiDiKiDfIiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iDuty	:_xZkqqHx_jGpAiKiEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			iDutyID	:_xZkqqHx_jGpAiKiE_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::RemoveChipDutyObject (FTChipDuty iDuty, int iDutyID)
{
	switch (iDuty)
	{
	case FDCA_LINK:
		m_vChipDutyLink.erase(m_vChipDutyLink.begin() + iDutyID);
		break;
	case FDCA_TEXT:
		m_vChipDutyText.erase(m_vChipDutyText.begin() + iDutyID);
		break;
	}
//----- 05.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jGpAiKiEiDgFiBfLiDhFiDiLiCmMiNfIjAfGiCpAiDhEiDiMiBfLiDiAiCmJjCmKjCgNiBeC_xHqqkZx_
//	FFChipEditorFrame()->DutyTblUpdateNotify();
//----- 05.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCChipEditorDoc::RemoveChipDutyObject.

/////////////////////////////////////////////////////////////////////////////
// CFCChipEditorDoc _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void CFCChipEditorDoc::AssertValid() const
{
	BASE_CLASS::AssertValid();
} // CFCChipEditorDoc::AssertValid.

void CFCChipEditorDoc::Dump(CDumpContext& dc) const
{
	BASE_CLASS::Dump(dc);
} // CFCChipEditorDoc::Dump.
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFCChipEditorDoc _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCChipEditorDoc _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::DeleteContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiDgGiBfLiDfOiCpAiNoNiPjMiClFiBeBiNmEiCnBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiOkJjAgHiCmNjEgKiKpMiClJiClIiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiClHiCoJiClNiCnPiCmJiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkKiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnNewDocument
 *			_xZkqqHx_iBeF_xHqqkZx_COleServerDoc::OnOpenDocument
 *			_xZkqqHx_iBeF_xHqqkZx_CFrameWnd::OnClose
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjEgKiKpMiOjOiCmJiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCoJiOjOiCmNiBeBiKpJiCmJ_xHqqkZx_View_xZkqqHx_iCmNjEgKiKpM_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiCkCiCoJiClBiCmGiCmJjCiNiInD_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiIoKjFjEiLeAjEfMiCpAiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::DeleteContents ()
{
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pObjChip != NULL)
	//----- _xZkqqHx_jFnLjBlGjHhAiDgAiDgCiDhGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDgPjIfOiCpAiJpAiPjMiBeC_xHqqkZx_
		m_pObjChip->UnregisterObjID();
		// _xZkqqHx_iNoNiPjMiBeC_xHqqkZx_
		delete m_pObjChip;
		m_pObjChip = NULL;
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	m_nChipKind = FDCM_OBJECT_CHIP;	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_dwObjUserUlong = DWORD(-1);
//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 01.08.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIjHhAjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ ----
	// _xZkqqHx_jFjEjFgJjGpAiKiEiDgFiBfLiDhFiDiL_xHqqkZx_.
	m_vChipDutyLink.clear();
	m_vChipDutyText.clear();

	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjGpAiKiEiDgFiBfLiDhFiDiLiCmMiNfIjAfGjCmKjCgNiCmNiBeB_xHqqkZx_Frame::DeleteContents_xZkqqHx_iCkJiCoHiBeC_xHqqkZx_

	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::DeleteContents();
} // CFCChipEditorDoc::DeleteContents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnFileComedtSaveExit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDgAiDgCiDhGiCpAjDgPjIfOiClFiPeJjHlJiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCmMiDfIiDgHiDiKiBfLiDiAiCpA_xHqqkZx_Molip Draw_xZkqqHx_iCnGjDfNjBjHiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.15 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			99.01.10 Fukushiro M. OLEAutomation_xZkqqHx_iCkJiCoH_xHqqkZx_Message_xZkqqHx_iDhIiBfLiDfIjFmPiNfIiCmJ_xHqqkZx_
 *									_xZkqqHx_jElKiCmBiCmEjAfGiLeLiCmJiNoMjAkM_xHqqkZx_
 *			99.03.24 Fukushiro M. CFCFoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnFileComedtSaveExit ()
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCZOrder zOrder;
	GetZOrder(zOrder, FDOZ_ON_ANY);

	BOOL bObjPoint = FALSE;
	FCZOrderIterator iObj;
	for (zOrder.Begin(iObj); !bObjPoint && !iObj.IsEnd(); iObj++)
		if ((*iObj)->IsKindOf(FDOJ_POINT)) bObjPoint = TRUE;

	// _xZkqqHx_jFjEjFgJjAjEiCkK_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiHiBeBiIlNiCkCiCmNiDhMiDeDiDjDiDgHjFjEjFgJiCmMiCnNiCmMiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiCmJiDhMiDeDiDjDiDgHjFjEjFgJiCkKiKnMiCnMiCoKiCoJiPoKiNiHiBeBiCmNiDfKiBfLiDhFiClJiClIiPeJjHlJiBeC_xHqqkZx_
	if (zOrder.IsEmpty() ||
		(zOrder.Size() == 1 && zOrder.Front()->Type() == FDOJ_POINT) ||
		(m_nChipKind == FDCM_OBJECT_CHIP && bObjPoint))
	{
		// IDS_MSG_INVALID_CHIP_END = "_xZkqqHx_jDgPjIfOjGlDiMpI_xHqqkZx_(_xZkqqHx_jFjEjFgJiCkKjGlDiCkC_xHqqkZx_/_xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiCmMiCnN_xHqqkZx_)_xZkqqHx_iCmFiClHiBeC_xHqqkZx_"
		// IDS_MSG_IS_QUIT_NO_REGISTER = "_xZkqqHx_jDgPjIfOiClJiClIiPeJjHlJiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(FFLoadWString(IDS_MSG_INVALID_CHIP_END) + L"\r\n" +
						FFLoadWString(IDS_MSG_IS_QUIT_NO_REGISTER), 0, MB_OKCANCEL) == IDOK)
		{
			// _xZkqqHx_iClBiCmMiCnMiCnMiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//----- 03.08.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			SetModifiedFlag(FALSE);
//			::PostMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_APP_EXIT, 0);
//----- 03.08.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			ExitApplication();
//----- 03.08.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
		return;
	}
	// _xZkqqHx_iDeHiDgGiDeCiDfOiMmEiCnBiPgPiClFiMlDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCmJiClHiCoJiBeC_xHqqkZx_
	::SetForegroundWindow(CFCCommonEditorFrame::GetMasterAppFrame());
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCmGjFjEjFgJiPoOjFpBiCpAiPjBiCkLiPgPiClFiBeBiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	SendStreamAndEnd();
} // CFCChipEditorDoc::OnFileComedtSaveExit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnUpdateFileChpedSaveExit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDgAiDgCiDhGiCpAjDgPjIfOiClFiPeJjHlJiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFfMiOkGiPpDjBnEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnUpdateFileChpedSaveExit (CCmdUI* pCmdUI)
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCZOrder zOrder;
	GetZOrder(zOrder, FDOZ_ON_ANY);
	pCmdUI->Enable(FFCanBasicOperate() && !zOrder.IsEmpty() &&
					!(zOrder.Size() == 1 &&
					  zOrder.Front()->Type() == FDOJ_POINT));
} // CFCChipEditorDoc::OnUpdateFileChpedSaveExit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnChipeditModeObjectChip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjDmGjHkHjFjEjFgJiDgAiDgCiDhGiDiCiBfLiDgIiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnChipeditModeObjectChip ()
{
	m_nChipKind = FDCM_OBJECT_CHIP;
} // CFCChipEditorDoc::OnChipeditModeObjectChip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnUpdateChipeditModeObjectChip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjDmGjHkHjFjEjFgJiDgAiDgCiDhGiDiCiBfLiDgIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFfMiOkGiPpDjBnEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnUpdateChipeditModeObjectChip (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate());
	pCmdUI->SetRadio(m_nChipKind == FDCM_OBJECT_CHIP);
} // CFCChipEditorDoc::OnUpdateChipeditModeObjectChip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnChipeditModeCompositeChip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFkBiNiHjFjEjFgJiDgAiDgCiDhGiDiCiBfLiDgIiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnChipeditModeCompositeChip ()
{
	m_nChipKind = FDCM_COMPOSITE_CHIP;
} // CFCChipEditorDoc::OnChipeditModeCompositeChip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnUpdateChipeditModeCompositeChip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFkBiNiHjFjEjFgJiDgAiDgCiDhGiDiCiBfLiDgIiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFfMiOkGiPpDjBnEiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnUpdateChipeditModeCompositeChip (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate());
	pCmdUI->SetRadio(m_nChipKind == FDCM_COMPOSITE_CHIP);
} // CFCChipEditorDoc::OnUpdateChipeditModeCompositeChip.

//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnChipeditProperty
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFjEjFgJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCChipEditorDoc::OnChipeditProperty ()
//{
//	CFCDlgObjUserUlong dlg;
//	dlg.DoModal();
//} // CFCChipEditorDoc::OnChipeditProperty.
//----- 01.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnChipeditProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDgAiDgCiDhGiCmMiDhGiDiNiDhAiDgFiDeCiBhGiDfCiDhNiDjDiDgIiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnChipeditProperty ()
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPfHiNiHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	vObj.push_back(m_pObjChip);
	CFCPrsObjProperty sheet(ID_CHIPEDIT_PROPERTY);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjFnLjBlGjHhAiDgAiDgCiDhGjFjEjFgJiCpAiBeBjDoAjFjEjFjEjFgJiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_jDoAjFjEjFjEjFgJiCmGiClFiCmEjAnNjCoIiClHiCoJiClBiCmGiCmJiCoGiCoIiBeBjFjEjFgJjGkCjBeJjBpAiCmMiPpDjBnEiCmFiCoAjFmPiNfIiJmCjEfMiCmJiBeC_xHqqkZx_
	sheet.SetTargetObject(&vObj, TRUE);
	// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	CFCProObjDynabaseUserId proUserId;
	CFCProObjDynabaseMark proMark;
	sheet.AddPage(&proUserId);
	sheet.AddPage(&proMark);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
} // CFCChipEditorDoc::OnChipeditProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipEditorDoc::OnUpdateChipeditProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDgAiDgCiDhGiCmMiDhGiDiNiDhAiDgFiDeCiBhGiDfCiDhNiDjDiDgIiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipEditorDoc::OnUpdateChipeditProperty (CCmdUI* pCmdUI)
{
	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJ_xHqqkZx_ command update UI _xZkqqHx_iDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
	
} // CFCChipEditorDoc::OnUpdateChipeditProperty.
