// ChipGroupListCtrl.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "Env.h"				// For g_pEnv.
#include "UtilGraph.h"			// For FCAutoDC.
#include "UtilDlg.h"			// For RightByLeftHand.
#include "UtilStr.h"			// For FFExtractUntil.
#include "UtilWin.h"			// For FFInsertColumn.
#include "RegData.h"			// For FCRegData.
#include "DlgInputStr.h"		// For CFCDlgInputStr.
#include "ChipGroupListCtrl.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const int FDLL_CURRENT_CHIP_GROUP_CLM	= 0;
const int FDLL_CHIP_GROUP_NAME_CLM		= 1;

#define FDLL_CURRENT_CHIP_GROUP_WIDTH	30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_CHIP_GROUP_NAME_WIDTH		80		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiNmFiPkMjCgMiBeC_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCChipGroupListCtrl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::CFCChipGroupListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCChipGroupListCtrl::CFCChipGroupListCtrl ()
{
	m_cgidCurrent = 0;		// _xZkqqHx_jFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiBeC_xHqqkZx_
} // CFCChipGroupListCtrl::CFCChipGroupListCtrl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::~CFCChipGroupListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCChipGroupListCtrl::~CFCChipGroupListCtrl ()
{
} // CFCChipGroupListCtrl::~CFCChipGroupListCtrl.

/////////////////////////////////////////////////////////////////////////////
// CFCChipGroupListCtrl _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::Initialize ()
{
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_imageList.Create(16, 16, ILC_MASK, 1, 4);
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CURRENT_MARK));		// Image 0.

	m_imageHeadList.Create(16, 16, ILC_MASK, 2, 4);
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_SHEET_EYE));	// Image 0.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_NAME_TAG));	// Image 1.

	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIjGlDiClFiPpDjBnEiCmFiCoAjBeJjBpAiDhNiBfLiDeOiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDfOiDeDiDiLjFmPiNfIiBeC_xHqqkZx_
	ModifyStyle(0, LVS_SHOWSELALWAYS);
	// _xZkqqHx_iDeBiDeDiDfCiDjDjFfMiOkGjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetImageList(&m_imageList, LVSIL_SMALL);
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	pHdrCtrl->SetImageList(&m_imageHeadList);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjBhNjDpM_xHqqkZx_ -----
	// _xZkqqHx_iMlLiNnN_xHqqkZx_\n_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiBeC_xHqqkZx_
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_CHIP_GROUP_LIST_CTRL);
	FFInsertColumn(this, FDLL_CURRENT_CHIP_GROUP_CLM, ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, 60);
	FFInsertColumn(this, FDLL_CHIP_GROUP_NAME_CLM,   ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, 200);
	//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	HD_ITEM curItem;
	for (int iC = 0; iC < pHdrCtrl->GetItemCount(); iC++)
	{
// 01.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		pHdrCtrl->GetItem(iC, &curItem);
		curItem.mask= HDI_IMAGE | HDI_FORMAT;
		curItem.iImage= iC;
		curItem.fmt= HDF_CENTER | HDF_IMAGE | HDF_STRING | HDF_BITMAP;
		pHdrCtrl->SetItem(iC, &curItem);
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateColumnWidth();
} // CFCChipGroupListCtrl::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::UpdateColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoIiCpAiPeJiCoNiCoHiClJiCmEiCkJiCoHiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::UpdateColumnWidth ()
{
	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	GetClientRect(rect);
	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiCmMjClHiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	long lChipGroupNameWidth = rect.Width() - FDLL_CURRENT_CHIP_GROUP_WIDTH;
	// _xZkqqHx_iNmFjCoBiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMjClHiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
	if (lChipGroupNameWidth < FDLL_CHIP_GROUP_NAME_WIDTH)
		lChipGroupNameWidth = FDLL_CHIP_GROUP_NAME_WIDTH;
	// _xZkqqHx_iOgDiCoIiCmMiDeKiDiJiDiAjClHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetColumnWidth(FDLL_CURRENT_CHIP_GROUP_CLM, FDLL_CURRENT_CHIP_GROUP_WIDTH);
	SetColumnWidth(FDLL_CHIP_GROUP_NAME_CLM, lChipGroupNameWidth);
} // CFCChipGroupListCtrl::UpdateColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::SetCurrentChipGroupId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgAiDgCiDhGiDePiDiLiBfLiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDeKiDiMiDjDiDgHiDgAiDgCiDhGiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::SetCurrentChipGroupId (ChipGroupID stid)
{
	// _xZkqqHx_jFmPiNfIjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_cgidCurrent == stid) return;
	long lCurIdx = ItemDataToIndex(m_cgidCurrent);
	// _xZkqqHx_iMmDiCkCjFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(lCurIdx, lCurIdx);
	// _xZkqqHx_jFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMjAnNjCoIiBeC_xHqqkZx_
	m_cgidCurrent = stid;
	lCurIdx = ItemDataToIndex(m_cgidCurrent);
	// _xZkqqHx_jAfGiClFiCkCjFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(lCurIdx, lCurIdx);
	// _xZkqqHx_iKePjFjEiCkJiCoHiCmMiOmAiNhDiCmIiCmMiCmFiBeBiDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMjFmPiNfIiCmNjCmKjCgNiClFiCmIiCkCiBeC_xHqqkZx_
} // CFCChipGroupListCtrl::SetCurrentChipGroupId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::GetCurrentChipGroupId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgAiDgCiDhGiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgAiDgCiDhGiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCChipGroupListCtrl::GetCurrentChipGroupId () const
{
	return m_cgidCurrent;
} // CFCChipGroupListCtrl::GetCurrentChipGroupId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::AppendRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfCiBfLiDgIiCmMiDfCiDhDiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			rec		:_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::AppendRec (DWORD dwId, const FCChipGroupRec& rec)
{
	m_mpIdToRec[dwId] = ChipGroupCtrlRecAuto(new FCChipGroupRec(rec));
} // CFCChipGroupListCtrl::AppendRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::SetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdSz	:dwId_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiPiHjEnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::SetIdOrder (DWORD dwIdSz, const DWORD dwId[])
{
	// _xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCpAiNoNiPjMiBgJiDiMiDfCiBfLiDgIiCmNiNoNiPjMiClFiCmIiCkCiBgKiBeC_xHqqkZx_
	DeleteAllItems();
	for (DWORD dwC = 0; dwC < dwIdSz; dwC++)
	{
		// LastItem_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		CListCtrl::InsertItem(dwC, _T(""));
		SetItemData(dwC, dwId[dwC]);
	}
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UpdateItemSize();
	UpdateScrollSize(TRUE);
} // CFCChipGroupListCtrl::SetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::GetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vstid	:stid_xZkqqHx_iCmMjFfMiOkGiPiHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::GetIdOrder (FDChipGroupIDVector& vstid) const
{
	vstid.clear();
	for	(long lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
		vstid.push_back(GetItemData(lIndex));
	}
} // CFCChipGroupListCtrl::GetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::GetRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCChipGroupRec* CFCChipGroupListCtrl::GetRec (DWORD dwId) const
{
	return (*m_mpIdToRec.find(dwId)).second.get();
} // CFCChipGroupListCtrl::GetRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::CanDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiNoNiPjMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCChipGroupListCtrl::CanDeleteItem () const
{
	if (!BASE_CLASS::CanDeleteItem()) return FALSE;
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKiLpDiCmFiCmIiCkPiCoKiCmOiNoNiPjMjFhDiJmC_xHqqkZx_ -----
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
//----- 01.05.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (IsSelectionMark(lIndex))
//			if (!GetRec(GetItemData(lIndex))->m_vFreqChip.empty()) return FALSE;
//----- 01.05.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiDiMiDfCiBfLiDgIiCmJiCmNiBeB_xHqqkZx_m_vFreqChip_xZkqqHx_iCkKiDfKiDgCiDgHiClDiCoKiCmE_xHqqkZx_
		// _xZkqqHx_iCkCiCmIiCkCiClNiCnPiBeB_xHqqkZx_g_pEnv _xZkqqHx_iCpAjClCiCnHiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if (IsSelectionMark(lIndex))
		{
			ChipGroupID cgid = GetItemData(lIndex);
			if (cgid < g_pEnv->GetChipGroupIDSize() &&
				g_pEnv->GetChipGroupRec(cgid) != NULL &&
				!g_pEnv->GetChipGroupRec(cgid)->m_vFreqChip.empty()) return FALSE;
		}
//----- 01.05.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
//----- 01.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long lFrontSelected;
//	long lMidSelected;
//	long lBackSelected;
//	GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
//	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKiIoKiCmCiCoAiOgDiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
//	if (GetItemCount() == lFrontSelected + lMidSelected + lBackSelected) return FALSE;
//----- 01.04.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // CFCChipGroupListCtrl::CanDeleteItem.

//----- 05.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::GetSubMenuIndex
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiPpAiMiPiCmFiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiDiBiDgKiDiFiBfLiCmMiBeB_xHqqkZx_IDR_RBTN_POPUP_xZkqqHx_iCmMjCiGiCmJ_xHqqkZx_
// *			_xZkqqHx_iCkIiCkPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeCjCmKiPoNiOjOiCmMiDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 0_xZkqqHx_iBeBiDeBiDeDiDgFiDiAiInKjDkOjCiGiCmM_xHqqkZx_
// *				 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long CFCChipGroupListCtrl::GetSubMenuIndex (long lId) const
//{
//	if (lId == 0) return 9;
//	return 10;
//} // CFCChipGroupListCtrl::GetSubMenuIndex.
//----- 05.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::OnInsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjBhNjDpMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jBhNjDpMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiDeBiDeDiDgFiDiAiCkKiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCChipGroupListCtrl::OnInsertItem (long lIndex, DWORD dwId)
{
//----- 02.02.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjGlMjBePiCmMiIoKjHjHiCpAiOoGjDlO_xHqqkZx_ -----
//	set<tcstring> stNameList;
//	IdToChipGroupCtrlRecMap::const_iterator iRc;
//	for (iRc = m_mpIdToRec.begin(); iRc != m_mpIdToRec.end(); iRc++)
//		stNameList.insert((const _TCHAR*)WStrToTStr((*iRc).second->m_szName));
//
//	//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCjGlMjBePiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
//	CString strName;
//	for (long lC = 1;; lC++)
//	{
//		// "_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_n"
//		strName.Format(_T("%s%d"), ::GetResWString(IDS_UNTITLED_CHIP_GROUP), lC);
//		if (stNameList.find((const _TCHAR*)strName) == stNameList.end()) break;
//	}
//
//	//----- _xZkqqHx_iNoMjAkMiClFiClNjGlMjBePiCmFiDiMiDfCiBfLiDgIiCpAjDgPjIfO_xHqqkZx_ -----
//	m_mpIdToRec[dwId] = ChipGroupCtrlRecAuto(new FCChipGroupRec(TStrToWStr(strName)));
//	return TRUE;
//----- 02.02.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjGlMjBePiCmMiIoKjHjHiCpAiOoGjDlO_xHqqkZx_ -----
	WStringSet stNameList;
	IdToChipGroupCtrlRecMap::const_iterator iRc;
	for (iRc = m_mpIdToRec.begin(); iRc != m_mpIdToRec.end(); iRc++)
		stNameList.insert((*iRc).second->m_szName);

	//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCjGlMjBePiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
	WString strName;
	for (long lC = 1;; lC++)
	{
		// "_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_n"
		strName.Format(L"%s%d", ::GetResWString(IDS_UNTITLED_CHIP_GROUP), lC);
		if (stNameList.find(strName) == stNameList.end()) break;
	}

	//----- _xZkqqHx_iNoMjAkMiClFiClNjGlMjBePiCmFiDiMiDfCiBfLiDgIiCpAjDgPjIfO_xHqqkZx_ -----
	m_mpIdToRec[dwId] = ChipGroupCtrlRecAuto(new FCChipGroupRec(strName));
	return TRUE;
//----- 02.02.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCChipGroupListCtrl::OnInsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::OnChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjFmPiNfIiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjFmPiNfIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCChipGroupListCtrl::OnChangeItem (long lIndex, DWORD dwId)
{
	// _xZkqqHx_jGlMjBePiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiBeC_xHqqkZx_
	CFCDlgInputStr dlgStr;
	// "_xZkqqHx_jDgPjIfOjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_";
	dlgStr.m_strTitle.LoadString(IDS_MSG_INPUT_ENTRY_NAME);
	dlgStr.m_strInput = WStrToTStr(GetRec(dwId)->m_szName);
	if (dlgStr.DoModal() != IDOK) return FALSE;
	(*m_mpIdToRec[dwId].get()) = FCChipGroupRec(TStrToWStr(dlgStr.m_strInput));
	return TRUE;
} // CFCChipGroupListCtrl::OnChangeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::OnDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiNoNiPjMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiNoNiPjMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCChipGroupListCtrl::OnDeleteItem (long lIndex, DWORD dwId)
{
	//----- _xZkqqHx_iCnMiClIiBeBiMlLiNnNiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhGiCpAiInKjDkO_xHqqkZx_ -----
	if (GetItemCount() == 1)
	//----- _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCkKiOgDiCoIiIoKiCmCiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_cgidCurrent = 0;
	} else
	if (dwId == m_cgidCurrent)
	//----- _xZkqqHx_iMlLiNnNiCmMiDgAiDgCiDhGiDePiDiLiBfLiDhGiCpAiNoNiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		long lIndex = ItemDataToIndex(m_cgidCurrent);
		if (GetItemCount() - 1 == lIndex)
			m_cgidCurrent = GetItemData(lIndex - 1);
		else
			m_cgidCurrent = GetItemData(lIndex + 1);
	}
	m_mpIdToRec.erase(dwId);
	return TRUE;
} // CFCChipGroupListCtrl::OnDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseFDA.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCChipGroupListCtrl::TransFDA (long lState, DWORD dwMessage, DWORD dwCommand)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	long lNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNiDfPiDiBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return lNextState;
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_LBUTTONDOWN:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (PointToColumn(NULL, m_ptMsc) != FDLL_CHIP_GROUP_NAME_CLM)
				lNextState = STATE_CLICK_NOT_NAME_COLUMN;		// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_CLICK_NOT_NAME_COLUMN:	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (lNextState == STATE_NONE)
		lNextState = BASE_CLASS::TransFDA(lState, dwMessage, dwCommand);
	return lNextState;
} // CFCChipGroupListCtrl::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::StateFDA (long lState)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_CLICK_NOT_NAME_COLUMN:		// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		StateClickNotNameColumn();
		break;
	default:
		BASE_CLASS::StateFDA(lState);
	}
} // CFCChipGroupListCtrl::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::StateClickNotNameColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDgAiDgCiDhGiDePiDiLiBfLiDhGjGlMiImIiKePiDeOiDiKiDgCiDeOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::StateClickNotNameColumn ()
{
	TRACE(_T("CFCChipGroupListCtrl::StateClickNotNameColumn\r\n"));
	long lIndex;
	if (PointToColumn(&lIndex, m_ptMsc) == FDLL_CURRENT_CHIP_GROUP_CLM)
	//----- _xZkqqHx_jFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (0 <= lIndex && m_cgidCurrent != GetItemData(lIndex))
		{
			// _xZkqqHx_iMmDiCkCjFfMiOkGjCiGiDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
			long lCurIdx = ItemDataToIndex(m_cgidCurrent);
			RedrawItems(lCurIdx, lCurIdx);
			RedrawItems(lIndex, lIndex);
			m_cgidCurrent = GetItemData(lIndex);
			// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
			GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
		}
	}
} // CFCChipGroupListCtrl::StateClickNotNameColumn.

BEGIN_MESSAGE_MAP(CFCChipGroupListCtrl, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCChipGroupListCtrl)
	ON_WM_DRAWITEM()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCChipGroupListCtrl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCChipGroupListCtrl::DrawItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDgJiBfLjFgAiJoGiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiPoDiCmMiKePiKmPiCkKjFmPiJlLiClFiClNiCmGiCkLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDIS	:_xZkqqHx_jHhGiLiBiClDiCoKiClNjFgAiJoGiCmMiMfOiCmJiCmCiCkCiCmEiCmMiPoOjFpBiCpAiOjNiCmC_xHqqkZx_
 *					 DRAWITEMSTRUCT _xZkqqHx_iNfMjBkCjBmMiCnGiCmM_xHqqkZx_ long _xZkqqHx_iDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCChipGroupListCtrl::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	CRect rtLabel;
	GetSubItemRect(lpDIS->itemID, 1, LVIR_LABEL, rtLabel);

	if (lpDIS->itemState & ODS_SELECTED)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.FillRect(&lpDIS->rcItem, FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjElNjDfNjAeGiBeC_xHqqkZx_
		atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, CP_ACP, rtLabel,
						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
	} else
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		// _xZkqqHx_jCmKiPoNiCmMjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDCSub.FillRect(&lpDIS->rcItem, FCAtBrush(pDC->GetBkColor()));
		atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, CP_ACP, rtLabel,
						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
	}
	if (GetItemState(lpDIS->itemID, LVIS_CUT) == LVIS_CUT)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.SetTextColor(::GetSysColor(COLOR_INACTIVECAPTION));
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		atDCSub.DrawText(GetRec(lpDIS->itemData)->m_szName, CP_ACP, rtLabel,
						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		atDCSub.DrawFocusRect(&lpDIS->rcItem);
	}
	if (lpDIS->itemData == m_cgidCurrent)
	{
		CImageList* pImg = GetImageList(LVSIL_SMALL);
		// _xZkqqHx_iOiLjDfPiCmMjFgAiJoGjIgHiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtEye;
		CListCtrl::GetItemRect(lpDIS->itemID, rtEye, LVIR_BOUNDS);
		rtEye.right = rtEye.left + GetColumnWidth(0);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
		CRgn rgn;
		rgn.CreateRectRgn(rtEye.left, rtEye.top, rtEye.right, rtEye.bottom);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDiKiBfLiDfHiDiHiDjDiCmNiDfCiDhDiBfLiClDiCoKiCoJiCmMiCmFiBeBiDeJiDiKiDfHiDgJiDiLiCmNiNoNiPjMiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		atDC.SetClipRgn(&rgn);
		long lx = (rtEye.Width() - 16) / 2;
		if (lx < 0) lx = 0;
		long ly = (rtEye.Height() - 16) / 2;
		if (ly < 0) ly = 0;
		if (lpDIS->itemState & ODS_SELECTED)
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_SELECTED);
		else
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_TRANSPARENT);
	}
} // CFCChipGroupListCtrl::DrawItem.

