#include "stdafx.h"
#include "DynamicDraw.h"
#include "FoundDoc.h"		// For g_pDoc.
#include "DlgSColorSelect.h"// For CFCDlgSColorSelect.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilStr.h"		// For GetResString.
#include "Env.h"			// For g_pEnv.
#include "DlgInputStr.h"	// For CFCDlgInputStr.
#include "CmbColorRef.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFCCmbColorRef

CFCCmbColorRef::CFCCmbColorRef ()
{
	m_crOriginal = FD_COLOR_REF_UNSPECIFY;
	m_crCurrent = FD_COLOR_REF_UNSPECIFY;
} // CFCCmbColorRef::CFCCmbColorRef.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_

ColorRefID CFCCmbColorRef::GetCurColorRef () const
{
	return m_crCurrent;
} // CFCCmbColorRef::GetCurColorRef.

void CFCCmbColorRef::SetCurColorRef (ColorRefID cref)
{
	m_crCurrent = cref;
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClFiCmIiCkCiCmIiCoHiCmOjFjMiLeBiBeCiDeBiDhGiDiKiPeJjHlJiOjOjDjJiCmJiBeCiBeC_xHqqkZx_
	if (!::IsWindow(m_hWnd)) return;
	//----- _xZkqqHx_iBhFjFmPiNfIiClFiCmIiCkCiBhGiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	if (cref == FD_COLOR_REF_UNSPECIFY)
	{
		SetCurSel(0);
		return;
	}
	//----- _xZkqqHx_jDgPjIfOiClDiCoKiClNiNiAjGnKiCmJiIoKjChGiClHiCoJjCgMiCkKiCkAiCoJiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	for (long lSel = GetCount() - 1; 2 <= lSel; lSel--)
	{
		if (cref == g_pEnv->scid2cref(SColorID(GetItemData(lSel))))
		{
			SetCurSel(lSel);
			return;
		}
	}
	//----- _xZkqqHx_jDgPjIfOiClDiCoKiClNiNiAjGnKiCmJiIoKjChGiClFiCmIiCkCiPoKiNiHiBeBjDmBjFmKjCgMiCpAjAnNjCoI_xHqqkZx_ -----
	m_crOriginal = cref;
	SetCurSel(1);	// _xZkqqHx_iBhFjDmBjFmKjCgMiBhGiCpAjBeJjBpAiBeC_xHqqkZx_
} // CFCCmbColorRef::SetCurColorRef.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDeJiBfLiDgPiBfLiDiJiDeDiDgI_xHqqkZx_
void CFCCmbColorRef::SelectOthers ()
{
	SColorID scid = g_pEnv->cref2scid(GetCurColorRef());
	if (GetCurColorRef() != FD_COLOR_REF_UNSPECIFY && scid == FD_S_COLOR_UNSPECIFY)
	{
		// "_xZkqqHx_jGkCjDgPjIfOiCmMjAeGiCmFiClHiBeCjDgPjIfOiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(IDS_MSG_IS_REGISTER_COLOR, 0, MB_YESNOCANCEL) == IDYES)
		{
			// _xZkqqHx_jAeGjGlMiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiBeC_xHqqkZx_
			// IDS_UNTITLED_COLOR = "_xZkqqHx_jGlDjBoIjAeG_xHqqkZx_"
			WString strColorName = GetResWString(IDS_UNTITLED_COLOR);
			CFCDlgInputStr dlgStr;
			// IDS_MSG_INPUT_ENTRY_NAME = "_xZkqqHx_jDgPjIfOjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_"
			dlgStr.m_strTitle = GetResWString(IDS_MSG_INPUT_ENTRY_NAME);
			dlgStr.m_strInput = strColorName;
			if (dlgStr.DoModal() == IDOK) strColorName = (const wchar_t*)TStrToWStr(dlgStr.m_strInput);
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->SessionBegin();
			// _xZkqqHx_jAfGiLeLiCmMjAeGiCpAjCmHiJmBjDgPjIfOiClHiCoJiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			SColorID scidNew;
//			g_pDoc->CmdInsert1SColor(scidNew, FCSColorRec(GetCurColorRef(), strColorName));
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// scid _xZkqqHx_iCmJjAfGiClFiCkCjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			g_pDoc->CmdInsert1SColor(scid, FCSColorRec(GetCurColorRef(), strColorName));
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
			g_pDoc->SessionEnd();
			// _xZkqqHx_jAeGjCmHiJmBiClFiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
			UpdateItem();
			// _xZkqqHx_jAeGiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
			SetCurColorRef(GetCurColorRef());
		}
	}
	CFCDlgSColorSelect dlg;
	dlg.SetProhibitDelete(TRUE);
	dlg.SetCurSColor(scid);
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (dlg.DoModal() == IDOK)
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jGkCjBeJjBpAiCmMiPoKiNiHiCmJ_xHqqkZx_FD_S_COLOR_UNSPECIFY_xZkqqHx_iCpAjFnEiClHiCmMiCmFiDgAiDeGiDgCiDeOiCkKjFeLjHhGiBeC_xHqqkZx_
	if (dlg.DoModal() == IDOK && dlg.GetCurSColor() != FD_S_COLOR_UNSPECIFY)
	//----- _xZkqqHx_jAeGiCkKjAnNjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//----- 06.06.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		UpdateItem();	// _xZkqqHx_jAeGjCmHiJmBiClFiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
		// _xZkqqHx_jDkHjGlOiCmNiOhHjCoIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		if (dlg.GetCurSColor() == FD_S_COLOR_UNUSE)
			SetCurColorRef(FD_COLOR_REF_UNSPECIFY);
		else
			SetCurColorRef(g_pEnv->scid2cref(dlg.GetCurSColor()));
		CWnd* pWnd = GetParent();
		if (pWnd == NULL) return;
		pWnd->SendMessage(WM_COMMAND, MAKELONG(GetDlgCtrlID(), CBBN_SELCHANGE),
							(LPARAM)m_hWnd);
	}
	else
	{
		SetCurColorRef(GetCurColorRef());
	}
} // CFCCmbColorRef::SelectOthers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbColorRef::SelChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbColorRef::SelChanged ()
{
	long lSel = GetCurSel();
	if (lSel == CB_ERR || lSel == 0)
	{
		m_crCurrent = FD_COLOR_REF_UNSPECIFY;
	} else
	if (lSel == 1)
	{
		m_crCurrent = m_crOriginal;
	} else
	{
		m_crCurrent = g_pEnv->scid2cref(GetItemData(lSel));
	}
} // CFCCmbColorRef::SelChanged.

#define	FD_COLOR_BOX_WIDTH	36
void CFCCmbColorRef::DrawItemSub (DWORD dwID, UINT wItem, ColorRefID col, CRect& lgrtBox, BOOL bIsDropped, CDC* pDC)
{
	SColorID scid = static_cast<SColorID>(dwID);
	if (scid == static_cast<SColorID>(-1) ||
		(scid == static_cast<SColorID>(-2) && m_crOriginal == FD_COLOR_REF_UNSPECIFY))
	//----- _xZkqqHx_jFmPiNfIjGlDiClFiCmMiPoKiNiHiBeBiIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jDkHjGlOjBeJjBpAiBjFiDeJiDiKiDfHiDgJiDiLjAeGiOhHjCoIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		BASE_CLASS::DrawItemSub(DWORD(FD_S_COLOR_UNSPECIFY), wItem, col, lgrtBox, bIsDropped, pDC);
	} else
	if (scid == static_cast<SColorID>(-2) && m_crOriginal != FD_COLOR_REF_UNSPECIFY)
	//----- _xZkqqHx_jDkHjGlOjBeJjBpAiBjFiDeJiDiKiDfHiDgJiDiLjAeGiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDC(pDC, FALSE, 0, 0);
		atDC.SetPen(PS_SOLID, 1, FD_COLREF_BLACK);
		atDC.SetBrush(::OptiColor(m_crOriginal));
		if (lgrtBox.Width() < FD_COLOR_BOX_WIDTH)
			atDC.Rectangle(lgrtBox);
		else
			atDC.Rectangle(CRect(	lgrtBox.left,
									lgrtBox.top,
						 			lgrtBox.left + FD_COLOR_BOX_WIDTH,
									lgrtBox.bottom));
	} else
	//----- _xZkqqHx_jCmKiPoNiCmMjAeGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		BASE_CLASS::DrawItemSub(dwID, wItem, col, lgrtBox, bIsDropped, pDC);
	}
} // CFCCmbColorRef::DrawItemSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbColorRef::OnItemPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmJiDhNiDeFiDfIiDeKiBfLiDfMiDiLiCkKjCoCiOhOiClFiClNiPoKiNiHiBeBjCmHjAnFiDhBiDjDiDgHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHjHhGiLiBiDiBiDgCiDfKiBfLiDfHiCkKjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiDiBiDgCiDfKiBfLiDfHiCmJiCoGiCoIiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrHintText	:_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCpAiOpDiCkPjDpMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiOpDiCkPjDpMiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FALSE_xZkqqHx_iCpAjFnEiClFiClNiPoKiNiHiBeBjCmHjAnFiDhBiDjDiDgHiCmNjAgFiDeFiDeCiDjDiDgIiDeFiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCmbColorRef::OnItemPursuerTextNeedInfo (WString& wstrHintText)
{
	// _xZkqqHx_jAeGiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	// FALSE _xZkqqHx_iCpAjFjMiLeBiClDiClJiCoJiClBiCmGiCmFiBeBiDgDiBfLiDiLiDgPiBfLiCmMiDhBiDjDiDgHjFfMiOkGiCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupColorHint())
	{
		// _xZkqqHx_iMlLiNnNiCmMjAeGiCpAiOoGjDlOiBeC_xHqqkZx_
		ColorRefID color = GetCurColorRef();
		if (color != FD_COLOR_REF_UNSPECIFY)
		//----- _xZkqqHx_iOhHjCoIiClFiCmIiCkC_xHqqkZx_ _xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			DWORD dwRed = 0;
			DWORD dwGreen = 0;
			DWORD dwBlue = 0;
			WString wstrName;
			if (color == FD_COLOR_REF_UNUSE)
			{
				// _xZkqqHx_jDkHjGlOiCmMiPoKiNiHiBeC_xHqqkZx_
				wstrName.LoadString(IDS_TRANSPARENT);
			} else
			{
				dwRed = GetRValue(color);
				dwGreen = GetGValue(color);
				dwBlue = GetBValue(color);
				// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_SColor_xZkqqHx_iCmMiCkEiClPiBeBiLnPiCkCjAeGiCpAjCfEiClHiBeC_xHqqkZx_
				SColorID scid;
				for (scid = 0; scid != g_pEnv->GetSColorIDSize(); scid++)
				{
// 06.06.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					if (g_pEnv->scid2cref(scid) == color)
					if (g_pEnv->GetSColorRec(scid) != NULL && g_pEnv->scid2cref(scid) == color)
					{
						wstrName = g_pEnv->scid2name(scid);
						break;
					}
				}
			}
			wstrHintText.Format((const wchar_t*)FFLoadWString(IDS_FORM_SCOLOR_HINT),
								wstrName.c_str(),
								dwRed, dwGreen, dwBlue);
			return TRUE;
		}
	}
	return FALSE;
} // CFCCmbColorRef::OnItemPursuerTextNeedInfo.

