#include "stdafx.h"
#include <algorithm>		// For sort template.
#include "DynamicDraw.h"	// For FFGetApp.
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDrawView.h"// For g_pView.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "UtilMath.h"		// For _i64tow10fig.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilWin.h"		// For FFNotifyPendingMessage.
#include "UtilMisc.h"		// For FFSetCapture.etc.
#include "UtilStr.h"		// For FormatResString.
#include "RegData.h"		// For InitRegFont.
#include "ToolBase.h"		// For g_pView->GetCurrentTool().
#include "PursuerText.h"	// For CFCPursuerText.
#include "CtlBrHRuler.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#define FD_RULER_WIDTH	20

// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#define FD_RULER_TOP	2

//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define FD_RULER_WIDTH	20
//#define FD_RULER_HALF	10
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#define FD_RULER_WIDTH	22
#define FD_RULER_HALF	12
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

#define FD_ICN_OFFSET_WIDTH		26
#define FD_ICN_OFFSET_HEIGHT	10
#define FD_ICN_OFFSET_CENTER	19
#define FD_ICN_OFFSET_BORDER	12

#define FD_ICN_START_WIDTH		13
#define FD_ICN_START_HEIGHT		10
#define FD_ICN_START_CENTER		6

#define FD_ICN_RIGHT_WIDTH		13
#define FD_ICN_RIGHT_HEIGHT		10
#define FD_ICN_RIGHT_CENTER		6

#define FD_ICN_TAB_WIDTH		6
#define FD_ICN_TAB_HEIGHT		6
#define FD_ICN_TAB_CENTER		0

////////////////////////////////////////////////////////////////////////////
// CFCCtlBrHRuler_xZkqqHx_iBeC_xHqqkZx_

IMPLEMENT_DYNAMIC(CFCCtlBrHRuler, CControlBar)

BEGIN_MESSAGE_MAP(CFCCtlBrHRuler, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCtlBrHRuler)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_RBTN_RULER_CLEAR_ALL_TAB_POS, OnRbtnRulerClearAllTabPos)
	ON_UPDATE_COMMAND_UI(ID_RBTN_RULER_CLEAR_ALL_TAB_POS, OnUpdateRulerClearAllTabPos)
	ON_WM_INITMENUPOPUP()
	ON_WM_SHOWWINDOW()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_MESSAGE(WM_USER_UPDATE_RULER, OnUserUpdateRuler)
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//CFCCtlBrHRuler::CFCCtlBrHRuler (BOOL bDrawBorder)
//{
//	m_bDrawBorder = bDrawBorder;
//} // CFCCtlBrHRuler::CFCCtlBrHRuler.
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
CFCCtlBrHRuler::CFCCtlBrHRuler ()
{
} // CFCCtlBrHRuler::CFCCtlBrHRuler.
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

CFCCtlBrHRuler::~CFCCtlBrHRuler ()
{
} // CFCCtlBrHRuler::~CFCCtlBrHRuler.

BOOL CFCCtlBrHRuler::Create (CWnd* pParentWnd, DWORD dwStyle, UINT nID)
{
	ASSERT_VALID(pParentWnd);   // must have a parent

	dwStyle |= WS_CLIPSIBLINGS;
	// force WS_CLIPSIBLINGS (avoids SetWindowPos bugs)

	// create the HWND
	CRect rect;
	rect.SetRectEmpty();
	LPCTSTR lpszClass = AfxRegisterWndClass(0,
							::FFGetApp()->LoadStandardCursor(IDC_ARROW),
							(HBRUSH)(COLOR_BTNFACE+1), NULL);

	if (!CWnd::Create(lpszClass, NULL, dwStyle, rect, pParentWnd, nID))
		return FALSE;

	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	m_mmPitch0 = 0.0;				// _xZkqqHx_iNnHiCkJiCkCiNiPiCnNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_mmPitch1 = 0.0;				// _xZkqqHx_jBoFiCkLiCkCiNiPiCnNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_nZoomFig = 0;					// Zoom_xZkqqHx_iCmMiMiFiBeC_xHqqkZx_10^m_nZoomFig_xZkqqHx_iBeC_xHqqkZx_
	m_dvOffset = 0;					// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBeC_xHqqkZx_0_xZkqqHx_iCkJiCoHiNlGjFpLiMpMiCnGiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dvrctRuler.SetRect(0,0,0,0);	// Ruler_xZkqqHx_jFgAiJoGjHmMiIoGiBeCiDgGiDgPiDeDiDfIiNmAjFfHiBeC_xHqqkZx_
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiKnGiMfH_xHqqkZx_ -----
	memset(m_baIsRulerMMKVisible, 0, sizeof(m_baIsRulerMMKVisible));
	memset(m_lgaRulerMMK, 0, sizeof(m_lgaRulerMMK));
//----------<NOT EXPORT TO VIEWER>-----------
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiBeC_xHqqkZx_
	m_wndpTarget = NULL;
	//----- _xZkqqHx_iDhNiBfLiDeKiBfLiCmMiDeBiDeDiDfCiDjDjDmHiCnNiNjOiCnN_xHqqkZx_ -----
	m_hIconUpMark	= FFGetApp()->LoadIcon(IDI_RULER_MARK_UP);
	m_hIconDownMark	= FFGetApp()->LoadIcon(IDI_RULER_MARK_DWN);
	m_hiMarkOffset	= FFGetApp()->LoadIcon(IDI_RULER_MARK_OFFSET);
	m_hiTab			= FFGetApp()->LoadIcon(IDI_TAB);
//----------</NOT EXPORT TO VIEWER>-----------
	return TRUE;
} // CFCCtlBrHRuler::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::ScrollTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_DynamicDrawView.cpp_xZkqqHx_iCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgVal	:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::ScrollTo (long lgVal)
{
	if (m_dvrctRuler.Width() < ::abs(m_dvOffset - lgVal))
	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKjFgAiJoGjEmNiImNiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_dvOffset = lgVal;
		RedrawWindow();
	} else
	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKjFgAiJoGjEmNiImNiCpAjClEiCkGiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CClientDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_.
//		CRect	client;
//		(void)dc.ScrollDC(m_dvOffset - lgVal, 0, &m_dvrctRuler, &m_dvrctRuler,
//							NULL, &client);
//
//		m_dvOffset = lgVal;
//		RedrawWindow(&client, NULL, RDW_INVALIDATE | RDW_UPDATENOW);
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		ScrollWindow(m_dvOffset - lgVal, 0, m_dvrctRuler, m_dvrctRuler);
		m_dvOffset = lgVal;
		UpdateWindow();
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // CFCCtlBrHRuler::ScrollTo.

//----- 03.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnViewSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView_xZkqqHx_iCmMiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiOjOiBeBiDfEiDeDiDfJiCpAjDoAjFjEjFmPjAjEiCmJiOoGiCoIiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCDynamicDrawView::UpdateScrollSize_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCCtlBrHRuler::OnViewSize ()
//{
//	TRACE(_T("CFCCtlBrHRuler::OnViewSizeA\n"));
//	if (g_pView != NULL)
//	{
//		TRACE(_T("CFCCtlBrHRuler::OnViewSizeB\n"));
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAjIfPjHjNiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
//		g_pView->GetClientRectLG(m_dvrctRuler);
//		// View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
//		m_dvOffset = m_dvrctRuler.left;
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//		m_dvrctRuler.left = 0;
//		m_dvrctRuler.right -= m_dvOffset;
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAiBeBiClBiCmMiDiLiBfLiDiJiBfLiCmFiCmMjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//		g_pView->ClientToScreen(&m_dvrctRuler);
//		ScreenToClient(&m_dvrctRuler);
//		// m_dvrctRuler_xZkqqHx_iCpAiBeBiDiLiBfLiDiJiBfLiCmMiDhCiDiFiBfLjEmNiImNiCmMjDgIiCoIiCmCiCnEiClFjHmMiIoGiCmJiBeC_xHqqkZx_
//		m_dvrctRuler.top = 0;
//		m_dvrctRuler.bottom = FD_RULER_WIDTH;
//	}
//
//	//----- Scale_xZkqqHx_iKnGiMfHiPiJiKpKiJlL_xHqqkZx_ -----
//
//	//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkK_xHqqkZx_20pixel_xZkqqHx_jCpGjDhIiCmJiCmIiCoJiCoGiCkEiCmJiBeBiDhDiDgCiDgAiCpAjClCjAkO_xHqqkZx_ -----
//	// 20pixel_xZkqqHx_iCpA_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//	hic hiPitch = lg2hi(20);
//	//----- HI_xZkqqHx_iNmAjFfHjCgMiCpAiBeB_xHqqkZx_a * 10^b (1 <= a < 10) _xZkqqHx_iCmJjFmPiKlH_xHqqkZx_ -----
//	double b = log10(hiPitch);
//	if (0 < b)
//	{
//		b = int(b);
//	} else
//	{
//		if ((b - int(b)) != 0.0)
//			b = int(b) - 1.0;
//	}
//	double p = pow(10.0, b);
//	double a = hiPitch / p;
//	//----- a _xZkqqHx_iCpA_xHqqkZx_1.0,2.5,5.0,10.0_xZkqqHx_iCmMiCkCiClIiCoKiCkJiLnPiCkCjCgMiCmJjFfHiPiAiJlL_xHqqkZx_ -----
//	double ra = 1.0;
//	double dif = fabs(a - ra);
//	// _xZkqqHx_iDhDiDgCiDgAiCfAiCmMiPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiBeC_xHqqkZx_0.1 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
//	short nZoomFigure = b + 1.0;
//	if (fabs(a - 2.5) < dif)
//	{
//		ra = 2.5;
//		dif = fabs(a - ra);
//		nZoomFigure = b;
//	}
//	if (fabs(a - 5.0) < dif)
//	{
//		ra = 5.0;
//		dif = fabs(a - ra);
//		nZoomFigure = b + 1.0;
//	}
//	if (fabs(a - 10.0) < dif)
//	{
//		ra = 10.0;
//		dif = fabs(a - ra);
//		nZoomFigure = b + 2.0;
//	}
//	if (0 < nZoomFigure) nZoomFigure = 0;
//	// Scale_xZkqqHx_iCmMiNnHiCkJiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
//	mmetol mmScalePitch0 = hi2mm(ra * p);
//	// Scale_xZkqqHx_iCmMjBlOiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
//	mmetol mmScalePitch1 = 10.0 * mmScalePitch0;
//	// _xZkqqHx_iDhDiDgCiDgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	SetPitch(mmScalePitch0, mmScalePitch1, nZoomFigure);
//
//	TRACE(_T("CFCCtlBrHRuler::OnViewSizeC %f\n"), mmScalePitch0);
//
//	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
//	Invalidate();
//} // CFCCtlBrHRuler::OnViewSize.
//----- 03.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void CFCCtlBrHRuler::SetPitch (mmetol mmPitch0, mmetol mmPitch1, short nZoomFig)
{
	m_mmPitch0 = mmPitch0;
	m_mmPitch1 = mmPitch1;
	m_nZoomFig = nZoomFig;
	Invalidate();
} // CFCCtlBrHRuler::SetPitch.

void CFCCtlBrHRuler::SetTextRange (CWnd* wndpTarget, mmetol vmmBegin, mmetol vmmEnd)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiBeC_xHqqkZx_
	m_wndpTarget = wndpTarget;
	m_vmmBegin	= vmmBegin;		// _xZkqqHx_jFfMiOkGjEmNiImNiCmMiKeKiOgOiNmAjFfH_xHqqkZx_.
	m_vmmEnd	= vmmEnd;		// _xZkqqHx_jFfMiOkGjEmNiImNiCmMiPeJjHlJiNmAjFfH_xHqqkZx_.

// 05.11.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_markerMovingStat = FDHR_NONE;	// _xZkqqHx_iDhNiBfLiDeOiCmMiPpDjBnEiCpAiOkGiClH_xHqqkZx_.
	m_whichMarkerMoving = NONE;		// _xZkqqHx_iInKjDkOjBmOiPnLiCmMiDhNiBfLiDeKiBfLiBeC_xHqqkZx_

	m_tmmMarkerLeft		= 0.0;
	m_tmmMarkerRight		= vmmEnd - vmmBegin;
	m_tmmMarkerOffset	= 0.0;

	Invalidate();
} // CFCCtlBrHRuler::SetTextRange.

void CFCCtlBrHRuler::UnSetTextRange ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiBeC_xHqqkZx_
	m_wndpTarget = NULL;
	Invalidate();
} // CFCCtlBrHRuler::UnSetTextRange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::IsRulerMMKVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCmMiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	: _xZkqqHx_jClCiCnHiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *************************************************************************/
BOOL CFCCtlBrHRuler::IsRulerMMKVisible (short nIndex) const
{
	return m_baIsRulerMMKVisible[nIndex];
} // CFCCtlBrHRuler::IsRulerMMKVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::SetRulerMMKVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	: _xZkqqHx_jAnNjCoIiClFiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *			bVisible: _xZkqqHx_jAnNjCoIiClHiCoJjFfMiOkGiBeFjEpBjFfMiOkGiCmMiPpDjBnE_xHqqkZx_.
 *************************************************************************/
void CFCCtlBrHRuler::SetRulerMMKVisible (short nIndex, BOOL bVisible)
{
	if (m_baIsRulerMMKVisible[nIndex] == bVisible) return;
	m_baIsRulerMMKVisible[nIndex] = bVisible;
	if (!IsWindowVisible()) return;

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(this);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
	FCEditDraw eDraw(&dc, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
								g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);
	//----- _xZkqqHx_iDgPiBfLiCpAiPmBiLiOiIlNiCkCiCmNjFfMiOkG_xHqqkZx_ -----
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	eDraw.Line(	&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), 0),
//				&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	eDraw.Line(	&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_TOP),
				&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrHRuler::SetRulerMMKVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::MoveRulerMMK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	:_xZkqqHx_iInKjDkOiClFiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *			lgVal	:_xZkqqHx_iInKjDkOjAoGiCmMiNmAjFfHiBgJ_xHqqkZx_View_xZkqqHx_jIfPjHjNiNmAjFfHiBgK_xHqqkZx_.
 *************************************************************************/
void CFCCtlBrHRuler::MoveRulerMMK (short nIndex, long lgVal)
{
	if (m_baIsRulerMMKVisible[nIndex])
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjFfMiOkGiPpDjBnE_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		CClientDC dc(this);
		// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
		FCEditDraw eDraw(&dc, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
									g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);
		// _xZkqqHx_iDgPiBfLiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiBgJjFkIjHjNiNmAjFfHiBgKiCpAiMhGiOfKiBeC_xHqqkZx_
		long dvX = VLG2DV(m_lgaRulerMMK[nIndex]);
		// _xZkqqHx_iDiLiBfLiDiJiBfLjFgAiJoGjHmMiIoGjDoAiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_dvrctRuler.left <= dvX && dvX <= m_dvrctRuler.right)
		{
			//----- _xZkqqHx_iMlLiNnNiCmMiDgPiBfLiCpAiPmBiLiO_xHqqkZx_ -----
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			eDraw.Line(	&CPoint(dvX, 0),
//						&CPoint(dvX, FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			eDraw.Line(	&CPoint(dvX, FD_RULER_TOP),
						&CPoint(dvX, FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
		// _xZkqqHx_jAfGiClFiCkCiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lgaRulerMMK[nIndex] = lgVal;
		// _xZkqqHx_iDgPiBfLiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiBgJjFkIjHjNiNmAjFfHiBgKiCpAiMhGiOfKiBeC_xHqqkZx_
		dvX = VLG2DV(m_lgaRulerMMK[nIndex]);
		// _xZkqqHx_iDiLiBfLiDiJiBfLjFgAiJoGjHmMiIoGjDoAiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_dvrctRuler.left <= dvX && dvX <= m_dvrctRuler.right)
		{
			//----- _xZkqqHx_jAfGiClFiCkCiDgPiBfLiCpAjFgAiJoG_xHqqkZx_ -----
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			eDraw.Line(	&CPoint(dvX, 0),
//						&CPoint(dvX, FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			eDraw.Line(	&CPoint(dvX, FD_RULER_TOP),
						&CPoint(dvX, FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	} else
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjEpBjFfMiOkGiPpDjBnE_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lgaRulerMMK[nIndex] = lgVal;
	}
} // CFCCtlBrHRuler::MoveRulerMMK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::GetLeftIndent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOiNhDiCmMiDeDiDjDiDgGiDjDiDgHjHmKiCpAjFnEiClHiBeCiDgFiDeMiDfIiDgHiOmAiNmAjFfHiBeC_xHqqkZx_
 *************************************************************************/
mmetol CFCCtlBrHRuler::GetLeftIndent () const
{
	return m_tmmMarkerLeft;
} // CFCCtlBrHRuler::GetLeftIndent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::GetOffsetIndent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiDeJiDhEiDfKiDgCiDgHiCpAjFnEiClHiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *************************************************************************/
mmetol CFCCtlBrHRuler::GetOffsetIndent () const
{
	return m_tmmMarkerOffset - m_tmmMarkerLeft;
} // CFCCtlBrHRuler::GetOffsetIndent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::GetRightIndent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHjHmKiCpAjFnEiClHiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *************************************************************************/
mmetol CFCCtlBrHRuler::GetRightIndent () const
{
	return (m_vmmEnd - m_vmmBegin) - m_tmmMarkerRight;
} // CFCCtlBrHRuler::GetRightIndent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::SetStartIndent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOiNhDiBeBiMhAjBlBiNhDiBeBiJeFiCmMiDeDiDjDiDgGiDjDiDgHjHmKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tmmStart	: _xZkqqHx_iDeDiDjDiDgGiDjDiDgHjHmK_xHqqkZx_._xZkqqHx_iDgFiDeMiDfIiDgHiOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::Set3Indents (mmetol tmmStart, mmetol tmmOffset,
									mmetol tmmRight)
{
	CRectVector	rctvRgn;

	if (m_tmmMarkerLeft != tmmStart)
	{
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
		m_tmmMarkerLeft = tmmStart;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
	}
	if (m_tmmMarkerOffset != tmmOffset + m_tmmMarkerLeft)
	{
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
		m_tmmMarkerOffset = tmmOffset + m_tmmMarkerLeft;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
	}
	if (m_tmmMarkerRight != m_vmmEnd - m_vmmBegin - tmmRight)
	{
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerRight) - FD_ICN_RIGHT_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
								FD_RULER_WIDTH));
		m_tmmMarkerRight = m_vmmEnd - m_vmmBegin - tmmRight;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerRight) - FD_ICN_RIGHT_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
								FD_RULER_WIDTH));
	}
	// _xZkqqHx_iInKjDkOiCkKjGlDiCkPiCoKiCmOiClLiCmMiCnMiCnMjFjMiLeB_xHqqkZx_.
	if (rctvRgn.empty()) return;

	CClientDC dc(this);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);
	CRgn	rgn1;
	CRgn	rgn2;
	CRectVector::iterator iR;

	//----- CDC_xZkqqHx_iCmMiDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkM_xHqqkZx_ -----
	rgn1.CreateRectRgn(0,0,0,0);
	for (iR = rctvRgn.begin(); iR != rctvRgn.end(); iR++)
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiCgOiChBiCmFjCmHiJmBiClHiCoJ_xHqqkZx_ -----
		rgn2.CreateRectRgn((*iR).left, (*iR).top,
							(*iR).right, (*iR).bottom);
		rgn1.CombineRgn(&rgn1, &rgn2, RGN_OR);
		rgn2.DeleteObject();
	}
	// CDC_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetClipRgn(&rgn1);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiMiDjDiDfHiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	DrawTextRange(&dc);
} // CFCCtlBrHRuler::Set3Indents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::GetTabs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDhFiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDhFiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const mmetolVector& CFCCtlBrHRuler::GetTabs () const
{
	return m_vtmmTabMarkers;
} // CFCCtlBrHRuler::GetTabs.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::SetTabs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDhFiCmMiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vtmmTabs	:_xZkqqHx_iDfOiDhFiImKjChFiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::SetTabs (const mmetolVector& vtmmTabs)
{
	// _xZkqqHx_iDfOiDhFiCmMiImKjChFiCkKjBfDiCmEjDkPiClGiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (m_vtmmTabMarkers == vtmmTabs) return;
	CRectVector rctvRgn;
	mmetolVector::const_iterator iDb;
	for (iDb = m_vtmmTabMarkers.begin(); iDb != m_vtmmTabMarkers.end(); iDb++)
	{
		rctvRgn.push_back(CRect(TMM2DV(*iDb) - FD_ICN_TAB_CENTER,
								FD_RULER_HALF,
								TMM2DV(*iDb) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
								FD_RULER_WIDTH));
	}
	m_vtmmTabMarkers = vtmmTabs;
	for (iDb = m_vtmmTabMarkers.begin(); iDb != m_vtmmTabMarkers.end(); iDb++)
	{
		rctvRgn.push_back(CRect(TMM2DV(*iDb) - FD_ICN_TAB_CENTER,
								FD_RULER_HALF,
								TMM2DV(*iDb) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
								FD_RULER_WIDTH));
	}
	CClientDC dc(this);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);
	CRgn rgn1;
	CRgn rgn2;
	CRectVector::iterator iR;
	//----- CDC_xZkqqHx_iCmMiDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkM_xHqqkZx_ -----
	rgn1.CreateRectRgn(0,0,0,0);
	for (iR = rctvRgn.begin(); iR != rctvRgn.end(); iR++)
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiCgOiChBiCmFjCmHiJmBiClHiCoJ_xHqqkZx_ -----
		rgn2.CreateRectRgn((*iR).left, (*iR).top,
							(*iR).right, (*iR).bottom);
		rgn1.CombineRgn(&rgn1, &rgn2, RGN_OR);
		rgn2.DeleteObject();
	}
	// CDC_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetClipRgn(&rgn1);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiMiDjDiDfHiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	DrawTextRange(&dc);
} // CFCCtlBrHRuler::SetTabs.

long CFCCtlBrHRuler::VLG2DV (long lgVal) const
{
	return lgVal + m_dvrctRuler.left - m_dvOffset;
} // CFCCtlBrHRuler::VLG2DV.

long CFCCtlBrHRuler::DV2VLG (long dvVal) const
{
	return dvVal - m_dvrctRuler.left + m_dvOffset;
} // CFCCtlBrHRuler::DV2VLG.

long CFCCtlBrHRuler::VMM2DV (mmetol vmmVal) const
{
	return VLG2DV(mm2lg(vmmVal));
} // CFCCtlBrHRuler::VMM2DV.

mmetol CFCCtlBrHRuler::DV2VMM (long dvVal) const
{
	return lg2mm(DV2VLG(dvVal));
} // CFCCtlBrHRuler::DV2VMM.

long CFCCtlBrHRuler::TMM2DV (mmetol tmmVal) const
{
	return VMM2DV(tmmVal + m_vmmBegin);
} // CFCCtlBrHRuler::TMM2DV.

mmetol CFCCtlBrHRuler::DV2TMM (long dvVal) const
{
	return DV2VMM(dvVal) - m_vmmBegin;
} // CFCCtlBrHRuler::DV2TMM.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::DrawTextRange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHiDiCiBfLiDgIiOjOiCmMiDiLiBfLiDiJiBfLiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::DrawTextRange (CDC* pDC)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	atDC.SetMapMode(MM_TEXT);	// DrawIcon_xZkqqHx_iCmMiInH_xHqqkZx_.

	long	dvBegin = VMM2DV(m_vmmBegin);
	long	dvEnd = VMM2DV(m_vmmEnd);

	// _xZkqqHx_iMlLiNnNiCmMiDeOiDiKiDgCiDhGiCmJiDiLiBfLiDiJiBfLjHmMiIoGiCpAiPgEiCmLiCmEjAnNjCoI_xHqqkZx_.
	atDC.IntersectClipRect(&m_dvrctRuler);

	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiCpAjDlOiCoJiBeC_xHqqkZx_dvrctClip_xZkqqHx_iCmNiDgGiDgPiDeDiDfIiNmAjFfHiMgOiBeC_xHqqkZx_
	CRect	dvrctClip;
	pDC->GetClipBox(&dvrctClip);

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long	dvVal;
//	long	lC;
//	wchar_t	tcsBuf[200];
//	CSize	szText;
//	CRect	rctNewClip;
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	atDC.SetPen(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
//	FCAtFont font;
//	g_pReg->InitRegFont(*font.Get(), FDFT_HRULER_DIGITS, 0);
//	atDC.SetObject(font);
//	//----- _xZkqqHx_jFlGiOjKjFgAiJoGiCmMjAeGiBjFiDiCiBfLiDgIiCpAjAnNjCoI_xHqqkZx_ -----
//	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
//	atDC.SetBkMode(TRANSPARENT);
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiCpAjDgIjCnHiClH_xHqqkZx_ -----
	CRect rtPaint;
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiNlGiCpAjDgIjCnHiClH_xHqqkZx_ -----
	FCAtBrush brOutside(::g_pReg->GetOptiRegColor(FDCL_RULER_DARK_FACE));
	rtPaint.SetRect(m_dvrctRuler.left, 0, dvBegin, FD_RULER_WIDTH);
	rtPaint &= dvrctClip;
	if (!rtPaint.IsRectEmpty()) atDC.FillRect(rtPaint, brOutside);
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiJeFiCpAjDgIjCnHiClH_xHqqkZx_ -----
	rtPaint.SetRect(dvEnd, 0, m_dvrctRuler.right,  FD_RULER_WIDTH);
	rtPaint &= dvrctClip;
	if (!rtPaint.IsRectEmpty()) atDC.FillRect(rtPaint, brOutside);
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiCpAjDgIjCnHiClH_xHqqkZx_ -----
	rtPaint.SetRect(dvBegin, 0, dvEnd, FD_RULER_WIDTH);
	rtPaint &= dvrctClip;
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!rtPaint.IsRectEmpty())
//		atDC.FillRect(rtPaint, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT)));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!rtPaint.IsRectEmpty())
		atDC.FillRect(rtPaint, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_FACE)));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiPoDjFjEiCmMiNgBiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.right, m_dvrctRuler.top);
	// _xZkqqHx_iNgBiCmMiMpFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top + 1);
	atDC.LineTo(m_dvrctRuler.right, m_dvrctRuler.top + 1);
	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	FCAtFont font;
	g_pReg->InitRegFont(*font.Get(), FDFT_HRULER_DIGITS, 0);
	atDC.SetObject(font);
	//----- _xZkqqHx_jFlGiOjKjFgAiJoGiCmMjAeGiBjFiDiCiBfLiDgIiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
	atDC.SetBkMode(TRANSPARENT);

	//----- _xZkqqHx_iDhDiDgCiDgA_xHqqkZx_1_xZkqqHx_iCmMjAjEjCgMiCmMjFfMiOkG_xHqqkZx_ -----
	long lC = static_cast<long>(DV2TMM(dvrctClip.left) / m_mmPitch1) - 1;
	double dFig = 1.0;
	if (m_nZoomFig != 0) dFig = pow(10.0, m_nZoomFig);
	for (;; lC++)
	{
		long dvVal = TMM2DV(lC * m_mmPitch1);
		wchar_t tcsBuf[200];
		_i64tow10fig(D2LL(mm2hi(lC * m_mmPitch1) / dFig), tcsBuf, m_nZoomFig);
		CSize szText = atDC.GetTextExtent(tcsBuf, wcslen(tcsBuf));
		if (dvrctClip.right < dvVal - szText.cx / 2) break;
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDC.TextOut(dvVal - szText.cx / 2, 0, tcsBuf, wcslen(tcsBuf), CP_ACP);
		atDC.TextOut(dvVal - szText.cx / 2, FD_RULER_TOP, tcsBuf, wcslen(tcsBuf), CP_ACP);
	}

	//----- _xZkqqHx_iDfOiDhFiCmMjFfMiOkG_xHqqkZx_ -----
	mmetolVector::const_iterator iDb;
	for (iDb = m_vtmmTabMarkers.begin(); iDb != m_vtmmTabMarkers.end(); iDb++)
	{
		// _xZkqqHx_jEmNiImNiKePiClOiCmGiDfOiDhFiCpAjFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
		if (*iDb < 0) continue;
		long dvTab = TMM2DV(*iDb);
		atDC.DrawIconEx(dvTab - FD_ICN_TAB_CENTER, FD_RULER_HALF,
						m_hiTab, FD_ICN_TAB_WIDTH, FD_ICN_TAB_HEIGHT,
						0, NULL, DI_NORMAL);
	}

	//----- _xZkqqHx_iDhNiBfLiDeKiBfLiCmMjFfMiOkG_xHqqkZx_ -----
	long	dvMarkStart = TMM2DV(m_tmmMarkerLeft);
	long	dvMarkRight = TMM2DV(m_tmmMarkerRight);
	long	dvMarkOffset = TMM2DV(m_tmmMarkerOffset);

//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	atDC.DrawIconEx(dvMarkStart - FD_ICN_START_CENTER, 0,
//					m_hIconUpMark, FD_ICN_START_WIDTH, FD_ICN_START_HEIGHT,
//					0, NULL, DI_NORMAL);
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	atDC.DrawIconEx(dvMarkStart - FD_ICN_START_CENTER,
					FD_RULER_TOP,
					m_hIconUpMark,
					FD_ICN_START_WIDTH,
					FD_ICN_START_HEIGHT,
					0, NULL, DI_NORMAL);
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	atDC.DrawIconEx(dvMarkOffset - FD_ICN_OFFSET_CENTER,
					FD_RULER_HALF,
					m_hiMarkOffset,
					FD_ICN_OFFSET_WIDTH,
					FD_ICN_OFFSET_HEIGHT,
					0, NULL, DI_NORMAL);
	atDC.DrawIconEx(dvMarkRight - FD_ICN_RIGHT_CENTER,
					FD_RULER_HALF,
					m_hIconDownMark,
					FD_ICN_RIGHT_WIDTH,
					FD_ICN_RIGHT_HEIGHT,
					0, NULL, DI_NORMAL);

	//----- _xZkqqHx_iDhDiDgCiDgA_xHqqkZx_0_xZkqqHx_iCmMjGnKjAlHiCmMjFfMiOkG_xHqqkZx_ -----
	lC = static_cast<long>(DV2TMM(dvrctClip.left) / m_mmPitch0) - 1;
	for (;; lC++)
	{
		long dvVal = TMM2DV(lC * m_mmPitch0);
		if (dvrctClip.right < dvVal) break;
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		atDC.MoveTo(dvVal, 0);
//		atDC.LineTo(dvVal, 3);
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		atDC.MoveTo(dvVal, FD_RULER_TOP);
		atDC.LineTo(dvVal, FD_RULER_TOP + 3);
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		atDC.MoveTo(dvVal, FD_RULER_WIDTH  - 3);
		atDC.LineTo(dvVal, FD_RULER_WIDTH);
	}

	//----- _xZkqqHx_iDhDiDgCiDgA_xHqqkZx_1_xZkqqHx_iCmMjGnKjAlHiCmMjFfMiOkG_xHqqkZx_ -----
	lC = static_cast<long>(DV2TMM(dvrctClip.left) / m_mmPitch1) - 1;
	for (;; lC++)
	{
		long dvVal = TMM2DV(lC * m_mmPitch1);
		if (dvrctClip.right < dvVal) break;
		atDC.MoveTo(dvVal, FD_RULER_WIDTH - 6);
		atDC.LineTo(dvVal, FD_RULER_WIDTH);
	}
} // CFCCtlBrHRuler::DrawTextRange.

//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnUpdatePopupMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeB_xHqqkZx_
// *			_xZkqqHx_jGlDiMpIiCmMiDfCiDhNiDjDiDgIiCmNiDePiDiMiBfLiBjFjGlDiMpIiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMenu	:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCCtlBrHRuler::OnUpdatePopupMenu (CMenu* pMenu) const
//{
//#ifndef _DEBUG
//_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiNoNiPjMiCmFiCkLiCoJiCmMiCmFiCmNiBeI_xHqqkZx_
//CFCCtlBrHTree::OnCmdMsg_xZkqqHx_iCmG_xHqqkZx_CFCWndHistoryTree_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiPiIjHjNiCpAiOfBiPmGiBeC_xHqqkZx_
//#endif//_DEBUG
//	ON_UPDATE_POPUP_MENU(ID_RBTN_RULER_CLEAR_ALL_TAB_POS,
//							g_pDoc->GetIsDocumentOpened() &&
//							g_pView->GetCurrentTool()->IsEditingText() &&
//							!GetTabs().empty())
//} // CFCCtlBrHRuler::OnUpdatePopupMenu.
//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::PointToWhichMarker
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmMiImKjChFiCmJiCkAiCoJiBeBiDhNiBfLiDeKiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lTabIndex	:_xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfLiCmMiPoKiNiHiCmNiDfOiDhFiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrHRuler::WhichMarker CFCCtlBrHRuler::PointToWhichMarker (long& lTabIndex, const CPoint& dvpt) const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHjCiGiCmFiCmIiCkCiPoKiNiHiCmNiDhNiBfLiDeKiBfLiCmNjGlDiCkCiBeC_xHqqkZx_
	if (m_wndpTarget == NULL)
		return NONE;

	//----- _xZkqqHx_iKeKiOgOiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
	if (CRect(	TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				0,
				FD_RULER_TOP,
				TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
				FD_RULER_HALF - 1).PtInRect(dvpt))
	{
		return LEFT_MARKER;
	}
	//----- _xZkqqHx_iCnEiCoHiJlKiClAiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
	if (CRect(	TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER + FD_ICN_OFFSET_BORDER,
				FD_RULER_HALF,
				TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
				FD_RULER_WIDTH - 1).PtInRect(dvpt))
	{
		return OFFSET_MARKER;
	}
	//----- _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
	if (CRect(	TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER,
				FD_RULER_HALF,
				TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER + FD_ICN_OFFSET_BORDER,
				FD_RULER_WIDTH - 1).PtInRect(dvpt))
	{
		return BOTH_MARKER;
	}
	//----- _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
	if (CRect(	TMM2DV(m_tmmMarkerRight) - FD_ICN_RIGHT_CENTER,
				FD_RULER_HALF,
				TMM2DV(m_tmmMarkerRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
			 	FD_RULER_WIDTH - 1).PtInRect(dvpt))
	{
		return RIGHT_MARKER;
	}
	//----- _xZkqqHx_iDhNiBfLiDeKiBfLiImIiKePiCpAiDhMiDeDiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	// _xZkqqHx_jFiJiCmIiCoHiCmOiBeBiDfOiDhFiCmNjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
	if (DV2VLG(dvpt.x) < 0)
		return NONE;

	//----- _xZkqqHx_iDfOiDhFiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	mmetolVector::const_iterator iDb;
	for (iDb = m_vtmmTabMarkers.begin(); iDb != m_vtmmTabMarkers.end(); iDb++)
	{
		// _xZkqqHx_iDfOiDhFiPoDiCmMiDhLiDfOiDjDiDfPiDeFiDjDiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (CRect(	TMM2DV(*iDb) - FD_ICN_TAB_CENTER,
					FD_RULER_HALF,
					TMM2DV(*iDb) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
					FD_RULER_WIDTH - 1).PtInRect(dvpt))
		{
			lTabIndex = long(iDb - m_vtmmTabMarkers.begin());
			return TAB_MARKER;
		}
	}
	return NONE;
} // CFCCtlBrHRuler::PointToWhichMarker.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmFjFfMiOkGiClDiCoKiCoJiDgFiDeMiDfIiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	which		:_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTabIndex	:which _xZkqqHx_iCkKiDfOiDhFiCmMiPoKiNiHiBeBiDfOiDhFiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiBeC_xHqqkZx_which _xZkqqHx_iCkK_xHqqkZx_ NONE_xZkqqHx_iBgJiDiLiBfLiDiJiBfLjEhHiMgJiBgKiCmMiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCCtlBrHRuler::GetHintText (WhichMarker which, long lTabIndex) const
{
	switch (which)
	{
	case BOTH_MARKER:		// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// "_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnO_xHqqkZx_: _xZkqqHx_iDeDiDjDiDgGiDjDiDgHjDkPiKpKiDhNiBfLiDeKiBfL_xHqqkZx_\r\n_xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiImKjChF_xHqqkZx_: %f\r\n_xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiImKjChF_xHqqkZx_: %f"
		return FormatResString(	IDS_FORM_RULER_BOTH_MARKER,
								mm2hi(m_tmmMarkerLeft),
								mm2hi(m_tmmMarkerOffset));
	case RIGHT_MARKER:		// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// "_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnO_xHqqkZx_: _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfL_xHqqkZx_\r\n_xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiImKjChF_xHqqkZx_: %f"
		return FormatResString(	IDS_FORM_RULER_RIGHT_MARKER,
								mm2hi(m_tmmMarkerRight));
	case LEFT_MARKER:		// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// "_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnO_xHqqkZx_: _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfL_xHqqkZx_\r\n_xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiImKjChF_xHqqkZx_: %f"
		return FormatResString(	IDS_FORM_RULER_LEFT_MARKER,
								mm2hi(m_tmmMarkerLeft));
	case OFFSET_MARKER:		// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// "_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnO_xHqqkZx_: _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfL_xHqqkZx_\r\n_xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiImKjChF_xHqqkZx_: %f"
		return FormatResString(	IDS_FORM_RULER_OFFSET_MARKER,
								mm2hi(m_tmmMarkerOffset));
	case TAB_MARKER:		// _xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// "_xZkqqHx_iDhNiBfLiDeKiBfLiCmMiOoNjHnO_xHqqkZx_: _xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfL_xHqqkZx_\r\n_xZkqqHx_iDfOiDhFiImKjChF_xHqqkZx_: %f"
		return FormatResString(	IDS_FORM_RULER_TAB_MARKER,
								mm2hi(m_vtmmTabMarkers[lTabIndex]));
	}
	return L"";
} // CFCCtlBrHRuler::GetHintText.

BOOL CFCCtlBrHRuler::OnCmdMsg (UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	TRACE(_T("CFCCtlBrHRuler::OnCmdMsg\n"));

	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
} // CFCCtlBrHRuler::OnCmdMsg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::CalcFixedLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiMiIjCoIiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize CFCCtlBrHRuler::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
{
	ASSERT(bHorz);
	CSize szThis = BASE_CLASS::CalcFixedLayout(bStretch, bHorz);
	szThis.cy = FD_RULER_WIDTH;
	return szThis;
} // CFCCtlBrHRuler::CalcFixedLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnUpdateCmdUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIjHeMiMpIjAkLiCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjGlDiCkNiCmEiCoAiLeMiPhBiCkKjFeLjHhGiBeCiPoDiImKjCiKiPnLiDeOiDiJiDfIiCmJiLpDiCmMiKnGjAjEiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jCoIiLgAiClDiCoKiCmEiCkCiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnUpdateCmdUI (CFrameWnd* /*pTarget*/, BOOL /*bDisableIfNoHndler*/)
{
} // CFCCtlBrHRuler::OnUpdateCmdUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::DoPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::DoPaint (CDC* pDC)
{
	TRACE(_T("CFCCtlBrHRuler::DoPaintA %f\n"), m_mmPitch0);

	// _xZkqqHx_iNiPiCnNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (almost0(m_mmPitch0) || almost0(m_mmPitch1)) return;

//----------<NOT EXPORT TO VIEWER>-----------

	TRACE(_T("CFCCtlBrHRuler::DoPaint %d %d %d %d\n"),
		m_dvrctRuler.left, m_dvrctRuler.top, m_dvrctRuler.right, m_dvrctRuler.bottom);

	// _xZkqqHx_iDgFiDeMiDfIiDgHiDiCiBfLiDgIiCmMiPoKiNiHiCmMiPiIjHjNiBeC_xHqqkZx_
	if (m_wndpTarget != NULL)
	{
		DrawTextRange(pDC);
		return;
	}
//----------</NOT EXPORT TO VIEWER>-----------

	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	//----- CFCDynamicDrawView_xZkqqHx_iCmM_xHqqkZx_CDC_xZkqqHx_iCpAiOgHiCkEjFjEjFgJjDjJiCmMjFgAiJoGiCmGiIoBiCkCiBeBjFgAiJoGjGlNjHnPiCmN_xHqqkZx_
	//		_xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiCmFiNhDiCkEiBeCiClBiCmMiDeOiDiJiDfIiCmFjIfPjHjNiNmAjFfHiCmGiMlOiCkEiCmMiCmN_xHqqkZx_
	//		_xZkqqHx_jAlDiKgNiCmJiCmN_xHqqkZx_CFCDynamicDrawView_xZkqqHx_iCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCmMjIfPjHjNiNmAjFfHiCmGiCkCiCkEiClBiCmG_xHqqkZx_	-----

	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	FCAtFont font;
	g_pReg->InitRegFont(*font.Get(), FDFT_HRULER_DIGITS, 0);
	atDC.SetObject(font);
	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
	atDC.SetBkMode(TRANSPARENT);

	// _xZkqqHx_iMlLiNnNiCmMiDeOiDiKiDgCiDhGiCmJiDiLiBfLiDiJiBfLjHmMiIoGiCpAiPgEiCmLiCmEjAnNjCoIiBeC_xHqqkZx_
	atDC.IntersectClipRect(&m_dvrctRuler);
	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiCpAjDlOiCoJ_xHqqkZx_.dvrctClip_xZkqqHx_iCmNiDgGiDgPiDeDiDfIiNmAjFfHiMgOiBeC_xHqqkZx_
	CRect dvrctClip;
	pDC->GetClipBox(&dvrctClip);

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long	dvVal;
//	long	lC;
//	wchar_t	tcsBuf[200];
//	CSize	szText;
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jFgAiJoGjHmMiIoGiCpAjGlOiCoJiCkCjEhHiMgJjAeGiCmFjDgIjCnHiClHiBeC_xHqqkZx_
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	atDC.FillRect(dvrctClip, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT)));
	atDC.FillRect(dvrctClip, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_FACE)));

//----- 06.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_bDrawBorder)
//	//----- _xZkqqHx_iDhLiBfLiDfPiBfLjApMiCpAjFgAiJoGiClHiCoJiCkJiBeI_xHqqkZx_ -----
//	{
//		atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.bottom - 1);
//		atDC.LineTo(m_dvrctRuler.right, m_dvrctRuler.bottom - 1);
//	}
//----- 06.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiPoDjFjEiCmMiNgBiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.right, m_dvrctRuler.top);
	// _xZkqqHx_iNgBiCmMiMpFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top + 1);
	atDC.LineTo(m_dvrctRuler.right, m_dvrctRuler.top + 1);
	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNiPiCnNiCmMiNmFiPiJiCmMiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	long lC = static_cast<long>(DV2VMM(dvrctClip.left) / m_mmPitch0) - 1;

	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMjCfKiCkCiNiPiCnNiCpAjFgAiJoGiBeC_xHqqkZx_
	for (;; lC++)
	{
		long dvVal = VMM2DV(lC * m_mmPitch0);
		if (dvrctClip.right < dvVal) break;
		atDC.MoveTo(dvVal, FD_RULER_WIDTH - 3);
		atDC.LineTo(dvVal, FD_RULER_WIDTH);
	}

	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMjClHiCkCiNiPiCnNiCmMiNmFiPiJiCmMiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	lC = static_cast<long>(DV2VMM(dvrctClip.left) / m_mmPitch1) - 1;

	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMjClHiCkCiNiPiCnNiCpAjFgAiJoGiBeC_xHqqkZx_
	double dFig = 1.0;
	if (m_nZoomFig != 0) dFig = pow(10.0, m_nZoomFig);
	for (;; lC++)
	{
		long dvVal = VMM2DV(lC * m_mmPitch1);
		wchar_t tcsBuf[200];
		_i64tow10fig(D2LL(mm2hi(lC * m_mmPitch1) / dFig), tcsBuf, m_nZoomFig);
		CSize szText = atDC.GetTextExtent(tcsBuf, wcslen(tcsBuf));
		if (dvrctClip.right < dvVal - szText.cx / 2) break;
		atDC.MoveTo(dvVal, FD_RULER_WIDTH - 6);
		atDC.LineTo(dvVal, FD_RULER_WIDTH);
		// _xZkqqHx_jClHiCkCiNiPiCnNiCmMjAjEjCgMiCpAjFgAiJoGiBeC_xHqqkZx_
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDC.TextOut(dvVal - szText.cx / 2, 0, tcsBuf, wcslen(tcsBuf), CP_ACP);
		atDC.TextOut(dvVal - szText.cx / 2, FD_RULER_TOP, tcsBuf, wcslen(tcsBuf), CP_ACP);
	}

	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjHhAiPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkM_xHqqkZx_ -----
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
							g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);

	short	nIndex;
	for (nIndex = 0; nIndex < FD_RULER_MMK_MAX; nIndex++)
	{
		if (m_baIsRulerMMKVisible[nIndex])
		/****** _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjFfMiOkGiPpDjBnE_xHqqkZx_ ******/
		{
		//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCpAjFgAiJoG_xHqqkZx_ -----
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			eDraw.Line(	&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), 0),
//						&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			eDraw.Line(	&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_TOP),
						&CPoint(VLG2DV(m_lgaRulerMMK[nIndex]), FD_RULER_WIDTH));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	// Do not call CControlBar::OnPaint() for painting messages
} // CFCCtlBrHRuler::DoPaint

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiPoDiCmFiCmMiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnLButtonDown (UINT nFlags, CPoint dvPos)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHjCiGiCmFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (m_wndpTarget == NULL) return;
	if (m_wndpTarget != NULL && m_whichMarkerMoving != NONE) return;

	long tlgX;

//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iKeKiOgOiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
//	if (CRect(TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER, 0,
//			TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
//			FD_RULER_HALF - 1).PtInRect(dvPos))
//	{
//		m_markerMovingStat = FDHR_LEFT_MARKER_BGNMOVE;
//		m_pxMovingOffset = TMM2DV(m_tmmMarkerLeft) - dvPos.x;
//		tlgX = mm2lg(m_tmmMarkerLeft);
//	} else
//	//----- _xZkqqHx_iCnEiCoHiJlKiClAiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
//	if (CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER + FD_ICN_OFFSET_BORDER,
//			FD_RULER_HALF,
//			TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
//			FD_RULER_WIDTH - 1).PtInRect(dvPos))
//	{
//		m_markerMovingStat = FDHR_OFFSET_MARKER_BGNMOVE;
//		m_pxMovingOffset = TMM2DV(m_tmmMarkerOffset) - dvPos.x;
//		tlgX = mm2lg(m_tmmMarkerOffset);
//	} else
//	//----- _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
//	if (CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER, FD_RULER_HALF,
//			TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER + FD_ICN_OFFSET_BORDER,
//			FD_RULER_WIDTH - 1).PtInRect(dvPos))
//	{
//		m_markerMovingStat = FDHR_BOTH_MARKER_BGNMOVE;
//		m_pxMovingOffset = TMM2DV(m_tmmMarkerOffset) - dvPos.x;
//		tlgX = mm2lg(m_tmmMarkerOffset);
//	} else
//	//----- _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiCpAiDhMiDeDiDjDiDgHiBeI_xHqqkZx_ -----
//	if (CRect(TMM2DV(m_tmmMarkerRight) - FD_ICN_RIGHT_CENTER, FD_RULER_HALF,
//			TMM2DV(m_tmmMarkerRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
//			 FD_RULER_WIDTH - 1).PtInRect(dvPos))
//	{
//		m_markerMovingStat = FDHR_RIGHT_MARKER_BGNMOVE;
//		m_pxMovingOffset = TMM2DV(m_tmmMarkerRight) - dvPos.x;
//		tlgX = mm2lg(m_tmmMarkerRight);
//	} else
//	//----- _xZkqqHx_iDhNiBfLiDeKiBfLiImIiKePiCpAiDhMiDeDiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jFiJiCmIiCoHiCmOiBeBiDfOiDhFiCmNjHeMiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//		if (DV2VLG(dvPos.x) < 0) return;
//		//----- _xZkqqHx_iDfOiDhFiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//		mmetolVector::const_iterator iDb;
//		for (iDb = m_vtmmTabMarkers.begin(); iDb != m_vtmmTabMarkers.end(); iDb++)
//		{
//			// _xZkqqHx_iDfOiDhFiPoDiCmMiDhLiDfOiDjDiDfPiDeFiDjDiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//			if (CRect(TMM2DV(*iDb) - FD_ICN_TAB_CENTER, FD_RULER_HALF,
//					TMM2DV(*iDb) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
//					FD_RULER_WIDTH - 1).PtInRect(dvPos))
//			{
//				break;
//			}
//		}
//		if (iDb == m_vtmmTabMarkers.end())
//		//----- _xZkqqHx_iKpJjBlGiDfOiDhFiPoDiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jAfGiClFiCkCiDfOiDhFiCpAjCmHiJmBiBeC_xHqqkZx_
//			m_vtmmTabMarkers.push_back(DV2TMM(dvPos.x));
//			// _xZkqqHx_iInKjDkOiDfOiBfLiDfBiDgCiDgHiCmMiDfOiDhF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//			m_iMovingTabIndex = m_vtmmTabMarkers.size() - 1;
//			m_markerMovingStat = FDHR_TAB_MARKER_BGNMOVE;
//			m_pxMovingOffset = TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - dvPos.x;
//			tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
//			//----- _xZkqqHx_jAfGiClFiCkNiNoMiCoHiCoKiClNiDfOiDhFiClOiCkJiCoHiBeBjFfMiOkGiPiIjHjN_xHqqkZx_ -----
//			CClientDC dc(this);
//			// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//			FCAutoDC atDC(&dc, TRUE, 0, 0);
//			CRgn rgn1;
//			rgn1.CreateRectRgn(TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - FD_ICN_TAB_CENTER,
//								FD_RULER_HALF,
//								TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
//								FD_RULER_WIDTH);
//			// CDC_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_.
//			atDC.SetClipRgn(&rgn1);
//			DrawTextRange(&dc);
//		} else
//		//----- _xZkqqHx_iKpJjBlGiDfOiDhFiPoDiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iInKjDkOiDfOiBfLiDfBiDgCiDgHiCmMiDfOiDhF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//			m_iMovingTabIndex = int(iDb - m_vtmmTabMarkers.begin());
//			m_markerMovingStat = FDHR_TAB_MARKER_BGNMOVE;
//			m_pxMovingOffset = TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - dvPos.x;
//			tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
//		}
//	}
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lTabIndex;
	WhichMarker which = PointToWhichMarker(lTabIndex, dvPos);
	switch (which)
	{
	case BOTH_MARKER:		// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		m_pxMovingOffset = TMM2DV(m_tmmMarkerOffset) - dvPos.x;
		tlgX = mm2lg(m_tmmMarkerOffset);
		break;
	case RIGHT_MARKER:		// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		m_pxMovingOffset = TMM2DV(m_tmmMarkerRight) - dvPos.x;
		tlgX = mm2lg(m_tmmMarkerRight);
		break;
	case LEFT_MARKER:		// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		m_pxMovingOffset = TMM2DV(m_tmmMarkerLeft) - dvPos.x;
		tlgX = mm2lg(m_tmmMarkerLeft);
		break;
	case OFFSET_MARKER:		// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		m_pxMovingOffset = TMM2DV(m_tmmMarkerOffset) - dvPos.x;
		tlgX = mm2lg(m_tmmMarkerOffset);
		break;
	case TAB_MARKER:		// _xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		// _xZkqqHx_iInKjDkOiDfOiBfLiDfBiDgCiDgHiCmMiDfOiDhF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		m_iMovingTabIndex = lTabIndex;
		m_pxMovingOffset = TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - dvPos.x;
		tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
		break;
	default:
		// _xZkqqHx_jAfGiClFiCkCiDfOiDhFiCpAjCmHiJmBiBeC_xHqqkZx_
		m_vtmmTabMarkers.push_back(DV2TMM(dvPos.x));
		which = TAB_MARKER;
		// _xZkqqHx_iInKjDkOiDfOiBfLiDfBiDgCiDgHiCmMiDfOiDhF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		m_iMovingTabIndex = m_vtmmTabMarkers.size() - 1;
		m_pxMovingOffset = TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - dvPos.x;
		tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
		//----- _xZkqqHx_jAfGiClFiCkNiNoMiCoHiCoKiClNiDfOiDhFiClOiCkJiCoHiBeBjFfMiOkGiPiIjHjN_xHqqkZx_ -----
		CClientDC dc(this);
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
		FCAutoDC atDC(&dc, TRUE, 0, 0);
		CRgn rgn1;
		rgn1.CreateRectRgn(	TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - FD_ICN_TAB_CENTER,
							FD_RULER_HALF,
							TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
							FD_RULER_WIDTH);
		// CDC_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_.
		atDC.SetClipRgn(&rgn1);
		DrawTextRange(&dc);
	}
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iPpDjBnEiBiBiDhNiBfLiDeKiBfLiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//	m_markerMovingStat = FDHR_MARKER_MOVE_BEGIN;
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_whichMarkerMoving = which;
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	::FFSetCapture(m_hWnd);	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	m_wndpTarget->SendMessage(	WM_USER_RULER_MARKER,
								(WPARAM)FDHR_MARKER_MOVE_BEGIN,
								(LPARAM)(tlgX));

//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRulerHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCpAiPoNiCmJjFfMiOkGiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->SetTargetInfo(GetHintText(m_whichMarkerMoving, m_iMovingTabIndex));
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrHRuler::OnLButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnLButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiPoDiCmFiCmMiNlGiDhLiDfOiDjDiDeBiDgCiDhGiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnLButtonUp (UINT nFlags, CPoint dvPos)
{
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_wndpTarget == NULL) return;
//	long tlgX;
//	switch (m_markerMovingStat)
//	{
//	case FDHR_NONE:			// _xZkqqHx_jGlDiClF_xHqqkZx_.
//		return;
//
//	case FDHR_BOTH_MARKER_BGNMOVE:	// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiInKjDkOiKeKiOgO_xHqqkZx_.
//	case FDHR_BOTH_MARKER_MOVING:	// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiInKjDkOjCiG_xHqqkZx_.
//		m_markerMovingStat = FDHR_BOTH_MARKER_ENDMOVE;
//		tlgX = mm2lg(m_tmmMarkerOffset);
//		break;
//
//	case FDHR_RIGHT_MARKER_BGNMOVE:	// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiInKjDkOiKeKiOgO_xHqqkZx_.
//	case FDHR_RIGHT_MARKER_MOVING:	// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiInKjDkOjCiG_xHqqkZx_.
//		m_markerMovingStat = FDHR_RIGHT_MARKER_ENDMOVE;
//		tlgX = mm2lg(m_tmmMarkerRight);
//		break;
//
//	case FDHR_LEFT_MARKER_BGNMOVE:	// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiInKjDkOiKeKiOgO_xHqqkZx_.
//	case FDHR_LEFT_MARKER_MOVING:	// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiInKjDkOjCiG_xHqqkZx_.
//		m_markerMovingStat = FDHR_LEFT_MARKER_ENDMOVE;
//		tlgX = mm2lg(m_tmmMarkerLeft);
//		break;
//
//	case FDHR_OFFSET_MARKER_BGNMOVE:	// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiInKjDkOiKeKiOgO_xHqqkZx_.
//	case FDHR_OFFSET_MARKER_MOVING:	// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiInKjDkOjCiG_xHqqkZx_.
//		m_markerMovingStat = FDHR_OFFSET_MARKER_ENDMOVE;
//		tlgX = mm2lg(m_tmmMarkerOffset);
//		break;
//
//	case FDHR_TAB_MARKER_BGNMOVE:	// _xZkqqHx_iDfOiDhFiInKjDkOiKeKiOgO_xHqqkZx_.
//	case FDHR_TAB_MARKER_MOVING:	// _xZkqqHx_iDfOiDhFiInKjDkOjCiG_xHqqkZx_.
//		m_markerMovingStat = FDHR_TAB_MARKER_ENDMOVE;
//		tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
//		if (m_vtmmTabMarkers[m_iMovingTabIndex] < 0)
//		//----- _xZkqqHx_jEmNiImNiKePiCmMiOjOiCmNiBeBiDfOiDhFiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
//		{
//			m_vtmmTabMarkers.erase(m_vtmmTabMarkers.begin() + m_iMovingTabIndex);
//		} else
//		{
//			sort(m_vtmmTabMarkers.begin(), m_vtmmTabMarkers.end());
//			// unique_xZkqqHx_iCmNiBeBiDiGiDgKiBfLiDeOiCmIjHpBiCpAjBePjFpLiCmJiBeBiOgDiCoIiCpAiMoDjFpLiCnGiInKjDkOiClFiCmEiBeBiClLiCmMiLkLiCpAjFnEiClHiBeC_xHqqkZx_
//			m_vtmmTabMarkers.erase(unique(m_vtmmTabMarkers.begin(), m_vtmmTabMarkers.end()), m_vtmmTabMarkers.end());
//		}
//		break;
//	}
//	::FFReleaseCapture();	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
//							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
//	// _xZkqqHx_jFnCiPfHjApMiCpAiPmBiClHiClNiCnPiCmJiBeBiPeJjHlJiCpAiDiBiDgCiDfKiBfLiDfHiCmFjCmKjCgNiBeC_xHqqkZx_
//	m_wndpTarget->SendMessage(WM_USER_RULER_MARKER,
//								(WPARAM)m_markerMovingStat, (LPARAM)(tlgX));
//	// _xZkqqHx_iNhDiPoOjFpBiCkKiNfIjAfGiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiBeC_xHqqkZx_
//	m_wndpTarget->PostMessage(WM_USER_CURRENT_LINE_UPDATED, (WPARAM)0, (LPARAM)(0));
//
//	m_markerMovingStat = FDHR_NONE;
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHjCiGiCmFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (m_wndpTarget == NULL) return;
	long tlgX;
	switch (m_whichMarkerMoving)
	{
	case NONE:				// _xZkqqHx_iDiLiBfLiDiJiBfLjEhHiMgJiBeC_xHqqkZx_
		return;
	case BOTH_MARKER:		// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tlgX = mm2lg(m_tmmMarkerOffset);
		break;
	case RIGHT_MARKER:		// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tlgX = mm2lg(m_tmmMarkerRight);
		break;
	case LEFT_MARKER:		// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tlgX = mm2lg(m_tmmMarkerLeft);
		break;
	case OFFSET_MARKER:		// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tlgX = mm2lg(m_tmmMarkerOffset);
		break;
	case TAB_MARKER:			// _xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
		if (m_vtmmTabMarkers[m_iMovingTabIndex] < 0)
		//----- _xZkqqHx_jEmNiImNiKePiCmMiOjOiCmNiBeBiDfOiDhFiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
		{
			m_vtmmTabMarkers.erase(m_vtmmTabMarkers.begin() + m_iMovingTabIndex);
		} else
		{
			sort(m_vtmmTabMarkers.begin(), m_vtmmTabMarkers.end());
			// unique_xZkqqHx_iCmNiBeBiDiGiDgKiBfLiDeOiCmIjHpBiCpAjBePjFpLiCmJiBeBiOgDiCoIiCpAiMoDjFpLiCnGiInKjDkOiClFiCmEiBeBiClLiCmMiLkLiCpAjFnEiClHiBeC_xHqqkZx_
			m_vtmmTabMarkers.erase(unique(m_vtmmTabMarkers.begin(), m_vtmmTabMarkers.end()), m_vtmmTabMarkers.end());
		}
		break;
	}
	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
	::FFReleaseCapture();
//----- 05.11.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iPpDjBnEiCpA_xHqqkZx_END_xZkqqHx_iCmJiBeC_xHqqkZx_
//	m_markerMovingStat = FDHR_MARKER_MOVE_END;
//----- 05.11.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFnCiPfHjApMiCpAiPmBiClHiClNiCnPiCmJiBeBiPeJjHlJiCpAiDiBiDgCiDfKiBfLiDfHiCmFjCmKjCgNiBeC_xHqqkZx_
	m_wndpTarget->SendMessage(	WM_USER_RULER_MARKER,
								(WPARAM)FDHR_MARKER_MOVE_END,
								(LPARAM)(tlgX));
	// _xZkqqHx_iNhDiPoOjFpBiCkKiNfIjAfGiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiBeC_xHqqkZx_
	m_wndpTarget->PostMessage(WM_USER_CURRENT_LINE_UPDATED, (WPARAM)0, (LPARAM)(0));
	// _xZkqqHx_iPpDjBnEiCpA_xHqqkZx_NONE_xZkqqHx_iCmJiBeC_xHqqkZx_
	m_whichMarkerMoving = NONE;

//----- 05.11.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRulerHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCpAjEpBjFfMiOkGiCmJiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->OnHide();
	}
//----- 05.11.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrHRuler::OnLButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnMouseMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiPoDiCmFiCmMiDhNiDeFiDfIiInKjDkOiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnMouseMove (UINT nFlags, CPoint dvPos)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnMouseMove(nFlags, dvPos);

	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHjCiGiCmFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (m_wndpTarget == NULL) return;

	mmetol	tmmNewMarkStart;
	mmetol	tmmNewMarkRight;
	mmetol	tmmNewMarkOffset;
	mmetol	tmmNewTab;
	mmetol	tmmWorkRight;
	long	tlgX;
	CRectVector	rctvRgn;
	switch (m_whichMarkerMoving)
	{
	case NONE:				// _xZkqqHx_iDiLiBfLiDiJiBfLjEhHiMgJiBeC_xHqqkZx_
		return;
	case BOTH_MARKER:		// _xZkqqHx_jHlMiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tmmNewMarkOffset = DV2TMM(dvPos.x + m_pxMovingOffset);
		FFSnapMP(&tmmNewMarkOffset, NULL);
		if (m_tmmMarkerOffset == tmmNewMarkOffset) break;
		tmmNewMarkStart = m_tmmMarkerLeft + tmmNewMarkOffset - m_tmmMarkerOffset;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewMarkStart) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(tmmNewMarkStart) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewMarkOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(tmmNewMarkOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
		m_tmmMarkerLeft = tmmNewMarkStart;
		m_tmmMarkerOffset = tmmNewMarkOffset;
		tlgX = mm2lg(m_tmmMarkerLeft);
		break;
	case RIGHT_MARKER:		// _xZkqqHx_iJeFiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tmmNewMarkRight = DV2TMM(dvPos.x + m_pxMovingOffset);
		tmmWorkRight = tmmNewMarkRight;
		FFSnapMP(&tmmNewMarkRight, NULL);
		// _xZkqqHx_iDfIiDgJiDgCiDhGiImKjChFiCkKiBeBiJeFjCfLiCmJiLnPiCkCiPoKiNiHiCmNiJeFjCfLiCmJjAnNjCoIiClHiCoJiPiIjHjNiBeC_xHqqkZx_
		// _xZkqqHx_iDfIiDgJiDgCiDhGiImKjChFiCkKiClPiCoFiCkEiCmHiJeFjCfLiCmJiCoAiCkAiCoJiCmGiCmNiMmAiCoHiCmIiCkCiClNiCnPiBeC_xHqqkZx_
		if (fabs(m_vmmEnd - m_vmmBegin - tmmWorkRight) <
												fabs(tmmNewMarkRight - tmmWorkRight))
			tmmNewMarkRight = m_vmmEnd - m_vmmBegin;
		if (m_tmmMarkerRight == tmmNewMarkRight) break;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerRight) - FD_ICN_RIGHT_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
								FD_RULER_WIDTH));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewMarkRight) - FD_ICN_RIGHT_CENTER,
								FD_RULER_HALF,
								TMM2DV(tmmNewMarkRight) + FD_ICN_RIGHT_WIDTH - FD_ICN_RIGHT_CENTER,
								FD_RULER_WIDTH));
		m_tmmMarkerRight = tmmNewMarkRight;
		tlgX = mm2lg(m_tmmMarkerRight);
		break;
	case LEFT_MARKER:		// _xZkqqHx_iNlGiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tmmNewMarkStart = DV2TMM(dvPos.x + m_pxMovingOffset);
		FFSnapMP(&tmmNewMarkStart, NULL);
		if (m_tmmMarkerLeft == tmmNewMarkStart) break;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerLeft) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(m_tmmMarkerLeft) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewMarkStart) - FD_ICN_START_CENTER,
// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//								0,
								FD_RULER_TOP,
								TMM2DV(tmmNewMarkStart) + FD_ICN_START_WIDTH - FD_ICN_START_CENTER,
								FD_RULER_HALF));
		m_tmmMarkerLeft = tmmNewMarkStart;
		tlgX = mm2lg(m_tmmMarkerLeft);
		break;

	case OFFSET_MARKER:		// _xZkqqHx_iCnEiCoHiJlKiClAiDeDiDjDiDgGiDjDiDgHiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tmmNewMarkOffset = DV2TMM(dvPos.x + m_pxMovingOffset);
		FFSnapMP(&tmmNewMarkOffset, NULL);
		if (m_tmmMarkerOffset == tmmNewMarkOffset) break;
		rctvRgn.push_back(CRect(TMM2DV(m_tmmMarkerOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_tmmMarkerOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewMarkOffset) - FD_ICN_OFFSET_CENTER,
								FD_RULER_HALF,
								TMM2DV(tmmNewMarkOffset) + FD_ICN_OFFSET_WIDTH - FD_ICN_OFFSET_CENTER,
								FD_RULER_WIDTH));
		m_tmmMarkerOffset = tmmNewMarkOffset;
		tlgX = mm2lg(m_tmmMarkerOffset);
		break;
	case TAB_MARKER:		// _xZkqqHx_iDfOiDhFiDhNiBfLiDeKiBfLiBeC_xHqqkZx_
		tmmNewTab = DV2TMM(dvPos.x + m_pxMovingOffset);
		FFSnapMP(&tmmNewTab, NULL);
		if (m_vtmmTabMarkers[m_iMovingTabIndex] == tmmNewTab) break;
		rctvRgn.push_back(CRect(TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) - FD_ICN_TAB_CENTER,
								FD_RULER_HALF,
								TMM2DV(m_vtmmTabMarkers[m_iMovingTabIndex]) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
								FD_RULER_WIDTH));
		rctvRgn.push_back(CRect(TMM2DV(tmmNewTab) - FD_ICN_TAB_CENTER,
								FD_RULER_HALF,
								TMM2DV(tmmNewTab) + FD_ICN_TAB_WIDTH - FD_ICN_TAB_CENTER,
								FD_RULER_WIDTH));
		m_vtmmTabMarkers[m_iMovingTabIndex] = tmmNewTab;
		tlgX = mm2lg(m_vtmmTabMarkers[m_iMovingTabIndex]);
		break;
	}
	// _xZkqqHx_iInKjDkOiCkKjGlDiCkPiCoKiCmOiClLiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
	if (rctvRgn.empty()) return;

	CClientDC dc(this);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(&dc, TRUE, 0, 0);
	CRgn	rgn1;
	CRgn	rgn2;
	CRectVector::iterator iR;

	//----- CDC_xZkqqHx_iCmMiDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkM_xHqqkZx_ -----
	rgn1.CreateRectRgn(0,0,0,0);
	for (iR = rctvRgn.begin(); iR != rctvRgn.end(); iR++)
	{
		//----- _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiCgOiChBiCmFjCmHiJmBiClHiCoJ_xHqqkZx_ -----
		rgn2.CreateRectRgn((*iR).left, (*iR).top,
							(*iR).right, (*iR).bottom);
		rgn1.CombineRgn(&rgn1, &rgn2, RGN_OR);
		rgn2.DeleteObject();
	}
	// CDC_xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoI_xHqqkZx_.
	atDC.SetClipRgn(&rgn1);
	DrawTextRange(&dc);

	// _xZkqqHx_iPpDjBnEiBiBiDhNiBfLiDeKiBfLiInKjDkOjCiGiBeC_xHqqkZx_
	m_wndpTarget->SendMessage(	WM_USER_RULER_MARKER,
								(WPARAM)FDHR_MARKER_MOVING,
								(LPARAM)(tlgX));

//----- 05.11.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRulerHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCpAiPoNiCmJjFfMiOkGiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->SetTargetInfo(GetHintText(m_whichMarkerMoving, m_iMovingTabIndex));
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.11.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

} // CFCCtlBrHRuler::OnMouseMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iDiGiBfLiDfFiBfLiCmJiCoGiCmBiCmEiDhNiDeFiDfIiCmMiJeFiDhLiDfOiDjDiCkKiDeOiDiKiDgCiDeOiClDiCoKiClN_xHqqkZx_
 *					 _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCmFiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDiGiBfLiDfFiBfLiCmJiCoGiCmBiCmEiDhNiDeFiDfIiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiCmGiCkLiCmMiBeB_xHqqkZx_
 *					 _xZkqqHx_iDeKiBfLiDfMiDiLiCmMiDfIiDeOiDiKiBfLiDjDiNmAjFfHiImKjChFiCmFiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnContextMenu (CWnd* pWnd, CPoint point)
{
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CMenu menu;
//	if (menu.LoadMenu(IDR_RBTN_POPUP))
//	{
//		CMenu* pPopup = menu.GetSubMenu(6);
//		ASSERT(pPopup != NULL);
//		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
//		if (g_pReg->GetIsLeftHand())
//			::RightByLeftHand(pPopup->m_hMenu, TRUE);
//		// _xZkqqHx_iDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//		OnUpdatePopupMenu(pPopup);
//		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN,
//								point.x, point.y,
//								// route commands through main window.
//								this);
//	}
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	FFPopupSubmenu(point, IDR_RBTN_MISC, FD_MENU_MISC_HRULER, this);
//----- 01.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrHRuler::OnContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnRbtnRulerClearAllTabPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBfDiDfOiDhFjAnNjCoIiCpAiJpAiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnRbtnRulerClearAllTabPos ()
{
	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiDfOiDhFiPoOjFpBiCkKiLpDiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (GetTabs().empty()) return;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiDfOiDhFiPoOjFpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	SetTabs(mmetolVector());
	// _xZkqqHx_iNhDiPoOjFpBiCkKiNfIjAfGiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiBeC_xHqqkZx_
	((CWnd*)g_pView->GetRTFEditor())->PostMessage(WM_USER_CURRENT_LINE_UPDATED, (WPARAM)0, (LPARAM)(0));
} // CFCCtlBrHRuler::OnRbtnRulerClearAllTabPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnUpdateRulerClearAllTabPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDiBiDgKiDiFiBfLiBhFjBfDiDfOiDhFjAnNjCoIiCpAiJpAiPjMiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnUpdateRulerClearAllTabPos (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(	g_pDoc->GetIsDocumentOpened() &&
					g_pView->GetCurrentTool()->IsEditingText() &&
					!GetTabs().empty());
} // CFCCtlBrHRuler::OnUpdateRulerClearAllTabPos.

//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnInitMenuPopup
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCkKiDeBiDeOiDgFiDeCiDhFiCmJiCmIiCoJjClMjBePiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPopupMenu	:_xZkqqHx_iDiBiDgKiDiFiBfLiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			nIndex		:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSysMenu	:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCkKiDfCiDjDiDgHiDiNiBfLiDiLiDiBiDgKiDiFiBfLiCmMiPoKiNiHiCmN_xHqqkZx_
// *						 TRUE _xZkqqHx_iCpAiBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCCtlBrHRuler::OnInitMenuPopup (CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
//{
//#ifndef _DEBUG
//_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiNoNiPjMiCmFiCkLiCoJiCmMiCmFiCmNiBeI_xHqqkZx_
//CFCCtlBrHTree::OnCmdMsg_xZkqqHx_iCmG_xHqqkZx_CFCWndHistoryTree_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiPiIjHjNiCpAiOfBiPmGiBeC_xHqqkZx_
//#endif//_DEBUG
//
//	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
//	BASE_CLASS::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);
////	OnUpdatePopupMenu(pPopupMenu);
//} // CFCCtlBrHRuler::OnInitMenuPopup.
//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnShowWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFfMiOkGiPpDjBnEiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bShow	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiBeBjEpBjFfMiOkGiCmJiClHiCoJ_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			nStatus	:_xZkqqHx_jFfMiOkGiClHiCoJiDeFiDeCiDjDiDgIiDeFiCmMiPpDjBnEiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *					 ShowWindow _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCkKiMmEiCnBiPgPiClDiCoKiBeBiDiBiDgCiDfKiBfLiDfHiCkK_xHqqkZx_
 *					 _xZkqqHx_jBjHiCoHiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_nStatus _xZkqqHx_iCmNiOjPiCmMjCgMiCmMiCkCiClIiCoKiCkJiCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_ 
 *				SW_PARENTCLOSING	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkKiDeOiDiNiBfLiDfJ_xHqqkZx_ (_xZkqqHx_iDeBiDeDiDfCiDjDiJlL_xHqqkZx_) 
 *									 _xZkqqHx_iClDiCoKiCoJiCkJiBeBiDhMiDgCiDhGiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_
 *									 _xZkqqHx_jEpBjFfMiOkGiCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *				SW_PARENTOPENING	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkKiDeJiBfLiDhGiDjD_xHqqkZx_ (_xZkqqHx_jFfMiOkG_xHqqkZx_) _xZkqqHx_iClDiCoKiCoJiCkJiBeB_xHqqkZx_
 *									 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiClDiCoKiCnMiClHiBeC_xHqqkZx_ 
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnShowWindow (BOOL bShow, UINT nStatus)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	CControlBar::OnShowWindow(bShow, nStatus);
	// _xZkqqHx_jChOjAmPiClDiCoKiCmEiCkCiCoJiDiBiDgCiDfKiBfLiDfHiCpAiPiIjHjNiBeC_xHqqkZx_
// 03.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (bShow) FFNotifyPendingMessage();
	FFNotifyPendingMessage(this, bShow);
} // CFCCtlBrHRuler::OnShowWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnUserUpdateRuler
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiCmMjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CView_xZkqqHx_iCmMiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiOjOiBeBiDfEiDeDiDfJiCpAjDoAjFjEjFmPjAjEiCmJiOoGiCoIiNjOiCnOiBeC_xHqqkZx_
 *			CFCDynamicDrawView::UpdateScrollSize_xZkqqHx_iKnGjAjEjDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCCtlBrHRuler::OnUserUpdateRuler (WPARAM wParam, LPARAM lParam)
{
	TRACE(_T("CFCCtlBrHRuler::OnViewSizeA\n"));
	if (g_pView != NULL)
	{
		TRACE(_T("CFCCtlBrHRuler::OnViewSizeB\n"));
		// View_xZkqqHx_iCmMjHmMiIoGiCpAjIfPjHjNiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		g_pView->GetClientRectLG(m_dvrctRuler);
		// View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
		m_dvOffset = m_dvrctRuler.left;
		// View_xZkqqHx_iCmMjHmMiIoGiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		m_dvrctRuler.left = 0;
		m_dvrctRuler.right -= m_dvOffset;
		// View_xZkqqHx_iCmMjHmMiIoGiCpAiBeBiClBiCmMiDiLiBfLiDiJiBfLiCmFiCmMjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		g_pView->ClientToScreen(&m_dvrctRuler);
		ScreenToClient(&m_dvrctRuler);
		// m_dvrctRuler_xZkqqHx_iCpAiBeBiDiLiBfLiDiJiBfLiCmMiDhCiDiFiBfLjEmNiImNiCmMjDgIiCoIiCmCiCnEiClFjHmMiIoGiCmJiBeC_xHqqkZx_
		m_dvrctRuler.top = 0;
		m_dvrctRuler.bottom = FD_RULER_WIDTH;
	}

	//----- Scale_xZkqqHx_iKnGiMfHiPiJiKpKiJlL_xHqqkZx_ -----

	//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkK_xHqqkZx_20pixel_xZkqqHx_jCpGjDhIiCmJiCmIiCoJiCoGiCkEiCmJiBeBiDhDiDgCiDgAiCpAjClCjAkO_xHqqkZx_ -----
	// 20pixel_xZkqqHx_iCpA_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	hic hiPitch = lg2hi(20);
	//----- HI_xZkqqHx_iNmAjFfHjCgMiCpAiBeB_xHqqkZx_a * 10^b (1 <= a < 10) _xZkqqHx_iCmJjFmPiKlH_xHqqkZx_ -----
	double b = log10(hiPitch);
	if (0 < b)
	{
		b = int(b);
	} else
	{
		if ((b - int(b)) != 0.0)
			b = int(b) - 1.0;
	}
	double p = pow(10.0, b);
	double a = hiPitch / p;
	//----- a _xZkqqHx_iCpA_xHqqkZx_1.0,2.5,5.0,10.0_xZkqqHx_iCmMiCkCiClIiCoKiCkJiLnPiCkCjCgMiCmJjFfHiPiAiJlL_xHqqkZx_ -----
	double ra = 1.0;
	double dif = fabs(a - ra);
	// _xZkqqHx_iDhDiDgCiDgAiCfAiCmMiPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiBeC_xHqqkZx_0.1 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
	short nZoomFigure = b + 1.0;
	if (fabs(a - 2.5) < dif)
	{
		ra = 2.5;
		dif = fabs(a - ra);
		nZoomFigure = b;
	}
	if (fabs(a - 5.0) < dif)
	{
		ra = 5.0;
		dif = fabs(a - ra);
		nZoomFigure = b + 1.0;
	}
	if (fabs(a - 10.0) < dif)
	{
		ra = 10.0;
		dif = fabs(a - ra);
		nZoomFigure = b + 2.0;
	}
	if (0 < nZoomFigure) nZoomFigure = 0;
	// Scale_xZkqqHx_iCmMiNnHiCkJiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
	mmetol mmScalePitch0 = hi2mm(ra * p);
	// Scale_xZkqqHx_iCmMjBlOiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
	mmetol mmScalePitch1 = 10.0 * mmScalePitch0;
	// _xZkqqHx_iDhDiDgCiDgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	SetPitch(mmScalePitch0, mmScalePitch1, nZoomFigure);

	TRACE(_T("CFCCtlBrHRuler::OnViewSizeC %f\n"), mmScalePitch0);

	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	Invalidate();

	return 1;
} // CFCCtlBrHRuler::OnUserUpdateRuler.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCCtlBrHRuler::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRulerHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint dvptMouse;
		(void)::GetCursorPos(&dvptMouse);
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		ScreenToClient(&dvptMouse);
		// _xZkqqHx_iCmHiCmMiDhNiBfLiDeKiBfLiPoDiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		long lTabIndex;
		WhichMarker which = PointToWhichMarker(lTabIndex, dvptMouse);
		if (which == NONE)
		//----- _xZkqqHx_iDiLiBfLiDiJiBfLjEhHiMgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FFGetApp()->GetPopHint()->SetTargetInfo(GetDlgCtrlID());
		} else
		//----- _xZkqqHx_iCkCiClIiCoKiCkJiCmMiDhNiBfLiDeKiBfLiPoDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FFGetApp()->GetPopHint()->SetTargetInfo(GetHintText(which, lTabIndex));
		}
	}
	return 1;
} // CFCCtlBrHRuler::OnUserPursuerTextNeedInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnWindowPosChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiImKjChFiBeFiDfEiDeDiDfJjDjJiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpwndpos	:_xZkqqHx_iImKjChFiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiInKjDkOiClFiCmEiDhEiDiMiBfLiDiAiDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiCpA_xHqqkZx_
 *			_xZkqqHx_iNgMiCkGiCoJiBeC_xHqqkZx_
 *			g_pFrame _xZkqqHx_iCmMiPoKiNiHiBeBiDiLiBfLiDiJiBfLiCkK_xHqqkZx_DynamicDrawView_xZkqqHx_iCoGiCoIiCoAjAoGiCmJiInKjDkOiBeF_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_iCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmJiCoGiCmBiCmE_xHqqkZx_
 *			OnUserUpdateRuler _xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiBeBjAlDiKgNiCmJiDhCiDiFiBfLiCmMiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIoKjFpLiBeB_xHqqkZx_g_pInPlace _xZkqqHx_iCmMiPoKiNiHiBeBiDiLiBfLiDiJiBfLiCkK_xHqqkZx_DynamicDrawView_xZkqqHx_iCoGiCoIiCoAiMoDiCmJ_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiBeFiDiKiDfEiDeDiDfJiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_iCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmJ_xHqqkZx_
 *			_xZkqqHx_iCoGiCmBiCmE_xHqqkZx_ OnUserUpdateRuler _xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiBeBjGkCiClOiDiLiBfLiDiJiBfLiCmN_xHqqkZx_
 *			_xZkqqHx_jAlDiClFiCkCiImKjChFiCmJiInKjDkOiClFiCmEiCkIiCoHiClIiBeBiDhCiDiFiBfLiCmMiPoOjFpBiCpAjAlDiClFiCkNiLeMjIfOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiLiBfLiDiJiBfLiCmM_xHqqkZx_OnWindowPosChanged_xZkqqHx_iKnGjAjEiCkJiCoHiCoA_xHqqkZx_
 *			OnUserUpdateRuler _xZkqqHx_iCpAiMmEiCnEjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrHRuler::OnWindowPosChanged (WINDOWPOS FAR* lpwndpos)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnWindowPosChanged(lpwndpos);
	if (!(SWP_NOMOVE & lpwndpos->flags) || !(SWP_NOSIZE & lpwndpos->flags))
	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiLiBfLiDiJiBfLiNfIjAfGiCmMiDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
		FFPushPendingMessage(FCPendingMessage(FD_PMSG_MAIN_HRULER,
											WM_USER_UPDATE_RULER, NULL, NULL,
											TRUE,
											FD_PMSG_MAIN_HRULER|FD_PMSG_IF_VISIBLE,
											FD_PMSG_VIEW|FD_PMSG_IF_VISIBLE));
	}
} // CFCCtlBrHRuler::OnWindowPosChanged.

//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnCreate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoMjAkMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//int CFCCtlBrHRuler::OnCreate (LPCREATESTRUCT lpCreateStruct)
//{
//	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
//		return -1;
//	// OnCmdMsg_xZkqqHx_iCmMiOmAiNhDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
//	FFGetMainWnd()->RegisterOnCmdMsg(this);
//	return 0;
//} // CFCCtlBrHRuler::OnCreate.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrHRuler::OnDestroy
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCCtlBrHRuler::OnDestroy ()
//{
//	// OnCmdMsg_xZkqqHx_iCmMiOmAiNhDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
//	FFGetMainWnd()->UnregisterOnCmdMsg(this);
//
//	BASE_CLASS::OnDestroy();
//} // CFCCtlBrHRuler::OnDestroy.
//----- 06.02.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
