#ifndef __DBLMath_h
#define __DBLMath_h

//;----- <EXPORT TO SDK> -----;

// float.h_xZkqqHx_jCiGiCmM_xHqqkZx_DBL_EPSILON_xZkqqHx_iCmN_xHqqkZx_2.2204460492503131e-016_xZkqqHx_iClOiCkKiBeBiClBiCmMjCgMiCmNiMoLiNlHiCmGiClFiCmE_xHqqkZx_
// _xZkqqHx_iMhGiOfKiClHiCoJiCmJiCmNiPkMiClDiClHiCkMiCoJiBeC_xHqqkZx_
// _xZkqqHx_jFiCjDkOiPkMjAjEjDfPiCmNiBeBjHeMiMpIiMiFjAjEiCkKiMiIiCnMiCmBiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_double_xZkqqHx_iCmMjCgMiCkKjBoFiCkLiCkCiPoKiNiHiBgJjBkGiClP_xHqqkZx_
// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiCkKiPkNiCmIiCkCiPoKiNiHiBgKiBeB_xHqqkZx_MY_DBL_EPSILON _xZkqqHx_iCpAiJmBiOfKiClFiCmEiCoAjCgMiCkKjFmPiCoNiCoHiCmIiCkC_xHqqkZx_
// _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
#define MY_DBL_EPSILON (2.2204460492503131e-012)
#define MY_DBL_ABOUT_EPSILON (2.2204460492503131e-07)
#define MY_DBL_ROUGH_EPSILON (1.0e-05)

//;----- </EXPORT TO SDK> -----;

#define POW2(a) ((a)*(a))
#define POW3(a) ((a)*(a)*(a))
#define POW4(a) ((a)*(a)*(a)*(a))

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFltExp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAjAlIjDhIiOmAjAjE_xHqqkZx_(4Byte)_xZkqqHx_iCmMiOhHjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	f	:_xZkqqHx_jCfAjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjAjEjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFiCjDkOiPkMjAjEjDfPjAjEiCmNiBeBiJlMjAjEjCgM_xHqqkZx_ * 2^_xZkqqHx_iOhHjAjEjCgM_xHqqkZx_ _xZkqqHx_iCmFjFfMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlMjAjEjCgMiBeBiOhHjAjEjCgMiCmNiClLiCmMiCnMiCnMiDhCiDgCiDgHjHpBiCmGiClFiCmEjFnLjBlGiClDiCoKiCmEiCkCiCoJiCoNiCkPiCmFiCmNiCmIiCkNiBeB_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiMgAiCmFjFiEiNiGjFjEiBeBiJlMjAjEjFjEiBeBiOhHjAjEjFjEiCmJjFmPiKlHiClFiCmEjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iJlMjAjEjCgM_xHqqkZx_ = (_xZkqqHx_jFiEiNiGjFjEiBhN_xHqqkZx_)(1.0 + _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_)
 *			_xZkqqHx_iOhHjAjEjCgM_xHqqkZx_ = _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ - _xZkqqHx_iDgPiDeDiDeBiDfI_xHqqkZx_
 *
 *			_xZkqqHx_jCfAjAlIjDhIiOmAjAjEiCmMiDhCiDgCiDgHjHpBiCpAiImIiJlKiCmJjAhNiOkGiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *			_xZkqqHx_iEkAiNiGiEkA_xHqqkZx_       8Bit     _xZkqqHx_iEkA_xHqqkZx_          23Bit         _xZkqqHx_iEkA_xHqqkZx_
 *			_xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *			_xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *			  31  30  29        23  22  21         2   1   0  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline short FFGetFltExp (float f)
{
	// _xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
	// _xZkqqHx_iEkAiNiGiEkA_xHqqkZx_       8Bit     _xZkqqHx_iEkA_xHqqkZx_          23Bit         _xZkqqHx_iEkA_xHqqkZx_
	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
	//   31  30  29        23  22  21         2   1   0  
	//
	struct FF {
		unsigned num : 23;
		unsigned exp : 8;
		unsigned sig : 1;
	};
	// _xZkqqHx_jCfAjAlIjDhIiOmAjAjEiNfMjBkCjBmMiCmFiDeMiDiDiDfIiDgHiClHiCoJiBeC_xHqqkZx_
	FF ff = *((FF*)&f);
	// _xZkqqHx_iDgPiDeDiDeBiDfIjCgMiCpAiIpIiCkCiClNiOhHjAjEjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	return short(ff.exp) - 127;
} // FFGetFltExp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetFltExp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAjAlIjDhIiOmAjAjE_xHqqkZx_(4Byte)_xZkqqHx_iCmMiOhHjAjEjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	f	:_xZkqqHx_jCfAjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nExp:_xZkqqHx_iOhHjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjCfAjAlIjDhIiOmAjAjEjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFGetFltExp_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline float FFSetFltExp (float f, short nExp)
{
	// _xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
	// _xZkqqHx_iEkAiNiGiEkA_xHqqkZx_       8Bit     _xZkqqHx_iEkA_xHqqkZx_          23Bit         _xZkqqHx_iEkA_xHqqkZx_
	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
	//   31  30  29        23  22  21         2   1   0  
	//
	struct FF {
		unsigned num : 23;
		unsigned exp : 8;
		unsigned sig : 1;
	};
	// _xZkqqHx_jCfAjAlIjDhIiOmAjAjEiNfMjBkCjBmMiCmFiDeMiDiDiDfIiDgHiClHiCoJiBeC_xHqqkZx_
	FF& ff = *((FF*)&f);
	// _xZkqqHx_jAfGiClFiCkCiOhHjAjEjFjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	ff.exp = nExp + 127;
	return f;
} // FFSetFltExp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDblExp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhLjAlIjDhIiOmAjAjE_xHqqkZx_(4Byte)_xZkqqHx_iCmMiOhHjAjEjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	d	:_xZkqqHx_jEhLjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjAjEjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFiCjDkOiPkMjAjEjDfPjAjEiCmNiBeBiJlMjAjEjCgM_xHqqkZx_ * 2^_xZkqqHx_iOhHjAjEjCgM_xHqqkZx_ _xZkqqHx_iCmFjFfMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlMjAjEjCgMiBeBiOhHjAjEjCgMiCmNiClLiCmMiCnMiCnMiDhCiDgCiDgHjHpBiCmGiClFiCmEjFnLjBlGiClDiCoKiCmEiCkCiCoJiCoNiCkPiCmFiCmNiCmIiCkNiBeB_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiMgAiCmFjFiEiNiGjFjEiBeBiJlMjAjEjFjEiBeBiOhHjAjEjFjEiCmJjFmPiKlHiClFiCmEjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iJlMjAjEjCgM_xHqqkZx_ = (_xZkqqHx_jFiEiNiGjFjEiBhN_xHqqkZx_)(1.0 + _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_)
 *			_xZkqqHx_iOhHjAjEjCgM_xHqqkZx_ = _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ - _xZkqqHx_iDgPiDeDiDeBiDfI_xHqqkZx_
 *
 *			_xZkqqHx_jEhLjAlIjDhIiOmAjAjEiCmMiDhCiDgCiDgHjHpBiCpAiImIiJlKiCmJjAhNiOkGiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *			_xZkqqHx_iEkAiNiGiEkA_xHqqkZx_      11Bit     _xZkqqHx_iEkA_xHqqkZx_          52Bit         _xZkqqHx_iEkA_xHqqkZx_
 *			_xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
 *			_xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
 *			  63  62  61        52  51  50         2   1   0  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline short FFGetDblExp (double d)
{
	// _xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
	// _xZkqqHx_iEkAiNiGiEkA_xHqqkZx_      11Bit     _xZkqqHx_iEkA_xHqqkZx_          52Bit         _xZkqqHx_iEkA_xHqqkZx_
	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
	//   63  62  61        52  51  50         2   1   0  
	//
	struct DD {
		DWORD	 num0;
		unsigned num1 : 20;
		unsigned exp  : 11;
		unsigned sig  : 1;
	};
	// _xZkqqHx_jEhLjAlIjDhIiOmAjAjEiNfMjBkCjBmMiCmFiDeMiDiDiDfIiDgHiClHiCoJiBeC_xHqqkZx_
	DD dd = *((DD*)&d);
	// _xZkqqHx_iDgPiDeDiDeBiDfIjCgMiCpAiIpIiCkCiClNiOhHjAjEjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	return short(dd.exp) - 1023;
} // FFGetDblExp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetDblExp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhLjAlIjDhIiOmAjAjE_xHqqkZx_(4Byte)_xZkqqHx_iCmMiOhHjAjEjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	d	:_xZkqqHx_jEhLjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nExp:_xZkqqHx_iOhHjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCjEhLjAlIjDhIiOmAjAjEjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFGetDblExp_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double FFSetDblExp (double d, short nExp)
{
	// _xZkqqHx_iEkAjFiEiEkFiEjPiEjP_xHqqkZx_ _xZkqqHx_iOhHjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjPiEjP_xHqqkZx_ _xZkqqHx_iJlMjAjEjFjE_xHqqkZx_ _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
	// _xZkqqHx_iEkAiNiGiEkA_xHqqkZx_      11Bit     _xZkqqHx_iEkA_xHqqkZx_          52Bit         _xZkqqHx_iEkA_xHqqkZx_
	// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkGiBgDiBgDiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
	// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkIiBgDiBgDiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
	//   63  62  61        52  51  50         2   1   0  
	//
	struct DD {
		DWORD	 num0;
		unsigned num1 : 20;
		unsigned exp  : 11;
		unsigned sig  : 1;
	};
	// _xZkqqHx_jEhLjAlIjDhIiOmAjAjEiNfMjBkCjBmMiCmFiDeMiDiDiDfIiDgHiClHiCoJiBeC_xHqqkZx_
	DD& dd = *((DD*)&d);
	// _xZkqqHx_jAfGiClFiCkCiOhHjAjEjFjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	dd.exp = nExp + 1023;
	return d;
} // FFSetDblExp.

//----- 05.04.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAdjustDblExp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDpBiCmCiCmMjEhLjAlIjDhIiOmAjAjEiCmMiOhHjAjEjCgMiCpAiBeBiCoGiCoIjBoFiCkLiCkCiOhHjAjEjCgMiCkKiCePiCmJ_xHqqkZx_
// *			_xZkqqHx_iCmIiCoJiCoGiCkEjFoCjAlDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	d1	:_xZkqqHx_jEhLjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeCjFoCjAlDiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			d2	:_xZkqqHx_jEhLjAlIjDhIiOmAjAjEiCpAiOhHjCoIiBeCjFoCjAlDiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	d1_xZkqqHx_iCmG_xHqqkZx_d2_xZkqqHx_iCmMiOhHjAjEjCgMiCmJiNlHiCkKiCkAiCoIiClHiCkMiCmEjFoCjAlDiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOmAjAjEiCmMiOhHjAjEjCgMiCpAjFoCjAlDiClHiCoJiClBiCmGiCmFiBeB_xHqqkZx_MY_DBL_EPSILON_xZkqqHx_iCmGiCkCiCmBiClNiMoLiNlHjCoIjAjEiCkK_xHqqkZx_
// *			_xZkqqHx_iOmAjAjEiCmMiMiFiCmJiKnGiMfHiCmIiCkNjHeMiMpIiCmJiCmIiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jDpBiCmCiCmMiOmAjAjEiCmMiCkEiClPiBeBiCoGiCoIjBoFiCkLiCkCiOhHjAjEjCgMiCkKiCePiCmJiCmIiCoJiCoGiCkEiBeBjHlMjFpLiCmMiOhHjAjEjCgMiCmJ_xHqqkZx_
// *			_xZkqqHx_jFoCjAlDjCgMiCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iCoGiCoIjBoFiCkLiCkCiOhHjAjEjCgMiCpAiCePiCmGiClHiCoJiCmMiCmNiBeBiMoLiNlHjCoIjAjEiCkK_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//inline BOOL FFAdjustDblExp (double& d1, double& d2)
//{
//} // FFAdjustDblExp.
//----- 05.04.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//;----- <EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	moeless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiMoLiNlHiCpAiNgMjHlGiClFiCmE_xHqqkZx_ x < v _xZkqqHx_iCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeCiMoLiNlHiCpAiNgMjHlGiClFiCmEiCoAiBeBjDjKiCkGiCkKjAfOiCmMiPoKiNiHiCmN_xHqqkZx_ x >= v _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			moe	:_xZkqqHx_iMoLiNlHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL moeless (double x, double v, double moe)
{
	return x < (v - moe);
} // moeless (double x, double v, double moe).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	moeeq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiMoLiNlHiCpAiNgMjHlGiClFiCmE_xHqqkZx_ x < v _xZkqqHx_iCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeCiMoLiNlHiCpAiNgMjHlGiClFiCmEiCoAiBeBjDjKiCkGiCkKjAfOiCmMiPoKiNiHiCmN_xHqqkZx_ x >= v _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			moe	:_xZkqqHx_iMoLiNlHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL moeeq (double x, double v, double moe)
{
	return (!moeless(x, v, moe) && !moeless(v, x, moe));
} // moeeq (double x, double v, double moe).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	moelesseq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiMoLiNlHiCpAiNgMjHlGiClFiCmE_xHqqkZx_ x <= v _xZkqqHx_iCkJiCmHiCkEiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			moe	:_xZkqqHx_iMoLiNlHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	x <= v _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL moelesseq (double x, double v, double moe)
{
	return !moeless(v, x, moe);
} // moelesseq (double x, double v, double moe).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	fig2moe
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiMiFjAjEiCkJiCoHiBeBiMoLiNlHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iFig:_xZkqqHx_jHeMiMpIiMiFjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMoLiNlHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	figless _xZkqqHx_iCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *			x = 3000.5, v = 3001.0, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNjAjEjCgMiCmMiCfAiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_3001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=1.0 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *			x = 0.30005, v = 0.30010, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNiPkMjAjEjDfPiImIiJlKiCfDiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_0.3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_0.3001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCfEiMiFiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.0000999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=0.0001 _xZkqqHx_iCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double fig2moe (double x, double v, int iFig)
{
	double ax = fabs(x);
	double av = fabs(v);
	double d = (ax < av) ? ax : av;
	// _xZkqqHx_iMoLiNlHiCmMiMiFjAjEiCkKiPkNiCmIiClHiCkMiCoJiPoKiNiHiBeBjBkGiClPjEoEiKhCjBmOiPnLiCkK_xHqqkZx_
	// _xZkqqHx_iCePiCmJiLnPiCkCiPoKiNiHiCmNiBeBiMiFjAjEiCpAiPkMjAjEjDfPiCmMiImKjChFiCkJiCoHiCmJiPeDjAlDiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCmNiBeBiCePiCmJjEpBiPoNiCmJiLnPiCkCiCfBjCgMiCpAjEoEiKhCiClHiCoJiPoKiNiHiCpA_xHqqkZx_
	// _xZkqqHx_iNgMiCkGiCoJiCmGjHjNiJpAiClFiCoCiClHiCkCiBeC_xHqqkZx_
	int iMoeFig;
	if (moeeq(d, 0.0, MY_DBL_EPSILON))
		iMoeFig = -iFig;
	else
		iMoeFig = (int)(log10(d) + 1000.0) - 1000 + 1 - iFig;
	if (iMoeFig < -306) iMoeFig = -iFig;
	return pow(10.0, iMoeFig);
} // fig2moe (double x, double v, int iFig).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	figless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCePjAgJjAjEiCmMjHeMiMpIiMiFjAjEiCpAiOhHjCoIiClFiCmEiBeBiClLiCmMiMoLiNlHiCpAiNgMjHlGiClFiCmEjAjEjCgMiCmMjBoFiPkMiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iFig:_xZkqqHx_jHeMiMpIiMiFjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	x < v _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	x = 3000.5, v = 3001.0, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNjAjEjCgMiCmMiCfAiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_30001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=1.0_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ x < v - 1.0 _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
 *			TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMjHoBiClOiCmGiBeB_xHqqkZx_3000.5 < 3001.0 - 1.0 _xZkqqHx_iCmIiCmMiCmFiBeB_xHqqkZx_FALSE_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *			x = 0.30005, v = 0.30010, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNiPkMjAjEjDfPiImIiJlKiCfDiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_0.3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_0.3001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCfEiMiFiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.0000999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=0.0001_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ x < v - 0.0001
 *			_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMjHoBiClOiCmGiBeB_xHqqkZx_0.30005 < 0.30010 - 0.0001 = 0.30000 _xZkqqHx_iCmIiCmMiCmFiBeB_xHqqkZx_FALSE_xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL figless (double x, double v, int iFig)
{
	return moeless(x, v, fig2moe(x, v, iFig));
} // figless (double x, double v, double moe).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	figeq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCePjAgJjAjEiCmMjHeMiMpIiMiFjAjEiCpAiOhHjCoIiClFiCmEiBeBiClLiCmMiMoLiNlHiCpAiNgMjHlGiClFiCmEjAjEjCgMiCmMjBoFiPkMiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			v	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iFig:_xZkqqHx_jHeMiMpIiMiFjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	x == v _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	x = 3000.5, v = 3001.0, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNjAjEjCgMiCmMiCfAiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_3001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=1.0_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ v - 1.0 <= x && x - 1.0 <= v
 *			_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 *			x = 0.30005, v = 0.30010, iFig = 4 _xZkqqHx_iCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHeMiMpIiMiFjAjEiCkKiCfDiCmIiCmMiCmFiBeBiClBiCmMiPoKiNiHiCmNiPkMjAjEjDfPiImIiJlKiCfDiCmMiMiFiCnMiCmFiBgJ_xHqqkZx_x_xZkqqHx_iClOiCmG_xHqqkZx_0.3000_xZkqqHx_iBeB_xHqqkZx_
 *			v_xZkqqHx_iClOiCmG_xHqqkZx_0.3001_xZkqqHx_iBgKiCkKjHeMiMpIiBeBiPkMjAjEjDfPiImIiJlKiCfEiMiFiImIiJlKiCkKiMoLiNlHiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoLiNlHiCmMiNmFjBoFjCgMiCmN_xHqqkZx_0.0000999999_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_=0.0001_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_ v - 0.0001 <= x &&
 *			x - 0.0001 <= v _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL figeq (double x, double v, int iFig)
{
	return moeeq(x, v, fig2moe(x, v, iFig));
} // figeq (double x, double v, double moe).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almostless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ x < v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCnJiCmGiCpBiCmHiCmGiMlOiCmBiCmEiCoAiBeB_xHqqkZx_x >= v _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almostless (double x, double v)
{
	return moeless(x, v, MY_DBL_EPSILON);
} // almostless (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	aboutless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iClOiCkCiClNiCkC_xHqqkZx_ x < v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClOiCkCiClNiCkCiCmGiMlOiCmBiCmEiCoAiBeB_xHqqkZx_x >= v _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkC_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL aboutless (double x, double v)
{
	return moeless(x, v, MY_DBL_ABOUT_EPSILON);
} // aboutless (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	roughless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iCnMiCkAiCnMiCkA_xHqqkZx_ x < v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiCkAiCnMiCkAiCmGiMlOiCmBiCmEiCoAiBeB_xHqqkZx_x >= v _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkA_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL roughless (double x, double v)
{
	return moeless(x, v, MY_DBL_ROUGH_EPSILON);
} // roughless (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almosteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnJiCmGiCpBiCmHjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.09.19 Fukushiro M. almosteq_xZkqqHx_iCmJjGlMiPmMjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
inline BOOL almosteq (double x, double v)
{
	// _xZkqqHx_jFiCjDkOiPkMjAjEjDfPiCmNiBeBjHeMiMpIiMiFjAjEiCkKiMiIiCnMiCmBiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_double_xZkqqHx_iCmMjCgMiCkKjBoFiCkLiCkCiPoKiNiHiBgJjBkGiClP_xHqqkZx_
	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiCkKiPkNiCmIiCkCiPoKiNiHiBgKiBeB_xHqqkZx_MY_DBL_EPSILON _xZkqqHx_iCpAiJmBiOfKiClFiCmEiCoAjCgMiCkKjFmPiCoNiCoHiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_(v - MY_DBL_EPSILON < x) && (x < v + MY_DBL_EPSILON)
	// _xZkqqHx_iCmFiCmNjAlDiClFiCkCiJpAiCmJiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	return (!almostless(x, v) && !almostless(v, x));
} // almosteq (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	abouteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiClOiCkCiClNiCkCjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkCjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL abouteq (double x, double v)
{
	// _xZkqqHx_jFiCjDkOiPkMjAjEjDfPiCmNiBeBjHeMiMpIiMiFjAjEiCkKiMiIiCnMiCmBiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_double_xZkqqHx_iCmMjCgMiCkKjBoFiCkLiCkCiPoKiNiHiBgJjBkGiClP_xHqqkZx_
	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiCkKiPkNiCmIiCkCiPoKiNiHiBgKiBeB_xHqqkZx_MY_DBL_ABOUT_EPSILON _xZkqqHx_iCpAiJmBiOfKiClFiCmEiCoAjCgMiCkKjFmPiCoNiCoHiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_(v - MY_DBL_ABOUT_EPSILON < x) && (x < v + MY_DBL_ABOUT_EPSILON)
	// _xZkqqHx_iCmFiCmNjAlDiClFiCkCiJpAiCmJiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	return (!aboutless(x, v) && !aboutless(v, x));
} // abouteq (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	rougheq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnMiCkAiCnMiCkAjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkAjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmetol -> hix -> mmetol _xZkqqHx_iCmFjAlGiClGiCoJiMoLiNlHiCpAiCnJiCnKjDjJiClFiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL rougheq (double x, double v)
{
	// _xZkqqHx_jFiCjDkOiPkMjAjEjDfPiCmNiBeBjHeMiMpIiMiFjAjEiCkKiMiIiCnMiCmBiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_double_xZkqqHx_iCmMjCgMiCkKjBoFiCkLiCkCiPoKiNiHiBgJjBkGiClP_xHqqkZx_
	// _xZkqqHx_iPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiCkKiPkNiCmIiCkCiPoKiNiHiBgKiBeB_xHqqkZx_MY_DBL_ROUGH_EPSILON _xZkqqHx_iCpAiJmBiOfKiClFiCmEiCoAjCgMiCkKjFmPiCoNiCoHiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_(v - MY_DBL_ROUGH_EPSILON < x) && (x < v + MY_DBL_ROUGH_EPSILON)
	// _xZkqqHx_iCmFiCmNjAlDiClFiCkCiJpAiCmJiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	return (!roughless(x, v) && !roughless(v, x));
} // rougheq (double x, double v).

//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almosteq
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vector<double>_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnJiCmGiCpBiCmHjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//inline BOOL almosteq (vector<double> x, vector<double> v)
//{
//	if (x.size() != v.size()) return FALSE;
//	for (long lC = 0; lC < x.size(); lC++)
//		if (!almosteq(x[lC], v[lC])) return FALSE;
//	return TRUE;
//} // almosteq (vector<double> x, vector<double> v).
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almosteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	vector<double>_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnJiCmGiCpBiCmHjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T> BOOL almosteq (vector<T> x, vector<T> v)
{
	if (x.size() != v.size()) return FALSE;
	for (long lC = 0; lC < x.size(); lC++)
		if (!almosteq(x[lC], v[lC])) return FALSE;
	return TRUE;
} // almosteq (vector<T> x, vector<T> v).
//----- 05.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almost0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOjCgMiCkKiCnJiCmGiCpBiCmH_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almost0 (double x)
{
	return almosteq(x, 0.0);
} // almost0 (double x).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	about0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOjCgMiCkKiClOiCkCiClNiCkC_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkCjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL about0 (double x)
{
	return abouteq(x, 0.0);
} // about0 (double x).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	rough0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOjCgMiCkKiCnMiCkAiCnMiCkA_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkAjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL rough0 (double x)
{
	return rougheq(x, 0.0);
} // rough0 (double x).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almostlesseq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ x <= v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ <= _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almostlesseq (double x, double v)
{
	// v < x -> return FALSE;
	// v >= x -> return TRUE;
	return !almostless(v, x);
} // almostlesseq (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	aboutlesseq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iClOiCkCiClNiCkC_xHqqkZx_ x <= v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkC_xHqqkZx_ <= _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL aboutlesseq (double x, double v)
{
	// v < x -> return FALSE;
	// v >= x -> return TRUE;
	return !aboutless(v, x);
} // aboutlesseq (double x, double v).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	roughlesseq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	double_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ x,v _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iCnMiCkAiCnMiCkA_xHqqkZx_ x <= v _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	x,v	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkA_xHqqkZx_ <= _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL roughlesseq (double x, double v)
{
	// v < x -> return FALSE;
	// v >= x -> return TRUE;
	return !roughless(v, x);
} // roughlesseq (double x, double v).

//----- 00.01.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LinearOverlap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiPoDiCmMjDpBiCmCiCmMjApMjFkKiCgAiCgBiBeBiCgCiCgDiCmMiPgEiCmIiCoJjFjEjFkKiCgPiChAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPgEiCmIiCoIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_P,Q_xZkqqHx_iCmMjCgMiCmNjFmPiCoNiCoHiCmIiCkCiBeC_xHqqkZx_DBLRect_xZkqqHx_jCiGiCmFiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	p,q	: _xZkqqHx_iPgEiCmIiCoI_xHqqkZx_PQ_xZkqqHx_iCmMjCgMiCpAjFnEiClH_xHqqkZx_.p < q.
 *			a,b	: _xZkqqHx_jApMjFkK_xHqqkZx_AB_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_a < b.
 *			c,d	: _xZkqqHx_jApMjFkK_xHqqkZx_CD_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_c < d.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iPgEiCmIiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FALSE	:_xZkqqHx_iPgEiCmIiCoIiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P221_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *			a=d _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ b=c _xZkqqHx_iCmMiPoKiNiHiCoAiPgEiCmIiCmBiCmEiCkCiCoJiCmGiCnNiCmIiClDiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL LinearOverlap (T& p, T& q, T a, T b, T c, T d)
{
	if (b < c || d < a) return FALSE;
	p = a < c ? c : a;
	q = b < d ? b : d;
	return TRUE;
} // LinearOverlap.

//;----- </EXPORT TO SDK> -----;

#endif//__DBLMath_h
