#if !defined(AFX_DBTABLE_H__4EA90A9E_9228_4F77_BEBE_9C71F0BE1F9C__INCLUDED_)
#define AFX_DBTABLE_H__4EA90A9E_9228_4F77_BEBE_9C71F0BE1F9C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DbTable.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "DbLock.h"				// For FCDbReadLock.etc.
#include "UtilVirtualTable.h"	// For FCTableName.

struct FCTableName;
class FCDynamicDb;

/////////////////////////////////////////////////////////////////////////////
// FCDbTable _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_

class FCDbTable
{
public:
	FCDbTable ();
	FCDbTable (const FCTableName& tableName);
	virtual ~FCDbTable ();
	virtual void	Initialize (const FCTableName& tableName);
//----- 05.12.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	Clear ();
	virtual void	operator = (const FCDbTable& dbTable);
	virtual void	Set (const FCDbTable& dbTable);
//----- 05.12.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual void	SetTable (const FCTableName& tableName);
	virtual void	SetTable (const FCDbTable& dbTable);

	virtual BOOL	TryLock (FCDbReadLock& readLock);
	virtual BOOL	TryLock (FCDbWriteLock& writeLock);
	virtual BOOL	TryLock (FCDbReadLock& readLock, FCDbWriteLock& writeLock);
	virtual BOOL	GetIsReadLocked () const;
	virtual BOOL	GetIsWriteLocked () const;

	virtual DWORD	AppendRecordAuto (const void* pData, DWORD dwDataSize);
	virtual DWORD	AppendRecord (flint fliPrimaryId, const void* pData, DWORD dwDataSize);
	virtual DWORD	GetRecordCount ();
	virtual void	ReduceRecordCount (DWORD dwIndex);
	virtual void	DeleteRecord (DWORD dwIndex);
	virtual void	DeleteRecords (const DWORDSet& stIndex);

	virtual void	CopyRecord (const FCTableName& tableNameSrc, DWORD dwIndexBegin, DWORD dwIndexEnd);

//----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual GUID	GetTableGuid () const;
	virtual DWORD	GetRecordAppendIdentifier (DWORD dwIndex);
//----- 06.02.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual flint	GetRecordPrimaryId (DWORD dwIndex);
	virtual DWORD	GetRecordDataSize (DWORD dwIndex);
	virtual DWORD	GetRecordData (void* pDataBuff, DWORD dwBuffSize, DWORD dwIndex);
	virtual void	GetRecord (flint& fliPrimaryId, BYTEVector* vBuff, DWORD dwIndex);
// 06.03.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual flint	GetRealRecordPrimaryId (DWORD dwIndex);

	virtual FCTableName	GetTableName () const;
	virtual BOOL	GetIsInvalid () const;

// 06.01.15 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	GetIsTableExist () const;
	virtual DWORD	PrimaryIdToLowerBoundIndex (flint fliPrimaryId);
	virtual DWORD	PrimaryIdToUpperBoundIndex (flint fliPrimaryId);
	virtual DWORD	PrimaryIdToIndex (flint fliPrimaryId);

protected:
	FCTableName		m_tableName;
}; // class FCDbTable.

/////////////////////////////////////////////////////////////////////////////

#endif // !defined(AFX_DBTABLE_H__4EA90A9E_9228_4F77_BEBE_9C71F0BE1F9C__INCLUDED_)
