// DlgImageMessageBox.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilZlibPng.h"		// For FFZlibUncompress.
#include "UtilStr.h"			// For ExtractUntil.
#include "UtilErr.h"			// For FFThrowMiscUnknown.
#include "UtilDlg.h"			// For IdToDlgLayoutRecMap.
#include "File32.h"				// For FCFile32.
#include "DlgImageMessageBox.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FD_SIZE_TOKEN		L"<size"
#define FD_SIZE_TOKEN_LEN	(sizeof(FD_SIZE_TOKEN) / sizeof(wchar_t) - 1)

//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define FD_INITIMG_TOKEN		L"<initimg"
#define FD_INITIMG_TOKEN_LEN	(sizeof(FD_INITIMG_TOKEN) / sizeof(wchar_t) - 1)
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#define FD_PAGE_TOKEN		L"<page"
#define FD_PAGE_TOKEN_LEN	(sizeof(FD_PAGE_TOKEN) / sizeof(wchar_t) - 1)

#define FD_PAGE_E_TOKEN		L"</page"
#define FD_PAGE_E_TOKEN_LEN	(sizeof(FD_PAGE_E_TOKEN) / sizeof(wchar_t) - 1)

#define FD_IMAGE_TOKEN		L"<image"
#define FD_IMAGE_TOKEN_LEN	(sizeof(FD_IMAGE_TOKEN) / sizeof(wchar_t) - 1)

#define FD_SLEEP_TOKEN		L"<sleep"
#define FD_SLEEP_TOKEN_LEN	(sizeof(FD_SLEEP_TOKEN) / sizeof(wchar_t) - 1)

//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
#define FD_RFBTN_TOKEN			L"<rfbtn"
#define FD_RFBTN_TOKEN_LEN		(sizeof(FD_RFBTN_TOKEN) / sizeof(wchar_t) - 1)
#define FD_RFBTN_E_TOKEN		L"</rfbtn"
#define FD_RFBTN_E_TOKEN_LEN	(sizeof(FD_RFBTN_E_TOKEN) / sizeof(wchar_t) - 1)
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#define FD_SIZE_CODE		BYTE(1)
//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define FD_PAGE_CODE	BYTE(2)
//#define FD_IMAGE_CODE	BYTE(3)
//#define FD_SLEEP_CODE	BYTE(4)
//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#define FD_INITIMG_CODE		BYTE(2)
#define FD_PAGE_CODE		BYTE(3)
#define FD_IMAGE_CODE		BYTE(4)
#define FD_SLEEP_CODE		BYTE(5)
#define FD_RFBTN_CODE		BYTE(6)
//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----


// DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
static const DWORD FD_DDSLIDE_VERSION = 0;

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImageMessageBox _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CFCDlgImageMessageBox::CFCDlgImageMessageBox (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgImageMessageBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgImageMessageBox)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT

	// _xZkqqHx_iMlLiNnNiCmMiDhJiBfLiDfHiImKjChFiBeC_xHqqkZx_
	m_lCurrentPage = -1;
	// _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiBeC_xHqqkZx_
	m_szImage = CSize(-1, -1);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiDhNiBfLiDfHiDjDiBeC_xHqqkZx_
	m_rtMargin.SetRect(0,0,0,0);
	// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	m_hEMF = NULL;
} // CFCDlgImageMessageBox::CFCDlgImageMessageBox.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImageMessageBox _xZkqqHx_iDiGiBfLiDfFiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::MakeDdSlideFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiDgJiDiKiDeJiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCpBiCmFiBeB_xHqqkZx_DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpScenario		:_xZkqqHx_iDfGiDgJiDiKiDeJiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDdSlideFile	:DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNkBiCmMiCmGiClBiCoLiOhHjCoIiCmFiCkLiCoJiDfOiDePiCmNiImIiJlKiBeC_xHqqkZx_
 *			<size width,height>	:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiDhDiDeOiDfKiDiLiCmFiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_jFeLiClIjAoGjDkKiCmFjCoIiLgAiBeC_xHqqkZx_
 *			<page>_xZkqqHx_iBgA_xHqqkZx_</page>		:_xZkqqHx_iDhJiBfLiDfHiCpAiOhHjCoIiBeCiBhFiOjPiCnGiBhGiDhLiDfOiDjDiCmFjBjHiCoJjCfAiImKiCmGiCmIiCoJiBeC_xHqqkZx_
 *			<image "file path">	:EMF_xZkqqHx_iDeDiDiBiBfLiDfHiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_jFeLiClIiDhJiBfLiDfHjDoAiCmFiOhHjCoIiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			<sleep msec>		:_xZkqqHx_iDeDiDjDiDfOiBfLiDgPiDiLiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_jFeLiClIiDhJiBfLiDfHjDoAiCmFiOhHjCoIiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			<rfbtn "ref">_xZkqqHx_iBgA_xHqqkZx_</rfbtn>
 *								:ref_xZkqqHx_iCpAjFfMiOkGiClHiCoJiDhLiDfOiDjDiCmMjFfMiOkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iBgAjFjEjFkKiCkKiDhLiDfOiDjDiCmMiDgFiDeMiDfIiDgHiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *								 _xZkqqHx_jFeLiClIiDhJiBfLiDfHjDoAiCmFiOhHjCoIiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			------------------------------------
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_
 *			<size 100 100>
 *			<page>
 *				<image "c:\doc\image1.emf">
 *			</page>
 *			<page>
 *				<image "c:\doc\image2.emf">
 *			</page>
 *			<page>
 *				<image "c:\doc\image3.emf">
 *				<sleep 200>
 *				<image "c:\doc\image4.emf">
 *				<sleep 200>
 *				<image "c:\doc\image5.emf">
 *				<rfbtn "http://www.dynamicdraw.com/jp/index.html">Dynamic Draw</rfbtn>
 *			</page>
 *			------------------------------------
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::MakeDdSlideFile (const wchar_t* wcpScenario, const wchar_t* wcpDdSlideFile)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_Open_xZkqqHx_iBeC_xHqqkZx_
	FCFile32 fileRead(wcpScenario, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	astring strBuff;
	strBuff.resize(fileRead.GetLength64());
	int iCount = fileRead.Read64(strBuff.begin(), strBuff.size());
	fileRead.Close();
	strBuff.resize(iCount);
	WString wstrBuff = AStrToWStr(strBuff.c_str());
	// _xZkqqHx_jBfDiDgGiBfLiDfOiBeC_xHqqkZx_
	BYTEVector vTotalData;
	while (!wstrBuff.IsEmpty())
	{
		wstrBuff.TrimLeft();
		WString wstr = FFExtractUntil(wstrBuff, L'\r');

		if (wcsncmp(wstr.c_str(), FD_SIZE_TOKEN, FD_SIZE_TOKEN_LEN) == 0)
		//----- <size> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiBeC_xHqqkZx_
			CSize szImage(-1, -1);
			// _xZkqqHx_iDeDiDiBiBfLiDfHiCmMiOgMjFpLiCmMiDhNiBfLiDfHiDjDiBeC_xHqqkZx_
			CRect rtMargin(0,0,0,0);
			// <size _xZkqqHx_iDgHiBfLiDeOiDjDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			wstr.Delete(0, FD_SIZE_TOKEN_LEN);
			wstr.TrimLeft();
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			szImage.cx = wcstol(wstr, NULL, 10);
			FFExtractUntil(wstr, L',');
			wstr.TrimLeft();
			szImage.cy = wcstol(wstr, NULL, 10);
			FFExtractUntil(wstr, L',');
			wstr.TrimLeft();
			// _xZkqqHx_iDhNiBfLiDfHiDjDiNlGiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			rtMargin.left = wcstol(wstr, NULL, 10);
			FFExtractUntil(wstr, L',');
			wstr.TrimLeft();
			// _xZkqqHx_iDhNiBfLiDfHiDjDiPoDiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			rtMargin.top = wcstol(wstr, NULL, 10);
			FFExtractUntil(wstr, L',');
			wstr.TrimLeft();
			// _xZkqqHx_iDhNiBfLiDfHiDjDiJeFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			rtMargin.right = wcstol(wstr, NULL, 10);
			FFExtractUntil(wstr, L',');
			wstr.TrimLeft();
			// _xZkqqHx_iDhNiBfLiDfHiDjDiJlKiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			rtMargin.bottom = wcstol(wstr, NULL, 10);
			// _xZkqqHx_iNmFiPiJiCmMiPjBiCkLiNjOiCnNiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			if (!vTotalData.empty()) FFThrowMiscUnknown();
			// size_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			vTotalData << FD_SIZE_CODE;
			// size_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			vTotalData << szImage;
			// _xZkqqHx_iDhNiBfLiDfHiDjDiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			vTotalData << rtMargin;
		} else
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (wcsncmp(wstr.c_str(), FD_INITIMG_TOKEN, FD_INITIMG_TOKEN_LEN) == 0)
		//----- <initimg> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// <initimg _xZkqqHx_iDgHiBfLiDeOiDjDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			wstr.Delete(0, FD_INITIMG_TOKEN_LEN);
			wstr.TrimLeft();
			if (wstr.GetAt(0) != L'"')
				FFThrowMiscUnknown();
			wstr.ChopFirst();
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
			WString wstrPath = FFExtractUntil(wstr, L'"');

			//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClFiCmEiBeBiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
			FCFile32 fileImage(wstrPath, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
			DWORD dwLen = fileImage.GetLength64();
			BYTEVector vImageData(dwLen);
			dwLen = fileImage.Read64(vImageData.begin(), vImageData.size());
			vImageData.resize(dwLen);
			fileImage.Close();
			// initimg_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			vTotalData << FD_INITIMG_CODE;
			// initimg_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			FFWriteData(vImageData.begin(), vImageData.size(), vTotalData);
		} else
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		if (wcsncmp(wstr.c_str(), FD_PAGE_TOKEN, FD_PAGE_TOKEN_LEN) == 0)
		//----- <page> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhJiBfLiDfHiDgGiBfLiDfOiBeC_xHqqkZx_
			BYTEVector vPageData;
			while (!wstrBuff.IsEmpty())
			{
				wstrBuff.TrimLeft();
				WString wstr = FFExtractUntil(wstrBuff, L'\r');
				if (wcsncmp(wstr.c_str(), FD_IMAGE_TOKEN, FD_IMAGE_TOKEN_LEN) == 0)
				//----- <image> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMpIiJmKiBeC_xHqqkZx_
					short nEffect = 0;
					// <image _xZkqqHx_iDgHiBfLiDeOiDjDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
					wstr.Delete(0, FD_IMAGE_TOKEN_LEN);
					wstr.TrimLeft();
					if (wstr.GetAt(0) != L'"')
					{
						// _xZkqqHx_iMpIiJmKiBeC_xHqqkZx_
						nEffect = (short)wcstol(wstr, NULL, 10);
						FFExtractUntil(wstr, L',');
						wstr.TrimLeft();
					}
					if (wstr.GetAt(0) != L'"')
						FFThrowMiscUnknown();
					wstr.ChopFirst();
					// _xZkqqHx_iDeDiDiBiBfLiDfHiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
					WString wstrPath = FFExtractUntil(wstr, L'"');

					//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClFiCmEiBeBiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
					FCFile32 fileImage(wstrPath, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
					DWORD dwLen = fileImage.GetLength64();
					BYTEVector vImageData(dwLen);
					dwLen = fileImage.Read64(vImageData.begin(), vImageData.size());
					vImageData.resize(dwLen);
					fileImage.Close();

					// image_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << FD_IMAGE_CODE;
					// _xZkqqHx_iOiLiKgPiMpIiJmKiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << nEffect;
					// image_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					FFWriteData(vImageData.begin(), vImageData.size(), vPageData);
				} else
				if (wcsncmp(wstr.c_str(), FD_SLEEP_TOKEN, FD_SLEEP_TOKEN_LEN) == 0)
				//----- <sleep> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
				{
					// <sleep _xZkqqHx_iDgHiBfLiDeOiDjDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
					wstr.Delete(0, FD_SLEEP_TOKEN_LEN);
					wstr.TrimLeft();
					long lSleepMsec = wcstol(wstr, NULL, 10);
					// sleep_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << FD_SLEEP_CODE;
					// sleep time_xZkqqHx_iCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << lSleepMsec;
				} else
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				if (wcsncmp(wstr.c_str(), FD_RFBTN_TOKEN, FD_RFBTN_TOKEN_LEN) == 0)
				//----- <rfbtn> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
				{
					// <rfbtn _xZkqqHx_iDgHiBfLiDeOiDjDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
					wstr.Delete(0, FD_RFBTN_TOKEN_LEN);
					wstr.TrimLeft();
					if (wstr.GetAt(0) != L'"')
						FFThrowMiscUnknown();
					wstr.ChopFirst();
					// REF_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
					WString wstrRef = FFExtractUntil(wstr, L'"');
					// '>'_xZkqqHx_iCnMiCmFiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
					FFExtractUntil(wstr, L'>');
					const int iEndOf = wstr.Find(FD_RFBTN_E_TOKEN);
					if (iEndOf == -1)
						FFThrowMiscUnknown();
					WString wstrMessage = wstr.Left(iEndOf);
					// rfbtn_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << FD_RFBTN_CODE;
					// REF_xZkqqHx_iCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << WORD(wstrRef.GetLength());
					FFWriteStream(vPageData, wstrRef.c_str(), sizeof(wchar_t) * wstrRef.GetLength());
					// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
					vPageData << WORD(wstrMessage.GetLength());
					FFWriteStream(vPageData, wstrMessage.c_str(), sizeof(wchar_t) * wstrMessage.GetLength());
				} else
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
				if (wcsncmp(wstr.c_str(), FD_PAGE_E_TOKEN, FD_PAGE_E_TOKEN_LEN) == 0)
				//----- </page> _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
				{
					break;
				}
			}
			// _xZkqqHx_iNmFiPiJiCmMiPjBiCkLiNjOiCnNiCmFiCkAiCmBiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
			if (vTotalData.empty()) FFThrowMiscUnknown();
			// page_xZkqqHx_iDfCiBfLiDgIiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			vTotalData << FD_PAGE_CODE;
			// page_xZkqqHx_iDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
			FFWriteData(vPageData.begin(), vPageData.size(), vTotalData);
		}
	}

	BYTEVector vCompressData;
	if (!FFZlibCompress(vCompressData, vTotalData.begin(), vTotalData.size()))
		FFThrowMiscUnknown();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_Open_xZkqqHx_iBeC_xHqqkZx_
	FCFile32 fileWrite(wcpDdSlideFile, GENERIC_READ|GENERIC_WRITE, 0, CREATE_NEW);
	// DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAiLeMjIfOiBeC_xHqqkZx_
	fileWrite.Write64(&FD_DDSLIDE_VERSION, sizeof(FD_DDSLIDE_VERSION));
	// _xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiDfEiDeDiDfJiCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwOriginalSize = vTotalData.size();
	fileWrite.Write64(&dwOriginalSize, sizeof(dwOriginalSize));
	// _xZkqqHx_iIlDiPgLiDgGiBfLiDfOiCpAiLeMjIfOiBeC_xHqqkZx_
	fileWrite.Write64(vCompressData.begin(), vCompressData.size());
	fileWrite.Close();
} // CFCDlgImageMessageBox::MakeDdSlideFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::SetDdSlideFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::SetDdSlideFile (const wchar_t* wcpFilePath)
{
	// _xZkqqHx_iKpJjBlGiDhJiBfLiDfHiDgGiBfLiDfOiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearPageData();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_Open_xZkqqHx_iBeC_xHqqkZx_
	FCFile32 fileRead(wcpFilePath, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	// DD_xZkqqHx_iDfIiDiJiDeDiDgIiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	DWORD dwVersion;
	fileRead.Read64(&dwVersion, sizeof(dwVersion));
	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiIoBiCkCiCmMiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (dwVersion != FD_DDSLIDE_VERSION)
		FFThrowMiscUnknown();
	// _xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	DWORD dwOriginalSize;
	fileRead.Read64(&dwOriginalSize, sizeof(dwOriginalSize));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHiIlDiPgLiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	BYTEVector vCompressData;
	vCompressData.resize(fileRead.GetLength64() - fileRead.GetPosition64());
	int iCount = fileRead.Read64(vCompressData.begin(), vCompressData.size());
	fileRead.Close();
	vCompressData.resize(iCount);
	// _xZkqqHx_iIlDiPgLjBePiDgGiBfLiDfOiCmMiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	BYTEVector vOriginalData(dwOriginalSize);
	if (!FFZlibUncompress(vOriginalData, vCompressData.begin(), vCompressData.size()))
		FFThrowMiscUnknown();
	const BYTE* pBuff = vOriginalData.begin();
	const BYTE* pBuffEnd = pBuff + vOriginalData.size();
	while (pBuff != pBuffEnd)
	{
		BYTE code;
		FFReadData(code, pBuff);
		if (code == FD_SIZE_CODE)
		//----- _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			FFReadData(m_szImage, pBuff);
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDhNiBfLiDfHiDjDiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			FFReadData(m_rtMargin, pBuff);
		} else

//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (code == FD_INITIMG_CODE)
		//----- _xZkqqHx_iPiJiKpKiDeDiDiBiBfLiDfHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			DWORD dwImageSize;
			FFReadData(dwImageSize, pBuff);
			m_vInitImageData.assign(dwImageSize, 0);
			FFReadStream(pBuff, m_vInitImageData.begin(), dwImageSize);
		} else
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		if (code == FD_PAGE_CODE)
		//----- _xZkqqHx_iDhJiBfLiDfHiDgGiBfLiDfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhJiBfLiDfHiDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			DWORD dwPageSize;
			FFReadData(dwPageSize, pBuff);
			BYTE* pDataBuff = new BYTE[dwPageSize];
			FFReadStream(pBuff, pDataBuff, dwPageSize);
			// _xZkqqHx_iDhJiBfLiDfHiDgGiBfLiDfOiCpAiLeMjIfOiBeC_xHqqkZx_
			m_vPageData.push_back(pair<BYTE*, DWORD>(pDataBuff, dwPageSize));
		} else
		{
			FFThrowMiscUnknown();
		}
	}
} // CFCDlgImageMessageBox::SetDdSlideFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::SetStartPageIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiCpAiKeKiOgOiClHiCoJiDhJiBfLiDfHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lPageIndex	:_xZkqqHx_jFfMiOkGiCpAiKeKiOgOiClHiCoJiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::SetStartPageIndex (long lPageIndex)
{
	m_lCurrentPage = lPageIndex - 1;
} // CFCDlgImageMessageBox::SetStartPageIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::ClearPageData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDhJiBfLiDfHiDgGiBfLiDfOiCmGiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::ClearPageData ()
{
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPiJiKpKiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vInitImageData.clear();
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	vector< pair<BYTE*, DWORD> >::iterator i;
	for (i = m_vPageData.begin(); i != m_vPageData.end(); i++)
		delete[] i->first;
	m_vPageData.clear();
	m_lCurrentPage = -1;
	// _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiBeC_xHqqkZx_
	m_szImage = CSize(-1, -1);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiDhNiBfLiDfHiDjDiBeC_xHqqkZx_
	m_rtMargin.SetRect(0,0,0,0);
	// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	if (m_hEMF != NULL)
	{
		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjEgKiKpMiBeC_xHqqkZx_
		::DeleteEnhMetaFile(m_hEMF);
		m_hEMF = NULL;
	}
} // CFCDlgImageMessageBox::ClearPageData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::ShowPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiDgGiBfLiDfOiCmJiKoOiCmDiCkLiBeBiOhHjCoIiClDiCoKiClNiDhJiBfLiDfHiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lPageIndex	:_xZkqqHx_iDhJiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::ShowPage (long lPageIndex)
{
	const BYTE* pBuff = m_vPageData[lPageIndex].first;
	const BYTE* pBuffEnd = pBuff + m_vPageData[lPageIndex].second;
	while (pBuff != pBuffEnd)
	{
		BYTE code;
		FFReadData(code, pBuff);
		switch (code)
		{
		case FD_IMAGE_CODE:
		  {
			// _xZkqqHx_iOiLiKgPiMpIiJmKiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			short nEffect;
			FFReadData(nEffect, pBuff);
			// _xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			DWORD dwImageSize;
			FFReadData(dwImageSize, pBuff);
			BYTEVector vImageData(dwImageSize);
			FFReadStream(pBuff, vImageData.begin(), dwImageSize);

			if (m_hEMF != NULL)
			{
				// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjEgKiKpMiBeC_xHqqkZx_
				::DeleteEnhMetaFile(m_hEMF);
				m_hEMF = NULL;
			}
			// _xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
			m_hEMF = SetEnhMetaFileBits(vImageData.size(), vImageData.begin());
			m_stcImage.SetEmfImage(m_hEMF);
			m_stcImage.SetMargin(m_rtMargin.left, m_rtMargin.top, m_rtMargin.right, m_rtMargin.bottom);
			m_stcImage.FlickerFreeDraw(nEffect);
			break;
		  }
		case FD_SLEEP_CODE:
		  {
			long lSleepMsec;
			FFReadData(lSleepMsec, pBuff);
			Sleep(lSleepMsec);
			break;
		  }
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case FD_RFBTN_CODE:
		  {
			WORD wRefLen;
			FFReadData(wRefLen, pBuff);
			WString wstrRef(wRefLen, L'\0');
			FFReadStream(pBuff, &wstrRef.at(0), sizeof(wchar_t) * wRefLen);
			WORD wMessageLen;
			FFReadData(wMessageLen, pBuff);
			WString wstrMessage(wMessageLen, L'\0');
			FFReadStream(pBuff, &wstrMessage.at(0), sizeof(wchar_t) * wMessageLen);
			EnableRefButton(wstrRef, wstrMessage);
			break;
		  }
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		default:
			FFThrowMiscUnknown();
		}
	}
} // CFCDlgImageMessageBox::ShowPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::EnableRefButton
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjDiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpRef		:_xZkqqHx_iOfBiPmGjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpMessage	:_xZkqqHx_iDhLiDfOiDjDiCmMiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCDlgImageMessageBox::EnableRefButton (const wchar_t* wcpRef, const wchar_t* wcpMessage)
{
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_iBhFiOjPiCnGiBhGiDhLiDfOiDjDiCmMiImKjChFiBeC_xHqqkZx_
	CRect rtNextButton;
	GetDlgItem(IDC_IMB_BTN_NEXT)->GetWindowRect(rtNextButton);
	ScreenToClient(rtNextButton);
	// _xZkqqHx_iDhLiDfOiDjDiKnEiKhFiCpAiMhGiOfKiBeC_xHqqkZx_
	const int iBtnSpace = rtClient.right - rtNextButton.right;
	// _xZkqqHx_jBePiJpBiCmMiDhLiDfOiDjDiImKjChFiBeC_xHqqkZx_
	CRect rtPrevButton(0, rtNextButton.top, 0, rtNextButton.bottom);
	int iBtnId;
	for (iBtnId = IDC_IMB_BTN_REF_1; iBtnId <= IDC_IMB_BTN_REF_5; iBtnId++)
	{
		if (!GetDlgItem(iBtnId)->IsWindowVisible())
		{
			// _xZkqqHx_iOfBiPmGjAoGiCpAjAnNjCoIiBeC_xHqqkZx_
			m_wstrRef[iBtnId - IDC_IMB_BTN_REF_1] = wcpRef;
			// _xZkqqHx_iDhLiDfOiDjDiCmJiDgFiDeMiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
			FFSetDlgItemText(this, iBtnId, wcpMessage);
			// _xZkqqHx_iDhLiDfOiDjDiCmMiDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
			CString strText;
			GetDlgItem(iBtnId)->GetWindowText(strText);
			CDC dc;
			dc.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
			CFont* pFontOld = dc.SelectObject(GetDlgItem(iBtnId)->GetFont());
			// _xZkqqHx_iDhLiDfOiDjDiCmJjFgAiJoGiClDiCoKiCoJiDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCmMiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
			CRect rtText(0,0,0,0);
			::DrawText(	dc.m_hDC,
						strText,
						strText.GetLength(),
						rtText,
						DT_SINGLELINE|DT_VCENTER|DT_CENTER|DT_CALCRECT);
			dc.SelectObject(pFontOld);
			// _xZkqqHx_iDhLiDfOiDjDiCpAiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
			GetDlgItem(iBtnId)->MoveWindow(	rtPrevButton.right + iBtnSpace,
											rtPrevButton.top,
											rtText.Width() + 4 * iBtnSpace,
											rtPrevButton.Height(),
											FALSE);
			// _xZkqqHx_iDhLiDfOiDjDiCpAjFfMiOkGiBeC_xHqqkZx_
			GetDlgItem(iBtnId)->ShowWindow(SW_SHOW);
			GetDlgItem(iBtnId)->EnableWindow(TRUE);
			break;
		}
		GetDlgItem(iBtnId)->GetWindowRect(rtPrevButton);
		ScreenToClient(rtPrevButton);
	}
	return iBtnId;
} // CFCDlgImageMessageBox::EnableRefButton.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImageMessageBox _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_

void CFCDlgImageMessageBox::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgImageMessageBox)
	DDX_Control(pDX, IDC_IMB_STC_IMAGE, m_stcImage);
	DDX_Control(pDX, IDC_IMB_BTN_NEXT, m_btnNext);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFCDlgImageMessageBox, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgImageMessageBox)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_IMB_BTN_NEXT, OnImbBtnNext)
	ON_BN_CLICKED(IDC_IMB_BTN_REF_1, OnImbBtnRef1)
	ON_BN_CLICKED(IDC_IMB_BTN_REF_2, OnImbBtnRef2)
	ON_BN_CLICKED(IDC_IMB_BTN_REF_3, OnImbBtnRef3)
	ON_BN_CLICKED(IDC_IMB_BTN_REF_4, OnImbBtnRef4)
	ON_BN_CLICKED(IDC_IMB_BTN_REF_5, OnImbBtnRef5)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImageMessageBox _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgImageMessageBox::OnInitDialog ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	if (m_szImage != CSize(-1, -1))
	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCmMiLoJiMgAiCpAiOoGjDlOiBeCiDiBiDeDiDjDiDiCiDgKiDfOiBfLiCmMjHmMiIoGiCkKiOoGjDlOiCmFiCkLiCoJiCmNiClIiBeC_xHqqkZx_
		CRect rtDesktop;
		GetDesktopWindow()->GetWindowRect(rtDesktop);

		//----- _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiCpAiMhGiOfK_xHqqkZx_ -----
		// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiBeC_xHqqkZx_
		IdToDlgLayoutRecMap mpLayoutInfo;

		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiOgMjFpLiCmJjCmHiPfNiClFiCmEiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
		const long aId1[] = {	IDC_IMB_STC_IMAGE };
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiJeFiJlKiCmJjCmHiPfNiClFiCmEiInKjDkOiBeC_xHqqkZx_
		const long aId2[] = {	IDC_IMB_BTN_NEXT,
								IDCANCEL };
		FFInitDlgLayout(mpLayoutInfo,
						this,
						sizeof(aId1) / sizeof(aId1[0]),
						aId1,
						FCDlgLayoutRec::HOOK_ALL);
		FFInitDlgLayout(mpLayoutInfo,
						this,
						sizeof(aId2) / sizeof(aId2[0]),
						aId2,
						FCDlgLayoutRec::HOOK_RIGHT | FCDlgLayoutRec::HOOK_BOTTOM);

		// _xZkqqHx_iClBiCmMiDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtDialog;
		GetWindowRect(rtDialog);
		// _xZkqqHx_iDeDiDiBiBfLiDfHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtImageClient;
		m_stcImage.GetClientRect(rtImageClient);
		// _xZkqqHx_iDeDiDiBiBfLiDfHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiBeBiKgHjBoFiDhDiDeOiDfKiDiLjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
		int iHorzExt = m_szImage.cx - rtImageClient.Width();
		int iVertExt = m_szImage.cy - rtImageClient.Height();
		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiJeFiJlKiCmJiKgHjBoFiBeC_xHqqkZx_
		rtDialog.right += iHorzExt;
		rtDialog.bottom += iVertExt;
		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiDfEiDeDiDfJiCkKiDgGiDfIiDeOiDgHiDgCiDhGiDfEiDeDiDfJiCpAjClEiCkGiCmIiCkCiCoGiCkEjClCjAkOiBeC_xHqqkZx_
		if (rtDesktop.Width() < rtDialog.Width())
			rtDialog.right = rtDialog.left + rtDesktop.Width();
		if (rtDesktop.Height() < rtDialog.Height())
			rtDialog.bottom = rtDialog.top + rtDesktop.Height();
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGjCiGjAfDiCmGiDfPiDeDiDeBiDiNiDePjCiGjAfDiCmMiNlHjFkKiCpAiMhGiOfKiBeC_xHqqkZx_
		CSize szMove = rtDesktop.CenterPoint() - rtDialog.CenterPoint();
		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCiGjAfDjDfPiCkKiDgGiDfIiDeOiDgHiDgCiDhGjCiGjAfDiCmGiCmIiCoJiCoGiCkEiInKjDkOiBeC_xHqqkZx_
		rtDialog += szMove;

		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiInKjDkOiBeC_xHqqkZx_
		MoveWindow(rtDialog.left, rtDialog.top, rtDialog.Width(), rtDialog.Height(), FALSE);
		// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(rtClient);
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiNmEjEhKjChFiBeC_xHqqkZx_
		FFDlgLayout(mpLayoutInfo, this, CSize(rtClient.Width(), rtClient.Height()));
	}

	// _xZkqqHx_iOjPiCnG_xHqqkZx_ _xZkqqHx_iDhLiDfOiDjDiCmMiDeBiDeDiDfCiDjDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	m_btnNext.SetIcon(FFGetApp()->LoadIcon(IDI_ARROW_RIGHT), 32, 32, FALSE);

//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPiJiKpKiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCkKjHeMiCoJiPoKiNiHiCmNjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	if (!m_vInitImageData.empty())
	{
		m_stcImage.SetEmfImage(&m_vInitImageData.front(), m_vInitImageData.size());
		m_stcImage.SetMargin(m_rtMargin.left, m_rtMargin.top, m_rtMargin.right, m_rtMargin.bottom);
	}
//----- 06.06.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
//	::FFJustifyWindow(m_hWnd);
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgImageMessageBox::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnDestroy ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
	// _xZkqqHx_iKpJjBlGiDhJiBfLiDfHiDgGiBfLiDfOiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearPageData();
} // CFCDlgImageMessageBox::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiDhLiDfOiDjDiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnNext ()
{
	if (m_lCurrentPage + 1 == m_vPageData.size())
		return;
	m_lCurrentPage++;
	GetDlgItem(IDC_IMB_BTN_NEXT)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_NEXT)->EnableWindow(FALSE);
	GetDlgItem(IDCANCEL)->ShowWindow(SW_HIDE);
	GetDlgItem(IDCANCEL)->EnableWindow(FALSE);
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	GetDlgItem(IDC_IMB_BTN_REF_1)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_REF_1)->EnableWindow(FALSE);
	GetDlgItem(IDC_IMB_BTN_REF_2)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_REF_2)->EnableWindow(FALSE);
	GetDlgItem(IDC_IMB_BTN_REF_3)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_REF_3)->EnableWindow(FALSE);
	GetDlgItem(IDC_IMB_BTN_REF_4)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_REF_4)->EnableWindow(FALSE);
	GetDlgItem(IDC_IMB_BTN_REF_5)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_IMB_BTN_REF_5)->EnableWindow(FALSE);
//----- 06.06.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ShowPage(m_lCurrentPage);
	if (m_lCurrentPage + 1 != m_vPageData.size())
	{
		GetDlgItem(IDC_IMB_BTN_NEXT)->ShowWindow(SW_SHOW);
		GetDlgItem(IDC_IMB_BTN_NEXT)->EnableWindow(TRUE);
	} else
	{
		GetDlgItem(IDCANCEL)->ShowWindow(SW_SHOW);
		GetDlgItem(IDCANCEL)->EnableWindow(TRUE);
	}
} // CFCDlgImageMessageBox::OnImbBtnNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnRef1
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjD_xHqqkZx_1_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnRef1 ()
{
	CString strRef = WStrToTStr(m_wstrRef[0]);
	ShellExecute(0, _T("open"), strRef, NULL, NULL, SW_SHOW);
} // CFCDlgImageMessageBox::OnImbBtnRef1.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnRef2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjD_xHqqkZx_2_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnRef2 ()
{
	CString strRef = WStrToTStr(m_wstrRef[1]);
	ShellExecute(0, _T("open"), strRef, NULL, NULL, SW_SHOW);
} // CFCDlgImageMessageBox::OnImbBtnRef2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnRef3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjD_xHqqkZx_3_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnRef3 ()
{
	CString strRef = WStrToTStr(m_wstrRef[2]);
	ShellExecute(0, _T("open"), strRef, NULL, NULL, SW_SHOW);
} // CFCDlgImageMessageBox::OnImbBtnRef3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnRef4
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjD_xHqqkZx_4_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnRef4 ()
{
	CString strRef = WStrToTStr(m_wstrRef[3]);
	ShellExecute(0, _T("open"), strRef, NULL, NULL, SW_SHOW);
} // CFCDlgImageMessageBox::OnImbBtnRef4.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnImbBtnRef5
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	REF_xZkqqHx_iDhLiDfOiDjD_xHqqkZx_5_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnImbBtnRef5 ()
{
	CString strRef = WStrToTStr(m_wstrRef[4]);
	ShellExecute(0, _T("open"), strRef, NULL, NULL, SW_SHOW);
} // CFCDlgImageMessageBox::OnImbBtnRef5.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImageMessageBox::OnShowWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFfMiOkGiBeFjEpBjFfMiOkGiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImageMessageBox::OnShowWindow (BOOL bShow, UINT nStatus)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnShowWindow(bShow, nStatus);

	// _xZkqqHx_iOjPiCnGiDhLiDfOiDjDiCpAiJjPiClHiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
	// OnInitDialog_xZkqqHx_iCmJjAnNjCoIiClFiCmEiCkCiClNiCkKiBeBiDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGiClHiCoJjBePiCkJiCoH_xHqqkZx_
	// _xZkqqHx_jDkOiNoMiClFiCmEiClFiCnMiCkEiClNiCnPiBeBiClBiClBiCmJiInKjDkOiBeC_xHqqkZx_
	if (bShow)
		PostMessage(WM_COMMAND, MAKELPARAM(IDC_IMB_BTN_NEXT, BN_CLICKED), 0);
} // CFCDlgImageMessageBox::OnShowWindow.

