// DlgInitUserRegistration.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilMisc.h"		// For FFStringToGuid.etc.
#include "UtilDlg.h"		// For SetUnitString.etc.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilStr.h"		// For FormatResString.
#include "FileDialogBase.h"	// For FCFileDialogBase.
#include "UtilFile.h"		// For FFSaveTextFile.
#include "RegData.h"		// For g_pReg.
#include "DynamicDb.h"	// For g_pFileServer.
#include "DlgInitUserRegistration.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCDlgInitUserRegistration _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CFCDlgInitUserRegistration::CFCDlgInitUserRegistration (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgInitUserRegistration::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgInitUserRegistration)
	m_bInhibitSetId = FALSE;
	m_bNotUseUserId = FALSE;
	//}}AFX_DATA_INIT
} // CFCDlgInitUserRegistration::CFCDlgInitUserRegistration.

void CFCDlgInitUserRegistration::DoDataExchange (CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgInitUserRegistration)
	DDX_Check(pDX, IDC_IUR_CHK_INHIBIT_SET_ID, m_bInhibitSetId);
	DDX_Check(pDX, IDC_IUR_CHK_NOT_USE_USER_ID, m_bNotUseUserId);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCDlgInitUserRegistration, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgInitUserRegistration)
	ON_BN_CLICKED(IDC_IUR_BTN_NEW_USER_ID, OnIurBtnNewUserId)
	ON_BN_CLICKED(IDC_IUR_BTN_SAVE_NAME_ID, OnIurBtnSaveNameId)
	ON_BN_CLICKED(IDC_IUR_CHK_NOT_USE_USER_ID, OnIurChkNotUseUserId)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgInitUserRegistration _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::CheckUserRegistration
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjCgMiCkKjAlDiClFiCkNjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjAlDiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjCgMiCkKjAlDiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgInitUserRegistration::CheckUserRegistration ()
{
	if (m_wstrCode1.GetLength() != 4) return FALSE;
	for (int iC = 0; iC < m_wstrCode1.GetLength(); iC++)
		if (iswxdigit(m_wstrCode1.GetAt(iC)) == 0) return FALSE;
	const WORD wCheckCode = wcstoul(m_wstrCode1, NULL, 16);
	GUID guid = GUID_NULL;
	if (!FFStringToGuid(guid, m_wstrCode2, m_wstrCode3, m_wstrCode4, m_wstrCode5, m_wstrCode6)) return FALSE;
	// NULL_xZkqqHx_iCmM_xHqqkZx_GUID_xZkqqHx_iCpAjDpMjHmNiClFiCmEiCoAiDfPiDiBiBeC_xHqqkZx_
	if (guid == GUID_NULL) return FALSE;
	return (FFGetGuidCheckCode(guid) == wCheckCode);
} // CFCDlgInitUserRegistration::CheckUserRegistration.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::UpdateVariables
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCpAiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::UpdateVariables ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
	UpdateData(TRUE);
	if (GetDlgItem(IDC_IUR_EDT_USER_ID1)->IsWindowEnabled())
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID1, m_wstrCode1);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID2, m_wstrCode2);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID3, m_wstrCode3);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID4, m_wstrCode4);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID5, m_wstrCode5);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_ID6, m_wstrCode6);
		FFGetDlgItemText(this, IDC_IUR_EDT_USER_NAME, m_wstrUserName);
		m_wstrUserName.TrimLeft();
		m_wstrUserName.TrimRight();
		// _xZkqqHx_iDfOiDhFiCpAiLpDjEjCiCmJiBeC_xHqqkZx_
		m_wstrUserName.Replace(L'\t', L' ');
		// _xZkqqHx_jFkBjAjEiCmMjIeBjBlBiClFiClNiLpDjEjCiCpAiNoNiPjMiBeC_xHqqkZx_
		while (m_wstrUserName.Replace(L"  ", L" "));
	}
} // CFCDlgInitUserRegistration::UpdateVariables.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAiBeBjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::UpdateControls ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(FALSE);
	if (m_bNotUseUserId)
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID1, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID2, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID3, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID4, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID5, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID6, L"");
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_NAME, L"");
	} else
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID1, m_wstrCode1);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID2, m_wstrCode2);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID3, m_wstrCode3);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID4, m_wstrCode4);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID5, m_wstrCode5);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_ID6, m_wstrCode6);
		FFSetDlgItemText(this, IDC_IUR_EDT_USER_NAME, m_wstrUserName);
	}
} // CFCDlgInitUserRegistration::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFjBkOjAkLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiBeBjHeMiMpIiPpDjBnEjFmPjAjEiCpAiNfIjAfGiClFiClNiMoD_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::UpdateActivate ()
{
	GetDlgItem(IDC_IUR_EDT_USER_ID1)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_ID2)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_ID3)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_ID4)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_ID5)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_ID6)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_EDT_USER_NAME)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_BTN_NEW_USER_ID)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_BTN_SAVE_NAME_ID)->EnableWindow(!m_bNotUseUserId);
	GetDlgItem(IDC_IUR_CHK_INHIBIT_SET_ID)->EnableWindow(!m_bNotUseUserId);
//----- 05.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_bNotUseUserId)
//	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//	} else
//	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----
//	{
//	}
//----- 05.11.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCDlgInitUserRegistration::UpdateActivate.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgInitUserRegistration _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgInitUserRegistration::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFlGiOjKjAjEiCpAjAkHiMmAiBeC_xHqqkZx_
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID1))->SetLimitText(4);
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID2))->SetLimitText(8);
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID3))->SetLimitText(4);
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID4))->SetLimitText(4);
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID5))->SetLimitText(4);
	((CEdit*)GetDlgItem(IDC_IUR_EDT_USER_ID6))->SetLimitText(12);

	//----- _xZkqqHx_iDiGiBfLiDfFjGlMiBeBiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiPiJiKpKiJlL_xHqqkZx_ ------
	m_wstrUserName = g_pReg->GetUserName();
	if (m_wstrUserName.IsEmpty())
	//----- _xZkqqHx_iDiGiBfLiDfFjGlMiCkKiDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiGiBfLiDfFjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
		_TCHAR szName[500];
		DWORD dwNameSz = 500;
		::GetUserName(szName, &dwNameSz);
		m_wstrUserName = TStrToWStr(szName);
	}
	if (g_pReg->GetUserId() != GUID_NULL)
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKiDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_wstrCode1.Format(L"%04X", FFGetGuidCheckCode(g_pReg->GetUserId()));
		FFGuidToString(m_wstrCode2, m_wstrCode3, m_wstrCode4, m_wstrCode5, m_wstrCode6, g_pReg->GetUserId());
	}
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClFiCmIiCkCiBeC_xHqqkZx_
	m_bNotUseUserId = (g_pReg->GetUserId() == GUID_NULL);
	// _xZkqqHx_jFlGiPjBiCmJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClHiCoJiClBiCmGiCpAiLnGiOhOiClHiCoJiCkJiBeI_xHqqkZx_
	m_bInhibitSetId = g_pReg->GetIsInhibitSetId();

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAiBeBjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControls();
//----- 05.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
//----- 05.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	if (!IsKindOf(RUNTIME_CLASS(CPropertyPage)))
		::FFJustifyWindow(m_hWnd);
	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgInitUserRegistration::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::OnOK ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariables();

	if (m_bNotUseUserId)
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiBeC_xHqqkZx_
		g_pReg->SetUserId(GUID_NULL);
		g_pReg->SetUserName(L"");
		g_pReg->SetIsInhibitSetId(TRUE);
	} else
	//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!CheckUserRegistration())
		//----- _xZkqqHx_jGoCjBoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjAlDiClFiCkNiCkAiCoIiCnMiClJiCpBiBeC_xHqqkZx_
			FFErrorBox(IDS_ERR_MSG_USER_ID_ILLEGAL);
			return;
		}
		if (m_wstrUserName.IsEmpty())
		//----- _xZkqqHx_iDiGiBfLiDfFjGlMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiGiBfLiDfFjGlMiCkKjAlDiClFiCkNiCkAiCoIiCnMiClJiCpBiBeC_xHqqkZx_
			FFErrorBox(IDS_ERR_MSG_USER_NAME_ILLEGAL);
			return;
		}

		//----- _xZkqqHx_jGoCjBoIiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		GUID guid;
		FFStringToGuid(guid, m_wstrCode2, m_wstrCode3, m_wstrCode4, m_wstrCode5, m_wstrCode6);
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiBeC_xHqqkZx_
		g_pReg->SetUserId(guid);
		g_pReg->SetUserName(m_wstrUserName);
		g_pReg->SetIsInhibitSetId(m_bInhibitSetId);
	}
//----- 04.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJiDiNiDePiDeDiDjDiPoOjFpBiCpAjDgPjIfOiBeC_xHqqkZx_
// 06.01.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	g_pFileServer->SetLoginUserIdAndName(g_pReg->GetUserId(), g_pReg->GetUserName());
	g_pFileServer->SetLoginUserName(FFGetApp()->GetUserName());
//----- 04.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCDlgInitUserRegistration::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::OnIurBtnNewUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDgIjAlGjAkMiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::OnIurBtnNewUserId ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariables();
	GUID guid = GUID_NULL;
	::CoCreateGuid(&guid);
	if (guid == GUID_NULL)
	{
		ASSERT(FALSE);
	}
	m_wstrCode1.Format(L"%04X", FFGetGuidCheckCode(guid));
	FFGuidToString(m_wstrCode2, m_wstrCode3, m_wstrCode4, m_wstrCode5, m_wstrCode6, guid);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAiBeBjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControls();
} // CFCDlgInitUserRegistration::OnIurBtnNewUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::OnIurBtnSaveNameId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmJjFnLjBlGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::OnIurBtnSaveNameId ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariables();
	if (!CheckUserRegistration())
	//----- _xZkqqHx_jGoCjBoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjAlDiClFiCkNiCkAiCoIiCnMiClJiCpBiBeC_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_USER_ID_ILLEGAL);
		return;
	}
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
//----- 05.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CFCFldgBase dlgFile(FALSE, NULL, _T("Untitled.txt"),
//						OFN_HIDEREADONLY|OFN_NOCHANGEDIR,
//						_T("Text file (*.txt)|*.txt||"));
//----- 05.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCFileDialogBase dlgFile(FALSE, NULL, L"Untitled.txt",
							OFN_HIDEREADONLY|OFN_NOCHANGEDIR,
							L"Text file (*.txt)|*.txt||");
//----- 05.10.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhHiDiLiDhGiDhLiDfOiDjDiCpAiPmBiLiOiBeC_xHqqkZx_
	dlgFile.m_ofn.Flags &= ~OFN_SHOWHELP;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	if (dlgFile.DoModal() == IDCANCEL) return;
	WString wstrText = FormatResString(	IDS_USER_REGISTRATION_TEXT,
										m_wstrCode2.c_str(),
										m_wstrCode3.c_str(),
										m_wstrCode4.c_str(),
										m_wstrCode5.c_str(),
										m_wstrCode6.c_str(),
										m_wstrCode1.c_str(),
										m_wstrUserName.c_str());
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDhEiDeAiDeDiDiLiCmJiDgGiBfLiDfOiCpAiIoKiKiHiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	if (!FFSaveTextFile(WStrToAStr(wstrText), dlgFile.GetPathName()))
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMjFnLjBlGiCmJiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_FAIL_SAVE_FILE,
					(const wchar_t*)dlgFile.GetPathName());
	}
} // CFCDlgInitUserRegistration::OnIurBtnSaveNameId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgInitUserRegistration::OnIurChkNotUseUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiBhFiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjHjIjHhAiClFiCmIiCkCiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgInitUserRegistration::OnIurChkNotUseUserId ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAiBeBjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgInitUserRegistration::OnIurChkNotUseUserId.
