// DlgRepairDoc.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilStdLib.h"		// For m1_for.
#include "UtilMisc.h"		// For FFVersionInfo().
#include "UtilStr.h"		// For GetResString.
#include "UtilWin.h"		// For ExecMolipDraw.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilRepair.h"		// For DeleteRepairFileStack.etc.
#include "UtilDlg.h"		// For FFJustifyWindow.
#include "UtilFile.h"		// For SplitFileName.
#include "DynamicDb.h"		// For g_pFileServer.
#include "DlgRepairDoc.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FD_FORCE_KILL_TIME 10
#define FD_RECOM_KILL_TIME 50
//#define FD_FORCE_KILL_TIME 1000
//#define FD_RECOM_KILL_TIME 5000

/////////////////////////////////////////////////////////////////////////////
// CFCDlgRepairDoc _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::CFCDlgRepairDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgRepairDoc::CFCDlgRepairDoc (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgRepairDoc::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgRepairDoc)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
} // CFCDlgRepairDoc::CFCDlgRepairDoc.

void CFCDlgRepairDoc::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgRepairDoc)
	DDX_Control(pDX, IDC_RPD_EDT_REPAIR_STAT, m_edtRepairStat);
	//}}AFX_DATA_MAP
} // CFCDlgRepairDoc::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCDlgRepairDoc, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgRepairDoc)
	ON_BN_CLICKED(IDC_RPD_BTN_STOP, OnRpdBtnStop)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_MOLIPDRAW_QUIT, OnUserMolipdrawQuit)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgRepairDoc _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFjBkOjAkLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiBeBjHeMiMpIiPpDjBnEjFmPjAjEiCpAiNfIjAfGiClFiClNiMoD_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::UpdateActivate ()
{
	GetDlgItem(IDC_RPD_BTN_STOP)->EnableWindow(m_hwndDraw != NULL && !m_bStopping);
	GetDlgItem(IDCANCEL)->EnableWindow(m_hwndDraw == NULL);
} // CFCDlgRepairDoc::UpdateActivate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::SetExecParam
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	exe_xZkqqHx_iOmAiNhDjHhAiCmMiDhAiDiJiDiBiBfLiDfOjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpParam	:_xZkqqHx_iDhAiDiJiDiBiBfLiDfOjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::SetExecParam (const wchar_t* tcpParam)
{
	m_strExecParam = tcpParam;
} // CFCDlgRepairDoc::SetExecParam.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::DeleteUnusedWork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDiPiBfLiDeOiDhEiDeAiDeDiDiLiBgJiDgGiDeCiDiMiDeOiDgHiDiKiBgKiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wAppMode	:_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiOmAiNhDiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.05.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void CFCDlgRepairDoc::DeleteUnusedWork ()
void CFCDlgRepairDoc::DeleteUnusedWork (WORD wAppMode)
{
	// _xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeCiNmFiMoDiCmJ_xHqqkZx_'\'_xZkqqHx_iCmNjFhEiCkCiCmEiCkCiCmIiCkCiCmNiClIiBeC_xHqqkZx_
	WString wstrTmpDir = FFGetTmpDirectory();
	WStringVector vDirName;		// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiIoKjHjHiBeC_xHqqkZx_
	WStringVector vFileName;	// wcpDirPath_xZkqqHx_jClMiJlKiCmMiDhEiDeAiDeDiDiLjGlMiIoKjHjHiBeC_xHqqkZx_
	// wstrTmpDir_xZkqqHx_jClMiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmGiDhEiDeAiDeDiDiLiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
	FFEnumDirectoryFile(vDirName, vFileName, wstrTmpDir + L"\\*");

	//----- _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhBiBfLiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjM_xHqqkZx_ -----
	mdef_const_iterator(WStringVector, iStr);
	m1_for (iStr, vDirName)
	{
		if (iStr->CompareTail(FD_FILE_EXT_HEAP) == 0)
		//----- _xZkqqHx_iDhBiBfLiDhGjHhAiDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			WString wstrPath = wstrTmpDir + L'\\' + *iStr;
			HANDLE hFile;
			if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
			//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
			{
				// _xZkqqHx_iDhBiBfLiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjEpBiLkEjHeMiCmFiKeKiCkCiCmEiCnNiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iOgHjHhAjCiGiCmMiDhBiBfLiDhGiCmNiLkEjHeMiCmFiKeKiCkCiCmEiCkCiCoJiCmMiCmFiBeBiKeKiCkPiCmIiCkCiCmNiClIiBeC_xHqqkZx_
				hFile = ::CreateFile(	WStrToTStr(wstrPath),
										FILE_LIST_DIRECTORY,			// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
										0,								// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
										NULL,							// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
										OPEN_EXISTING,					// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
										FILE_FLAG_BACKUP_SEMANTICS,		// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
										NULL);							// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
			} else
			//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// 95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmFiCmNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jBoDiCoNiCoIiCmJ_xHqqkZx_ .lock _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiCmEjEpBiLkEjHeMiCmFiKeKiCkNiBeC_xHqqkZx_
				hFile = ::CreateFile(	WStrToTStr(wstrPath + L"\\.lock"),
										GENERIC_READ|GENERIC_WRITE,				// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
										0,										// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
										NULL,									// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
										OPEN_ALWAYS,							// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
										FILE_ATTRIBUTE_NORMAL,					// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
										NULL);									// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
			}
			if (hFile != INVALID_HANDLE_VALUE)
			//----- _xZkqqHx_iKeKiCkPiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFmCiClGiCoJiBeC_xHqqkZx_
				CloseHandle(hFile);
				// _xZkqqHx_iDhBiBfLiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
				FFRecursiveRemoveDirectory(wstrPath);
			}
		}
	}

//----- 06.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (wAppMode == FD_APPMODE_DYNAMICDRAW)
	//----- Dynamic Draw_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkC_xHqqkZx_DynamicDraw_xZkqqHx_iDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjM_xHqqkZx_ -----
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiBeBiPeDjFjMiCkKjFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmMiIoKjHjHiCpA_xHqqkZx_PID_xZkqqHx_iCmGiClFiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		DWORDSet setdwPid;
		::GetRepairDocPid(setdwPid);
		// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_Undo_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
		WStringSet stRegisteredUndo;
		for (DWORDSet::iterator iPid = setdwPid.begin(); iPid != setdwPid.end(); iPid++)
		//----- _xZkqqHx_iOkJjDkOiPeDjFjMiCkKjFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_PID -----
		{
			// _xZkqqHx_iDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
			WString wstrUndoDir;
			::LoadRepairDocName(&WString(), &WString(), &wstrUndoDir, *iPid);
			stRegisteredUndo.insert(wstrUndoDir);
		}

		m1_for (iStr, vDirName)
		{
			if (iStr->CompareTail(FD_FILE_EXT_UNDO_WORK) == 0)
			//----- DynamicDraw_xZkqqHx_iDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				WString wstrPath = wstrTmpDir + L'\\' + *iStr;
				// _xZkqqHx_iPeDjFjMiDiKiDfIiDgHiCmJjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiDgGiDeCiDiMiDeOiDgHiDiKiCmFiCkAiCoKiCmOiNoNiPjMiBeC_xHqqkZx_
				if (stRegisteredUndo.find(wstrPath) == stRegisteredUndo.end())
					g_pFileServer->DeleteTopGroup(HString(wstrPath));
			}
		}
// 06.05.30 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	}

	//----- FCWorkFile_xZkqqHx_iCmMiDiPiBfLiDeOiDhEiDeAiDeDiDiL_xHqqkZx_(_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiBfLiCmFjHjIjHhA_xHqqkZx_)_xZkqqHx_iCpAiNoNiPjM_xHqqkZx_ -----
	m1_for (iStr, vFileName)
	{
		if (iStr->CompareTail(L".tmp") == 0)
		//----- FCWorkFile_xZkqqHx_iCmMiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCmGiCoIiCkAiCkGiClIiNoNiPjMiClFiCmEiCnNiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmFiCkAiCoKiCmOiNoNiPjMiCmFiCkLiCmIiCkCiCmNiClIiBeC_xHqqkZx_
			FFDeleteFile(wstrTmpDir + L'\\' + *iStr);
		}
	}
} // CFCDlgRepairDoc::DeleteUnusedWork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::CheckRepairMolipDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiCkKjFeLjHhGiCmI_xHqqkZx_MolipDraw_xZkqqHx_jFlGiPjBiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPeDjFjMiClFiCmIiCkCjFlGiPjBiCmMiPeDjFjMiPoOjFpBjDjJiCmMiNoNiPjMiPiIjHjNiCoAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::CheckRepairMolipDoc ()
{
	// _xZkqqHx_iPeDjFjMiCkKjFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmMiIoKjHjHiCpA_xHqqkZx_PID_xZkqqHx_iCmGiClFiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	DWORDSet setdwPid;
	::GetRepairDocPid(setdwPid);
	for (DWORDSet::iterator iPid = setdwPid.begin(); iPid != setdwPid.end(); iPid++)
	//----- _xZkqqHx_iOkJjDkOiPeDjFjMiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
	{
		WString strDocFile;
		WString strOrigFile;
		WString wstrUndoDir;
		// _xZkqqHx_jFlGiPjBjGlMjDjJiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		::LoadRepairDocName(&strDocFile, &strOrigFile, &wstrUndoDir, *iPid);
		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjFlGiPjBjGlMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		WString strDefName = strDocFile;
		if (strDocFile.IsEmpty())
			strDefName = FFGetApp()->GetDocString(CDocTemplate::docName);
		// IDS_ERR_MSG_IS_REPAIR_DOC = "_xZkqqHx_jFlGiPjBiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeCiPeDjFjMiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		WString strMsg = FormatResString(IDS_ERR_MSG_IS_REPAIR_DOC, strDefName.c_str());

		if (FFMessageBox(strMsg, NULL, MB_YESNOCANCEL) == IDYES)
		//----- _xZkqqHx_iPeDjFjMiCpAiOiOiCnNiCoJiPoKiNiH_xHqqkZx_ -----
		{
			::DeleteRepairFileStack();
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
			::DeleteRepairFilePtr();
			::PushRepairFileStack(wstrUndoDir);
			::PushRepairFileStack(strOrigFile);
			::PushRepairFileStack(strDocFile);

			CFCDlgRepairDoc dlg;
			dlg.SetExecParam(L"-repair");
			dlg.DoModal();
			if (dlg.m_iErrorCode == CFCDlgRepairDoc::ERR_NONE)
			//----- _xZkqqHx_iPeDjFjMiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//				// _xZkqqHx_iDfCiDhDiBfLiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//				if (!strOrigFile.IsEmpty()) (void)::FFDeleteFile(strOrigFile);
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
				// Undo_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_(_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_)_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
				g_pFileServer->DeleteTopGroup(HString(wstrUndoDir));
				// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPeDjFjMiPoOjFpBiJpAiPjMiBeC_xHqqkZx_
				::DeleteRepairDocName(*iPid);
			}
		} else
		//----- _xZkqqHx_iPeDjFjMiCpAiOiOiCnNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_IS_ERASE_REPAIR_INFO_DOC = "_xZkqqHx_jFlGiPjBiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiPeDjFjMiPoOjFpBiCpAiPmBiLiOiClFiCnMiClHiCkJiBeI_xHqqkZx_ _xZkqqHx_iPmBiLiOiClHiCoJiCmGiPeDjFjMiPgPjHiIiCmIiCkNiCmIiCoIiCnMiClH_xHqqkZx_"
			if (FFMessageBox(FormatResString(IDS_ERR_MSG_IS_ERASE_REPAIR_INFO_DOC, strDefName.c_str()),
							NULL, MB_YESNOCANCEL) == IDYES)
			{
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//				// _xZkqqHx_iDfCiDhDiBfLiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
//				if (!strOrigFile.IsEmpty()) (void)::FFDeleteFile(strOrigFile);
//----- 06.02.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
				// Undo_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_(_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_)_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
				g_pFileServer->DeleteTopGroup(HString(wstrUndoDir));
				// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPeDjFjMiPoOjFpBiJpAiPjMiBeC_xHqqkZx_
				::DeleteRepairDocName(*iPid);
			}
		}
	}
} // CFCDlgRepairDoc::CheckRepairMolipDoc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::CheckRepairHistoricDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiCkKjFeLjHhGiCmI_xHqqkZx_HistoricDraw_xZkqqHx_jFlGiPjBiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPeDjFjMiClFiCmIiCkCjFlGiPjBiCmMiPeDjFjMiPoOjFpBjDjJiCmMiNoNiPjMiPiIjHjNiCoAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::CheckRepairHistoricDoc ()
{
	// _xZkqqHx_iPeDjFjMiCkKjFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmMiIoKjHjHiCpA_xHqqkZx_PID_xZkqqHx_iCmGiClFiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	DWORDSet setdwPid;
	::GetRepairDocPid(setdwPid);
	for (DWORDSet::iterator iPid = setdwPid.begin(); iPid != setdwPid.end(); iPid++)
	//----- _xZkqqHx_iOkJjDkOiPeDjFjMiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrProject;
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		::LoadRepairDocName(&wstrProject, NULL, NULL, *iPid);
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiBeBiNmFiMoDiCmM_xHqqkZx_'\'_xZkqqHx_jGlDiClFiCmFiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//		WString wstrProjectDir = FFGetFileDirectory(wstrProject, TRUE);
//----- 06.03.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// IDS_ERR_MSG_IS_REPAIR_PROJECT = "_xZkqqHx_jGkCjFnLjBlGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCkKiCkAiCoIiCnMiClHiBeCiPeDjFjMiClFiCnMiClHiCkJiBeI_xHqqkZx_"
		if (FFMessageBox(IDS_ERR_MSG_IS_REPAIR_PROJECT, 0, MB_YESNOCANCEL) == IDYES)
		{
			// _xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmJiCkAiCoJiPoKiNiHiCmNiBeBiPeDjFjMiDgDiBfLiDiLiCmJiDgGiDfIiDeOiDgHiDgCiDhGiInKjDkOiCpAiOhHiOkGiBeC_xHqqkZx_
			WString wstrTmpDir = FFGetTmpDirectory();
			BOOL bIsMoveToDesktop = (wcsncmp(wstrProject, wstrTmpDir, wstrTmpDir.GetLength()) == 0);
			// _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiDeJiDhGiDfGiDiHiDjDiBeC_xHqqkZx_
			WString wstrToolOption;
			// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiInKjDkOiCmMiPoKiNiHiCmN_xHqqkZx_ "-desktop"_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
			if (bIsMoveToDesktop)
				wstrToolOption += L"-desktop ";
			// _xZkqqHx_iPeDjFjMjBmOiPnLiDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
			wstrToolOption += L'"';
// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			wstrToolOption += FFNormalizePath(wstrProject);
			wstrToolOption += wstrProject;
			wstrToolOption += L'"';
			// _xZkqqHx_iPeDjFjMiDgDiBfLiDiLiCpAiOmAiNhDiBeC_xHqqkZx_
			::ExecAndWaitApp(L"HiDocTool.exe", wstrToolOption, INFINITE);
			// HiDocTool.exe _xZkqqHx_iCmNiBeBiCmGiCoIiCkAiCkGiClIiCnJiCnKiKgNiOmAiCmJiDgGiDfIiDeOiDgHiDgCiDhGiCnG_xHqqkZx_
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiInKjDkOiClHiCoJiClNiCnPiBeBiPeDjFjMjAkMiMpHiBeFiOlIjEhDiCmJiKnGiCoNiCoHiClIiBeB_xHqqkZx_
			// _xZkqqHx_iPeDjFjMiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
			::DeleteRepairDocName(*iPid);
		} else
		{
			// IDS_ERR_MSG_IS_DELETE_REPAIR_PROJECT = "_xZkqqHx_jGkCjFnLjBlGiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClFiCnMiClHiCkJiBeI_xHqqkZx_"
			if (FFMessageBox(IDS_ERR_MSG_IS_DELETE_REPAIR_PROJECT, 0, MB_YESNOCANCEL) == IDYES)
			{
				::DeleteRepairDocName(*iPid);
				// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
				g_pFileServer->DeleteTopGroup(HString(wstrProject));
			}
		}
	}
} // CFCDlgRepairDoc::CheckRepairHistoricDoc.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgRepairDoc _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlKiLeMiDfCiDiBiDjDiDgHiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgRepairDoc::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	//----- _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	m_hwndDraw = NULL;		// Historic Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	m_dwDrawProcId = 0;		// Historic Draw_xZkqqHx_iCmMiDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_bStopping = FALSE;	// _xZkqqHx_jCoCiOhOiPiIjHjNjCiGiBeC_xHqqkZx_
	m_iErrorCode = ERR_NONE;	// _xZkqqHx_iPeJjHlJiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_iStopTimer = -1;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
	m_iKillTimer = -1;		// _xZkqqHx_iDhGiDiNiDfKiDfIiLkNjAkHiPeJjHlJiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_dwRepairPtr = DWORD(-1);	// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	m_fliRepairPtr = flint(-1);	// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_

	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	::DeleteRepairFilePtr();
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
	::DeleteRepairMessage();
//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	FFJustifyWindow(m_hWnd);
//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	PostMessage(WM_USER_MOLIPDRAW_QUIT);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgRepairDoc::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::OnRpdBtnStop
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjCiGiOhOiClHiCoJiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::OnRpdBtnStop ()
{
	if (m_hwndDraw == NULL) return;
	// _xZkqqHx_jCoCiOhOiPiIjHjNjCiGiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_bStopping) return;
	m_bStopping = TRUE;		// _xZkqqHx_jCoCiOhOiPiIjHjNjCiGiCpAjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_iPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeC_xHqqkZx_
	::PostMessage(m_hwndDraw, WM_COMMAND, ID_APP_EXIT, 0);

	m_iStopTimer = -1;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
	m_iKillTimer = 0;		// _xZkqqHx_iDhGiDiNiDfKiDfIiLkNjAkHiPeJjHlJiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_

	// _xZkqqHx_iKgFiDhLiDfOiDjDiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgRepairDoc::OnRpdBtnStop.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::OnUserMolipdrawQuit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMiDiCiBfLiDgIiCmFiLeOjDkOiClFiClN_xHqqkZx_Historic Draw_xZkqqHx_iCkKiPeJjHlJiClFiClNiOjOiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_ExecMolipDraw_xZkqqHx_jCiGiCmM_xHqqkZx_Historic Draw_xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjBjHiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgRepairDoc::OnUserMolipdrawQuit (WPARAM, LPARAM)
{
	m_hwndDraw = NULL;		// Historic Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	m_dwDrawProcId = 0;		// Historic Draw_xZkqqHx_iCmMiDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	KillTimer(1);
	m_iStopTimer = -1;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
	m_iKillTimer = -1;		// _xZkqqHx_iDhGiDiNiDfKiDfIiLkNjAkHiPeJjHlJiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_dwRepairPtr = DWORD(-1);	// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
	m_fliRepairPtr = flint(-1);	// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_

	// _xZkqqHx_iPeDjFjMiDfOiDfIiDeOiCkJiCoHiCmMiDiBiDgCiDfKiBfLiDfHiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	WString strMsg;
	LoadRepairMessage(strMsg);
	if (!strMsg.IsEmpty())
		FFReplaceSel(&m_edtRepairStat, strMsg + L"\r\n");
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
	::DeleteRepairMessage();

	// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DWORD dwRepairPtr = LoadRepairFilePtr();
	flint fliRepairPtr = LoadRepairFilePtr();
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (dwRepairPtr == DWORD(-2))
	if (fliRepairPtr == flint(-2))
	//----- _xZkqqHx_iPeDjFjMiDfOiDfIiDeOiCkJiCoHjCoCiOhOjHhGiLiBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairFileStack();
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairFilePtr();
		// IDS_MSG_FAIL_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCpAiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		FFReplaceSel(&m_edtRepairStat, FFLoadWString(IDS_MSG_FAIL_REPAIR) + L"\r\n");
		m_iErrorCode = ERR_FAIL_REPAIR;	// _xZkqqHx_iPeDjFjMiPiIjHjNiCpAiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_
	} else if (m_bStopping)
	//----- _xZkqqHx_jCoCiOhOiPiIjHjNjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairFileStack();
		// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairFilePtr();
		// IDS_MSG_STOP_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCpAjCiGjCgGiClFiCnMiClFiClN_xHqqkZx_"
		FFReplaceSel(&m_edtRepairStat, FFLoadWString(IDS_MSG_STOP_REPAIR) + L"\r\n");
		m_iErrorCode = ERR_INTERRUPT;	// _xZkqqHx_iPeJjHlJiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	} else
	//----- _xZkqqHx_jCoCiOhOiPiIjHjNjCiGiCmFiCmNjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjPiCmJiPeDjFjMiClHiCoJiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
		WString strFile;
		if (::SeeRepairFileStack(&strFile) == 0)
		{
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
			::DeleteRepairFileStack();
			// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
			::DeleteRepairFilePtr();
			// IDS_MSG_FINISH_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCpAiKkOjHlJiClFiCnMiClFiClN_xHqqkZx_"
			FFReplaceSel(&m_edtRepairStat, FFLoadWString(IDS_MSG_FINISH_REPAIR) + L"\r\n");
			m_iErrorCode = ERR_NONE;	// _xZkqqHx_iPeJjHlJiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
		} else
		{
			DWORD dwThreadId;
			// _xZkqqHx_iPeJjHlJiKmEiOiLjFhEiCkLiCmF_xHqqkZx_ _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCpAiLeOjDkOiBeC_xHqqkZx_
			if (::ExecMolipDraw(m_strExecParam, GetSafeHwnd(), WM_USER_MOLIPDRAW_QUIT,
								&dwThreadId, &m_dwDrawProcId))
			{
				m_hwndDraw = ::GetThreadTopWnd(dwThreadId);
				if (strFile.IsEmpty())
				{
					// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjFlGiPjBjGlMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
					WString strDefName = FFGetApp()->GetDocString(CDocTemplate::docName);
					// IDS_MSG_NOW_REPAIRING = "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCpAiPeDjFjMjCiGiCmFiClH_xHqqkZx_"
					FFReplaceSel(&m_edtRepairStat, FormatResString(IDS_MSG_NOW_REPAIRING,
																strDefName.c_str()) + L"\r\n");
				} else
				{
					// IDS_MSG_NOW_REPAIRING = "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCpAiPeDjFjMjCiGiCmFiClH_xHqqkZx_"
					FFReplaceSel(&m_edtRepairStat, FormatResString(IDS_MSG_NOW_REPAIRING,
																strFile.c_str()) + L"\r\n");
				}

				m_iStopTimer = 0;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
				SetTimer(1, 1000, NULL);
			} else
			{
				// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
				::DeleteRepairFileStack();
				// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
				::DeleteRepairFilePtr();
				// IDS_MSG_FAIL_START_REPAIR = "_xZkqqHx_iPeDjFjMiDgDiBfLiDiLiCmMiLeOjDkOiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
				// IDS_MSG_STOP_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCpAjCiGjCgGiClFiCnMiClFiClN_xHqqkZx_"
				FFReplaceSel(&m_edtRepairStat, FFLoadWString(IDS_MSG_FAIL_START_REPAIR) + L"\r\n");
				FFReplaceSel(&m_edtRepairStat, FFLoadWString(IDS_MSG_STOP_REPAIR) + L"\r\n");
				m_iErrorCode = ERR_FAIL_EXEC;	// _xZkqqHx_iPeJjHlJiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
			} 
		}
	}
	// _xZkqqHx_iKgFiDhLiDfOiDjDiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	return 1;
} // CFCDlgRepairDoc::OnUserMolipdrawQuit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgRepairDoc::OnTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiKiEiCoIiNjOiCnNiCmFiLeOjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgRepairDoc::OnTimer (UINT nIDEvent)
{
	if (0 <= m_iKillTimer)
	{
		if (FD_FORCE_KILL_TIME <= m_iKillTimer++)
		{
			// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgOiDjDiDgIiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
			HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, m_dwDrawProcId);
			TerminateProcess(hProcess, 0);
			CloseHandle(hProcess);
			m_iKillTimer = -1;		// _xZkqqHx_iDhGiDiNiDfKiDfIiLkNjAkHiPeJjHlJiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
		} else
		{
			// IDS_MSG_TIME_UNTIL_KILL_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCmMiLkNjAkHjCoCiOhOiCnMiCmF_xHqqkZx_ %d_xZkqqHx_jFgC_xHqqkZx_"
			FFReplaceSel(&m_edtRepairStat, FormatResString(IDS_MSG_TIME_UNTIL_KILL_REPAIR,
										FD_FORCE_KILL_TIME - m_iKillTimer) + L"\r\n");
		}
	}
	if (0 <= m_iStopTimer)
	{
		// _xZkqqHx_iMlLiNnNiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		DWORD dwRepairPtr = LoadRepairFilePtr();
		flint fliRepairPtr = LoadRepairFilePtr();
		if (m_fliRepairPtr != fliRepairPtr)
		{
			m_fliRepairPtr = fliRepairPtr;
			m_iStopTimer = 0;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
		} else if (FD_RECOM_KILL_TIME <= m_iStopTimer++)
		{
			OnRpdBtnStop();
			m_iStopTimer = -1;		// ID_APP_EXIT_xZkqqHx_jBjHjAeNiCmMiDfOiDeDiDhNiBfLiBeC_xHqqkZx_
		} else
		{
			// IDS_MSG_TIME_UNTIL_STOP_REPAIR = "_xZkqqHx_iPeDjFjMiPiIjHjNiCmMjCoCiOhOjHhGiLiBiCnMiCmF_xHqqkZx_ %d_xZkqqHx_jFgC_xHqqkZx_"
			FFReplaceSel(&m_edtRepairStat, FormatResString(IDS_MSG_TIME_UNTIL_STOP_REPAIR,
										FD_RECOM_KILL_TIME - m_iStopTimer) + L"\r\n");
		}
	}
	BASE_CLASS::OnTimer(nIDEvent);
} // CFCDlgRepairDoc::OnTimer.

