// DynamicDb.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "../DynamicServer/DynamicServer.h"			// For DynamicServer.
#include "DbLock.h"					// For FCDbReadLock.etc.
#include "UtilErr.h"				// For FFThrowMiscUnknown.
#include "UtilFile.h"				// For BYTEVector <<.
#include "UtilVirtualTable.h"		// For CONTROL_TABLE_ID.
#include "UtilMisc.h"				// For FFCreateGuid.
#include "UtilStdLib.h"				// For mdef_iterator.
#include "UtilStr.h"				// For StrNewCpy.
#include "UtilDlg.h"				// For RightByLeftHand.
#include "VirtualTableManager.h"	// For FCVirtualTableManager.
#include "VirtualTable.h"			// For FCVirtualTable.
#include "TopGroupRec.h"			// For FCTopGroupRec.
#include "RegData.h"				// For g_pReg.
// 06.04.20 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "DbFileDialog.h"			// For FD_DBFD_OK_BUTTON_ID.
#include "DynamicDb.h"				// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FD_CACHE_SIZE_MAX	100000

static FCDynamicDb s_dynamicDb;
FCDynamicDb* g_pFileServer = &s_dynamicDb;

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDePiDiNiBfLiDgPiDiLiKnGjAjEiBeC_xHqqkZx_

DynamicServer* g_pDbServer = NULL;

static void myErrorThrowCallback (DWORD dwId, const wchar_t* wcpMessage)
{
	FFThrowMiscUserException(dwId, wcpMessage);
} // myErrorThrowCallback.

void FFStartDbServer ()
{
	g_pDbServer = DynamicServerCreate(myErrorThrowCallback);
} // FFStartDbServer ().

void FFSetDbServerHwnd (HWND hWnd)
{
	DynamicServerSetWnd(hWnd, WM_USER_UNLOCK_REQUEST);
} // FFStartDbServer ().

void FFStopDbServer ()
{
	DynamicServerDelete(g_pDbServer);
	g_pDbServer = NULL;
} // FFStopDbServer ().

/////////////////////////////////////////////////////////////////////////////
// FCLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLockRec::FCLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmMiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLockRec::FCLockRec ()
		:	m_lReadLockCounter(0),
			m_lWriteLockCounter(0),
			m_guidTable(GUID_NULL),
			m_dwDeleteIdentifier(0),
			m_dwAppendIdentifier(0)
{
} // FCLockRec::FCLockRec ().

/////////////////////////////////////////////////////////////////////////////
// FCDynamicDb

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::FCDynamicDb
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDynamicDb::FCDynamicDb ()
{
	// Read_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGjHhAiNmFiLnPiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_lRecentReadLockForCache = 0;
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiCmMiNmFiPiJiCmMiPeDjAlDiCmMiOjOiKnEiBeC_xHqqkZx_
	m_fliFirstModifiedFdtime = -1;
	// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_dwErrorCode = 0;
} // FCDynamicDb::FCDynamicDb.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::~FCDynamicDb
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDynamicDb::~FCDynamicDb ()
{
} // FCDynamicDb::~FCDynamicDb.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CreateTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock		:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiKmHjHjNiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			writeLock		:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiKmHjHjNiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDeJiDhFiDfHiDeGiDeOiDgHiBeCiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FCDbGroup::GetIsInvalid()_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbGroup FCDynamicDb::CreateTopGroup (	FCDbReadLock& readLock,
										FCDbWriteLock& writeLock,
										const HString& hstrTopDirPath)
{
	writeLock.SetTable(FCTableName(hstrTopDirPath, &CONTROL_TABLE_ID, 1));
	readLock.SetTable(FCTableName(hstrTopDirPath, &CONTROL_TABLE_ID, 1));
	BOOL bIsLocked = FALSE;
	// CreateLock_xZkqqHx_iCmNiBeBiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCnMiCmFiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCoAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmMiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiHiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmN_xHqqkZx_
	// _xZkqqHx_iOkJjDkOjDeJiCmJiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (writeLock.CreateLock())
	//----- _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeB_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (readLock.TryLock())
		//----- READ_xZkqqHx_iDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			bIsLocked = TRUE;
		}
	}
	if (bIsLocked)
	//----- _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiNoMjAkMiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiCpAiNoMjAlLiBeC_xHqqkZx_
		FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(hstrTopDirPath);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiDiNiDgCiDeOiCmJiCoGiCmBiCmEiNoMjAkMiNmPiCnNiCmMiCmNiClIiBeC_xHqqkZx_
		// _xZkqqHx_iDePiDiLiBfLiDhGiNoMjAkMiCmMjFeLjHhGiCmNiCmIiCkNiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCmMiCnNiNoMjAkMiClHiCoKiCmOiCoGiCkCiBeC_xHqqkZx_
		CmdCreateTable(FCTableName(hstrTopDirPath, &CONTROL_TABLE_ID, 1));
		return FCDbGroup(FCTableName(hstrTopDirPath));
	} else
	//----- _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiNoMjAkMiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (readLock.IsLocked())
			readLock.Unlock();
		if (writeLock.IsLocked())
			writeLock.Unlock();
		readLock.Clear();
		writeLock.Clear();
		return FCDbGroup();
	}
} // FCDynamicDb::CreateTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCkJiCoHiBeBiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCmNiKgNjEeGiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbGroup FCDynamicDb::GetTopGroup (const HString& hstrTopDirPath)
{
	return FCDbGroup(FCTableName(hstrTopDirPath));
} // FCDynamicDb::GetTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::FlushAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jChOjAmPiClDiCoKiCmEiCkCiCoJiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfEiBfLiDgPiBfLiCmJiCmNiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAjDgOiClFiCmEiOmAiNhDiCpAiOhHiOkGiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmFiCmNiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMiOmAiNhDiMiLiJmKiCpAiJlMjBhKiDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_jElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bMultiUserAccessable:_xZkqqHx_jFkBjAjEiDiGiBfLiDfFiBfLiCkKiDhEiDeAiDeDiDiLiCmJjDkPiOjOiCmJiDeBiDeOiDfKiDfI_xHqqkZx_
 *								 _xZkqqHx_iClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bReturnImmediate	:_xZkqqHx_jBkGiOjOiCmJjFjMiLeBiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 TRUE_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeBiDfEiBfLiDgPiBfLiCmFiCmM_xHqqkZx_
 *								 _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiPiIjHjNiCmNjFmKiDfIiDiMiDgCiDgIiCmF_xHqqkZx_
 *								 _xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmKiDfIiDiMiDgCiDgIiCmFiOmAiNhDiClHiCoJiPoKiNiHiBeBiPiIjHjNjCiGiCkJiCmHiCkEiCkJiCmN_xHqqkZx_IsFlushing_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPiIjHjNiMiLiJmKiCmNiBeB_xHqqkZx_GetFlushErrorCode_xZkqqHx_iKnGjAjEiCmFiOoGjDlOiCmFiCkLiCoJiBeC_xHqqkZx_
 *			bMultiUserAccessable = TRUE _xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiDiNiDgCiDeOiCmM_xHqqkZx_
 *			_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_EXCLUSIVE_xZkqqHx_iCmFiDiNiDgCiDeOiClFiCmEjBlMiDiGiBfLiDfFiBfLiCmMiDeBiDeOiDfKiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_jAkHiMmAiClFiCmEiCkJiCoHiBeBiDgFiBfLiDhFiDiLiCmMiPjBiCkLiNjOiCnNiCpAiNhDiCkEiBeCiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCpAjEkNiNhDiClHiCoJiBeCiCnMiClNiBeBiDgFiBfLiDhFiDiLiCmMiPjBiCkLiNjOiCnNjBePiCmJiJpBjFjMiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiNoMjAkMiClFiBeBiPjBiCkLiNjOiCnNjCiGiCmJjCiGjCgGiClFiCmEiCoAiMlDiCmMiPpDjBnEiCmJiJpBjFjMiCmFiCkLiCoJiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::FlushAll (BOOL bMultiUserAccessable, BOOL bReturnImmediate)
{
//----- 06.02.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDiJiBfLiPoOjFpBiCpAiDeOiDiKiDeBiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	ResetError();
//----- 06.02.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	vector<wchar_t*> vTopDirPath;		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiDgGiDeCiDiMiDeOiDgHiDiKjEhKjHpBiBeC_xHqqkZx_
	vector<const BYTE*> vTransaction;	// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiClCiCmGiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCmMjEhKjHpBiBeC_xHqqkZx_
	vector<size_t> vTransactionSize;	// vTransaction_xZkqqHx_iCmMiDgGiBfLiDfOiDfEiDeDiDfJjEhKjHpBiBeC_xHqqkZx_
	mdef_iterator(HStrToTopGroupRec, iTop);
	m1_for (iTop, m_mpTopDirToTopGroupRec)
	//----- _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		FCTopGroupRec* pTopGroupRec = iTop->second.get();
		if (!pTopGroupRec->m_vTransaction.empty())
		//----- _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmGiClFiCmEjFmPjAjEiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
			vTopDirPath.push_back(StrNewCpy(WString(iTop->first)));
			vTransaction.push_back(&pTopGroupRec->m_vTransaction[0]);
			vTransactionSize.push_back(pTopGroupRec->m_vTransaction.size());
		}
	}
	if (!vTopDirPath.empty())
	//----- _xZkqqHx_iCfAiCmCiCmFiCoAiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfEiBfLiDgPiBfLiCmJiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAjBjHjFhEiBeC_xHqqkZx_
		// _xZkqqHx_iDfEiBfLiDgPiBfLiCmNiBeBiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
		ASSERT(!IsFlushing());
		g_pDbServer->SendTransaction(	bMultiUserAccessable,
										bReturnImmediate,
										(const wchar_t**)&vTopDirPath[0],
										&vTransaction[0],
										&vTransactionSize[0],
										vTopDirPath.size());
	}

	mdef_iterator(vector<wchar_t*>, iStr);
	m1_for (iStr, vTopDirPath)
	//----- _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiPiIjHjNiClHiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		FCTopGroupRec* pTopGroupRec = GetTopGroupRec(HString(*iStr));
		// StrNewCpy_xZkqqHx_iCmFiKgNjFnLiClFiClNiDiBiDiCiDiKiBfLiCpAiJpAjFpKiBeC_xHqqkZx_
		delete[] *iStr;
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAiJpAjFpKiBeC_xHqqkZx_
		pTopGroupRec->m_vTransaction.clear();
		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiJlKiCmMjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjBiAiNoMiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		// FCVirtualWriteTable::m_recordOperation _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		pTopGroupRec->CalcRecordOperationGroup(pTopGroupRec->m_pGroupRecTop);
		// m_recordOperation_xZkqqHx_iCmJiKoOiCmDiCkCiCmEjFmPiNfIiCmMiCkAiCmBiClNiDgFiBfLiDhFiDiLiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
		vector<FCTableName> vDeletedTableName;	// _xZkqqHx_iNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		vector<FCTableName> vModifiedTableName;	// _xZkqqHx_iNoMjAkMiBeFiPeDjAlDiClDiCoKiClNiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		pTopGroupRec->GetModifiedTable(	vDeletedTableName,
										vModifiedTableName,
										pTopGroupRec->m_pGroupRecTop,
										FCTableIds());
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiPoOjFpBiCmMiNfIjAfGiBeCiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiCoA_xHqqkZx_
		// _xZkqqHx_jDkPjHgMiCmMiPiIjHjNiCkKiNhDiCoNiCoKiCmEiCkCiCoJiCmMiCmFiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmM_xHqqkZx_
		// _xZkqqHx_iNoNiPjMiBeFjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjDkPiClGjCgMiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		pTopGroupRec->UpdateGroupLockIdentifier(pTopGroupRec->m_pGroupRecTop, FCTableIds());

		vector<FCTableName>::iterator iTn;
		for (iTn = vDeletedTableName.begin(); iTn != vDeletedTableName.end(); iTn++)
		//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
			// _xZkqqHx_iDfEiBfLiDgPiDfEiDeDiDgIiCmFiCoAjDkPjHgMiCmMiPiIjHjNiCkKiCmIiClDiCoKiCoJiBeC_xHqqkZx_
			DeleteClientLock(*iTn);
		}
		// WRITE_xZkqqHx_iDiMiDfCiBfLiDgIiDeMiDiDiDgCiDfGiDiFiCpA_xHqqkZx_READ_xZkqqHx_iDiMiDfCiBfLiDgIiDeMiDiDiDgCiDfGiDiFiCnGiInKjDkOiBeC_xHqqkZx_
		// _xZkqqHx_iNoNiPjMiDhEiDiJiDePiCkKjHkHiCmBiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCmNjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCnMiClNiBeBiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiDfCiDhNiDjDiDgIiBgJ_xHqqkZx_CMD_COPY_RECORD_xZkqqHx_iCmIiCmHiBgKiCpA_xHqqkZx_
		// _xZkqqHx_iPiIjHjNiClFiClNiDgFiBfLiDhFiDiLiCmNiDeMiDiDiDgCiDfGiDiFiCkJiCoHiNoNiPjMiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		pTopGroupRec->MoveWriteRecordToReal(pTopGroupRec->m_pGroupRecTop);
	}
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiNmFiPiJiCmMiNfIjAfGiCmMiOjOiKnEiBeC_xHqqkZx_
	m_fliFirstModifiedFdtime = -1;
} // FCDynamicDb::FlushAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::IsFlushing
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFjFmKiDfIiDiMiDgCiDgIiCmFiPjBiCkLiNjOiCnNiPiIjHjNiCpAiClFiCmEiCkCiCoJiPoKiNiHiCpA_xHqqkZx_
 *			_xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmGiCkCiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOjBiAiNoMiCoCjDmHiCnNiPgPiClFjBiAiNoMiCmIiCmHiBeBiDfEiBfLiDgPiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jBmOiClFiCmEiPiIjHjNiCpAiOmAiNhDiClDiClJiCoJiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::IsFlushing () const
{
	return g_pDbServer->IsFlushing();
} // FCDynamicDb::IsFlushing.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::OnUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiJpAjFpKjHhGiLiBiCmMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiJpAjFpKjHhGiLiBiCpAiOpDiCkPiClNiCmGiCkLiCmJiBeBiClBiCmMiKnGjAjEiCpAiOmAiNhDiClFiCmEiJpAjFpKiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiDgFiBfLiDhFiDiLiBgJiJpAjFpKjHhGiLiBiCmNiDePiDiLiBfLiDhGjCfAiImKiCmIiCmMiCmF_xHqqkZx_
 *			_xZkqqHx_jHhGiLiBiCpAiOpDiCkPiCmEiCkCiCmIiCkNiCmEiCoAjDkPiClGiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDgFiBfLiDhFiDiLiCmNjBfDiCmE_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiOpDiCkPiCmEiCkCiCoJiCmGiCnNiCmIiClHiBgKiCpA_xHqqkZx_READ_xZkqqHx_iDeMiBfLiDhGiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDeMiBfLiDhGiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::OnUnlockRequest ()
{
	// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKjBlGiNnNiClFiBeBjHhGiLiBiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiDeMiBfLiDhGiCkKjBlGiNnNiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiCmNiBeBiClLiCmMiDeMiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	UnkeepIfUnlockRequest();
} // FCDynamicDb::OnUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CheckTopGroupPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCkKjAlDiPoNiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::CheckTopGroupPath (const wchar_t* wcpTopDirPath) const
{
	// _xZkqqHx_iDfEiBfLiDgPiBfLiCmJiDhAiDfIiCpAjClCiCnHiClDiClJiCoJiBeC_xHqqkZx_
	DsErr dsErrCode = g_pDbServer->CheckTopGroupPath(wcpTopDirPath);
	// _xZkqqHx_iDfEiBfLiDgPiBfLiDeHiDiJiBfLiDfCiBfLiDgIiCpAiDeOiDiJiDeDiDeBiDjDiDgHiDeHiDiJiBfLiDfCiBfLiDgIiCmJjFmPiKlHiBeC_xHqqkZx_
	return DsErrToErrorCode(dsErrCode);
} // FCDynamicDb::CheckTopGroupPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::DeleteTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiImIiJlKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iNoNiPjMiClHiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::DeleteTopGroup (const HString& hstrTopDirPath)
{
	FCTopGroupRec* pTopGroupRec = GetTopGroupRec(hstrTopDirPath);
	if (pTopGroupRec != NULL)
	//----- _xZkqqHx_jBmOiJjOiClHiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
		if (!pTopGroupRec->m_vTransaction.empty())
			FFThrowMiscUnknown();
		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
		DeleteTopGroupRec(hstrTopDirPath);
	}
	// Read_xZkqqHx_iDiNiDgCiDeOiDeMiDiDiDgCiDfGiDiFiCkJiCoHjGjFiPmBiClHiCnHiCkLiDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
	TableNameSet stTableName;
	// Read_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	mdef_const_iterator(TableNameToLong, iTnl);
	m1_for (iTnl, m_mpReadLockForCache)
	{
		if (iTnl->first.GetTopDirPath() == hstrTopDirPath)
			stTableName.insert(iTnl->first);
	}
	// Read_xZkqqHx_iDiNiDgCiDeOiDeMiDiDiDgCiDfGiDiFiCpAiJpAiPjMiBeC_xHqqkZx_
	mdef_const_iterator(TableNameSet, iTbn);
	m1_for (iTbn, stTableName)
		UnkeepReadLockForCache(*iTbn);

	// Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCpAjBfDiCmEiOoGjDlOiBeC_xHqqkZx_
	vector<FCTableName> vReadLockTableName;
	GetReadLockedTableName(vReadLockTableName);
	mdef_const_iterator(vector<FCTableName>, iTnv);
	m1_for (iTnv, vReadLockTableName)
	{
		// Read_xZkqqHx_iDiNiDgCiDeOiCmJjDkPiClGiDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKiOgDiCmBiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
		if ((*iTnv).GetTopDirPath() == hstrTopDirPath)
			FFThrowMiscUnknown();
	}
	ASSERT(!IsFlushing());
	DsErr dsErrCode = g_pDbServer->DeleteTopGroup(WString(hstrTopDirPath));
	SetErrorFromServer(dsErrCode, FCTableName(hstrTopDirPath));
	return (dsErrCode == 0);
} // FCDynamicDb::DeleteTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::IsRecoveryRequired
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiImIiJlKiCmJiBeBiPeDjFjMiPoOjFpBiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath		:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiPoOjFpBiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPeDjFjMiPoOjFpBiCkKjBlGiNnNiClHiCoJiCmGiCkCiCkEiClBiCmGiCmNiBeBjBePiJpBiCmMiDeBiDhGiDiKiCmJiCoGiCoJ_xHqqkZx_
 *			_xZkqqHx_iPeDjAlDiCkKjFnLjBlGjDhCjCiGiCmFiPeJjHlJiClFiClNiClBiCmGiCpAiInDjGkBiClHiCoJiBeCiCmCiCnMiCoIiDePiDiLiBfLiDhGiCmN_xHqqkZx_
 *			_xZkqqHx_jEgKjBlJiClFiCmEiCkCiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::IsRecoveryRequired (const HString& hstrTopDirPath) const
{
	return g_pDbServer->IsRecoveryRequired(WString(hstrTopDirPath));
} // FCDynamicDb::IsRecoveryRequired.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::IsTopGroupExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath		:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::IsTopGroupExist (const HString& hstrTopDirPath) const
{
	return g_pDbServer->IsTopGroupExist(WString(hstrTopDirPath));
} // FCDynamicDb::IsTopGroupExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::FlushAll2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDhEiDeAiDeDiDiLiCmMiDiBiDiCiDiKiDgPiDgCiDhEiDeAiCmJjChOjAmPiClDiCoKiClNiDgGiBfLiDfOiCpAiBeBiOmAiDhEiDeAiDeDiDiLiCnG_xHqqkZx_
 *			_xZkqqHx_iPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	GetFlushErrorCode_xZkqqHx_iKnGjAjEiCmG_xHqqkZx_GetFlushErrorMessage_xZkqqHx_iKnGjAjEiCmFiBeBiDeHiDiJiBfL_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCpAiOoGjDlOiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCmNjFmKiDfIiDiMiDgCiDgIiCpAiNoMiCoHiClIiBeBjDkPiClGiDfIiDiMiDgCiDgIiCmFiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiBeBiDiNiDgCiDeOiCmMjAkHiMoEiBeBiJpBjFjMiDhEiDeAiDeDiDiLiNoMjAkMiCoAiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::FlushAll2 ()
{
	FlushAll(FALSE, FALSE);
	if (GetFlushErrorCode() == 0)
	//----- Flush_xZkqqHx_iCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// Write_xZkqqHx_iDiNiDgCiDeOiCmMiDeMiDiDiDgCiDfGiDiFiCpAiJpAiPjMiBeC_xHqqkZx_
		ClearWriteLockForFlush();
		return TRUE;
	} else
	//----- Flush_xZkqqHx_iCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		return FALSE;
	}
} // FCDynamicDb::FlushAll2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ClearTransaction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiPeJjHlJiOjOjDjJiCmJiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::ClearTransaction (const HString& hstrTopDirPath)
{
	HStrToTopGroupRec::const_iterator iTop;
	iTop = m_mpTopDirToTopGroupRec.find(hstrTopDirPath);
	if (iTop != m_mpTopDirToTopGroupRec.end())
	{
		FCTopGroupRec* pTopGroupRec = iTop->second.get();
		pTopGroupRec->m_vTransaction.clear();
	}
} // FCDynamicDb::ClearTransaction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ClearAllTransaction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmJjChOjAmPiClDiCoKiCmEiCkCiCoJiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiPeJjHlJiOjOiCmJiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::ClearAllTransaction ()
{
	mdef_const_iterator(HStrToTopGroupRec, iTop);
	m1_for (iTop, m_mpTopDirToTopGroupRec)
	{
		FCTopGroupRec* pTopGroupRec = iTop->second.get();
		pTopGroupRec->m_vTransaction.clear();
	}
} // FCDynamicDb::ClearAllTransaction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ResetError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::ResetError ()
{
	m_dwErrorCode = 0;
	m_wstrErrorMessage.Empty();
} // FCDynamicDb::ResetError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiOmAiNhDiMiLiJmKiBeCiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiHiCmNiCePiBeB_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ IDS_ERR_XXX _xZkqqHx_iCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::GetErrorCode () const
{
	return m_dwErrorCode;				// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
} // FCDynamicDb::GetErrorCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDynamicDb::GetErrorMessage () const
{
	return m_wstrErrorMessage;			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
} // FCDynamicDb::GetErrorMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetFdtimeFromFirstModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiBeBiNmFiPiJiCmMiPeDjAlDiCkJiCoHiMlLiNnNiCnMiCmFiCmMiMgPiJnPiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMgPiJnPiOjOiKnEiBeCiPeDjAlDiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCDynamicDb::GetFdtimeFromFirstModified () const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiNmFiPiJiCmMiNfIjAfGiCmMiOjOiKnEiBeC_xHqqkZx_
	if (m_fliFirstModifiedFdtime == -1) return -1;
	return FFGetCurrentTime() - m_fliFirstModifiedFdtime;
} // FCDynamicDb::GetFdtimeFromFirstModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::UpdateFirstModifiedFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeCiPeDjAlDiCkKjDpMiCmBiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetFdtimeFromFirstModified_xZkqqHx_iKnGjAjEiCmMiOjOiKnEiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::UpdateFirstModifiedFdtime ()
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiNmFiPiJiCmMiNfIjAfGiCmMiOjOiKnEiBeC_xHqqkZx_
	if (m_fliFirstModifiedFdtime == -1)
		m_fliFirstModifiedFdtime = FFGetCurrentTime();
} // FCDynamicDb::UpdateFirstModifiedFdtime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLastModifiedFdtime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiNfIjAfGiOjOiKnEiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiNfIjAfGiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTIME FCDynamicDb::GetLastModifiedFdtime (const FCTableName& tableName)
{
	return g_pDbServer->GetLastModifiedFdtime(DsTableName(tableName));
} // FCDynamicDb::GetLastModifiedFdtime.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	myDlgCaptionArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCmJjDgOiClHiDfCiDjDiDgHiDiNiBfLiDiLiDeMiDiDiDhGiDfGiDiHiDjDjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct myDlgCaptionArray
{
	~myDlgCaptionArray ()
		{
			mdef_const_iterator(vector<wchar_t*>, iStr);
			m1_for (iStr, vCtrlTextPtr)
				delete[] *iStr;
		}
	void SetId (DWORD dwControlId, DWORD dwStringId)
		{
			WString wstrText = FFLoadWString(dwStringId);
			// _xZkqqHx_iNlGjHjIiCkLjHhAiCmJjFmPiNfIiClHiCoJiPoKiNiHiCmNjFmPiKlHiBeC_xHqqkZx_
			if (g_pReg->GetIsLeftHand())
				RightByLeftHand(wstrText);
			vCtrlId.push_back(dwControlId);
			vCtrlTextPtr.push_back(StrNewCpy(wstrText.c_str()));
		}

	DWORDVector			vCtrlId;
	vector<wchar_t*>	vCtrlTextPtr;
}; // struct myDlgCaptionArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::OnDlgOpenDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAjBeJjBpAiClHiCoJiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrDirPath	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmJiNmFiPiJiCmJjFfMiOkGiClDiCoKiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jBeJjBpAiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
 *			hwndOwner	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeJiBfLiDgJiBfLiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBgJ_xHqqkZx_IDOK/IDCANCEL_xZkqqHx_iBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCoNiClEiCoNiClEiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJiClBiCmMiKnGjAjEiCpAjHhAiInDiClFiClNiCmMiCmNiBeBiCkCiCmCiCkJ_xHqqkZx_
 *			IP_xZkqqHx_iCmFiDfEiBfLiDgPiBeFiDeOiDiJiDeDiDeBiDjDiDgHiDiCiDgGiDiLiCmGiClFiCmEiNfMjChKiClHiCoJiNnLiBeBiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCpAiDfEiBfLiDgPiCkJiCoHiOoGjDlOiClHiCoJiCoGiCkEiCmJiNoMiCoIjFmPiCkGiCoCiClHiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::OnDlgOpenDirectory (	WString& wstrDirPath,
										HWND hwndParent,
										const wchar_t* wcpInitPath) const
{
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DWORDVector vCtrlId;
//	WStringVector vCtrlTextStr;
//	vector<const wchar_t*> vCtrlTextPtr;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiOoNjHnO_xHqqkZx_(&X):
//	vCtrlId.push_back(IDOK);
//	vCtrlTextStr.push_back(FFLoadWString(IDS_CTRL_OK));
//	vCtrlId.push_back(IDCANCEL);
//	vCtrlTextStr.push_back(FFLoadWString(IDS_CTRL_CANCEL));
//	vCtrlId.push_back(IDHELP);
//	vCtrlTextStr.push_back(FFLoadWString(IDS_CTRL_HELP));
//	if (g_pReg->GetIsLeftHand())
//	//----- _xZkqqHx_iNlGjHjIiCkLjHhAiCmJjFmPiNfIiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		long lC;
//		for (lC = 0; lC != vCtrlTextStr.size(); lC++)
//			RightByLeftHand(vCtrlTextStr[lC]);
//	}
//	// _xZkqqHx_iDhMiDeDiDjDiDfOjEhKjHpBiCmJjAnNjCoIiBeC_xHqqkZx_
//	long lC;
//	for (lC = 0; lC != vCtrlTextStr.size(); lC++)
//		vCtrlTextPtr.push_back(vCtrlTextStr[lC]);
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	ASSERT(!IsFlushing());

	myDlgCaptionArray my;
	my.SetId(IDOK, IDS_CTRL_OK);
	my.SetId(IDCANCEL, IDS_CTRL_CANCEL);
	my.SetId(IDHELP, IDS_CTRL_HELP);
//----- 06.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	DsString dsDirPath;
	const DWORD dwReturn = g_pDbServer->OnDlgOpenDirectory(	dsDirPath,
															hwndParent,
															wcpInitPath,
															&my.vCtrlId[0],
															(const wchar_t**)&my.vCtrlTextPtr[0],
															my.vCtrlId.size());
	wstrDirPath = dsDirPath.Get();
	return dwReturn;
} // FCDynamicDb::OnDlgOpenDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::OnDlgSaveTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGjFnLjBlGiCmMiClNiCnPiBeBiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjBeJjBpAiClHiCoJiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrFilePath	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDlgTitle		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFileName		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMjHhAiCmMiDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCmJiPiJiKpKjFfMiOkG_xHqqkZx_
 *							 _xZkqqHx_iClDiCoKiCoJiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFlags			:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDeKiDfIiDfOiDhNiDeDiDfJiClHiCoJiClNiCnPiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilter		:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiDhEiDeCiDiLiDfOiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *							 _xZkqqHx_jFlGiOjKjHpBiCmMjBgHiCnNiNiHiCoNiClJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBgJ_xHqqkZx_IDOK/IDCANCEL_xZkqqHx_iBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCoNiClEiCoNiClEiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJiClBiCmMiKnGjAjEiCpAjHhAiInDiClFiClNiCmMiCmNiBeBiCkCiCmCiCkJ_xHqqkZx_
 *			IP_xZkqqHx_iCmFiDfEiBfLiDgPiBeFiDeOiDiJiDeDiDeBiDjDiDgHiDiCiDgGiDiLiCmGiClFiCmEiNfMjChKiClHiCoJiNnLiBeBiDhEiDeAiDeDiDiLiPoOjFpB_xHqqkZx_
 *			_xZkqqHx_iCpAiDfEiBfLiDgPiCkJiCoHiOoGjDlOiClHiCoJiCoGiCkEiCmJiNoMiCoIjFmPiCkGiCoCiClHiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::OnDlgSaveTopGroup (	WString& wstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpInitPath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt) const
{
	ASSERT(!IsFlushing());

	myDlgCaptionArray my;
	my.SetId(stc2, IDS_CTRL_FILE_KIND);				// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiOoNjHnO_xHqqkZx_(&X):
	my.SetId(stc3, IDS_CTRL_FILE_NAME);				// _xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_(&W):
	my.SetId(IDCANCEL, IDS_CTRL_CANCEL);			// _xZkqqHx_iDeMiDiDiDjDiDfKiDiL_xHqqkZx_(&Q)
	my.SetId(psh15, IDS_CTRL_HELP);					// Help (&1)
// 06.04.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	my.SetId(FD_DBFD_OK_BUTTON_ID, IDS_CTRL_SAVE);	// _xZkqqHx_jFnLjBlG_xHqqkZx_ (&S)
	my.SetId(IDOK, IDS_CTRL_SAVE);					// _xZkqqHx_jFnLjBlG_xHqqkZx_ (&S)
	my.SetId(stc4, IDS_CTRL_FILE_SAVE_DRIVE);		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiPiK_xHqqkZx_(&E):
	DsString dsTopGroupPath;
	const DWORD dwReturn = g_pDbServer->OnDlgSaveTopGroup(	dsTopGroupPath,
															hwndParent,
															wcpDlgTitle,
															wcpInitPath,
															wcpDocumentType,
															wcpExt,
															&my.vCtrlId[0],
															(const wchar_t**)&my.vCtrlTextPtr[0],
															my.vCtrlId.size(),
															TRUE);
	wstrTopGroupPath = dsTopGroupPath.Get();
	return dwReturn;
} // FCDynamicDb::OnDlgSaveTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::OnDlgOpenTopGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjBeJjBpAiClHiCoJiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrFilePath	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpDlgTitle		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClDiCoKiCoJiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFileName		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMjHhAiCmMiDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCmJiPiJiKpKjFfMiOkG_xHqqkZx_
 *							 _xZkqqHx_iClDiCoKiCoJiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFlags			:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDeKiDfIiDfOiDhNiDeDiDfJiClHiCoJiClNiCnPiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilter		:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmBjCoIiClHiCoJiClNiCnPiCmMiDhEiDeCiDiLiDfOiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *							 _xZkqqHx_jFlGiOjKjHpBiCmMjBgHiCnNiNiHiCoNiClJiBeC_xHqqkZx_
 *			wcpMarkFile		:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKiMjPiNpFjBmOiPnLiCmFiCkAiCoJiCkJjClCiCnHiCoJiClNiCnPiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiMiLiJmKiBgJ_xHqqkZx_IDOK/IDCANCEL_xZkqqHx_iBgK_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCoNiClEiCoNiClEiJlMjBhKiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJiClBiCmMiKnGjAjEiCpAjHhAiInDiClFiClNiCmMiCmNiBeBiCkCiCmCiCkJ_xHqqkZx_
 *			IP_xZkqqHx_iCmFiDfEiBfLiDgPiBeFiDeOiDiJiDeDiDeBiDjDiDgHiDiCiDgGiDiLiCmGiClFiCmEiNfMjChKiClHiCoJiNnLiBeBiDhEiDeAiDeDiDiLiPoOjFpB_xHqqkZx_
 *			_xZkqqHx_iCpAiDfEiBfLiDgPiCkJiCoHiOoGjDlOiClHiCoJiCoGiCkEiCmJiNoMiCoIjFmPiCkGiCoCiClHiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::OnDlgOpenTopGroup (	WString& wstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpFilePath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt) const
{
	ASSERT(!IsFlushing());

	myDlgCaptionArray my;
	my.SetId(stc2, IDS_CTRL_FILE_KIND);				// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiOoNjHnO_xHqqkZx_(&X):
	my.SetId(stc3, IDS_CTRL_FILE_NAME);				// _xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_(&W):
	my.SetId(IDCANCEL, IDS_CTRL_CANCEL);			// _xZkqqHx_iDeMiDiDiDjDiDfKiDiL_xHqqkZx_(&Q)
	my.SetId(psh15, IDS_CTRL_HELP);					// Help (&1)
// 06.04.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	my.SetId(FD_DBFD_OK_BUTTON_ID, IDS_CTRL_OPEN);	// _xZkqqHx_iKeKiCkN_xHqqkZx_ (&S)
	my.SetId(IDOK, IDS_CTRL_OPEN);					// _xZkqqHx_iKeKiCkN_xHqqkZx_ (&S)
	my.SetId(stc4, IDS_CTRL_FILE_OPEN_DRIVE);		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiPiK_xHqqkZx_(&E):
	DsString dsFilePath;
	const DWORD dwReturn = g_pDbServer->OnDlgOpenTopGroup(	dsFilePath,
															hwndParent,
															wcpDlgTitle,
															wcpFilePath,
															wcpDocumentType,
															wcpExt,
															&my.vCtrlId[0],
															(const wchar_t**)&my.vCtrlTextPtr[0],
															my.vCtrlId.size(),
															TRUE);
	wstrTopGroupPath = dsFilePath.Get();
	return dwReturn;
} // FCDynamicDb::OnDlgOpenTopGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::SetLoginUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCpAiOgHjHhAiClFiCmEiCkCiCoJiDiGiBfLiDfFiCmMiDiGiBfLiDfFjGlMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpUserName	:_xZkqqHx_iDiGiBfLiDfFjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCmNiBeBjCeOiCkKiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiClFiCmEiCkCiCoJiCmMiCkJiBeBiOkPjFmK_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::SetLoginUserName (const wchar_t* wcpUserName)
{
	g_pDbServer->SetLoginUserName(wcpUserName);
} // FCDynamicDb::SetLoginUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetFlushErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDhEiDiJiDgCiDfGiDiFiCmMiOmAiNhDiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDhEiDiJiDgCiDfGiDiFiCmMiOmAiNhDiMiLiJmKiBeCiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiHiCmNiCePiBeB_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ IDS_ERR_XXX _xZkqqHx_iCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::GetFlushErrorCode () const
{
	return DsErrToErrorCode(g_pDbServer->GetFlushErrorCode());
} // FCDynamicDb::GetFlushErrorCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetFlushErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDhEiDiJiDgCiDfGiDiFiCmMiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDhEiDiJiDgCiDfGiDiFiCmMiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDynamicDb::GetFlushErrorMessage () const
{
	DsString dsErrorMessage;
	g_pDbServer->GetFlushErrorMessage(dsErrorMessage);
	return WString(dsErrorMessage.Get());
} // FCDynamicDb::GetFlushErrorMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::IsThereUnflushed
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmMjCiGiCmJiIoKiCmCiCmFiCoAjGkCiDhEiDiJiDgCiDfGiDiFiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAjGkCiDhEiDiJiDgCiDfGiDiFiCkKiCkAiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::IsThereUnflushed () const
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiNmFiPiJiCmMiNfIjAfGiCmMiOjOiKnEiBeC_xHqqkZx_
	return (m_fliFirstModifiedFdtime != -1);
} // FCDynamicDb::IsThereUnflushed.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::UnkeepIfUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCkKjBlGiNnNiClFiBeBjHhGiLiBiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiDeMiBfLiDhGiCkKjBlGiNnNiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiClLiCmMiDeMiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiDiNiDgCiDeOiDeMiBfLiDhGiCpAiJpAiPjMiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::UnkeepIfUnlockRequest ()
{
	// _xZkqqHx_iCnMiClIiBeBiJpAjFpKjHhGiLiBiCkKiPgPiCmEiCkCiCoJjBfDiCmEiCmMiDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iBkGiJpAjFpKjHhGiLiBiCmNiDePiDiLiBfLiDhGjCfAiImKiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	DsArray<DsTableName> dsGroupNameArray;
	g_pDbServer->GetUnlockRequestGroup(dsGroupNameArray);
	// DsArray<DsTableName> _xZkqqHx_iCpA_xHqqkZx_ TableNameSet _xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	TableNameSet stReqGroupName;
	long lC;
	for (lC = 0; lC != dsGroupNameArray.GetSize(); lC++)
		stReqGroupName.insert(FCTableName(dsGroupNameArray.GetAt(lC)));

	// Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCmMiCkEiClPiBeBiJpAjFpKjHhGiLiBiCkKiPgPiCmEiCkCiCoJiCoAiCmM_xHqqkZx_
	// _xZkqqHx_iClOiCkPiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	TableNameSet stReqTableName;
	mdef_const_iterator(TableNameToLong, iTnl);
	m1_for (iTnl, m_mpReadLockForCache)
	{
		if (stReqGroupName.find(FCTableName(iTnl->first).PopBack()) != stReqGroupName.end())
			stReqTableName.insert(iTnl->first);
	}

	BOOL bIsUnkeeped = FALSE;
	// _xZkqqHx_iJpAjFpKjHhGiLiBiCmMiPgPiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCpAjBfDiCmEiJpAjFpKiBeC_xHqqkZx_
	mdef_const_iterator(TableNameSet, iTns);
	m1_for (iTns, stReqTableName)
	{
		if (UnkeepReadLockForCache(*iTns))
			bIsUnkeeped = TRUE;
	}
	return bIsUnkeeped;
} // FCDynamicDb::UnkeepIfUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::UnkeepIfNotWriteKeeped
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WRITE_xZkqqHx_iDeMiBfLiDhGiDgFiBfLiDhFiDiLiImIiKePiCmMiBeB_xHqqkZx_READ_xZkqqHx_iDeMiBfLiDhGiClDiCoKiCmEiCkCiCoJiDiNiDgCiDeOiCmNiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::UnkeepIfNotWriteKeeped ()
{
	// READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiCmMiCkEiClPiBeB_xHqqkZx_
	// WRITE_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiClDiCoKiCmEiCkCiCmIiCkCiCoAiCmMiClOiCkPiCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	TableNameSet stUnkeepTable;
	mdef_const_iterator(TableNameToLong, iTnl);
	m1_for (iTnl, m_mpReadLockForCache)
	{
		//----- WRITE_xZkqqHx_iDeMiBfLiDhGiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		if (m_stWriteLockForFlush.find(iTnl->first) == m_stWriteLockForFlush.end())
			stUnkeepTable.insert(iTnl->first);
	}
	// _xZkqqHx_iDeMiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	mdef_const_iterator(TableNameSet, iTns);
	m1_for (iTns, stUnkeepTable)
		UnkeepReadLockForCache(*iTns);
} // FCDynamicDb::UnkeepIfNotWriteKeeped.

//----- 06.02.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ShowProgressBar
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCDynamicDb::ShowProgressBar (flint fliGoalByte)
//{
////	g_pDbServer->ShowProgressBar(fliGoalByte);
//} // FCDynamicDb::ShowProgressBar.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::HideProgressBar
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCDynamicDb::HideProgressBar ()
//{
////	g_pDbServer->HideProgressBar();
//} // FCDynamicDb::HideProgressBar.
//----- 06.02.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTotalUnflushedBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGkCiDhEiDiJiDgCiDfGiDiFiCmMiDgGiBfLiDfOiDfEiDeDiDfJiCmMiNiHiMhGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCmMiDfEiDeDiDfJiNiHiMhGiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCDynamicDb::GetTotalUnflushedBufferSize () const
{
	flint fliTotalTransaction = 0;
	mdef_const_iterator(HStrToTopGroupRec, iTop);
	m1_for (iTop, m_mpTopDirToTopGroupRec)
	{
		FCTopGroupRec* pTopGroupRec = iTop->second.get();
		fliTotalTransaction += pTopGroupRec->m_vTransaction.size();
	}
	return fliTotalTransaction;
} // FCDynamicDb::GetTotalUnflushedBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::TerminateFlushThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCmMjFmKiDfIiDiMiDgCiDgIiCpAiLkNjAkHiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiPiIjHjNiCpAiOmAiNhDiClHiCoJiCmGiDiBiDiCiDiKiBfLiDiKiBfLiDeOjDjJiCmMjFhDiLoPiNiHiCkKjAlGiClGiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iLnJiLhNiPeJjHlJiOjOiCmMiCnNiCmJiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::TerminateFlushThread ()
{
	ASSERT(!IsFlushing());
	g_pDbServer->TerminateFlushThread();
} // FCDynamicDb::TerminateFlushThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::KeepWriteLockForFlush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmFiBeBiOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiCmG_xHqqkZx_
 *			Read_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmJiPjBiCkLiNjOiCnNiCpAiClFiClNiPoKiNiHiBeBjBlMiDeBiDhGiDiKiCkJiCoHiCmMiPjBiCkLiNjOiCnNiCpAjGgIiCkOiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iOjPiCmMiDhEiDiJiDgCiDfGiDiFiCnMiCmFiClLiCmM_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiCmNiDeMiBfLiDhGiClDiCoKiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::KeepWriteLockForFlush (const FCTableName& tableName)
{
	// _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_stWriteLockForFlush.find(tableName) != m_stWriteLockForFlush.end())
		return;
	if (!GetIsWriteLocked(tableName))
		FFThrowMiscUnknown();
	TryWriteLockTable(tableName);
	m_stWriteLockForFlush.insert(tableName);
} // FCDynamicDb::KeepWriteLockForFlush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetIsTableExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::GetIsTableExist (const FCTableName& tableName) const
{
	return g_pDbServer->IsTableExist(DsTableName(tableName));
} // FCDynamicDb::GetIsTableExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLockedTableGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCkJiCoHiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCmNiBeBiOmAiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmMjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFjFkBiOmKiClFiCmEiKmHjHjNiClFiCmEiCkCiCoJiBeC_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_
 *			WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiKnEiCmN_xHqqkZx_ _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmMjFkBiOmKiPoOjFpBiCmNiOmAiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiCmJiInLiOjNiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiCmFjFkBiOmKiKmHjHjNiClDiCoKiCmEiCkCiCoJjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCmGiCkLiCmMiCnNiOmAiNhDiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCDynamicDb::GetLockedTableGuid (const FCTableName& tableName) const
{
	const FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
		FFThrowMiscUnknown();
	// READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (pLockRec->m_lReadLockCounter == 0 &&
		pLockRec->m_lWriteLockCounter == 0)
		FFThrowMiscUnknown();
	return pLockRec->m_guidTable;
} // FCDynamicDb::GetLockedTableGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLockedDeleteIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCkJiCoHiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCmNiBeBiOmAiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmMjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFjFkBiOmKiClFiCmEiKmHjHjNiClFiCmEiCkCiCoJiBeC_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_
 *			WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiKnEiCmN_xHqqkZx_ _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmMjFkBiOmKiPoOjFpBiCmNiOmAiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiCmJiInLiOjNiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiCmFjFkBiOmKiKmHjHjNiClDiCoKiCmEiCkCiCoJjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCmGiCkLiCmMiCnNiOmAiNhDiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::GetLockedDeleteIdentifier (const FCTableName& tableName) const
{
	const FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
		FFThrowMiscUnknown();
	// READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (pLockRec->m_lReadLockCounter == 0 &&
		pLockRec->m_lWriteLockCounter == 0)
		FFThrowMiscUnknown();
	return pLockRec->m_dwDeleteIdentifier;
} // FCDynamicDb::GetLockedDeleteIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLockedAppendIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCkJiCoHiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCmNiBeBiOmAiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmMjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFjFkBiOmKiClFiCmEiKmHjHjNiClFiCmEiCkCiCoJiBeC_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_
 *			WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiKnEiCmN_xHqqkZx_ _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmMjFkBiOmKiPoOjFpBiCmNiOmAiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iPoOjFpBiCmGjDkPiClGiCmJiCmIiCoJiCoGiCkEiCmJiInLiOjNiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiCmFjFkBiOmKiKmHjHjNiClDiCoKiCmEiCkCiCoJjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCmGiCkLiCmMiCnNiOmAiNhDiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::GetLockedAppendIdentifier (const FCTableName& tableName) const
{
	const FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
		FFThrowMiscUnknown();
	// READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (pLockRec->m_lReadLockCounter == 0 &&
		pLockRec->m_lWriteLockCounter == 0)
		FFThrowMiscUnknown();
	return pLockRec->m_dwAppendIdentifier;
} // FCDynamicDb::GetLockedAppendIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ClearWriteLockForFlush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiCpAjBfDiCmEiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::ClearWriteLockForFlush ()
{
	TableNameSet::const_iterator iTbl;
	for (iTbl = m_stWriteLockForFlush.begin(); iTbl != m_stWriteLockForFlush.end(); iTbl++)
		WriteUnlockTable(*iTbl);
	m_stWriteLockForFlush.clear();
} // FCDynamicDb::ClearWriteLockForFlush.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::MakeUniqTopGroupPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhAiDfIiCpAiMlDiCmJiBeBiDiGiDgKiBfLiDeOiCmIiDgHiDgCiDhGiDePiDiLiBfLiDhGiDhAiDfIjGlMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrGroupPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpPath			:_xZkqqHx_iNoMjAkMiClHiCoJiMlDiCmGiCmIiCoJiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpExt			:_xZkqqHx_iKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiBeG_xHqqkZx_wcpPath = "C:\TMP\HELLO", wcpExt = ".TXT"_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *				dsTopGroupPath = "C:\TMP\HELLO_1f.TXT"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::MakeUniqTopGroupPath (WString& wstrGroupPath,
										const wchar_t* wcpPath,
										const wchar_t* wcpExt) const
{
	DsString dstrGroupPath;
	g_pDbServer->MakeUniqTopGroupPath(dstrGroupPath, wcpPath, wcpExt);
	wstrGroupPath = dstrGroupPath.Get();
} // FCDynamicDb::MakeUniqTopGroupPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::SetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath		:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiOjPiCmJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiCmGiCkLiCmM_xHqqkZx_
 *			_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiPiJiKpKjCgMiCpAiMiIiCnPiCoJiNnLiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::SetCurrentDirectory (const wchar_t* wcpDirPath)
{
	g_pDbServer->SetCurrentDirectory(wcpDirPath);
} // FCDynamicDb::SetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetCurrentDirectory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiOjPiCmJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiCmGiCkLiCmM_xHqqkZx_
 *			_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiPiJiKpKjCgMiCpAiMiIiCnPiCoJiNnLiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDynamicDb::GetCurrentDirectory () const
{
	DsString dsDirPath;
	g_pDbServer->GetCurrentDirectory(dsDirPath);
	WString wstrCurDir = dsDirPath.Get();
	return wstrCurDir;
} // FCDynamicDb::GetCurrentDirectory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::MakeUniqTmpTopGroupPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiBgJ_xHqqkZx_TMP_xZkqqHx_jDjJiBgKiCmMiJlKiCmFiBeBiDiGiDgKiBfLiDeOiCmIiDgHiDgCiDhGiDePiDiLiBfLiDhGiDhAiDfI_xHqqkZx_
 *			_xZkqqHx_iBgJiDgGiDeCiDiMiDeOiDgHiDiKjGlMiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpExt	:_xZkqqHx_iKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP' -> 'TMP' -> 'TEMP'
 *			_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiNoMjAkMiCkJiCoHjHjIjHhAiClHiCoJiCnMiCmFiCmJiBeBjBlMiCmMiDeBiDhGiDiKiCkJiCoHjDkPiClG_xHqqkZx_
 *			_xZkqqHx_jGlMjBePiCmMiDhEiDeAiDeDiDiLiCkKiNoMjAkMiClDiCoKiCoJiClBiCmGiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDynamicDb::MakeUniqTmpTopGroupPath (const wchar_t* wcpExt) const
{
//----- 06.02.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	DsString dsTopGroupPath;
//	g_pDbServer->MakeUniqTmpTopGroupPath(dsTopGroupPath);
//	return WString(dsTopGroupPath.Get());
//----- 06.02.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrTmpPath = FFGetTmpDirectory();
	wstrTmpPath += L'\\';
	wstrTmpPath += L"_Dyn";
	WString wstrGroupPath;
	MakeUniqTopGroupPath(wstrGroupPath, wstrTmpPath, wcpExt);
	return wstrGroupPath;
//----- 06.02.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCDynamicDb::MakeUniqTmpTopGroupPath.

//----- 06.03.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTmpDirectory
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MakeUniqTmpTopGroupPath_xZkqqHx_iKnGjAjEiCmFiOgHiCoNiCoKiCoJiBeBiIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIoKiOjOiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeBiKmCiLkLjFmPjAjE_xHqqkZx_'MOLIPTMP' -> 'TMP' -> 'TEMP'
// *			_xZkqqHx_iCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCDynamicDb::GetTmpDirectory () const
//{
//	return FFGetTmpDirectory();
//} // FCDynamicDb::GetTmpDirectory.
//----- 06.03.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CreateWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiBgJiPiKjHeMiMkAiDhEiDeAiDeDiDiLiBgKiCpAiNoMjAkMiClFiBeB_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeCjBkGiClPjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::CreateWriteLock (const FCTableName& tableName)
{
	ASSERT(!IsFlushing());
	DsErr dsErrCode = g_pDbServer->CreateWriteLock(DsTableName(tableName));
	SetErrorFromServer(dsErrCode, tableName);
	if (dsErrCode == 0)
	//----- _xZkqqHx_iDiNiDgCiDeOiNoMjAkMiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		FCLockRec* pLockRec = QueryLockRec(tableName);
		pLockRec->m_lWriteLockCounter = 1;
		pLockRec->m_guidTable = GUID_NULL;
		pLockRec->m_dwDeleteIdentifier = 0;
		pLockRec->m_dwAppendIdentifier = 0;
		return 1;
	} else
	//----- _xZkqqHx_iDiNiDgCiDeOiNoMjAkMiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		return 0;
	}
} // FCDynamicDb::CreateWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::TryReadLockTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_SHARED READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGkCiDiNiDgCiDeOiDgFiBfLiDhFiDiLiCmMiNmFiPiJiCmMiDiNiDgCiDeOiCmMiPoKiNiHiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_Identifier
 *			_xZkqqHx_iCpAiOoGjDlOiClFiCmEiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiKmHjHjNjFmPjAjEiCmJjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::TryReadLockTable (const FCTableName& tableName)
{
	FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL && pLockRec->m_lReadLockCounter != 0)
	//----- _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiJmBiOfKiClFiCmEjFjMiLeBiBeC_xHqqkZx_
		pLockRec->m_lReadLockCounter++;

		// _xZkqqHx_iDiNiDgCiDeOiCpAiDeMiDiDiDgCiDfGiDiFiClHiCoJiClNiCnPiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
		// _xZkqqHx_jChIiCkCiDgGiDeCiDfIiDeOiCmMiPoKiNiHiBeBiDiNiDgCiDeOiBeFiDeBiDjDiDiNiDgCiDeOiClOiCkPiCmFiOjOiKnEiCkKiCkJiCkJiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeBiClBiClBiCmFiDeMiBfLiDhGiBeC_xHqqkZx_
		// _xZkqqHx_iKpJiCmJiDeMiBfLiDhGiNmPiCnNiCmFiCkAiCmBiCmEiCoAiBeBiNmFiLnPiDeKiDeFiDjDiDfOiCpAjAnNjCoIiClHiCoJiClNiCnPiCmJ_xHqqkZx_
		// _xZkqqHx_iMmEiCnBiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		KeepReadLockForCache(tableName);

		return pLockRec->m_lReadLockCounter;
	}

	ASSERT(!IsFlushing());

	GUID guidTable;
	DWORD dwDeleteIdentifier;
	DWORD dwAppendIdentifier;
	DsErr dsErrCode = g_pDbServer->TryReadLock(	guidTable,
												dwDeleteIdentifier,
												dwAppendIdentifier,
												DsTableName(tableName));
	SetErrorFromServer(dsErrCode, tableName);
	if (dsErrCode == 0)
	//----- _xZkqqHx_iDfEiBfLiDgPiCmFiDiNiDgCiDeOiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClFiBeBjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		pLockRec = QueryLockRec(tableName);
		pLockRec->m_lReadLockCounter = 1;
		pLockRec->m_guidTable = guidTable;
		pLockRec->m_dwDeleteIdentifier = dwDeleteIdentifier;
		pLockRec->m_dwAppendIdentifier = dwAppendIdentifier;

		// _xZkqqHx_iDiNiDgCiDeOiCpAiDeMiDiDiDgCiDfGiDiFiClHiCoJiClNiCnPiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
		// _xZkqqHx_jChIiCkCiDgGiDeCiDfIiDeOiCmMiPoKiNiHiBeBiDiNiDgCiDeOiBeFiDeBiDjDiDiNiDgCiDeOiClOiCkPiCmFiOjOiKnEiCkKiCkJiCkJiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiCmJiBeBiClBiClBiCmFiDeMiBfLiDhGiBeC_xHqqkZx_
		KeepReadLockForCache(tableName);
		return pLockRec->m_lReadLockCounter;
	} else
	//----- _xZkqqHx_iDfEiBfLiDgPiCmFiDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		return 0;
	}
} // FCDynamicDb::TryReadLockTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::TryWriteLockTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_EXCLUSIVE WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	READ/WRITE_xZkqqHx_iCmGiCoAiCmJjGkCiDiNiDgCiDeOiDgFiBfLiDhFiDiLiCmMiPoKiNiHiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_Identifier
 *			_xZkqqHx_iCpAiOoGjDlOiClHiCoJiClNiCnPiCmJiBeBiCnMiClI_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClFiCmEiPoOjFpBiCpAiOoGjDlOiClFiClNiMoDiBeB_xHqqkZx_
 *			WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiCkJiCkPiCmE_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::TryWriteLockTable (const FCTableName& tableName)
{
	FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL && pLockRec->m_lWriteLockCounter != 0)
	{
		pLockRec->m_lWriteLockCounter++;
		return pLockRec->m_lWriteLockCounter;
	}

	// _xZkqqHx_iJlMiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiCkJiCkPiCoJiCkJiBeI_xHqqkZx_
	BOOL bTempReadLock = FALSE;
	if (pLockRec == NULL || pLockRec->m_lReadLockCounter == 0)
	//----- READ_xZkqqHx_iDiNiDgCiDeOiBeB_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCmGiCoAiNmFiPiJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJlMjBhKiDhEiDeAiDeDiDiLiCpAjFkIjHjNiDhEiDeAiDeDiDiLiCmJiIoKjChGiClDiClJiCoJiClNiCnPiCmJiBeB_xHqqkZx_
		// READ_xZkqqHx_iDiNiDgCiDeOiCkKjAoGiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if (TryReadLockTable(tableName) == 0)
			return 0;
		// _xZkqqHx_iJlMiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiCkJiCkPiCoJiCkJiBeI_xHqqkZx_
		bTempReadLock = TRUE;
	}

	ASSERT(!IsFlushing());

	long lWriteLock;
	DsErr dsErrCode = g_pDbServer->TryWriteLock(DsTableName(tableName));
	SetErrorFromServer(dsErrCode, tableName);
	if (dsErrCode == 0)
	//----- _xZkqqHx_iDiNiDgCiDeOiCmJjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		pLockRec = QueryLockRec(tableName);
		pLockRec->m_lWriteLockCounter = 1;
		lWriteLock = 1;
	} else
	//----- _xZkqqHx_iDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		lWriteLock = 0;
	}
	// _xZkqqHx_iJlMiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiClFiCmEiCkCiCoJiPoKiNiHiCmNiDiNiDgCiDeOiJpAiPjMiBeC_xHqqkZx_
	if (bTempReadLock)
		ReadUnlockTable(tableName);

	return lWriteLock;
} // FCDynamicDb::TryWriteLockTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ReadUnlockTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::ReadUnlockTable (const FCTableName& tableName)
{
	FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
	{
		if (1 < pLockRec->m_lReadLockCounter)
		//----- _xZkqqHx_iDeKiDeFiDjDiDfOiCkKiCfBiImIiPoDiBeBjBkGiClPiDiNiDgCiDeOiJpAiPjMiClFiCmEiCoAiDiNiDgCiDeOiCkKiOgDiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDeKiDeFiDjDiDfOiCpAiMlIiOfKiClHiCoJiCmMiCnNiBeC_xHqqkZx_
			pLockRec->m_lReadLockCounter--;
			return pLockRec->m_lReadLockCounter;
		} else
		if (pLockRec->m_lReadLockCounter == 1)
		//----- _xZkqqHx_iDeKiDeFiDjDiDfOiBiBiCfAiBeBjBkGiClPiDiNiDgCiDeOiJpAiPjMiClHiCoKiCmOiDiNiDgCiDeOiCkKiOgDiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			ASSERT(!IsFlushing());
			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDeKiDeFiDjDiDfOiCpAiCePiCmJiBeC_xHqqkZx_
			pLockRec->m_lReadLockCounter = 0;
			// _xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
			g_pDbServer->ReadUnlock(DsTableName(tableName));
			// Read,Write_xZkqqHx_iDiNiDgCiDeOiCmGiCoAiCmJiCePiCmMiPoKiNiHiCmNjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
			if (pLockRec->m_lWriteLockCounter == 0)
				DeleteLockRec(tableName);
			return 0;
		} else
		{
			FFThrowMiscUnknown();
			return 0;
		}
	} else
	{
		FFThrowMiscUnknown();
		return 0;
	}
} // FCDynamicDb::ReadUnlockTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::WriteUnlockTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::WriteUnlockTable (const FCTableName& tableName)
{
	FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
	{
		if (1 < pLockRec->m_lWriteLockCounter)
		//----- _xZkqqHx_iDeKiDeFiDjDiDfOiCkKiCfBiImIiPoDiBeBjBkGiClPiDiNiDgCiDeOiJpAiPjMiClFiCmEiCoAiDiNiDgCiDeOiCkKiOgDiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDeKiDeFiDjDiDfOiCpAiMlIiOfKiClHiCoJiCmMiCnNiBeC_xHqqkZx_
			pLockRec->m_lWriteLockCounter--;
			return pLockRec->m_lWriteLockCounter;
		} else
		if (pLockRec->m_lWriteLockCounter == 1)
		//----- _xZkqqHx_iDeKiDeFiDjDiDfOiBiBiCfAiBeBjBkGiClPiDiNiDgCiDeOiJpAiPjMiClHiCoKiCmOiDiNiDgCiDeOiCkKiOgDiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			ASSERT(!IsFlushing());
			// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDeKiDeFiDjDiDfOiCpAiCePiCmJiBeC_xHqqkZx_
			pLockRec->m_lWriteLockCounter = 0;
			// _xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
			g_pDbServer->WriteUnlock(DsTableName(tableName));
			// Read,Write_xZkqqHx_iDiNiDgCiDeOiCmGiCoAiCmJiCePiCmMiPoKiNiHiCmNjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
			if (pLockRec->m_lReadLockCounter == 0)
				DeleteLockRec(tableName);
			return 0;
		} else
		{
			FFThrowMiscUnknown();
			return 0;
		}
	} else
	{
		FFThrowMiscUnknown();
		return 0;
	}
} // FCDynamicDb::WriteUnlockTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::DeleteClientLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiKmHjHjNiLeAiNfMiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCmMjDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMiDiNiDgCiDeOiCmNiBeBiDfEiBfLiDgPiBfLjBkEiCmFiDhEiDiJiDgCiDfGiDiFjCiGiCmJiPjPiOoIiCmJ_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClDiCoKiCoJiBeCiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCoAiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOjDgPjIfOiCpAjGjFiPmBiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::DeleteClientLock (const FCTableName& tableName)
{
	// READ KEEP_xZkqqHx_iCkJiCoHjGjFiPmBiBeC_xHqqkZx_
	m_mpReadLockForCache.erase(tableName);
	// WRITE KEEP_xZkqqHx_iCkJiCoHjGjFiPmBiBeC_xHqqkZx_
	m_stWriteLockForFlush.erase(tableName);
	// _xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
	m_mpTableNameToLockRec.erase(tableName);
} // FCDynamicDb::DeleteClientLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetReadLockCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::GetReadLockCount (const FCTableName& tableName) const
{
	const FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
		return pLockRec->m_lReadLockCounter;
	else
		return 0;
} // FCDynamicDb::GetReadLockCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetWriteLockCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDynamicDb::GetWriteLockCount (const FCTableName& tableName) const
{
	const FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec != NULL)
		return pLockRec->m_lWriteLockCounter;
	else
		return 0;
} // FCDynamicDb::GetWriteLockCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetIsReadLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::GetIsReadLocked (const FCTableName& tableName) const
{
	return (GetReadLockCount(tableName) != 0);
} // FCDynamicDb::GetIsReadLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetIsWriteLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCkK_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::GetIsWriteLocked (const FCTableName& tableName) const
{
	return (GetWriteLockCount(tableName) != 0);
} // FCDynamicDb::GetIsWriteLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::MultiCmdDeleteRecords
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNjFkBjAjEiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stIndex		:_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiCmJiCmNiBeBiCnMiClIiOhHjCoIiDiMiDfCiBfLiDgIiImIiNhOiCpAjBfDiCmE_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClFiBeBiOhHjCoIiDiMiDfCiBfLiDgIiBhLiCfAiImIiNhOiCmMjEpBiNoNiPjMjBmOiPnLiDiMiDfCiBfLiDgIiCpAiNmEjDgPjIfOiClHiCoJiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmFiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCfBiBeBiCfDiBeBiCfEiCmMiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiPoKiNiHiCpAiOkGiClHiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iNoNiPjMjBePiCmMiDgFiBfLiDhFiDiL_xHqqkZx_
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Indx_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_DataSz_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            0 _xZkqqHx_iEkA_xHqqkZx_     0_xZkqqHx_iEkA_xHqqkZx_     1_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            1 _xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            2 _xZkqqHx_iEkA_xHqqkZx_     4_xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            3 _xZkqqHx_iEkA_xHqqkZx_     5_xZkqqHx_iEkA_xHqqkZx_     3_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            4 _xZkqqHx_iEkA_xHqqkZx_     6_xZkqqHx_iEkA_xHqqkZx_     4_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            5 _xZkqqHx_iEkA_xHqqkZx_     7_xZkqqHx_iEkA_xHqqkZx_     4_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            6 _xZkqqHx_iEkA_xHqqkZx_     8_xZkqqHx_iEkA_xHqqkZx_     5_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iNoNiPjMjBmOiPnLiCmMiNmFiCoAiPkMiClDiCkCiDeDiDjDiDgGiDgCiDeOiDfIiCfBiImIiMoDiCpAiNoNiPjMiBeC_xHqqkZx_
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Indx_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_DataSz_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            0 _xZkqqHx_iEkA_xHqqkZx_     0_xZkqqHx_iEkA_xHqqkZx_     1_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            1 _xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iOjPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCfCiCpAjGnPiClHiBeC_xHqqkZx_
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Indx_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_DataSz_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            0 _xZkqqHx_iEkA_xHqqkZx_     0_xZkqqHx_iEkA_xHqqkZx_     1_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            1 _xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            3 _xZkqqHx_iEkA_xHqqkZx_     5_xZkqqHx_iEkA_xHqqkZx_     6_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_iNoNiPjMjBmOiPnLiCmMiCfDiBeBiCfEiCmNjGnPiClDiClIiBeBiCfFiCpAjGnPiClHiBeC_xHqqkZx_
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          Indx_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_DataSz_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            0 _xZkqqHx_iEkA_xHqqkZx_     0_xZkqqHx_iEkA_xHqqkZx_     1_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            1 _xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_     2_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            3 _xZkqqHx_iEkA_xHqqkZx_     5_xZkqqHx_iEkA_xHqqkZx_     6_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkFiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *            6 _xZkqqHx_iEkA_xHqqkZx_     8_xZkqqHx_iEkA_xHqqkZx_     6_xZkqqHx_iEkA_xHqqkZx_    XX_xZkqqHx_iEkA_xHqqkZx_********_xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::MultiCmdDeleteRecords (const FCTableName& tableName, const DWORDSet& stIndex)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableName);

	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_REDUCE_RECORD_COUNT << tableName.m_vTableIds  << *(stIndex.begin());

	const FCVirtualTable* pVirtualTable = QueryTable(tableName);
	DWORD dwTmp;
	for (dwTmp = *(stIndex.begin()) + 1;
		 dwTmp != pVirtualTable->GetRecordCount(); dwTmp++)
	{
		if (stIndex.find(dwTmp) == stIndex.end())
		//----- _xZkqqHx_iNoNiPjMjBmOiPnLiCmMiDiMiDfCiBfLiDgIiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIiDgGiBfLiDfOiCkKjGlDiCkCiPoKiNiHiCmNiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			if (pVirtualTable->IsNullRecord(dwTmp))
				CacheTableRealRecords(tableName, dwTmp);
			BYTEVector vDataBuff;
			flint fliPrimaryId = pVirtualTable->GetRecordPrimaryId(dwTmp);
			pVirtualTable->GetRecordData(vDataBuff, dwTmp, 0);
			pTopGroupRec->m_vTransaction << CMD_APPEND_RECORD << tableName.m_vTableIds << fliPrimaryId << vDataBuff;
		}
	}
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::MultiCmdDeleteRecords.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdCreateGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiNoMjAkMiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCGroupRec_xZkqqHx_iBgKiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiLpDiCmMiDePiDiLiBfLiDhGiCkKiNoMjAkMiClDiCoKiCoJiClOiCkPiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMjFmPiNfIjDjJiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdCreateGroup (const FCTableName& groupName)
{
	// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(groupName.m_hstrTopDirPath);
	// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMiDfEiDeDiDfJiCpAiLeMiJkPiBeC_xHqqkZx_
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfEiNoMjAkMiDfCiDhNiDjDiDgIiCpAiNoMjAkMiBeC_xHqqkZx_
	pTopGroupRec->m_vTransaction << CMD_CREATE_GROUP;
// 05.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	groupName.m_vTableIds.OutStream(pTopGroupRec->m_vTransaction);
	pTopGroupRec->m_vTransaction << groupName.m_vTableIds;
	// _xZkqqHx_iDePiDiLiBfLiDhGiNoMjAkMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdCreateGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdDeleteGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiNoNiPjMiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iNoNiPjMiClHiCoJiDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiDePiDiLiBfLiDhGiCfAiCpAiNoNiPjMiClHiCoJiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiCfAiCmJiCnEiCoHiJlKiCkKiCoJ_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmGiDePiDiLiBfLiDhGiBgJiKmHjHjNiDgFiBfLiDhFiDiLiCfBiBgAiDePiDiLiBfLiDhG_xHqqkZx_10_xZkqqHx_iBgKiCpAjHfMiCnP_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiLpDiCmMiDePiDiLiBfLiDhGiCkKiNoNiPjMiClDiCoKiCoJiClOiCkPiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMjFmPiNfIjDjJiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                          _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                    _xZkqqHx_iEkA_xHqqkZx_      
 *                            _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiEkAiDgFiBfLiDhFiDiLiCfFiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                              _xZkqqHx_iEkA_xHqqkZx_      
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                                      _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                              _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiEkAiDgFiBfLiDhFiDiLiCfIiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhG_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                                        _xZkqqHx_iBeG_xHqqkZx_      
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdDeleteGroup (const FCTableName& groupName)
{
	// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(groupName.m_hstrTopDirPath);
	// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmMiDfEiDeDiDfJiCpAiLeMiJkPiBeC_xHqqkZx_
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfAiNoNiPjMiDfCiDhNiDjDiDgIiCpAiNoMjAkMiBeC_xHqqkZx_
	pTopGroupRec->m_vTransaction << CMD_DELETE_GROUP;
// 05.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	groupName.m_vTableIds.OutStream(pTopGroupRec->m_vTransaction);
	pTopGroupRec->m_vTransaction << groupName.m_vTableIds;
	// _xZkqqHx_iDePiDiLiBfLiDhGiNoNiPjMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdDeleteGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdCreateTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiNoMjAkMiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCTableRec_xZkqqHx_iBgKiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiLpDiCmMiDgFiBfLiDhFiDiLiCkKiNoMjAkMiClDiCoKiCoJiClOiCkPiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMjFmPiNfIjDjJiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDgFiBfLiDhFiDiLiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdCreateTable (const FCTableName& tableName)
{
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMjAfGiLeLiNoMjAkMiCmFiCmNiBeB_xHqqkZx_GUID_xZkqqHx_iCmNiDgFiBfLiDhFiDiLjBkEiCmJiLeMjIfOiClFiCmEiCkIiCkCiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOjOiCmJiPiJiCnPiCmEiDiNiDgCiDeOiCmJ_xHqqkZx_GUID_xZkqqHx_iCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOjAfGiLeLiNoMjAkMiOjOiCmJ_xHqqkZx_GUID_xZkqqHx_iCpAiLeMjIfOiClFiCmEiCkIiCkCiCmEiBeBiDgFiBfLiDhFiDiLiNoMjAkMiOjOiCmJ_xHqqkZx_
	// _xZkqqHx_iClLiCoKiCpAiDgFiBfLiDhFiDiLiCmJiDfCiDhDiBfLiClHiCoJjFpLiCkKiCoGiClDiClLiCkEiClOiCkKiBeB_xHqqkZx_
	// DELETE_AND_CREATE _xZkqqHx_iCmMiPoKiNiHiCmJiClLiCoKiClOiCmGiNkCiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableName);
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_CREATE_TABLE;
	pTopGroupRec->m_vTransaction << tableName.m_vTableIds;
	pTopGroupRec->m_vTransaction << FFCreateGuid();
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdCreateTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdDeleteTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiNoNiPjMiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiDgFiBfLiDhFiDiLiCkKiNoNiPjMiClDiCoKiCoJiClOiCkPiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMjFmPiNfIjDjJiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdDeleteTable (const FCTableName& tableName)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableName);
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_DELETE_TABLE;
	pTopGroupRec->m_vTransaction << tableName.m_vTableIds;
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdDeleteTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdAppendRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjCmHiJmBiCmMiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliPrimaryId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecordData1	:_xZkqqHx_iDgGiBfLiDfOiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwRecordData1	:_xZkqqHx_iDgGiBfLiDfOiCfAiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecordData2	:_xZkqqHx_iDgGiBfLiDfOiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwRecordData2	:_xZkqqHx_iDgGiBfLiDfOiCfBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiNmFiMoDiCmJiBeBiDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCmNiCfBiCmCiCmJjFkKiKiEiClFiCmEiOhHjCoIiCmFiCkLiCoJiBeCiCfAiCmCiCmMjFpLiCkKiDfGiDjDiDhGiDiLiCmFjHmHiCkCiCmMiClOiCkKiBeB_xHqqkZx_
 *			CRC_xZkqqHx_iCpAiPjBiCkLiNjOiCnOiCoGiCkEiCmJiClFiClNiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_jFjEiCmGiOmAiDgGiBfLiDfOjFjEiCmMiCfBiCmCiCpAiOhHjCoIiCmFiCkLiCoJ_xHqqkZx_
 *			_xZkqqHx_iCoGiCkEiCmJiOgEjHgMjFmPiNfIiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::CmdAppendRecord (const FCTableName& tableName,
									flint fliPrimaryId,
									const void* pRecordData1,
									DWORD dwRecordData1,
									const void* pRecordData2,
									DWORD dwRecordData2)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableName);
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_APPEND_RECORD;
	pTopGroupRec->m_vTransaction << tableName.m_vTableIds;
	pTopGroupRec->m_vTransaction << fliPrimaryId;
	pTopGroupRec->m_vTransaction << DWORD(dwRecordData1 + dwRecordData2);
	FFWriteStream(pTopGroupRec->m_vTransaction, pRecordData1, dwRecordData1);
	if (pRecordData2 != NULL)
		FFWriteStream(pTopGroupRec->m_vTransaction, pRecordData2, dwRecordData2);
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
	return QueryTable(tableName)->GetRecordCount() - 1;
} // FCDynamicDb::CmdAppendRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdReduceRecordCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAiPgLiPkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCount		:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiNkBiCmMiDiMiDfCiBfLiDgIjAjEiCoGiCoIiPkMiClDiCkCjCgMiCpAiOhHjCoIiClHiCoJiClBiCmGiBeCjDkPiClGjCgMiCoAiDfPiDiBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdReduceRecordCount (const FCTableName& tableName, DWORD dwCount)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableName);
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_REDUCE_RECORD_COUNT << tableName.m_vTableIds << dwCount;
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdReduceRecordCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CmdCopyRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiOhHjCoIjEmNiImNiCmMiDiMiDfCiBfLiDgIiCpAiBeBiClBiCmMiDgFiBfLiDhFiDiLiCmMjGjGjEpGiCmJ_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableNameTo		:_xZkqqHx_iDfCiDhDiBfLiClHiCoJjAoGiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tableNameFrom	:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiMlDiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndexBegin	:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndexEnd		:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiClDiCoKiCoJiDiMiDfCiBfLiDgIiCmNiBeB_xHqqkZx_AppendIdentifier_xZkqqHx_iCmMiCnNjAfGiClFiCkCjCgMiCmJjFmPiNfIiClDiCoK_xHqqkZx_
 *			_xZkqqHx_iOgDiCoIiCmMjCgMiCmNiMlDiCmMiCnMiCnMjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPiIjHjNiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiNhDiCoNiCoKiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiMlDiCmNiCkCiCmBiClDiCkCiOfBiPmGiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjBoFiCkLiCmIiDfEiDeDiDfJiCmMiDgFiBfLiDhFiDiLiCpAjFkBiOmKiClHiCoJiPoKiNiHiCmJjHeMiMpIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CmdCopyRecord (	const FCTableName& tableNameTo,
									const FCTableName& tableNameFrom,
									DWORD dwIndexBegin,
									DWORD dwIndexEnd)
{
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiPeJjHlJiCnMiCmF_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiBeC_xHqqkZx_tableNameFrom _xZkqqHx_iCoAiDeMiBfLiDhGiClHiCoJiCmMiCmNiBeB_xHqqkZx_
	// _xZkqqHx_jFkBiOmKiCkKiPeJiCoNiCoJiCnMiCmFiCmJiPeDjAlDiCkKjDpMiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeC_xHqqkZx_Write_xZkqqHx_iCmFiCmIiCkN_xHqqkZx_ReadLock_xZkqqHx_iCmFiDeMiBfLiDhGiClHiCoJiCmGiBeB_xHqqkZx_
	// _xZkqqHx_jBlMiDeBiDhGiDiKiCmFiPjBiCkLiNjOiCnNiPiIjHjNiCkKiOmAiNhDiClDiCoKiCmEiDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCkKjClHiOjOiKnEjBnCiCmCiClBiCmGiCmJiCmIiCoJiBeC_xHqqkZx_
	KeepWriteLockForFlush(tableNameTo);
	KeepWriteLockForFlush(tableNameFrom);
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableNameTo.m_hstrTopDirPath);
	const size_t szTransactionTop = pTopGroupRec->m_vTransaction.size();
	pTopGroupRec->m_vTransaction << CMD_COPY_RECORD << tableNameTo.m_vTableIds << tableNameFrom << dwIndexBegin << dwIndexEnd;
	pTopGroupRec->AddTransaction(&pTopGroupRec->m_vTransaction[szTransactionTop],
								 pTopGroupRec->m_vTransaction.size() - szTransactionTop);
	// _xZkqqHx_iPeDjAlDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	UpdateFirstModifiedFdtime();
} // FCDynamicDb::CmdCopyRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::QueryTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLjGlMiCmMiJlMjBhKiDgFiBfLiDhFiDiLiCpAiOoGjDlOiClHiCoJiBeCiDgFiBfLiDhFiDiLiCmN_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClOiJlMjBhKiDgFiBfLiDhFiDiLiCkKiNoMiCoHiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmGjFkIjHjNiDgFiBfLiDhFiDiLiCmJjAeIiCkCiIoBiCkCiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJlMjBhKiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiPeDjAlDiClFiCmEjFkIjHjNiDgFiBfLiDhFiDiLiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCVirtualTable* FCDynamicDb::QueryTable (const FCTableName& tableName)
{
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
//----- 06.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return pTopGroupRec->QueryTable(tableName.m_vTableIds);
//----- 06.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCTableRec* pTableRec = pTopGroupRec->UpdateVirtualTable(tableName.m_vTableIds);
	return (FCVirtualTable*)pTableRec->m_pVirtualTable;
//----- 06.02.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCDynamicDb::QueryTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::CacheTableRealRecords
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiDgGiBfLiDfOiCpA_xHqqkZx_
 *			_xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHjDmHiCnNiPgPiClFiCmEiDeMiDiDiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndex		:_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiClHiCoJiDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmNiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCpAiDeMiDiDiDgCiDfGiDiFiClHiCoJiClBiCmGiCkK_xHqqkZx_
 *			_xZkqqHx_iPgPjHiIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiBhLiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iBhLiDiMiDfCiBfLiDgI_xHqqkZx_Identifier_xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_jFeLiClIiDeMiDiDiDgCiDfGiDiFiClFiCmEiCkCiCoJiCmMiClOiCkKiBeBiDiMiDfCiBfLiDgIiDgGiBfLiDfOiCmNiPiJiKpKiPpDjBnEiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiClDiCoKiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjDmHiCnNiPgPiClFiCkKiCkAiCmBiCmEiPiJiCnPiCmEjFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiDfCiDhDiBfLiClFiCmEiCkNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiDiMiDfCiBfLiDgIjDmHiCnNiPgPiClFiCmMjDhIiCmJjFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiDfCiDhDiBfLiClHiCoJiCmMiCmNiMpIjHkGiCkK_xHqqkZx_
 *			_xZkqqHx_iIkLiCkCiCmMiCmFiBeBjDmHiCnNiPgPiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMjBePiMoDiCmMiDiMiDfCiBfLiDgIiCoAiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiDfCiDhDiBfLiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::CacheTableRealRecords (const FCTableName& tableName, DWORD dwIndex)
{
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	FCTableRec* pTableRec = pTopGroupRec->UpdateVirtualTable(tableName.m_vTableIds);
	FCVirtualTable* pVirtualTable = (FCVirtualTable*)pTableRec->m_pVirtualTable;

	DWORD dwPrevIndex = dwIndex - 1;
	DWORD dwNextIndex = dwIndex;
	DWORD dwCachedSize = 0;
	for (;;)
	{
		//----- _xZkqqHx_iCnMiClIiBeB_xHqqkZx_dwIndex _xZkqqHx_iCoGiCoIiMoDjFpLiCmMiDiMiDfCiBfLiDgIiCpAjClCiCnHiCoJ_xHqqkZx_ -----
		// _xZkqqHx_iDeMiDiDiDgCiDfGiDiFiCkKjFeLjHhGiCkJiBeI_xHqqkZx_
		BOOL bIsNeedToCache = FALSE;
		if (dwNextIndex != pVirtualTable->GetRecordCount())
		{
			if (pVirtualTable->IsNullRecord(dwNextIndex))
			//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjGkCiDeMiDiDiDgCiDfGiDiFiCmMiPoKiNiH_xHqqkZx_ -----
			{
				dwCachedSize += pVirtualTable->GetRecordDataSize(dwNextIndex);
				dwNextIndex++;
				bIsNeedToCache = TRUE;
			}
		}
		// _xZkqqHx_iDeMiDiDiDgCiDfGiDiFiClHiCoJiDfEiDeDiDfJiCkKiPfMjFkKiCmMjBoFiCkLiClDiCmJjCeCiClFiClNiCkJiBeI_xHqqkZx_
		if (FD_CACHE_SIZE_MAX < dwCachedSize) break;

		//----- _xZkqqHx_iOjPiCmJ_xHqqkZx_ dwIndex _xZkqqHx_iCoGiCoIjBePjFpLiCmMiDiMiDfCiBfLiDgIiCpAjClCiCnHiCoJ_xHqqkZx_ -----
		if (dwPrevIndex != DWORD(-1))
		{
			if (pVirtualTable->IsNullRecord(dwPrevIndex))
			//----- _xZkqqHx_iDiMiDfCiBfLiDgIiCkKjGkCiDeMiDiDiDgCiDfGiDiFiCmMiPoKiNiH_xHqqkZx_ -----
			{
				dwCachedSize += pVirtualTable->GetRecordDataSize(dwPrevIndex);
				dwPrevIndex--;
				bIsNeedToCache = TRUE;
			}
		}
		// _xZkqqHx_iDeMiDiDiDgCiDfGiDiFiClHiCoJiDfEiDeDiDfJiCkKiPfMjFkKiCmMjBoFiCkLiClDiCmJjCeCiClFiClNiCkJiBeI_xHqqkZx_
		if (FD_CACHE_SIZE_MAX < dwCachedSize) break;
		// _xZkqqHx_iCoAiCkEiDeMiDiDiDgCiDfGiDiFiCmNjFeLjHhGiCmIiCkCiCkJiBeI_xHqqkZx_
		if (!bIsNeedToCache) break;
	}
	dwPrevIndex++;

	if (dwPrevIndex != dwNextIndex)
	//----- _xZkqqHx_iDeMiDiDiDgCiDfGiDiFjEmNiImNiCkKiCfAiCmCiImIiPoDiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ASSERT(!IsFlushing());
		// _xZkqqHx_iDfEiBfLiDgPiBfLiCkJiCoHiDgFiBfLiDhFiDiLiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
		DsArray<BYTE> vTableRecord;
		g_pDbServer->LoadTableRecords(	vTableRecord,
										DsTableName(tableName),
										dwPrevIndex,
										dwNextIndex);

		// _xZkqqHx_iOoGjDlOiClFiClNiDgGiBfLiDfOiCpAiDiMiDfCiBfLiDgIiDgGiBfLiDfOiCmJiDeMiDiDiDgCiDfGiDiFiCmGiClFiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		DWORD dwRecIndex;
		const BYTE* pDataBuff = vTableRecord.Get();
		for (dwRecIndex = dwPrevIndex; dwRecIndex != dwNextIndex; dwRecIndex++)
		{
			const DWORD dwDataSize = pVirtualTable->SetDataToEmptyRealRecord(pDataBuff, dwRecIndex);
			pDataBuff += dwDataSize;
		}
	}
} // FCDynamicDb::CacheTableRealRecords.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetReadLockedTableName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNkBiMlLiNnNiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vReadLockTableName	:READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *								 _xZkqqHx_iDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::GetReadLockedTableName (vector<FCTableName>& vReadLockTableName)
{
	TableNameToLockRec::iterator i;
	for (i = m_mpTableNameToLockRec.begin();
		 i != m_mpTableNameToLockRec.end(); i++)
	{
		if (i->second.get()->m_lReadLockCounter != 0)
			vReadLockTableName.push_back(i->first);
	}
} // FCDynamicDb::GetReadLockedTableName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetWriteLockedTableName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNkBiMlLiNnNiBeB_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vReadLockTableName	:WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *								 _xZkqqHx_iDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::GetWriteLockedTableName (vector<FCTableName>& vWriteLockTableName)
{
	TableNameToLockRec::iterator i;
	for (i = m_mpTableNameToLockRec.begin();
		 i != m_mpTableNameToLockRec.end(); i++)
	{
		if (i->second.get()->m_lWriteLockCounter != 0)
			vWriteLockTableName.push_back(i->first);
	}
} // FCDynamicDb::GetWriteLockedTableName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTopGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiCnNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTopGroupRec* FCDynamicDb::GetTopGroupRec (const HString& hstrTopDirPath)
{
	HStrToTopGroupRec::iterator i = m_mpTopDirToTopGroupRec.find(hstrTopDirPath);
	if (i != m_mpTopDirToTopGroupRec.end())
		return i->second.get();
	else
		return NULL;
} // FCDynamicDb::GetTopGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTopGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiCnNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTopGroupRec* FCDynamicDb::GetTopGroupRec (const HString& hstrTopDirPath) const
{
	HStrToTopGroupRec::const_iterator i = m_mpTopDirToTopGroupRec.find(hstrTopDirPath);
	if (i != m_mpTopDirToTopGroupRec.end())
		return i->second.get();
	else
		return NULL;
} // FCDynamicDb::GetTopGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::DeleteTopGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiBeBiJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiA_xHqqkZx_
 *			_xZkqqHx_iCmMjDgPjIfOiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiNoNiPjMiClHiCoJiNnLiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::DeleteTopGroupRec (const HString& hstrTopDirPath)
{
	m_mpTopDirToTopGroupRec.erase(hstrTopDirPath);
} // FCDynamicDb::DeleteTopGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::QueryTopGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAjFnEiClHiBeCiJlMjBhKiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iDfGiDfIiDgFiDiAiCmJjGkCjDgPjIfOiCmMiPoKiNiHiCmNiBeBjAfGiClFiCkNiNoMjAkMiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetTopGroupRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBjGkCjDgPjIfOiCmMiPoKiNiHiCmNiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTopGroupRec* FCDynamicDb::QueryTopGroupRec (const HString& hstrTopDirPath)
{
	FCTopGroupRec* pTopGroupRec = GetTopGroupRec(hstrTopDirPath);
	if (pTopGroupRec == NULL)
	{
		pTopGroupRec = new FCTopGroupRec(hstrTopDirPath);
		m_mpTopDirToTopGroupRec[hstrTopDirPath] = FCTopGroupRecAuto(pTopGroupRec);
	}
	return pTopGroupRec;
} // FCDynamicDb::QueryTopGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLjGlMiCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBeCiJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmJjGkCjDgPjIfOiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCDynamicDb::GetTableRec (const FCTableName& tableName)
{
	if (tableName.m_vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	FCTopGroupRec* pTopGroupRec = GetTopGroupRec(tableName.m_hstrTopDirPath);
	if (pTopGroupRec != NULL)
	{
		return pTopGroupRec->GetTableRec(tableName.m_vTableIds);
	}
	return NULL;
} // FCDynamicDb::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLjGlMiCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBeCiJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmJjGkCjDgPjIfOiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTableRec* FCDynamicDb::GetTableRec (const FCTableName& tableName) const
{
	if (tableName.m_vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	const FCTopGroupRec* pTopGroupRec = GetTopGroupRec(tableName.m_hstrTopDirPath);
	if (pTopGroupRec != NULL)
	{
		return pTopGroupRec->GetTableRec(tableName.m_vTableIds);
	}
	return NULL;
} // FCDynamicDb::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::QueryTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLjGlMiCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBeCiJlMjBhKiDgFiBfLiDhFiDiLiDfGiDfIiDgFiDiAiCmJjGkCjDgPjIfOiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetTableRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBjGkCjDgPjIfOiCmMiPoKiNiHiCmNiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCDynamicDb::QueryTableRec (const FCTableName& tableName)
{
	if (tableName.m_vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	FCTopGroupRec* pTopGroupRec = QueryTopGroupRec(tableName.m_hstrTopDirPath);
	return pTopGroupRec->QueryTableRec(tableName.m_vTableIds);
} // FCDynamicDb::QueryTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCjGkCjDgPjIfOiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmJiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiBgJiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_
 *			Identifier_xZkqqHx_iBeBiDiNiDgCiDeOiDeKiDeFiDjDiDgHjDjJiBgKiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMjCgMiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiKmHjHjNiClDiCoKiCmEiCkIiCoIiBeBiDiNiDgCiDeOiCkK_xHqqkZx_
 *			_xZkqqHx_iInLiOjNiClDiCoKiCmEiCkCiCoJiKnEiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMjCgMiCmGjDkPiClGiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiClNiCnPiBeBiDfEiBfLiDgPiBfLiCmJiDeBiDeOiDfKiDfIiClFiCmIiCkNiCmEiCoAjCgMiCpAiOoGiCoIiPgPiClHiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLockRec* FCDynamicDb::GetLockRec (const FCTableName& tableName)
{
	if (tableName.m_vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	TableNameToLockRec::iterator i = m_mpTableNameToLockRec.find(tableName);
	if (i != m_mpTableNameToLockRec.end())
	{
		return i->second.get();
	} else
	{
		return NULL;
	}
} // FCDynamicDb::GetLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::GetLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCjGkCjDgPjIfOiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmJiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiBgJiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_
 *			Identifier_xZkqqHx_iBeBiDiNiDgCiDeOiDeKiDeFiDjDiDgHjDjJiBgKiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMjCgMiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiKmHjHjNiClDiCoKiCmEiCkIiCoIiBeBiDiNiDgCiDeOiCkK_xHqqkZx_
 *			_xZkqqHx_iInLiOjNiClDiCoKiCmEiCkCiCoJiKnEiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMjCgMiCmGjDkPiClGiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiClNiCnPiBeBiDfEiBfLiDgPiBfLiCmJiDeBiDeOiDfKiDfIiClFiCmIiCkNiCmEiCoAjCgMiCpAiOoGiCoIiPgPiClHiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCLockRec* FCDynamicDb::GetLockRec (const FCTableName& tableName) const
{
	if (tableName.m_vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	TableNameToLockRec::const_iterator i = m_mpTableNameToLockRec.find(tableName);
	if (i != m_mpTableNameToLockRec.end())
	{
		return i->second.get();
	} else
	{
		return NULL;
	}
} // FCDynamicDb::GetLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::DeleteLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiCmJiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiBgJiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_
 *			Identifier_xZkqqHx_iBeBiDiNiDgCiDeOiDeKiDeFiDjDiDgHjDjJiBgKiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMjCgMiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiKmHjHjNiClDiCoKiCmEiCkIiCoIiBeBiDiNiDgCiDeOiCkK_xHqqkZx_
 *			_xZkqqHx_iInLiOjNiClDiCoKiCmEiCkCiCoJiKnEiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmMjCgMiCmGjDkPiClGiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiClNiCnPiBeBiDfEiBfLiDgPiBfLiCmJiDeBiDeOiDfKiDfIiClFiCmIiCkNiCmEiCoAjCgMiCpAiOoGiCoIiPgPiClHiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::DeleteLockRec (const FCTableName& tableName)
{
	m_mpTableNameToLockRec.erase(tableName);
} // FCDynamicDb::DeleteLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::QueryLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiBeBiDiNiDgCiDeOiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetLockRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBjGkCjDgPjIfOiCmMiPoKiNiHiCmNjAfGiClFiCkNiNoMjAkMiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLockRec* FCDynamicDb::QueryLockRec (const FCTableName& tableName)
{
	FCLockRec* pLockRec = GetLockRec(tableName);
	if (pLockRec == NULL)
	{
		pLockRec = new FCLockRec();
		m_mpTableNameToLockRec[tableName] = FCLockRecAuto(pLockRec);
	}
	return pLockRec;
} // FCDynamicDb::QueryLockRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::KeepReadLockForCache
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiDeMiBfLiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiDeKiDeFiDjDiDgHiCpAiBhLiCfAiJmBiOfKiClFiBeBiDiNiDgCiDeOiCpA_xHqqkZx_
 *			_xZkqqHx_iDeMiBfLiDhGiClHiCoJiBeCiOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmNjHfMiCnP_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmO_xHqqkZx_
 *			_xZkqqHx_iCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDiBiDiCiDiKiDgPiDgCiDhEiDeAiCkKiJpAjFpKiClDiCoKiCoJiCmMiCpA_xHqqkZx_
 *			_xZkqqHx_jGgIiCkMiBeBjChIiCkCiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCpAjHjIjHhAiClFiCmEiCkCiCoJiPoKiNiHiCmJjDkOiNoMiCpAiMhJiCkNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jChIiCkCiDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmNiBeBiDgFiBfLiDhFiDiLiCmMiDeJiBfLiDhGiDjDiBeBiNoMjAkMiCoAjChIiJiEiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCpAiIoKjDhIjFmCiClGiCoJiCmGiBeBiNmEiCnBiDiNiDgCiDeOiCpAiKeKiCkNiClOiCkPiCmFiOjOiKnEiCkKiCkJiCkJiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiCkKiOhHjCoIiClDiCoKiCoJiCmGiBeBiDiNiDgCiDeOiJpAjFpKjHhGiLiBiCpAiKmEiOiLiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiJpAjFpKjHhGiLiBiCkKjDmNiCkCiClNiPoKiNiHiBeBiClLiCmMiPoOjFpBiCmN_xHqqkZx_ m_stUnlockRequest_xZkqqHx_jFmPjAjEiCmJ_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiBeBjDkPiOjOiCmJiDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmJjBmOiClFiCmEiJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfHiCkKjBjHjFhE_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIjDkOiNoMjCiGiCmNiBeBiDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIiCkJiCoH_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhG_xHqqkZx_
 *			_xZkqqHx_iCkKiJpAjFpKiClDiCoKiCoJiBeCiDhEiDiJiDgCiDfGiDiFiDfIiDiMiDgCiDgIjCoCiOhOjCiGiCmNiBeBjGhLjBmMiCmMiJpAjFpKjHhGiLiBiDiBiDgCiDfKiBfLiDfH_xHqqkZx_
 *			_xZkqqHx_iCmJiCoGiCmBiCmEiJpAjFpKiPiIjHjNiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::KeepReadLockForCache (const FCTableName& tableName)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmN_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsReadLocked(tableName))
		FFThrowMiscUnknown();

	// _xZkqqHx_iNmFiLnPiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
	m_lRecentReadLockForCache++;

	// _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_mpReadLockForCache.find(tableName) != m_mpReadLockForCache.end())
	//----- _xZkqqHx_iKpJiCmJjDgPjIfOiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiLnPiDeKiDeFiDjDiDfOiCpAiNfIjAfGiBeC_xHqqkZx_
		m_mpReadLockForCache[tableName] = m_lRecentReadLockForCache;
		return;
	}

//----- 05.12.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCmMjAjEiCpAiDgAiDeGiDgCiDeOiBeCjBlNiClHiCkMiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
//	// _xZkqqHx_iDeMiBfLiDhGiDiNiDgCiDeOiCmMiJpAiPjMiCmGjFhDjHhGiCmIiDfIiDiMiDgCiDgIiCpAjCoCiOhOiClDiClJiCoJiBeC_xHqqkZx_
//	ReduceWatchUnlockRequestThread();
//----- 05.12.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.12.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// ReadLock_xZkqqHx_iCpAiJmBiOfKiBeCiKpJiCmJiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFjFeLiClIjBkGiOjOjAkMiMpHiClHiCoJiBeC_xHqqkZx_
//	TryReadLockTable(tableName);
//----- 05.12.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// ReadLock_xZkqqHx_iCpAiJmBiOfKiBeCiKpJiCmJiDiNiDgCiDeOiNmPiCnNiCmIiCmMiCmFjFeLiClIjAkMiMpHiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
	GetLockRec(tableName)->m_lReadLockCounter++;
//----- 05.12.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jDgPjIfOiBeC_xHqqkZx_
	m_mpReadLockForCache[tableName] = m_lRecentReadLockForCache;
} // FCDynamicDb::KeepReadLockForCache.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::UnkeepReadLockForCache
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDeMiBfLiDhGiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDynamicDb::UnkeepReadLockForCache (const FCTableName& tableName)
{
	if (m_mpReadLockForCache.find(tableName) != m_mpReadLockForCache.end())
	//----- _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
		ReadUnlockTable(tableName);
		// READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiLeMjIfOjFmPjAjEiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
		m_mpReadLockForCache.erase(tableName);
		return TRUE;
	} else
	{
		return FALSE;
	}
} // FCDynamicDb::UnkeepReadLockForCache.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ServerGetRecordCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiNmEiDiNiDgCiDeOiClFiClNiNnLiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCmJiNiHiCoNiClJiCoJiClNiCnPiCmJ_xHqqkZx_
 *			_xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCpAiOoGjDlOiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeCiClLiCmMiOjOiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::ServerGetRecordCount (const FCTableName& tableName)
{
	ASSERT(!IsFlushing());
	return g_pDbServer->GetRecordCount(DsTableName(tableName));
} // FCDynamicDb::ServerGetRecordCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::ServerLoadTableIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiOhHjCoIiClDiCoKiClNjEmNiImNiCmM_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIndex	:_xZkqqHx_iDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBeginIndex:_xZkqqHx_jDmHiCnNiPgPiClHjEmNiImNiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwEndIndex	:_xZkqqHx_jDmHiCnNiPgPiClHjEmNiImNiCmMiNmFiMoDiBhLiCfAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiNmFiMoDiCnMiCmFjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiNmEiDiNiDgCiDeOiClFiClNiNnLiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCmJiNiHiCoNiClJiCoJiClNiCnPiCmJ_xHqqkZx_
 *			_xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCpAiOoGjDlOiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeCiClLiCmMiOjOiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::ServerLoadTableIndex (	DsArray<BYTE>& vTableIndex,
											const FCTableName& tableName,
											DWORD dwBeginIndex,
											DWORD dwEndIndex)
{
	ASSERT(!IsFlushing());
	g_pDbServer->LoadTableIndex(vTableIndex,
								DsTableName(tableName),
								dwBeginIndex,
								dwEndIndex);
} // FCDynamicDb::ServerLoadTableIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::SetErrorFromServer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCkJiCoHjFnEiCmBiCmEjHiIiClNiDeHiDiJiBfLjCgMiCpAiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDeHiDiJiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsErrCode	:_xZkqqHx_iDfEiBfLiDgPiBfLiDeHiDiJiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCmM_xHqqkZx_TryReadLock_xZkqqHx_iKnGjAjEiCmIiCmHiBeBiDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiKnGjAjEiCmJjHjIjHhAiBeC_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDeHiDiJiBfLiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCmG_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCmJjFmPiKlHiClDiCoKiBeBjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDynamicDb::SetErrorFromServer (DsErr dsErrCode, const FCTableName& tableName)
{
	// _xZkqqHx_iDfEiBfLiDgPiBfLiDeHiDiJiBfLiDfCiBfLiDgIiCpAiDeOiDiJiDeDiDeBiDjDiDgHiDeHiDiJiBfLiDfCiBfLiDgIiCmJjFmPiKlHiBeC_xHqqkZx_
	m_dwErrorCode = DsErrToErrorCode(dsErrCode);
	if (m_dwErrorCode == IDS_ERR_MSG_FILE_LOCKED_BY_OTHERS)
	{
		DsString dsUserName;
		g_pDbServer->WhoLockingFile(dsUserName, DsTableName(tableName));
		const wchar_t* wcpUserName = (dsUserName.Get() != NULL) ? dsUserName.Get() : L"";
		m_wstrErrorMessage.Format(	m_dwErrorCode,
									tableName.GetTitle().c_str(), wcpUserName);
	} else
	if (m_dwErrorCode == 0)
	{
		m_wstrErrorMessage.Empty();
	} else
	{
		m_wstrErrorMessage.Format(m_dwErrorCode, tableName.GetTitle().c_str());
	}
} // FCDynamicDb::SetErrorFromServer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDynamicDb::DsErrToErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiBfLiDgPiBfLiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCkJiCoHiDeOiDiJiDeDiDeBiDjDiDgHiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dsErrCode	:_xZkqqHx_iDfEiBfLiDgPiBfLiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDynamicDb::DsErrToErrorCode (DsErr dsErrCode)
{
// _xZkqqHx_iDfEiBfLiDgPiBfLiCmMiDeHiDiJiBfLiCpAjBfDiCmEjGnEjHiFiClFiCmEiCkCiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
#if (IDS_DYSR_ERR_BEGIN != IDS_DYSR_ERR_MISC_UNKNOWN)
	ERROR!!
#endif
#if (IDS_DYSR_ERR_END != IDS_DYSR_ERR_FILE_PATH_WRONG)
	ERROR!!
#endif

	switch (dsErrCode)
	{
	case 0:
    	return 0;									// _xZkqqHx_iDeHiDiJiBfLiCmIiClFiBeC_xHqqkZx_
	case IDS_DYSR_ERR_MISC_UNKNOWN:
    	return IDS_ERR_FILE_UNKNOWN;				// "_xZkqqHx_jGkCjCoIiLgAiDeHiDiJiBfLiCmFiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_COPY_FAILED:
    	return IDS_ERR_MSG_FILE_COPY_FAILED;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCnGiCmMiDfCiDhDiBfLiCpAiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_UNLOCK_REQUESTED:
    	return IDS_ERR_MSG_FILE_UNLOCK_REQUESTED;	// "_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiJpAjFpKjHhGiLiBiCkKjHiIiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_ALREADY_EXIST:
		return IDS_ERR_MSG_FILE_ALREADY_EXIST;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiKpJiCmJjBlGiNnNiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_LOCKED_BY_SELF:
		return IDS_ERR_MSG_FILE_LOCKED_BY_SELF;	// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_LOCKED_OTHERKIND:
		return IDS_ERR_MSG_FILE_LOCKED_OTHERKIND;	// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiKpJiCmJjBlMiCmMiDiNiDgCiDeOiOoNiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_LOCKED_BY_OTHERS:
    	return IDS_ERR_MSG_FILE_LOCKED_BY_OTHERS;	// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiDiGiBfLiDfFiBfLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmJiCoGiCmBiCmEiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_UNKNOWN:
    	return IDS_ERR_FILE_UNKNOWN;				// "_xZkqqHx_jGkCjCoIiLgAiDeHiDiJiBfLiCmFiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_ACCESS_DENIED:
    	return IDS_ERR_MSG_FILE_ACCESS_DENIED;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmJiDeBiDeOiDfKiDfIiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_\r\n_xZkqqHx_iDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_RECOVERY_REQUIRED:
    	return IDS_ERR_MSG_REPAIR_DAMAGED_FILE;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeCiPeDjFjMiDgDiBfLiDiLiCmFiPeDjFjMiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_SIZE_TOO_LARGE:
    	return IDS_ERR_MSG_FILE_SIZE_TOO_LARGE;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiDfEiDeDiDfJiCkKjBoFiCkLiClHiCkMiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_PATH_TOO_LONG:
    	return IDS_ERR_MSG_FILE_PATH_TOO_LONG;		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiDhAiDfIiCkKjClHiClHiCkMiCnMiClHiBeC_xHqqkZx_"
	case IDS_DYSR_ERR_FILE_PATH_WRONG:
    	return IDS_ERR_MSG_FILE_PATH_WRONG;			// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiDhAiDfIiCmJiCmNiBeBiDhEiDeAiDeDiDiLjGlMiCmJiOgHiCkGiCmIiCkCjFlGiOjKiCkKiKnMiCnMiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_"
	default:
		FFThrowMiscUnknown();
    	return 0;									// _xZkqqHx_iDeHiDiJiBfLiCmIiClFiBeC_xHqqkZx_
	}
} // FCDynamicDb::DsErrToErrorCode.
