#if !defined(AFX_DYNAMICDB_H__B09CF6B0_73EA_4DDF_8462_7BD8DCB4A8A8__INCLUDED_)
#define AFX_DYNAMICDB_H__B09CF6B0_73EA_4DDF_8462_7BD8DCB4A8A8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DynamicDb.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "DbGroup.h"			// For FCDbGroup.
#include "UtilVirtualTable.h"	// For FCTableName.
#include "HString.h"			// For HString.

class FCDynamicDb;
class FCVirtualTable;
class FCDbReadLock;
class FCDbWriteLock;
class FCDbTable;
class FCDbGroup;
class FCDbReadLock;
class FCDbWriteLock;
struct FCLockRec;
class FCTopGroupRec;
struct FCTableRec;
enum FTFileKind;

typedef long DsErr;

typedef auto_ptr<FCLockRec> FCLockRecAuto;
typedef auto_ptr<FCTopGroupRec> FCTopGroupRecAuto;

typedef map<HString, FCTopGroupRecAuto>	HStrToTopGroupRec;
typedef map<FCTableName, FCLockRecAuto>	TableNameToLockRec;
typedef set<FCTableName>				TableNameSet;
typedef map<FCTableName, long>			TableNameToLong;

/////////////////////////////////////////////////////////////////////////////
// FCLockRec.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCLockRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDiMiDfCiBfLiDgIiBeCiDiNiDgCiDeOiCmMiPpDjBnEiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeBiNoNiPjMiBeFjCmHiJmB_xHqqkZx_Identifier
 *			_xZkqqHx_iCpAiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *			READ_xZkqqHx_iDiNiDgCiDeOiIlNiCkCiCmN_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiKnEiCmNiBeBiClBiCmMjCgMiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgI_xHqqkZx_
 *			_xZkqqHx_iCmMjCgMiCmGiIoKjChGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCLockRec
{
	FCLockRec ();
	long	m_lReadLockCounter;
	long	m_lWriteLockCounter;
	GUID	m_guidTable;
	DWORD	m_dwDeleteIdentifier;
	DWORD	m_dwAppendIdentifier;
}; // struct FCLockRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCDynamicDb
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiBeBiJlMjBhKiDgFiBfLiDhFiDiLiBeFiJlMjBhKiDePiDiLiBfLiDhGiCmMiKmHjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiBeBiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCnGiCmMiPjBiCkLiNjOiCnNiBeBjDmHiCnNiPgPiClFiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMiKfEjEePiCmNiBeBiDeOiDiJiDeDiDeBiDjDiDgHjBkEiBgJiClBiCmMiDeOiDiJiDfIiBgKiCmJiCmMiCnN_xHqqkZx_
 *			_xZkqqHx_jBlGiNnNiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_jEkNiNhDiClHiCoJiDfCiDhNiDjDiDgIiBgJ_xHqqkZx_CMD_CREATE_GROUP_xZkqqHx_jDjJiBgKiCmNiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCmG_xHqqkZx_
 *			_xZkqqHx_iIoKjEmKiCmMiDgFiBfLiDhFiDiLiCpAiLoGjFmKiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCDynamicDb
{
public:
	FCDynamicDb ();
	virtual ~FCDynamicDb ();
	virtual FCDbGroup	CreateTopGroup (FCDbReadLock& readLock, FCDbWriteLock& writeLock, const HString& hstrTopDirPath);
	virtual FCDbGroup	GetTopGroup (const HString& hstrTopDirPath);
	virtual void	FlushAll (BOOL bMultiUserAccessable = TRUE, BOOL bReturnImmediate = TRUE);
	virtual BOOL	IsFlushing () const;
	virtual void	OnUnlockRequest ();

// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual DWORD	CheckTopGroupPath (const wchar_t* wcpTopDirPath) const;

	virtual BOOL	DeleteTopGroup (const HString& hstrTopDirPath);
	virtual BOOL	IsRecoveryRequired (const HString& hstrTopDirPath) const;
	virtual BOOL	IsTopGroupExist (const HString& hstrTopDirPath) const;
	virtual BOOL	FlushAll2 ();
	virtual void	ClearTransaction (const HString& hstrTopDirPath);
	virtual void	ClearAllTransaction ();

	virtual void	ResetError ();
	virtual DWORD	GetErrorCode () const;
	virtual WString	GetErrorMessage () const;

	virtual flint	GetFdtimeFromFirstModified () const;
	virtual void	UpdateFirstModifiedFdtime ();
	virtual FDTIME	GetLastModifiedFdtime (const FCTableName& tableName);

	virtual DWORD	OnDlgOpenDirectory (WString& wstrDirPath,
										HWND hwndParent,
										const wchar_t* wcpInitPath) const;

	virtual DWORD	OnDlgSaveTopGroup (	WString& wstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpInitPath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt) const;
	virtual DWORD	OnDlgOpenTopGroup (	WString& wstrTopGroupPath,
										HWND hwndParent,
										const wchar_t* wcpDlgTitle,
										const wchar_t* wcpFilePath,
										const wchar_t* wcpDocumentType,
										const wchar_t* wcpExt) const;
	virtual void	SetLoginUserName (const wchar_t* wcpUserName);

	virtual DWORD	GetFlushErrorCode () const;
	virtual WString	GetFlushErrorMessage () const;

	virtual BOOL	IsThereUnflushed () const;
	virtual BOOL	UnkeepIfUnlockRequest ();
	virtual void	UnkeepIfNotWriteKeeped ();

//----- 06.02.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual void	ShowProgressBar (flint fliGoalByte);
//	virtual void	HideProgressBar ();
//----- 06.02.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	virtual flint	GetTotalUnflushedBufferSize () const;
	virtual void	TerminateFlushThread ();
	virtual void	KeepWriteLockForFlush (const FCTableName& tableName);
	virtual BOOL	GetIsTableExist (const FCTableName& tableName) const;
	virtual GUID	GetLockedTableGuid (const FCTableName& tableName) const;
	virtual DWORD	GetLockedDeleteIdentifier (const FCTableName& tableName) const;
	virtual DWORD	GetLockedAppendIdentifier (const FCTableName& tableName) const;
	virtual void	ClearWriteLockForFlush ();

	virtual void	MakeUniqTopGroupPath (	WString& wstrGroupPath,
											const wchar_t* wcpPath,
											const wchar_t* wcpExt) const;

	virtual void	SetCurrentDirectory (const wchar_t* wcpDirPath);
	virtual WString	GetCurrentDirectory () const;
	virtual WString	MakeUniqTmpTopGroupPath (const wchar_t* wcpExt) const;
// 06.03.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual WString	GetTmpDirectory () const;

friend class FCDbTable;
friend class FCDbGroup;
friend class FCDbReadLock;
friend class FCDbWriteLock;
friend class FCTopGroupRec;

protected:
	virtual long	CreateWriteLock (const FCTableName& tableName);
	virtual long	TryReadLockTable (const FCTableName& tableName);
	virtual long	TryWriteLockTable (const FCTableName& tableName);
	virtual long	ReadUnlockTable (const FCTableName& tableName);
	virtual long	WriteUnlockTable (const FCTableName& tableName);

	virtual void	DeleteClientLock (const FCTableName& tableName);

	virtual long	GetReadLockCount (const FCTableName& tableName) const;
	virtual long	GetWriteLockCount (const FCTableName& tableName) const;
	virtual BOOL	GetIsReadLocked (const FCTableName& tableName) const;
	virtual BOOL	GetIsWriteLocked (const FCTableName& tableName) const;

	virtual void	MultiCmdDeleteRecords (const FCTableName& tableName, const DWORDSet& stIndex);
	virtual void	CmdCreateGroup (const FCTableName& groupName);
	virtual void	CmdDeleteGroup (const FCTableName& groupName);
	virtual void	CmdCreateTable (const FCTableName& tableName);
	virtual void	CmdDeleteTable (const FCTableName& tableName);
	virtual DWORD	CmdAppendRecord (	const FCTableName& tableName,
										flint fliPrimaryId,
										const void* pRecordData1,
										DWORD dwRecordData1,
										const void* pRecordData2 = NULL,
										DWORD dwRecordData2 = 0);
	virtual void	CmdReduceRecordCount (const FCTableName& tableName, DWORD dwCount);
	virtual void	CmdCopyRecord (	const FCTableName& tableNameTo,
									const FCTableName& tableNameFrom,
									DWORD dwIndexBegin,
									DWORD dwIndexEnd);
	virtual const FCVirtualTable*	QueryTable (const FCTableName& tableName);
	virtual void	CacheTableRealRecords (const FCTableName& tableName, DWORD dwIndex);

	virtual void	GetReadLockedTableName (vector<FCTableName>& vReadLockTableName);
	virtual void	GetWriteLockedTableName (vector<FCTableName>& vWriteLockTableName);


protected:
	virtual FCTopGroupRec*			GetTopGroupRec (const HString& hstrTopDirPath);
	virtual const FCTopGroupRec*	GetTopGroupRec (const HString& hstrTopDirPath) const;
	virtual void					DeleteTopGroupRec (const HString& hstrTopDirPath);
	virtual FCTopGroupRec*			QueryTopGroupRec (const HString& hstrTopDirPath);
	virtual FCTableRec*			GetTableRec (const FCTableName& tableName);
	virtual const FCTableRec*	GetTableRec (const FCTableName& tableName) const;
	virtual FCTableRec*			QueryTableRec (const FCTableName& tableName);

	virtual FCLockRec*			GetLockRec (const FCTableName& tableName);
	virtual const FCLockRec*	GetLockRec (const FCTableName& tableName) const;
	virtual void				DeleteLockRec (const FCTableName& tableName);
	virtual FCLockRec*			QueryLockRec (const FCTableName& tableName);

	virtual void				KeepReadLockForCache (const FCTableName& tableName);
	virtual BOOL				UnkeepReadLockForCache (const FCTableName& tableName);


	virtual DWORD	ServerGetRecordCount (const FCTableName& tableName);
	virtual void	ServerLoadTableIndex (	DsArray<BYTE>& vTableIndex,
											const FCTableName& tableName,
											DWORD dwBeginIndex,
											DWORD dwEndIndex);

	virtual void	SetErrorFromServer (DsErr dsErrCode, const FCTableName& tableName);

	static DWORD	DsErrToErrorCode (DsErr dsErrCode);

protected:
	HStrToTopGroupRec	m_mpTopDirToTopGroupRec;
	TableNameToLockRec	m_mpTableNameToLockRec;
	TableNameSet		m_stWriteLockForFlush;
	TableNameToLong		m_mpReadLockForCache;		// Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
													// _xZkqqHx_iDgFiBfLiDhFiDiLjGlM_xHqqkZx_ -> _xZkqqHx_iNmFiLnPiDeKiDeFiDjDiDfOiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	longSet				m_stImportantForCache;		// _xZkqqHx_iCoGiCoIiPgEjHhGiCmI_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	long				m_lRecentReadLockForCache;	// Read_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGjHhAiNmFiLnPiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	flint				m_fliFirstModifiedFdtime;	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiMoDiCmMiNmFiPiJiCmMiPeDjAlDiCmMiOjOiKnEiBeC_xHqqkZx_

	DWORD				m_dwErrorCode;				// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	WString				m_wstrErrorMessage;			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
}; // class FCDynamicDb.

extern FCDynamicDb*	g_pFileServer;

extern void FFStartDbServer ();
extern void FFSetDbServerHwnd (HWND hWnd);
extern void FFStopDbServer ();

/////////////////////////////////////////////////////////////////////////////

#endif // !defined(AFX_DYNAMICDB_H__B09CF6B0_73EA_4DDF_8462_7BD8DCB4A8A8__INCLUDED_)
