#ifndef __FileBase_h
#define __FileBase_h

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// File32.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "UtilFile.h"	// For FTFileKind.

/////////////////////////////////////////////////////////////////////////////
// FCFileBase _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFileBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfCiCfBiDhCiDgCiDgHiBeBiCfFiCfDiDhCiDgCiDgHiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeBjAkHiMoEiClHiCoJiClBiCmGiCpAiJmCjEfMiCmJiClHiCoJiBeC_xHqqkZx_
 *			CFile_xZkqqHx_iCmGjDkPjHgMiCmMiLeAjEfMiCpAiOjNiCmCiBeC_xHqqkZx_
 *			CFile_xZkqqHx_iCmNiBeBiDhEiDeAiDeDiDiLiCmMjAfGiLeLiNoMjAkMiOjOiCmJiBeBiKpJjBlGiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiClN_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmJiDeHiDiJiBfLiCpAjEkNjAlGiClDiClJiCoJiClBiCmGiCkKiPgPjHiIiCmIiCkCiCkKiBeB_xHqqkZx_FCFileBase_xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDeJiDhGiDfGiDiHiDjDiCmJiCoGiCmBiCmEiDeHiDiJiBfLiCpAjEkNjAlGiClDiClJiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFileBase
{
// _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
public:
	virtual ~FCFileBase () {};
	virtual BOOL	Open (	const wchar_t* wcpFilePath,
							DWORD dwDesiredAccess,
							DWORD dwShareMode,
							DWORD dwCreationDisposition,
							DWORD dwFlagsAndAttributes = FILE_ATTRIBUTE_NORMAL) = 0;
	virtual void	Close () = 0;
	virtual void	Flush () = 0;
	virtual const WString& GetFilePathW () const = 0;
//	virtual const WString& GetFileNameW () const = 0;
	virtual flint	GetPosition64 () const = 0;
	virtual flint	Seek64 (flint fliOffset, DWORD dwFrom) = 0;
	virtual flint	GetLength64 () const = 0;
	virtual void	SetLength64 (flint fliNewLen) = 0;
	virtual flint	Read64 (void* lpBuf, flint fliCount) = 0;
	virtual void	Write64 (const void* lpBuf, flint fliCount) = 0;
	virtual FTFileKind	GetFileKind () const = 0;
	virtual BOOL	IsFileOpened () const = 0;
	virtual DWORD	GetDesiredAccess () const = 0;
	virtual BOOL	GetFileTime (	FDTIME* lpCreationTime,
									FDTIME* lpLastAccessTime,
									FDTIME* lpLastWriteTime) const = 0;
}; // class FCFileBase.

template<class T> void operator << (FCFileBase& file, const T data)
{
	file.Write64(&data, sizeof(data));
} // template<class T> void operator <<.

template<class T> void operator >> (FCFileBase& file, T& data)
{
	file.Read64(&data, sizeof(data));
} // template<class T> void operator >>.

/////////////////////////////////////////////////////////////////////////////

#endif //__FileBase_h
