#include "stdafx.h"
#include "UtilFile.h"		// For ReadData.
#include "HiProject.h"		// For FCHiProject.
#include "DbGroup.h"		// For FCDbGroup::FDCT_TYPE_GROUP.
#include "HiDocumentRec.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FCHiDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::FCHiDocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRec::FCHiDocumentRec ()
			:	m_pProject(NULL),
				m_lDocumentId(-1),
				m_dwIndex(DWORD(-1))
{
} // FCHiDocumentRec::FCHiDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::FCHiDocumentRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProject	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId	:_xZkqqHx_jFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRec::FCHiDocumentRec (FCHiProject* pProject, long lDocumentId, DWORD dwIndex)
			:	m_pProject(pProject),
				m_lDocumentId(lDocumentId),
				m_dwIndex(dwIndex)
{
} // FCHiDocumentRec::FCHiDocumentRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetIsInvalid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkKjGlDiMpIiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiDocumentRec::GetIsInvalid () const
{
	return (m_pProject == NULL);
} // FCHiDocumentRec::GetIsInvalid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiDocumentRec::GetDocumentId () const
{
	return m_lDocumentId;
} // FCHiDocumentRec::GetDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetFirstSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiDocumentRec::GetFirstSessionIndex ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vBuff;
//	const BYTE* pData = SkipNone(vBuff);
//	flint fliFirstSessionIndex;
//	FFReadData(fliFirstSessionIndex, pData);
//	return fliFirstSessionIndex;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	flint fliFirstSessionIndex;
	GetValue(	&fliFirstSessionIndex,		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return fliFirstSessionIndex;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetFirstSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetSuperDocId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHiDocumentRec::GetSuperDocId ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipFirstSessionIndex(vData);
//	long lSuperDocId;
//	FFReadData(lSuperDocId, pData);
//	return lSuperDocId;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lSuperDocId;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				&lSuperDocId,	// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return lSuperDocId;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetSuperDocId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetDocTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiDocumentRec::GetDocTitle ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipSuperDocId(vData);
//	WString wstrDocTitle;
//	FFReadData(wstrDocTitle, pData);
//	return wstrDocTitle;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrDocTitle;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				&wstrDocTitle,	// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return wstrDocTitle;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetDocTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiDocumentRec::GetVersion ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipDocTitle(vData);
//	WString wstrVersion;
//	FFReadData(wstrVersion, pData);
//	return wstrVersion;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrVersion;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				&wstrVersion,	// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return wstrVersion;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCHiDocumentRec::GetUserId ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipVersion(vData);
//	GUID guidUserId;
//	FFReadData(guidUserId, pData);
//	return guidUserId;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	GUID guidUserId;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				&guidUserId,	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return guidUserId;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCHiDocumentRec::GetDate ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipUserId(vData);
//	FDSECTIME fdstDate;
//	FFReadData(fdstDate, pData);
//	return fdstDate;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FDSECTIME fdstDate;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				&fdstDate,		// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return fdstDate;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiDocumentRec::GetComment ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipDate(vData);
//	WString wstrComment;
//	FFReadData(wstrComment, pData);
//	return wstrComment;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrComment;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				&wstrComment,	// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return wstrComment;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetIsLogCommandUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiDocumentRec::GetIsLogCommandUserId ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipComment(vData);
//	BOOL bIsLog;
//	FFReadData(bIsLog, pData);
//	return bIsLog;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	BOOL bIsLog;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				&bIsLog,		// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				NULL);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return bIsLog;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetIsLogCommandUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCHiDocumentRec::GetHtreeScore ()
{
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTEVector vData;
//	const BYTE* pData = SkipIsLogCommandUserId(vData);
//	double dHtreeScore;
//	FFReadData(dHtreeScore, pData);
//	return dHtreeScore;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	double dHtreeScore;
	GetValue(	NULL,			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
				NULL,			// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
				&dHtreeScore);	// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	return dHtreeScore;
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHiDocumentRec::GetHtreeScore.

//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetIsTemporary
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHiDocumentRec::GetIsTemporary ()
//{
//	return (GetDocumentId() == -2L);
//} // FCHiDocumentRec::GetIsTemporary.
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetHintText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHiDocumentRec::GetHintText (const FCHiProject* pProject)
//{
//	return WString();
//} // FCHiDocumentRec::GetHintText.
//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//const BYTE* FCHiDocumentRec::SkipNone (BYTEVector& vBuff)
//{
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKjAlDiClFiCkCjCgMiCkJiCmHiCkEiCkJjClCiCnHiBeBjAlDiClFiCkNiCmIiCkCiPoKiNiHiCmNjAlDiClFiCkCjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	CheckIndex();
//	// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
//	BYTE byType;
//	DWORD dwId;
//	m_pProject->GetControlRecord(byType, dwId, &vBuff, m_dwIndex);
//	return &vBuff[0];
//} // FCHiDocumentRec::SkipNone.
//
//const BYTE* FCHiDocumentRec::SkipFirstSessionIndex (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipNone(vBuff);
//	FFSkipData((flint*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipFirstSessionIndex.
//
//const BYTE* FCHiDocumentRec::SkipSuperDocId (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipFirstSessionIndex(vBuff);
//	FFSkipData((long*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipSuperDocId.
//
//const BYTE* FCHiDocumentRec::SkipDocTitle (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipSuperDocId(vBuff);
//	FFSkipData((WString*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipDocTitle.
//
//const BYTE* FCHiDocumentRec::SkipVersion (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipDocTitle(vBuff);
//	FFSkipData((WString*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipVersion.
//
//const BYTE* FCHiDocumentRec::SkipUserId (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipVersion(vBuff);
//	FFSkipData((GUID*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipUserId.
//
//const BYTE* FCHiDocumentRec::SkipDate (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipUserId(vBuff);
//	FFSkipData((FDSECTIME*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipDate.
//
//const BYTE* FCHiDocumentRec::SkipComment (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipDate(vBuff);
//	FFSkipData((WString*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipComment.
//
//const BYTE* FCHiDocumentRec::SkipIsLogCommandUserId (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipComment(vBuff);
//	FFSkipData((BOOL*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipIsLogCommandUserId.
//
//const BYTE* FCHiDocumentRec::SkipHtreeScore (BYTEVector& vBuff)
//{
//	const BYTE* pBuff = SkipIsLogCommandUserId(vBuff);
//	FFSkipData((double*)NULL, pBuff);
//	return pBuff;
//} // FCHiDocumentRec::SkipHtreeScore.
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::GetValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRec::GetValue (flint* fliFirstSessionIndex,	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
								long* lSuperDocId,				// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
								WString* wstrDocTitle,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
								WString* wstrVersion,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
								GUID* guidUserId,				// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
								FDSECTIME* fdstDate,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
								WString* wstrComment,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
								BOOL* bIsLogCommandUserId,		// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
								double* dHtreeScore)			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKjAlDiClFiCkCjCgMiCkJiCmHiCkEiCkJjClCiCnHiBeBjAlDiClFiCkNiCmIiCkCiPoKiNiHiCmNjAlDiClFiCkCjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	CheckIndex();
	// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	BYTE byType;
	DWORD dwId;
	BYTEVector vBuff;
	m_pProject->GetControlRecord(byType, dwId, &vBuff, m_dwIndex);
	const BYTE* pData = &vBuff[0];
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
	if (fliFirstSessionIndex != NULL)
		FFReadData(*fliFirstSessionIndex, pData);
	else
		FFSkipData(fliFirstSessionIndex, pData);
	// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	if (lSuperDocId != NULL)
		FFReadData(*lSuperDocId, pData);
	else
		FFSkipData(lSuperDocId, pData);
	// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
	if (wstrDocTitle != NULL)
		FFReadData(*wstrDocTitle, pData);
	else
		FFSkipData(wstrDocTitle, pData);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	if (wstrVersion != NULL)
		FFReadData(*wstrVersion, pData);
	else
		FFSkipData(wstrVersion, pData);
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	if (guidUserId != NULL)
		FFReadData(*guidUserId, pData);
	else
		FFSkipData(guidUserId, pData);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	if (fdstDate != NULL)
		FFReadData(*fdstDate, pData);
	else
		FFSkipData(fdstDate, pData);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	if (wstrComment != NULL)
		FFReadData(*wstrComment, pData);
	else
		FFSkipData(wstrComment, pData);
	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
	if (bIsLogCommandUserId != NULL)
		FFReadData(*bIsLogCommandUserId, pData);
	else
		FFSkipData(bIsLogCommandUserId, pData);
	// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	if (dHtreeScore != NULL)
		FFReadData(*dHtreeScore, pData);
	else
		FFSkipData(dHtreeScore, pData);
} // FCHiDocumentRec::GetValue.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRec::CheckIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCkKjAlDiClFiCkCjCgMiCkJiCmHiCkEiCkJjClCiCnHiBeBjAlDiClFiCkNiCmIiCkCiPoKiNiHiCmNjAlDiClFiCkCjCgMiCpA_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmNiDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmFjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkKiBeBiClLiCmMiMoDiDgFiBfLiDhFiDiLiCkK_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClDiCoKiClNiPoKiNiHiBeBiLlGiCkEiClBiCmGiCoAiCkAiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRec::CheckIndex ()
{
	if (m_dwIndex < m_pProject->GetRecordCount())
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_(m_dwIndex)_xZkqqHx_iCkKiDgFiBfLiDhFiDiLiDfEiDeDiDfJiCmJiOpLiCnMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		BYTE byType;
		DWORD dwId;
		m_pProject->GetControlRecord(byType, dwId, NULL, m_dwIndex);
		// _xZkqqHx_iDfOiDeDiDhGiBeF_xHqqkZx_ID_xZkqqHx_iCmGiCoAiCmJiIoKjChGiClHiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (byType == FCDbGroup::FDCT_TYPE_GROUP && dwId == GetDocumentId())
			return;
	}

	//----- _xZkqqHx_iImIiNhOiCmNiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_(m_dwIndex)_xZkqqHx_iCmJiKnEiIoBiCkCiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iOhHjCoIiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAiMjPiNpFiBeC_xHqqkZx_
	m_dwIndex = m_pProject->FindEntry(FCDbGroup::FDCT_TYPE_GROUP, GetDocumentId());
} // FCHiDocumentRec::CheckIndex.

/////////////////////////////////////////////////////////////////////////////
// FCHiDocumentRecW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::FCHiDocumentRecW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRecW::FCHiDocumentRecW ()
				:	BASE_CLASS(),
					m_dwFlag(0)
{
} // FCHiDocumentRecW::FCHiDocumentRecW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::FCHiDocumentRecW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hiDocRec	:_xZkqqHx_jHjKjHpAjFlGiPjBiDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Read_xZkqqHx_jAoKjHhAiCmM_xHqqkZx_FCHiDocumentRec_xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiDocumentRecW::FCHiDocumentRecW (const FCHiDocumentRec& hiDocRec)
				:	BASE_CLASS(hiDocRec),
					m_dwFlag(0)
{
} // FCHiDocumentRecW::FCHiDocumentRecW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetFirstSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetFirstSessionIndex (flint fliSessionIndex)
{
	m_dwFlag |= FD_FIRST_SESSION_INDEX_ID;
	m_fliFirstSessionIndex = fliSessionIndex;
} // FCHiDocumentRecW::SetFirstSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetSuperDocId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetSuperDocId (long lDocId)
{
	m_dwFlag |= FD_SUPER_DOC_ID;
	m_lSuperDocId = lDocId;
} // FCHiDocumentRecW::SetSuperDocId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetDocTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetDocTitle (const wchar_t* wcpDocTitle)
{
	m_dwFlag |= FD_DOC_TITLE;
	m_wstrDocTitle = wcpDocTitle;
} // FCHiDocumentRecW::SetDocTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetVersion (const wchar_t* wcpVersion)
{
	m_dwFlag |= FD_VERSION;
	m_wstrVersion = wcpVersion;
} // FCHiDocumentRecW::SetVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetUserId (const GUID& guidUserId)
{
	m_dwFlag |= FD_USER_ID;
	m_guidUserId = guidUserId;
} // FCHiDocumentRecW::SetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetDate (FDSECTIME fdstDate)
{
	m_dwFlag |= FD_DATE;
	m_fdstDate = fdstDate;
} // FCHiDocumentRecW::SetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetComment (const wchar_t* wcpComment)
{
	m_dwFlag |= FD_COMMENT;
	m_wstrComment = wcpComment;
} // FCHiDocumentRecW::SetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetIsLogCommandUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetIsLogCommandUserId (const BOOL bIsLogCommandUserId)
{
	m_dwFlag |= FD_IS_LOG_COMMAND_USER_ID;
	m_bIsLogCommandUserId = bIsLogCommandUserId;
} // FCHiDocumentRecW::SetIsLogCommandUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::SetHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::SetHtreeScore (double dScore)
{
	m_dwFlag |= FD_HTREE_SCORE;
	m_dHtreeScore = dScore;
} // FCHiDocumentRecW::SetHtreeScore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::Update
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::Update ()
{
	if (m_dwFlag != 0)
	//----- _xZkqqHx_jFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		BYTEVector vData;
		GetData(vData);
		// _xZkqqHx_iDiMiDfCiBfLiDgIiCpAjAnNjCoIiBeCiDgOiDgCiDfGiDiFiCoAiNfIjAfGiClDiCoKiCoJiCmMiCmFiClBiClBiCmF_xHqqkZx_UpdateHash_xZkqqHx_iCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		m_pProject->SetDocumentRecord(m_lDocumentId, &vData[0], vData.size());
		// _xZkqqHx_iDeOiDiKiDeBiBeC_xHqqkZx_
		m_dwFlag = 0;
		m_dwIndex = DWORD(-1);
	}
} // FCHiDocumentRecW::Update.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiDocumentRecW::GetData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHiDocumentRecW::GetData (BYTEVector& vData)
{
	flint		fliFirstSessionIndex = 0;		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
	long		lSuperDocId = -1;				// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	WString		wstrDocTitle;					// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
	WString		wstrVersion;					// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	GUID		guidUserId = GUID_NULL;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FDSECTIME	fdstDate = 0;					// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	WString		wstrComment;					// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	BOOL		bIsLogCommandUserId = FALSE;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
	double		dHtreeScore = 0;				// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_

	if (!GetIsInvalid())
		GetValue(	&fliFirstSessionIndex,	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
					&lSuperDocId,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
					&wstrDocTitle,			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
					&wstrVersion,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
					&guidUserId,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					&fdstDate,				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
					&wstrComment,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
					&bIsLogCommandUserId,	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
					&dHtreeScore);			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_

	if (m_dwFlag & FD_FIRST_SESSION_INDEX_ID)
		fliFirstSessionIndex = m_fliFirstSessionIndex;
	if (m_dwFlag & FD_SUPER_DOC_ID)
		lSuperDocId = m_lSuperDocId;
	if (m_dwFlag & FD_DOC_TITLE)
		wstrDocTitle = m_wstrDocTitle;
	if (m_dwFlag & FD_VERSION)
		wstrVersion = m_wstrVersion;
	if (m_dwFlag & FD_USER_ID)
		guidUserId = m_guidUserId;
	if (m_dwFlag & FD_DATE)
		fdstDate = m_fdstDate;
	if (m_dwFlag & FD_COMMENT)
		wstrComment = m_wstrComment;
	if (m_dwFlag & FD_IS_LOG_COMMAND_USER_ID)
		bIsLogCommandUserId = m_bIsLogCommandUserId;
	if (m_dwFlag & FD_HTREE_SCORE)
		dHtreeScore = m_dHtreeScore;

	vData.clear();
	vData << fliFirstSessionIndex;
	vData << lSuperDocId;
	vData << wstrDocTitle;
	vData << wstrVersion;
	vData << guidUserId;
	vData << fdstDate;
	vData << wstrComment;
	vData << bIsLogCommandUserId;
	vData << dHtreeScore;
} // FCHiDocumentRecW::GetData.

